/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.updaters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import si.nevensrok.common.objects.ObjectCompare;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.GroupDraw;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.DuoTable;
import si.nevensrok.jtekma.server.management.AgeCategoryOptionManager;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.updaters.Duo2023PlacingCalculator;

public class Duo2023Updater {
    private CompetitionManager competitionManager;
    private RulesManager rulesManager;
    private CategoryManager categoryManager;
    private DuoPresentationManager duoPresentationManager;
    private MatchManager matchManager;
    private Duo2023PlacingCalculator duo2023PlacingCalculator;
    private AgeCategoryOptionManager ageCategoryOptionManager;

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setDuoPresentationManager(DuoPresentationManager duoPresentationManager) {
        this.duoPresentationManager = duoPresentationManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setDuo2023PlacingCalculator(Duo2023PlacingCalculator duo2023PlacingCalculator) {
        this.duo2023PlacingCalculator = duo2023PlacingCalculator;
    }

    public void setAgeCategoryOptionManager(AgeCategoryOptionManager ageCategoryOptionManager) {
        this.ageCategoryOptionManager = ageCategoryOptionManager;
    }

    public void updateDuo2023Category(Duo2023Category duo2023Category) {
        this.calculateDuoTable(duo2023Category, true);
    }

    public DuoTable getDuoTable(Duo2023Category duo2023Category) {
        return this.calculateDuoTable(duo2023Category, false);
    }

    private DuoTable calculateDuoTable(Duo2023Category duo2023Category, boolean update) {
        Competition competition = this.competitionManager.getCompetitionForCategory((Category)duo2023Category);
        CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
        Map draw = this.categoryManager.getGroupDraw((Category)duo2023Category);
        AgeCategoryOption ageCategoryOption = this.ageCategoryOptionManager.getForCategory(duo2023Category);
        List duoPresentations = this.duoPresentationManager.getDuoPresentationsForCategory((Category)duo2023Category);
        LinkedList<DuoPresentation> duoPresentationsToRemove = new LinkedList<DuoPresentation>();
        for (DuoPresentation duoPresentation : duoPresentations) {
            duoPresentation.setGroupPosition(Integer.valueOf(0));
            duoPresentation.setGroupNumber(null);
            if (!update || duoPresentation.getRound() != Round.ROUND_3 || competitionRules.isDuoPresentationRoundNeeded(ageCategoryOption, 3)) continue;
            duoPresentationsToRemove.add(duoPresentation);
        }
        HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
        HashMap<Integer, Set<MatchPoint>> matchPoints = new HashMap<Integer, Set<MatchPoint>>();
        for (Match match : this.matchManager.getMatchesForCategory((Category)duo2023Category)) {
            matches.put(match.getFightNumber(), match);
        }
        for (Map.Entry entry : this.matchManager.getMatchPointsForMatches(new HashSet(matches.values())).entrySet()) {
            matchPoints.put(((Match)entry.getKey()).getFightNumber(), (Set<MatchPoint>)entry.getValue());
        }
        DuoTable duoTable = new DuoTable();
        for (Map.Entry entry : draw.entrySet()) {
            Competitor competitor = (Competitor)entry.getKey();
            if (entry.getValue() == null || ((GroupDraw)entry.getValue()).getDrawGroup() == null) continue;
            duoTable.addCompetitor(competitor);
        }
        if (update && !duoPresentationsToRemove.isEmpty()) {
            for (DuoPresentation duoPresentation : duoPresentationsToRemove) {
                this.duoPresentationManager.removeDuoPresentation(duoPresentation);
            }
        }
        this.processDuoTable(competitionRules, duo2023Category, duoTable, duoPresentations, draw, update);
        this.processKnockoutStage(update, competitionRules, matches, matchPoints, duo2023Category, duoTable);
        if (update) {
            this.duoPresentationManager.updateDuoPresentationAdvancementData((Collection)duoPresentations);
            this.matchManager.updateMatchTreeAdvancmentData(matches.values());
        }
        if (update) {
            Map<Competitor, Integer> map = this.duo2023PlacingCalculator.calculatePlacings(duo2023Category, duoTable, Rank.WORLD_LEVEL);
            this.categoryManager.setPlacings((Category)duo2023Category, map, Rank.WORLD_LEVEL);
            Map<Competitor, Integer> map2 = this.duo2023PlacingCalculator.calculatePlacings(duo2023Category, duoTable, Rank.ADVANCED);
            this.categoryManager.setPlacings((Category)duo2023Category, map2, Rank.ADVANCED);
            Map<Competitor, Integer> novicePlacings = this.duo2023PlacingCalculator.calculatePlacings(duo2023Category, duoTable, Rank.NOVICE);
            this.categoryManager.setPlacings((Category)duo2023Category, novicePlacings, Rank.NOVICE);
        }
        return duoTable;
    }

    private DuoPresentation getOrCreateDuoPresentation(List<DuoPresentation> duoPresentations, Competitor competitor, Duo2023Category duo2023Category, Round round, Map<Competitor, GroupDraw> draw) {
        DuoPresentation duoPresentation = duoPresentations.stream().filter(dp -> competitor.equals((Object)dp.getCompetitor()) && dp.getRound() == round).findFirst().orElse(null);
        Integer groupNumber = null;
        GroupDraw groupDraw = draw.get(competitor);
        if (groupDraw != null && groupDraw.getDrawGroup() != null) {
            groupNumber = groupDraw.getDrawGroup();
        }
        if (duoPresentation == null) {
            duoPresentation = new DuoPresentation();
            duoPresentation.setCompetitor(competitor);
            duoPresentation.setCategory((Category)duo2023Category);
            duoPresentation.setStatus(DuoPresentation.Status.WAITING);
            duoPresentation.setRound(round);
            duoPresentation.setGroupNumber(groupNumber);
            duoPresentation.setGroupPosition(Integer.valueOf(0));
            duoPresentation.setNotNeeded(Boolean.FALSE);
            duoPresentation = this.duoPresentationManager.createDuoPresentation(duoPresentation);
            duoPresentations.add(duoPresentation);
        } else {
            duoPresentation.setGroupNumber(groupNumber);
        }
        return duoPresentation;
    }

    private DuoPresentation getDuoPresentation(List<DuoPresentation> duoPresentations, Competitor competitor, Round round) {
        return duoPresentations.stream().filter(dp -> competitor.equals((Object)dp.getCompetitor()) && dp.getRound() == round).findFirst().orElse(null);
    }

    private Match getOrCreateMatch(Map<Integer, Match> matches, Duo2023Category duo2023Category, int fightNumber) {
        Match match = matches.get(fightNumber);
        if (match == null) {
            match = new Match();
            match.setCategory((Category)duo2023Category);
            match.setStatus(Match.Status.WAITING);
            match.setType(Match.Type.DUO2023);
            match.setFightNumber(Integer.valueOf(fightNumber));
            match.setNotNeeded(Boolean.FALSE);
            match.setMatchEmpty(Boolean.TRUE);
            match.setNoWinner(Boolean.FALSE);
            match = this.matchManager.createMatch(match);
            matches.put(fightNumber, match);
        }
        return match;
    }

    private Match getMatch(Map<Integer, Match> matches, int fightNumber) {
        return matches.get(fightNumber);
    }

    private void processDuoTable(CompetitionRules competitionRules, Duo2023Category duo2023Category, DuoTable duoTable, List<DuoPresentation> duoPresentations, Map<Competitor, GroupDraw> draw, boolean update) {
        if (duoTable.getRows() == null) {
            duoTable.setFinished(true);
            return;
        }
        AgeCategoryOption ageCategoryOption = this.ageCategoryOptionManager.getForCategory(duo2023Category);
        LinkedList<Round> rounds = new LinkedList<Round>();
        rounds.add(Round.ROUND_1);
        rounds.add(Round.ROUND_2);
        if (competitionRules.isDuoPresentationRoundNeeded(ageCategoryOption, 3)) {
            rounds.add(Round.ROUND_3);
        }
        for (Round round : rounds) {
            for (DuoTable.Row row : duoTable.getRows()) {
                DuoPresentation duoPresentation = update ? this.getOrCreateDuoPresentation(duoPresentations, row.getCompetitor(), duo2023Category, round, draw) : this.getDuoPresentation(duoPresentations, row.getCompetitor(), round);
                if (duoPresentation == null) continue;
                float points = 0.0f;
                float varietyScorePoints = 0.0f;
                if (duoPresentation.getStatus() == DuoPresentation.Status.FINISHED) {
                    row.setFinished(row.getFinished() + 1);
                    Set duoPresentationPoints = this.duoPresentationManager.getDuoPresentationPointsForDuoPresentation(duoPresentation);
                    points = competitionRules.sumDuoPresentationPoints(duoPresentationPoints);
                    varietyScorePoints = competitionRules.sumVarietyScorePoints(duoPresentationPoints);
                }
                if (round == Round.ROUND_1) {
                    row.setRound1Points(points);
                    row.setRound1VarietyScorePoints(varietyScorePoints);
                } else if (round == Round.ROUND_2) {
                    row.setRound2Points(points);
                    row.setRound2VarietyScorePoints(varietyScorePoints);
                } else if (round == Round.ROUND_3) {
                    row.setRound3Points(points);
                    row.setRound3VarietyScorePoints(varietyScorePoints);
                }
                row.setTotalPoints(row.getRound1Points() + row.getRound2Points() + row.getRound3Points());
                row.setTotalVarietyScorePoints(row.getRound1VarietyScorePoints() + row.getRound2VarietyScorePoints() + row.getRound3VarietyScorePoints());
            }
            if (!update) continue;
            ArrayList rows = new ArrayList(duoTable.getRows());
            if (round == Round.ROUND_2) {
                Collections.sort(rows, new Comparator<DuoTable.Row>(){

                    @Override
                    public int compare(DuoTable.Row o1, DuoTable.Row o2) {
                        return new ObjectCompare().addValue((double)o1.getRound1Points(), (double)o2.getRound1Points()).addValue((double)o1.getRound1VarietyScorePoints(), (double)o2.getRound1VarietyScorePoints()).calculateCompare();
                    }
                });
            } else if (round == Round.ROUND_3) {
                Collections.sort(rows, new Comparator<DuoTable.Row>(){

                    @Override
                    public int compare(DuoTable.Row o1, DuoTable.Row o2) {
                        return new ObjectCompare().addValue((double)o1.getRound1Points() + (double)o1.getRound2Points(), (double)o2.getRound1Points() + (double)o2.getRound2Points()).addValue((double)o1.getRound1VarietyScorePoints() + (double)o1.getRound2VarietyScorePoints(), (double)o2.getRound1VarietyScorePoints() + (double)o2.getRound2VarietyScorePoints()).calculateCompare();
                    }
                });
            }
            int n = 1;
            for (DuoTable.Row row : rows) {
                DuoPresentation duoPresentation = this.getOrCreateDuoPresentation(duoPresentations, row.getCompetitor(), duo2023Category, round, draw);
                duoPresentation.setGroupPosition(Integer.valueOf(n++));
            }
        }
        boolean finished = true;
        for (DuoTable.Row row : duoTable.getRows()) {
            if (row.getFinished() >= rounds.size()) continue;
            finished = false;
            break;
        }
        if (update) {
            for (DuoPresentation duoPresentation : duoPresentations) {
                duoPresentation.setNotNeeded(Boolean.FALSE);
            }
        }
        duoTable.setFinished(finished);
        competitionRules.setPlacingsInDuoTable(duoTable);
    }

    private void processKnockoutStage(boolean update, CompetitionRules competitionRules, Map<Integer, Match> matches, Map<Integer, Set<MatchPoint>> matchPoints, Duo2023Category duo2023Category, DuoTable duoTable) {
        for (Rank rank : Rank.values()) {
            int competitorCount = 0;
            if (rank == Rank.WORLD_LEVEL) {
                if (duoTable.getRows() != null) {
                    competitorCount = Math.min(duoTable.getRows().size(), 4);
                }
            } else if (rank == Rank.ADVANCED) {
                if (duoTable.getRows() != null) {
                    competitorCount = Math.min(duoTable.getRows().size() - 4, 4);
                }
            } else if (rank == Rank.NOVICE && duoTable.getRows() != null) {
                competitorCount = Math.min(duoTable.getRows().size() - 8, 4);
            }
            competitorCount = Math.max(competitorCount, 0);
            int offset = 0;
            if (rank == Rank.ADVANCED) {
                offset = 4;
            } else if (rank == Rank.NOVICE) {
                offset = 8;
            }
            for (int i = 1; i <= 4; ++i) {
                Match m2;
                Match m1;
                Match match = update ? this.getOrCreateMatch(matches, duo2023Category, offset + i) : this.getMatch(matches, offset + i);
                if (match == null) continue;
                if (i <= 3) {
                    if (competitorCount < 4) {
                        match.setCompetitor1(null);
                        match.setCompetitor2(null);
                        match.setMatchEmpty(Boolean.valueOf(true));
                        match.setNotNeeded(Boolean.valueOf(true));
                        continue;
                    }
                    if (duoTable.isFinished()) {
                        if (i == 1) {
                            match.setCompetitor1(duoTable.getCompetitorAtPosition(offset + 4));
                            match.setCompetitor2(duoTable.getCompetitorAtPosition(offset + 1));
                            continue;
                        }
                        if (i == 2) {
                            match.setCompetitor1(duoTable.getCompetitorAtPosition(offset + 3));
                            match.setCompetitor2(duoTable.getCompetitorAtPosition(offset + 2));
                            continue;
                        }
                        if (i != 3) continue;
                        if (!duo2023Category.getDouble3rdPlace().booleanValue()) {
                            if (update) {
                                m1 = this.getOrCreateMatch(matches, duo2023Category, offset + 1);
                                m2 = this.getOrCreateMatch(matches, duo2023Category, offset + 2);
                            } else {
                                m1 = this.getMatch(matches, offset + 1);
                                m2 = this.getMatch(matches, offset + 2);
                            }
                            this.setMatchProcessLosers(competitionRules, match, m1, matchPoints.get(m1.getFightNumber()), m2, matchPoints.get(m2.getFightNumber()));
                            continue;
                        }
                        match.setCompetitor1(null);
                        match.setCompetitor2(null);
                        match.setMatchEmpty(Boolean.valueOf(true));
                        match.setNotNeeded(Boolean.valueOf(true));
                        continue;
                    }
                    if (i == 3) {
                        if (!duo2023Category.getDouble3rdPlace().booleanValue()) continue;
                        match.setCompetitor1(null);
                        match.setCompetitor2(null);
                        match.setMatchEmpty(Boolean.valueOf(true));
                        match.setNotNeeded(Boolean.valueOf(true));
                        continue;
                    }
                    match.setCompetitor1(null);
                    match.setCompetitor2(null);
                    match.setMatchEmpty(Boolean.valueOf(false));
                    match.setNotNeeded(Boolean.valueOf(false));
                    continue;
                }
                match.setMatchEmpty(Boolean.valueOf(false));
                match.setNotNeeded(Boolean.valueOf(false));
                if (duoTable.isFinished()) {
                    if (competitorCount < 4) {
                        match.setCompetitor1(duoTable.getCompetitorAtPosition(offset + 1));
                        match.setCompetitor2(duoTable.getCompetitorAtPosition(offset + 2));
                        if (match.getCompetitor1() == null && match.getCompetitor2() == null) {
                            match.setMatchEmpty(Boolean.valueOf(true));
                        }
                        if (match.getCompetitor1() != null && match.getCompetitor2() != null) continue;
                        match.setNotNeeded(Boolean.valueOf(true));
                        continue;
                    }
                    if (update) {
                        m1 = this.getOrCreateMatch(matches, duo2023Category, offset + 1);
                        m2 = this.getOrCreateMatch(matches, duo2023Category, offset + 2);
                    } else {
                        m1 = this.getMatch(matches, offset + 1);
                        m2 = this.getMatch(matches, offset + 2);
                    }
                    this.setMatchProcessWinners(competitionRules, match, m1, matchPoints.get(m1.getFightNumber()), m2, matchPoints.get(m2.getFightNumber()));
                    continue;
                }
                match.setCompetitor1(null);
                match.setCompetitor2(null);
                if (competitorCount <= 1) {
                    match.setMatchEmpty(Boolean.valueOf(true));
                    match.setNotNeeded(Boolean.valueOf(true));
                    continue;
                }
                match.setMatchEmpty(Boolean.valueOf(false));
                match.setNotNeeded(Boolean.valueOf(false));
            }
        }
    }

    private void setMatchProcessWinners(CompetitionRules competitionRules, Match match, Match m1, Set<MatchPoint> mp1, Match m2, Set<MatchPoint> mp2) {
        boolean nn1 = false;
        boolean nn2 = false;
        if (m1 != null) {
            if (m1.getMatchEmpty().booleanValue() || m1.getNoWinner().booleanValue()) {
                match.setCompetitor1(null);
                nn1 = true;
            } else if (m1.getNotNeeded().booleanValue()) {
                if (m1.getCompetitor1() != null) {
                    match.setCompetitor1(m1.getCompetitor1());
                } else if (m1.getCompetitor2() != null) {
                    match.setCompetitor1(m1.getCompetitor2());
                } else {
                    match.setCompetitor1(null);
                }
                nn1 = match.getCompetitor1() == null;
            } else if (m1.getStatus() == Match.Status.FINISHED) {
                match.setCompetitor1(competitionRules.getMatchWinner(m1, mp1));
                nn1 = match.getCompetitor1() == null;
            } else {
                match.setCompetitor1(null);
            }
        }
        if (m2 != null) {
            if (m2.getMatchEmpty().booleanValue() || m2.getNoWinner().booleanValue()) {
                match.setCompetitor2(null);
                nn2 = true;
            } else if (m2.getNotNeeded().booleanValue()) {
                if (m2.getCompetitor1() != null) {
                    match.setCompetitor2(m2.getCompetitor1());
                } else if (m2.getCompetitor2() != null) {
                    match.setCompetitor2(m2.getCompetitor2());
                } else {
                    match.setCompetitor2(null);
                }
                nn2 = match.getCompetitor2() == null;
            } else if (m2.getStatus() == Match.Status.FINISHED) {
                match.setCompetitor2(competitionRules.getMatchWinner(m2, mp2));
                nn2 = match.getCompetitor2() == null;
            } else {
                match.setCompetitor2(null);
            }
        }
        if (nn1 && nn2) {
            match.setMatchEmpty(Boolean.valueOf(true));
            match.setNotNeeded(Boolean.valueOf(true));
        } else if (nn1 || nn2) {
            match.setMatchEmpty(Boolean.valueOf(false));
            match.setNotNeeded(Boolean.valueOf(true));
        } else {
            match.setMatchEmpty(Boolean.valueOf(false));
            match.setNotNeeded(Boolean.valueOf(false));
        }
    }

    private void setMatchProcessLosers(CompetitionRules competitionRules, Match match, Match m1, Set<MatchPoint> mp1, Match m2, Set<MatchPoint> mp2) {
        boolean nn1 = false;
        boolean nn2 = false;
        if (m1 != null) {
            if (m1.getMatchEmpty().booleanValue() || m1.getNotNeeded().booleanValue() || m1.getNoWinner().booleanValue()) {
                match.setCompetitor1(null);
                nn1 = true;
            } else if (m1.getStatus() == Match.Status.FINISHED) {
                match.setCompetitor1(competitionRules.getMatchLoser(m1, mp1));
                nn1 = match.getCompetitor1() == null;
            } else {
                match.setCompetitor1(null);
            }
        }
        if (m2 != null) {
            if (m2.getMatchEmpty().booleanValue() || m2.getNotNeeded().booleanValue() || m2.getNoWinner().booleanValue()) {
                match.setCompetitor2(null);
                nn2 = true;
            } else if (m2.getStatus() == Match.Status.FINISHED) {
                match.setCompetitor2(competitionRules.getMatchLoser(m2, mp2));
                nn2 = match.getCompetitor2() == null;
            } else {
                match.setCompetitor2(null);
            }
        }
        if (nn1 && nn2) {
            match.setMatchEmpty(Boolean.valueOf(true));
            match.setNotNeeded(Boolean.valueOf(true));
        } else if (nn1 || nn2) {
            match.setMatchEmpty(Boolean.valueOf(false));
            match.setNotNeeded(Boolean.valueOf(true));
        } else {
            match.setMatchEmpty(Boolean.valueOf(false));
            match.setNotNeeded(Boolean.valueOf(false));
        }
    }
}

