/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiHistory;
import si.nevensrok.jtekma.server.dl.dao.TatamiHistoryDAO;
import si.nevensrok.jtekma.server.management.TatamiHistoryManager;

@Transactional(value="jtekmaTransactionManager")
public class TatamiHistoryManagerImpl
implements TatamiHistoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TatamiHistoryManagerImpl.class);
    private TatamiHistoryDAO tatamiHistoryDAO;

    public void setTatamiHistoryDAO(TatamiHistoryDAO tatamiHistoryDAO) {
        this.tatamiHistoryDAO = tatamiHistoryDAO;
    }

    public TatamiHistory createTatamiHistory(TatamiHistory tatamiHistory) {
        LOGGER.debug("Creating tatami history: {}", (Object)tatamiHistory);
        return (TatamiHistory)this.tatamiHistoryDAO.create((Pojo)tatamiHistory);
    }

    public TatamiHistory updateTatamiHistory(TatamiHistory tatamiHistory) {
        LOGGER.debug("Updating tatami history: {}", (Object)tatamiHistory);
        return (TatamiHistory)this.tatamiHistoryDAO.update((Pojo)tatamiHistory);
    }

    public void deleteTatamiHistory(TatamiHistory tatamiHistory) {
        LOGGER.debug("Deleting tatami history: {}", (Object)tatamiHistory);
        this.tatamiHistoryDAO.delete((Pojo)tatamiHistory);
    }

    public TatamiHistory getTatamiHistoryById(Long tatamiHistoryiId) {
        return (TatamiHistory)this.tatamiHistoryDAO.getById((Object)tatamiHistoryiId);
    }

    public PageDataResult<TatamiHistory> findTatamiHistory(Tatami tatami, DataFilter dataFilter) {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("tatami", FieldFilter.Comparator.EQUAL, (Object)tatami.getTatamiId()));
        rootFilter.addFilter(dataFilter.getFilter());
        ((SimpleDataFilter)dataFilter).setFilter((Filter)rootFilter);
        return this.tatamiHistoryDAO.find(dataFilter, false);
    }

    public void deleteTatamiHistoryForTatami(Tatami tatami) {
        this.tatamiHistoryDAO.deleteTatamiHistoryForTatami(tatami);
    }
}

