/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.tatami.Event;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.EventManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TatamiFightsManager;
import si.nevensrok.jtekma.server.management.TatamiManager;

public class TatamiFightsManagerImpl
implements TatamiFightsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TatamiFightsManagerImpl.class);
    private final Set<Long> lockedTatamis = new HashSet<Long>();
    private TatamiManager tatamiManager;
    private CategoryManager categoryManager;
    private MatchManager matchManager;
    private EventManager eventManager;
    private DuoPresentationManager duoPresentationManager;

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setDuoPresentationManager(DuoPresentationManager duoPresentationManager) {
        this.duoPresentationManager = duoPresentationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMatchToTatami(Match match, Tatami tatami) {
        Object category;
        boolean added = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return added;
        }
        if (match == null || match.getMatchId() == null) {
            return added;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Adding match {} to tatami {}", (Object)match, (Object)tatami);
        try {
            match = this.matchManager.getById(match.getMatchId());
            category = this.categoryManager.getCategoryForMatch(match);
            if (this.tatamiManager.isCategoryOnTatami(tatami, category)) {
                if (this.tatamiManager.getTatamiForMatch(match) == null) {
                    if (match.getStatus() == Match.Status.WAITING) {
                        ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
                        FightOrder fightOrder = new FightOrder();
                        fightOrder.setTatami(tatami);
                        fightOrder.setMatch(match);
                        fightOrder.setFightNumber(Integer.valueOf(fights.size() + 1));
                        fights.add(fightOrder);
                        this.checkList(fights);
                        this.tatamiManager.setFightOrderForTatami(tatami, fights);
                        this.matchManager.setMatchStatus(match, Match.Status.INQUEUE);
                        added = true;
                    } else {
                        LOGGER.debug("Match {} has invalid status", (Object)match);
                    }
                } else {
                    LOGGER.debug("Match {} is already on tatami", (Object)tatami);
                }
            } else {
                LOGGER.debug("Category {} is not on tatami {}", category, (Object)tatami);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error while adding match to tatami", e);
            added = false;
        }
        finally {
            category = this.lockedTatamis;
            synchronized (category) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMatchFromTatami(Match match, Tatami tatami) {
        Collection<Object> fights;
        boolean removed = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return removed;
        }
        if (match == null || match.getMatchId() == null) {
            return removed;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Removing match {} from tatami {}", (Object)match, (Object)tatami);
        try {
            match = this.matchManager.getById(match.getMatchId());
            fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (FightOrder fightOrder : new LinkedList(fights)) {
                if (fightOrder.getMatch() != null && fightOrder.getMatch().getMatchId().equals(match.getMatchId())) {
                    fights.remove(fightOrder);
                    removed = true;
                    continue;
                }
                if (!removed) continue;
                fightOrder.setFightNumber(Integer.valueOf(fightOrder.getFightNumber() - 1));
            }
            this.checkList((ArrayList<FightOrder>)fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
            if (match.getStatus() == Match.Status.INQUEUE || match.getStatus() == Match.Status.INPROGRESS) {
                this.matchManager.setMatchStatus(match, Match.Status.WAITING);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error while removing match from tatami", e);
            removed = false;
        }
        finally {
            fights = this.lockedTatamis;
            synchronized (fights) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveMatchOnTatamiUp(Match match, Tatami tatami) {
        Collection<Object> fights;
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (match == null || match.getMatchId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Moving up match {} on tatami {}", (Object)match, (Object)tatami);
        try {
            fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (int i = 1; i < ((ArrayList)fights).size(); ++i) {
                if (((FightOrder)((ArrayList)fights).get(i)).getMatch() == null || !((ArrayList)fights).get(i).getMatch().getMatchId().equals(match.getMatchId())) continue;
                ((FightOrder)((ArrayList)fights).get(i)).setFightNumber(Integer.valueOf(((FightOrder)((ArrayList)fights).get(i)).getFightNumber() - 1));
                ((FightOrder)((ArrayList)fights).get(i - 1)).setFightNumber(Integer.valueOf(((FightOrder)((ArrayList)fights).get(i - 1)).getFightNumber() + 1));
                moved = true;
                break;
            }
            this.checkList((ArrayList<FightOrder>)fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            LOGGER.error("Error while moving match up on tatami", e);
            moved = false;
        }
        finally {
            fights = this.lockedTatamis;
            synchronized (fights) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveMatchOnTatamiDown(Match match, Tatami tatami) {
        Collection<Object> fights;
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (match == null || match.getMatchId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Moving down match {} on tatami {}", (Object)match, (Object)tatami);
        try {
            fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (int i = 0; i < ((ArrayList)fights).size() - 1; ++i) {
                if (((FightOrder)((ArrayList)fights).get(i)).getMatch() == null || !((ArrayList)fights).get(i).getMatch().getMatchId().equals(match.getMatchId())) continue;
                ((FightOrder)((ArrayList)fights).get(i)).setFightNumber(Integer.valueOf(((FightOrder)((ArrayList)fights).get(i)).getFightNumber() + 1));
                ((FightOrder)((ArrayList)fights).get(i + 1)).setFightNumber(Integer.valueOf(((FightOrder)((ArrayList)fights).get(i + 1)).getFightNumber() - 1));
                moved = true;
                break;
            }
            this.checkList((ArrayList<FightOrder>)fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            LOGGER.error("Error while moving match down on tatami", e);
            moved = false;
        }
        finally {
            fights = this.lockedTatamis;
            synchronized (fights) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveMatchOnTatamiToSpot(Match match, Tatami tatami, Integer moveToSpot) {
        Collection<Object> fights;
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (match == null || match.getMatchId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Moving match {} to spot {} on tatami {}", new Object[]{match, moveToSpot, tatami});
        }
        try {
            int i;
            fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            moveToSpot = moveToSpot - 1;
            int currentSpot = -1;
            FightOrder fightOrder = null;
            for (i = 0; i < ((ArrayList)fights).size(); ++i) {
                if (((FightOrder)((ArrayList)fights).get(i)).getMatch() == null || !((ArrayList)fights).get(i).getMatch().getMatchId().equals(match.getMatchId())) continue;
                currentSpot = i;
                fightOrder = (FightOrder)((ArrayList)fights).remove(i);
                break;
            }
            if (fightOrder != null) {
                if (moveToSpot <= currentSpot) {
                    ((ArrayList)fights).add(moveToSpot, fightOrder);
                } else {
                    ((ArrayList)fights).add(moveToSpot - 1, fightOrder);
                }
                for (i = 0; i < ((ArrayList)fights).size(); ++i) {
                    ((FightOrder)((ArrayList)fights).get(i)).setFightNumber(Integer.valueOf(i + 1));
                }
            }
            this.checkList((ArrayList<FightOrder>)fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            LOGGER.error("Error while moving match to custom spot on tatami", e);
            moved = false;
        }
        finally {
            fights = this.lockedTatamis;
            synchronized (fights) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDuoPresentationToTatami(DuoPresentation duoPresentation, Tatami tatami) {
        Object category;
        boolean added = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return added;
        }
        if (duoPresentation == null || duoPresentation.getDuoPresentationId() == null) {
            return added;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Adding duo presentation {} to tatami {}", (Object)duoPresentation, (Object)tatami);
        try {
            duoPresentation = this.duoPresentationManager.getById(duoPresentation.getDuoPresentationId());
            category = this.categoryManager.getCategoryForDuoPresentation(duoPresentation);
            if (this.tatamiManager.isCategoryOnTatami(tatami, category)) {
                if (this.tatamiManager.getTatamiForDuoPresentation(duoPresentation) == null) {
                    if (duoPresentation.getStatus() == DuoPresentation.Status.WAITING) {
                        ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
                        FightOrder fightOrder = new FightOrder();
                        fightOrder.setTatami(tatami);
                        fightOrder.setDuoPresentation(duoPresentation);
                        fightOrder.setFightNumber(Integer.valueOf(fights.size() + 1));
                        fights.add(fightOrder);
                        this.checkList(fights);
                        this.tatamiManager.setFightOrderForTatami(tatami, fights);
                        this.duoPresentationManager.setDuoPresentationStatus(duoPresentation, DuoPresentation.Status.INQUEUE);
                        added = true;
                    } else {
                        LOGGER.debug("Duo presentation {} has invalid status", (Object)duoPresentation);
                    }
                } else {
                    LOGGER.debug("Duo presentation {} is already on tatami", (Object)tatami);
                }
            } else {
                LOGGER.debug("Category {} is not on tatami {}", category, (Object)tatami);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error while adding duo presentation to tatami", e);
            added = false;
        }
        finally {
            category = this.lockedTatamis;
            synchronized (category) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDuoPresentationFromTatami(DuoPresentation duoPresentation, Tatami tatami) {
        Collection<Object> fights;
        boolean removed = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return removed;
        }
        if (duoPresentation == null || duoPresentation.getDuoPresentationId() == null) {
            return removed;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Removing duo presentation {} from tatami {}", (Object)duoPresentation, (Object)tatami);
        try {
            duoPresentation = this.duoPresentationManager.getById(duoPresentation.getDuoPresentationId());
            fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (FightOrder fightOrder : new LinkedList(fights)) {
                if (fightOrder.getDuoPresentation() != null && fightOrder.getDuoPresentation().getDuoPresentationId().equals(duoPresentation.getDuoPresentationId())) {
                    fights.remove(fightOrder);
                    removed = true;
                    continue;
                }
                if (!removed) continue;
                fightOrder.setFightNumber(Integer.valueOf(fightOrder.getFightNumber() - 1));
            }
            this.checkList((ArrayList<FightOrder>)fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
            if (duoPresentation.getStatus() == DuoPresentation.Status.INQUEUE || duoPresentation.getStatus() == DuoPresentation.Status.INPROGRESS) {
                this.duoPresentationManager.setDuoPresentationStatus(duoPresentation, DuoPresentation.Status.WAITING);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error while removing duo presentation from tatami", e);
            removed = false;
        }
        finally {
            fights = this.lockedTatamis;
            synchronized (fights) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveDuoPresentationOnTatamiUp(DuoPresentation duoPresentation, Tatami tatami) {
        Collection<Object> fights;
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (duoPresentation == null || duoPresentation.getDuoPresentationId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Moving up duo presentation {} on tatami {}", (Object)duoPresentation, (Object)tatami);
        try {
            fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (int i = 1; i < ((ArrayList)fights).size(); ++i) {
                if (((FightOrder)((ArrayList)fights).get(i)).getDuoPresentation() == null || !((ArrayList)fights).get(i).getDuoPresentation().getDuoPresentationId().equals(duoPresentation.getDuoPresentationId())) continue;
                ((FightOrder)((ArrayList)fights).get(i)).setFightNumber(Integer.valueOf(((FightOrder)((ArrayList)fights).get(i)).getFightNumber() - 1));
                ((FightOrder)((ArrayList)fights).get(i - 1)).setFightNumber(Integer.valueOf(((FightOrder)((ArrayList)fights).get(i - 1)).getFightNumber() + 1));
                moved = true;
                break;
            }
            this.checkList((ArrayList<FightOrder>)fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            LOGGER.error("Error while moving duo presentation up on tatami", e);
            moved = false;
        }
        finally {
            fights = this.lockedTatamis;
            synchronized (fights) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveDuoPresentationOnTatamiDown(DuoPresentation duoPresentation, Tatami tatami) {
        Collection<Object> fights;
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (duoPresentation == null || duoPresentation.getDuoPresentationId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Moving down duo presentation {} on tatami {}", (Object)duoPresentation, (Object)tatami);
        try {
            fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (int i = 0; i < ((ArrayList)fights).size() - 1; ++i) {
                if (((FightOrder)((ArrayList)fights).get(i)).getDuoPresentation() == null || !((ArrayList)fights).get(i).getDuoPresentation().getDuoPresentationId().equals(duoPresentation.getDuoPresentationId())) continue;
                ((FightOrder)((ArrayList)fights).get(i)).setFightNumber(Integer.valueOf(((FightOrder)((ArrayList)fights).get(i)).getFightNumber() + 1));
                ((FightOrder)((ArrayList)fights).get(i + 1)).setFightNumber(Integer.valueOf(((FightOrder)((ArrayList)fights).get(i + 1)).getFightNumber() - 1));
                moved = true;
                break;
            }
            this.checkList((ArrayList<FightOrder>)fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            LOGGER.error("Error while moving duo presentation down on tatami", e);
            moved = false;
        }
        finally {
            fights = this.lockedTatamis;
            synchronized (fights) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveDuoPresentationOnTatamiToSpot(DuoPresentation duoPresentation, Tatami tatami, Integer moveToSpot) {
        Collection<Object> fights;
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (duoPresentation == null || duoPresentation.getDuoPresentationId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Moving duo presentation {} to spot {} on tatami {}", new Object[]{duoPresentation, moveToSpot, tatami});
        }
        try {
            int i;
            fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            moveToSpot = moveToSpot - 1;
            int currentSpot = -1;
            FightOrder fightOrder = null;
            for (i = 0; i < ((ArrayList)fights).size(); ++i) {
                if (((FightOrder)((ArrayList)fights).get(i)).getDuoPresentation() == null || !((ArrayList)fights).get(i).getDuoPresentation().getDuoPresentationId().equals(duoPresentation.getDuoPresentationId())) continue;
                currentSpot = i;
                fightOrder = (FightOrder)((ArrayList)fights).remove(i);
                break;
            }
            if (fightOrder != null) {
                if (moveToSpot <= currentSpot) {
                    ((ArrayList)fights).add(moveToSpot, fightOrder);
                } else {
                    ((ArrayList)fights).add(moveToSpot - 1, fightOrder);
                }
                for (i = 0; i < ((ArrayList)fights).size(); ++i) {
                    ((FightOrder)((ArrayList)fights).get(i)).setFightNumber(Integer.valueOf(i + 1));
                }
            }
            this.checkList((ArrayList<FightOrder>)fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            LOGGER.error("Error while moving duo presentation to custom spot on tatami", e);
            moved = false;
        }
        finally {
            fights = this.lockedTatamis;
            synchronized (fights) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEventToTatami(Event event, Tatami tatami) {
        boolean added = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return added;
        }
        if (event == null) {
            return added;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Adding event {} to tatami {}", (Object)event, (Object)tatami);
        try {
            event.setTatami(tatami);
            event = this.eventManager.createEvent(event);
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            FightOrder fightOrder = new FightOrder();
            fightOrder.setTatami(tatami);
            fightOrder.setEvent(event);
            fightOrder.setFightNumber(Integer.valueOf(fights.size() + 1));
            fights.add(fightOrder);
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
            added = true;
        }
        catch (Throwable e) {
            LOGGER.error("Error while adding event to tatami", e);
            added = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEventFromTatami(Event event, Tatami tatami) {
        boolean removed = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return removed;
        }
        if (event == null || event.getEventId() == null) {
            return removed;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Removing event {} from tatami {}", (Object)event, (Object)tatami);
        try {
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (FightOrder fightOrder : new LinkedList(fights)) {
                if (fightOrder.getEvent() != null && fightOrder.getEvent().getEventId().equals(event.getEventId())) {
                    fights.remove(fightOrder);
                    removed = true;
                    continue;
                }
                if (!removed) continue;
                fightOrder.setFightNumber(Integer.valueOf(fightOrder.getFightNumber() - 1));
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            LOGGER.error("Error while removing event from tatami", e);
            removed = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveEventOnTatamiUp(Event event, Tatami tatami) {
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (event == null || event.getEventId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Moving up event {} on tatami {}", (Object)event, (Object)tatami);
        try {
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (int i = 1; i < fights.size(); ++i) {
                if (((FightOrder)fights.get(i)).getEvent() == null || !fights.get(i).getEvent().getEventId().equals(event.getEventId())) continue;
                fights.get(i).setFightNumber(Integer.valueOf(fights.get(i).getFightNumber() - 1));
                fights.get(i - 1).setFightNumber(Integer.valueOf(fights.get(i - 1).getFightNumber() + 1));
                moved = true;
                break;
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            LOGGER.error("Error while moving event up on tatami", e);
            moved = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveEventOnTatamiDown(Event event, Tatami tatami) {
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (event == null || event.getEventId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Moving down event {} on tatami {}", (Object)event, (Object)tatami);
        try {
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (int i = 0; i < fights.size() - 1; ++i) {
                if (((FightOrder)fights.get(i)).getEvent() == null || !fights.get(i).getEvent().getEventId().equals(event.getEventId())) continue;
                fights.get(i).setFightNumber(Integer.valueOf(fights.get(i).getFightNumber() + 1));
                fights.get(i + 1).setFightNumber(Integer.valueOf(fights.get(i + 1).getFightNumber() - 1));
                moved = true;
                break;
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            LOGGER.error("Error while moving event down on tatami", e);
            moved = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveEventOnTatamiToSpot(Event event, Tatami tatami, Integer moveToSpot) {
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (event == null || event.getEventId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Moving event {} to spot {} on tatami {}", new Object[]{event, moveToSpot, tatami});
        }
        try {
            int i;
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            moveToSpot = moveToSpot - 1;
            int currentSpot = -1;
            FightOrder fightOrder = null;
            for (i = 0; i < fights.size(); ++i) {
                if (((FightOrder)fights.get(i)).getEvent() == null || !fights.get(i).getEvent().getEventId().equals(event.getEventId())) continue;
                currentSpot = i;
                fightOrder = fights.remove(i);
                break;
            }
            if (fightOrder != null) {
                if (moveToSpot <= currentSpot) {
                    fights.add(moveToSpot, fightOrder);
                } else {
                    fights.add(moveToSpot - 1, fightOrder);
                }
                for (i = 0; i < fights.size(); ++i) {
                    fights.get(i).setFightNumber(Integer.valueOf(i + 1));
                }
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            LOGGER.error("Error while moving event to custom spot on tatami", e);
            moved = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMatchFights(Tatami tatami) {
        Collection<Object> fights;
        if (tatami == null || tatami.getTatamiId() == null) {
            return;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Checking fights on tatami {}", (Object)tatami);
        try {
            fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            this.checkList((ArrayList<FightOrder>)fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            LOGGER.error("Error while checking fights on tatami", e);
        }
        finally {
            fights = this.lockedTatamis;
            synchronized (fights) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
    }

    private void checkList(ArrayList<FightOrder> fights) {
        Collections.sort(fights, new Comparator<FightOrder>(){

            @Override
            public int compare(FightOrder o1, FightOrder o2) {
                return o1.getFightNumber().compareTo(o2.getFightNumber());
            }
        });
        int n = 1;
        for (FightOrder fightOrder : new ArrayList<FightOrder>(fights)) {
            if (fightOrder.getMatch() != null && (fightOrder.getMatch().getStatus() == Match.Status.FINISHED || fightOrder.getMatch().getNotNeeded().booleanValue())) {
                fights.remove(fightOrder);
                continue;
            }
            if (fightOrder.getDuoPresentation() != null && (fightOrder.getDuoPresentation().getStatus() == DuoPresentation.Status.FINISHED || fightOrder.getDuoPresentation().getNotNeeded().booleanValue())) {
                fights.remove(fightOrder);
                continue;
            }
            if (fightOrder.getEvent() != null && fightOrder.getEvent().getAutoRemove().booleanValue() && n == 1) {
                fights.remove(fightOrder);
                continue;
            }
            if (fightOrder.getMatch() != null && fightOrder.getMatch().getStatus() == Match.Status.INPROGRESS && n != 1) {
                this.matchManager.setMatchStatus(fightOrder.getMatch(), Match.Status.INQUEUE);
            }
            fightOrder.setFightNumber(Integer.valueOf(n++));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Match getNextMatchForTatami(Tatami tatami, boolean markInProgress) {
        if (tatami == null || tatami.getTatamiId() == null) {
            return null;
        }
        Match match = null;
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Checking fights on tatami {}", (Object)tatami);
        try {
            List fights = this.tatamiManager.getFightOrderForTatami(tatami);
            if (!fights.isEmpty() && (match = ((FightOrder)fights.get(0)).getMatch()) != null && markInProgress) {
                this.matchManager.setMatchStatus(match, Match.Status.INPROGRESS);
                match.setStatus(Match.Status.INPROGRESS);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error while getting next match", e);
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNextMatchForTatami(Tatami tatami, Match match) {
        if (tatami == null || tatami.getTatamiId() == null) {
            return false;
        }
        if (match == null || match.getMatchId() == null) {
            return false;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Checking fights on tatami {}", (Object)tatami);
        try {
            Collection<Object> fights = this.tatamiManager.getFightOrderForTatami(tatami);
            if (!fights.isEmpty()) {
                Match nextMatch = ((FightOrder)fights.get(0)).getMatch();
                if (nextMatch == null) {
                    boolean bl = false;
                    return bl;
                }
                if (match.getMatchId().equals(nextMatch.getMatchId())) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error while checking next match", e);
        }
        finally {
            Set<Long> set2 = this.lockedTatamis;
            synchronized (set2) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DuoPresentation getNextDuoPresentationForTatami(Tatami tatami, boolean markInProgress) {
        if (tatami == null || tatami.getTatamiId() == null) {
            return null;
        }
        DuoPresentation duoPresentation = null;
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Checking fights on tatami {}", (Object)tatami);
        try {
            List fights = this.tatamiManager.getFightOrderForTatami(tatami);
            if (!fights.isEmpty() && (duoPresentation = ((FightOrder)fights.get(0)).getDuoPresentation()) != null && markInProgress) {
                this.duoPresentationManager.setDuoPresentationStatus(duoPresentation, DuoPresentation.Status.INPROGRESS);
                duoPresentation.setStatus(DuoPresentation.Status.INPROGRESS);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error while getting next duo presentation", e);
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return duoPresentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNextDuoPresentationForTatami(Tatami tatami, DuoPresentation duoPresentation) {
        if (tatami == null || tatami.getTatamiId() == null) {
            return false;
        }
        if (duoPresentation == null || duoPresentation.getDuoPresentationId() == null) {
            return false;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        LOGGER.debug("Checking fights on tatami {}", (Object)tatami);
        try {
            Collection<Object> fights = this.tatamiManager.getFightOrderForTatami(tatami);
            if (!fights.isEmpty()) {
                DuoPresentation nextDuoPresentation = ((FightOrder)fights.get(0)).getDuoPresentation();
                if (nextDuoPresentation == null) {
                    boolean bl = false;
                    return bl;
                }
                if (duoPresentation.getDuoPresentationId().equals(nextDuoPresentation.getDuoPresentationId())) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error while checking next duo presentation", e);
        }
        finally {
            Set<Long> set2 = this.lockedTatamis;
            synchronized (set2) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatchesForCategory(Category category) {
        LinkedHashSet<Category> categories = new LinkedHashSet<Category>();
        categories.add(category);
        for (Tatami tatami : (Set)this.tatamiManager.getTatamisForCategories(categories).get(category)) {
            Collection<Object> fights;
            Set<Long> set = this.lockedTatamis;
            synchronized (set) {
                while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                    try {
                        this.lockedTatamis.wait();
                    }
                    catch (Exception exception) {}
                }
                this.lockedTatamis.add(tatami.getTatamiId());
            }
            try {
                fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
                for (FightOrder fightOrder : new LinkedList(fights)) {
                    Category categoryForDuoPresentation;
                    Category categoryForMatch;
                    if (fightOrder.getMatch() == null) continue;
                    Match match = fightOrder.getMatch();
                    DuoPresentation duoPresentation = fightOrder.getDuoPresentation();
                    if (match != null && (categoryForMatch = this.categoryManager.getCategoryForMatch(match)) != null && category.getCategoryId().equals(categoryForMatch.getCategoryId())) {
                        ((ArrayList)fights).remove(fightOrder);
                    }
                    if (duoPresentation == null || (categoryForDuoPresentation = this.categoryManager.getCategoryForDuoPresentation(duoPresentation)) == null || !category.getCategoryId().equals(categoryForDuoPresentation.getCategoryId())) continue;
                    ((ArrayList)fights).remove(fightOrder);
                }
                this.checkList((ArrayList<FightOrder>)fights);
                this.tatamiManager.setFightOrderForTatami(tatami, fights);
            }
            catch (Throwable e) {
                LOGGER.error("Error while removing matches for category", e);
            }
            finally {
                fights = this.lockedTatamis;
                synchronized (fights) {
                    this.lockedTatamis.remove(tatami.getTatamiId());
                    this.lockedTatamis.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatch(Match matchToRemove) {
        Tatami tatami;
        while ((tatami = this.tatamiManager.getTatamiForMatch(matchToRemove)) != null) {
            Collection<Object> fights;
            Set<Long> set = this.lockedTatamis;
            synchronized (set) {
                while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                    try {
                        this.lockedTatamis.wait();
                    }
                    catch (Exception exception) {}
                }
                this.lockedTatamis.add(tatami.getTatamiId());
            }
            try {
                fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
                for (FightOrder fightOrder : new LinkedList(fights)) {
                    Match match;
                    if (fightOrder.getMatch() == null || !(match = fightOrder.getMatch()).getMatchId().equals(matchToRemove.getMatchId())) continue;
                    ((ArrayList)fights).remove(fightOrder);
                }
                this.checkList((ArrayList<FightOrder>)fights);
                this.tatamiManager.setFightOrderForTatami(tatami, fights);
                continue;
            }
            catch (Throwable e) {
                LOGGER.error("Error while removing match", e);
                continue;
            }
            finally {
                fights = this.lockedTatamis;
                synchronized (fights) {
                    this.lockedTatamis.remove(tatami.getTatamiId());
                    this.lockedTatamis.notifyAll();
                }
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDuoPresentation(DuoPresentation duoPresentationToRemove) {
        Tatami tatami;
        while ((tatami = this.tatamiManager.getTatamiForDuoPresentation(duoPresentationToRemove)) != null) {
            Collection<Object> fights;
            Set<Long> set = this.lockedTatamis;
            synchronized (set) {
                while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                    try {
                        this.lockedTatamis.wait();
                    }
                    catch (Exception exception) {}
                }
                this.lockedTatamis.add(tatami.getTatamiId());
            }
            try {
                fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
                for (FightOrder fightOrder : new LinkedList(fights)) {
                    DuoPresentation duoPresentation;
                    if (fightOrder.getDuoPresentation() == null || !(duoPresentation = fightOrder.getDuoPresentation()).getDuoPresentationId().equals(duoPresentationToRemove.getDuoPresentationId())) continue;
                    ((ArrayList)fights).remove(fightOrder);
                }
                this.checkList((ArrayList<FightOrder>)fights);
                this.tatamiManager.setFightOrderForTatami(tatami, fights);
                continue;
            }
            catch (Throwable e) {
                LOGGER.error("Error while removing match", e);
                continue;
            }
            finally {
                fights = this.lockedTatamis;
                synchronized (fights) {
                    this.lockedTatamis.remove(tatami.getTatamiId());
                    this.lockedTatamis.notifyAll();
                }
                continue;
            }
            break;
        }
        return;
    }
}

