/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.jobs;

import java.util.Calendar;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import si.nevensrok.jtekma.common.tatami.Event;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.management.EventManager;
import si.nevensrok.jtekma.server.management.TatamiFightsManager;
import si.nevensrok.jtekma.server.management.TatamiManager;

public class EventRemoverJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventRemoverJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ApplicationContext applicationContext = (ApplicationContext)context.getScheduler().getContext().get((Object)"applicationContext");
            if (applicationContext == null) {
                throw new RuntimeException("ApplicationContext not found");
            }
            EventManager eventManager = (EventManager)applicationContext.getBean("jtekmaEventManager");
            if (eventManager == null) {
                throw new RuntimeException("EventManager not found");
            }
            TatamiManager tatamiManager = (TatamiManager)applicationContext.getBean("jtekmaTatamiManager");
            if (tatamiManager == null) {
                throw new RuntimeException("TatamiManager not found");
            }
            TatamiFightsManager tatamiFightsManager = (TatamiFightsManager)applicationContext.getBean("jtekmaTatamiFightsManager");
            if (tatamiFightsManager == null) {
                throw new RuntimeException("TatamiFightsManager not found");
            }
            for (Event event : eventManager.getExpiredEvents(Calendar.getInstance())) {
                Tatami tatami = tatamiManager.getTatamiForEvent(event);
                if (tatami == null) continue;
                tatamiFightsManager.removeEventFromTatami(event, tatami);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing event remover job", (Throwable)e);
        }
    }
}

