/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dto.tatami;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.jtekma.server.dl.dto.matches.DuoPresentationDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.MatchDTO;
import si.nevensrok.jtekma.server.dl.dto.tatami.EventDTO;
import si.nevensrok.jtekma.server.dl.dto.tatami.TatamiDTO;

@Entity
@Table(name="fightorders")
public class FightOrderDTO {
    @Id
    private FightOrderKey fightOrderKey;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="matchid", nullable=true, updatable=true)
    private MatchDTO match;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="eventid", nullable=true, updatable=true)
    private EventDTO event;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="duo_presentation_id", nullable=true, updatable=true)
    private DuoPresentationDTO duoPresentation;

    public FightOrderDTO() {
    }

    public FightOrderDTO(TatamiDTO tatami, Integer fightNumber) {
        this.fightOrderKey = new FightOrderKey(tatami, fightNumber);
    }

    public FightOrderKey getFightOrderKey() {
        return this.fightOrderKey;
    }

    public void setFightOrderKey(FightOrderKey fightOrderKey) {
        this.fightOrderKey = fightOrderKey;
    }

    public MatchDTO getMatch() {
        return this.match;
    }

    public void setMatch(MatchDTO match) {
        this.match = match;
    }

    public EventDTO getEvent() {
        return this.event;
    }

    public void setEvent(EventDTO event) {
        this.event = event;
    }

    public DuoPresentationDTO getDuoPresentation() {
        return this.duoPresentation;
    }

    public void setDuoPresentation(DuoPresentationDTO duoPresentation) {
        this.duoPresentation = duoPresentation;
    }

    public String toString() {
        return new ObjectToString(FightOrderDTO.class).addProperty("fightOrderKey", (Object)this.fightOrderKey).addPropertyObjectHash("match", (Object)this.match).addPropertyObjectHash("event", (Object)this.event).addPropertyObjectHash("duoPresentation", (Object)this.duoPresentation).generateString();
    }

    @Embeddable
    public static class FightOrderKey
    implements Serializable {
        private static final long serialVersionUID = -8402692378447413917L;
        @ManyToOne(fetch=FetchType.LAZY)
        @JoinColumn(name="tatamiid", nullable=false, updatable=false)
        private TatamiDTO tatami;
        @Column(name="fightnumber", nullable=false, updatable=false)
        private Integer fightNumber;

        public FightOrderKey() {
        }

        public FightOrderKey(TatamiDTO tatami, Integer fightNumber) {
            this.tatami = tatami;
            this.fightNumber = fightNumber;
        }

        public TatamiDTO getTatami() {
            return this.tatami;
        }

        public void setTatami(TatamiDTO tatami) {
            this.tatami = tatami;
        }

        public Integer getFightNumber() {
            return this.fightNumber;
        }

        public void setFightNumber(Integer fightNumber) {
            this.fightNumber = fightNumber;
        }

        public String toString() {
            return new ObjectToString(FightOrderKey.class).addPropertyObjectHash("tatami", (Object)this.tatami).addProperty("fightNumber", (Object)this.fightNumber).generateString();
        }
    }
}

