/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dto.matches;

import java.io.Serializable;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.jtekma.server.dl.dto.judges.JudgeDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.MatchDTO;

@Entity
@Table(name="match_gradings")
public class MatchGradingDTO {
    @Id
    private MatchGradingKey matchGradingKey;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="judge_id", nullable=false, updatable=false)
    private JudgeDTO judge;
    @Column(name="sent_at", nullable=false)
    private Calendar sentAt;
    @Column(name="final_result")
    private Boolean finalResult;

    public MatchGradingDTO() {
    }

    public MatchGradingDTO(MatchDTO match, Integer judgeNum) {
        this.matchGradingKey = new MatchGradingKey(match, judgeNum);
    }

    public MatchGradingKey getMatchGradingKey() {
        return this.matchGradingKey;
    }

    public void setMatchGradingKey(MatchGradingKey matchGradingKey) {
        this.matchGradingKey = matchGradingKey;
    }

    public JudgeDTO getJudge() {
        return this.judge;
    }

    public void setJudge(JudgeDTO judge) {
        this.judge = judge;
    }

    public Calendar getSentAt() {
        return this.sentAt;
    }

    public void setSentAt(Calendar sentAt) {
        this.sentAt = sentAt;
    }

    public Boolean getFinalResult() {
        return this.finalResult;
    }

    public void setFinalResult(Boolean finalResult) {
        this.finalResult = finalResult;
    }

    public String toString() {
        return new ObjectToString(MatchGradingDTO.class).addProperty("matchGradingKey", (Object)this.matchGradingKey).addProperty("judge", (Object)this.judge).addPropertyCalendar("sentAt", this.sentAt).addProperty("finalResult", (Object)this.finalResult).generateString();
    }

    @Embeddable
    public static class MatchGradingKey
    implements Serializable {
        private static final long serialVersionUID = 4797451418204877297L;
        @ManyToOne(fetch=FetchType.LAZY)
        @JoinColumn(name="match_id", nullable=false, updatable=false)
        private MatchDTO match;
        @Column(name="judge_num", nullable=false, updatable=false)
        private Integer judgeNum;

        public MatchGradingKey() {
        }

        public MatchGradingKey(MatchDTO match, Integer judgeNum) {
            this.match = match;
            this.judgeNum = judgeNum;
        }

        public MatchDTO getMatch() {
            return this.match;
        }

        public void setMatch(MatchDTO match) {
            this.match = match;
        }

        public Integer getJudgeNum() {
            return this.judgeNum;
        }

        public void setJudgeNum(Integer judgeNum) {
            this.judgeNum = judgeNum;
        }

        public String toString() {
            return new ObjectToString(MatchGradingKey.class).addPropertyObjectHash("match", (Object)this.match).addProperty("judgeNum", (Object)this.judgeNum).generateString();
        }
    }
}

