/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dto.competition;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import si.nevensrok.common.objects.ObjectEquals;
import si.nevensrok.common.objects.ObjectHash;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.jtekma.server.dl.dto.competition.CompetitionDTO;

@Entity
@Table(name="competitionsettings")
public class CompetitionSettingDTO {
    @Id
    private CompetitionSettingKey competitionSettingKey;
    @Enumerated(value=EnumType.STRING)
    @Column(length=32, name="valuetype", nullable=false)
    private ValueType valueType;
    @Column(length=16384, name="settingsvalue")
    private String settingsValue;

    public CompetitionSettingDTO() {
    }

    public CompetitionSettingDTO(CompetitionDTO competition, String settingKey) {
        this.competitionSettingKey = new CompetitionSettingKey(competition, settingKey);
    }

    public CompetitionSettingKey getCompetitionSettingKey() {
        return this.competitionSettingKey;
    }

    public void setCompetitionSettingKey(CompetitionSettingKey competitionSettingKey) {
        this.competitionSettingKey = competitionSettingKey;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public String getSettingsValue() {
        return this.settingsValue;
    }

    public void setSettingsValue(String settingsValue) {
        this.settingsValue = settingsValue;
    }

    public String toString() {
        return new ObjectToString(CompetitionSettingDTO.class).addProperty("competitionSettingKey", (Object)this.competitionSettingKey).addProperty("valueType", (Object)this.valueType).addProperty("settingsValue", (Object)this.settingsValue).generateString();
    }

    @Embeddable
    public static class CompetitionSettingKey
    implements Serializable {
        private static final long serialVersionUID = -2250912925637010156L;
        @ManyToOne(fetch=FetchType.EAGER)
        @JoinColumn(name="competitionid", nullable=false, updatable=false)
        private CompetitionDTO competition;
        @Column(length=512, name="settingkey", nullable=false)
        private String settingKey;

        public CompetitionSettingKey() {
        }

        public CompetitionSettingKey(CompetitionDTO competition, String settingKey) {
            this.competition = competition;
            this.settingKey = settingKey;
        }

        public CompetitionDTO getCompetition() {
            return this.competition;
        }

        public void setCompetition(CompetitionDTO competition) {
            this.competition = competition;
        }

        public String getSettingKey() {
            return this.settingKey;
        }

        public void setSettingKey(String settingKey) {
            this.settingKey = settingKey;
        }

        public int hashCode() {
            return new ObjectHash().addValue((Object)this.competition).addValue((Object)this.settingKey).calculateHash();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompetitionSettingKey) {
                CompetitionSettingKey other = (CompetitionSettingKey)obj;
                return new ObjectEquals().addValue((Object)this.competition, (Object)other.competition).addValue((Object)this.settingKey, (Object)other.settingKey).calculateEquals();
            }
            return true;
        }

        public String toString() {
            return new ObjectToString(CompetitionSettingKey.class).addProperty("competition", (Object)this.competition).addProperty("settingKey", (Object)this.settingKey).generateString();
        }
    }

    public static enum ValueType {
        STRING,
        NUMBER,
        DECIMAL,
        DATE,
        BOOLEAN;

    }
}

