/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.tatami.Event;
import si.nevensrok.jtekma.server.dl.dto.tatami.EventDTO;

public class EventDAO
extends ExtendedDao<Long, EventDTO, Event> {
    public EventDAO() {
        super(EventDTO.class, Event.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("eventId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("text")) {
            return "text";
        }
        if (fieldName.equalsIgnoreCase("autoRemove")) {
            return "autoRemove";
        }
        if (fieldName.equalsIgnoreCase("tatami")) {
            return "tatami.id";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public List<Event> getExpiredEvents(Calendar calendar) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select e from EventDTO e where e.removeAt is not null and e.removeAt < ");
        sqlQuery.append(params.addParam(calendar));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        LinkedList<Event> events = new LinkedList<Event>();
        for (EventDTO eventDTO : query.getResultList()) {
            Event event = (Event)this.getAdapterPool().create(Event.class, (Object)eventDTO);
            events.add(event);
        }
        this.flush();
        return events;
    }
}

