/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.AddressNetworkMessageSender;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.utils.ObjectUtil;

public abstract class AbstractMessageSender
implements AddressNetworkMessageSender,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageSender.class);
    private String address;
    private Integer port;
    private DatagramSocket socket = null;
    private Object senderMonitor = new Object();

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    abstract DatagramSocket openSocket() throws IOException;

    public void afterPropertiesSet() throws Exception {
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        if (this.getPort() == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        LOGGER.debug("Connecting to datagram connection on [{}]:{}", (Object)this.getAddress(), (Object)this.getPort());
        try {
            this.socket = this.openSocket();
        }
        catch (Exception e) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NetworkException("Error connecting to datagram connection", e);
        }
    }

    public void destroy() throws Exception {
        LOGGER.debug("Disconnecting from datagram connection on [{}]:{}", (Object)this.getAddress(), (Object)this.getPort());
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    @Override
    public void sendMessage(Object object) throws NetworkException {
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        if (this.getPort() == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        try {
            byte[] data = ObjectUtil.serializeObject((Object)object);
            this.sendMessage(data);
        }
        catch (NetworkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }

    @Override
    public void sendMessage(byte[] data) throws NetworkException {
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        if (this.getPort() == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        this.sendMessage(this.getAddress(), (int)this.getPort(), data);
    }

    @Override
    public void sendMessage(int port, Object object) throws NetworkException {
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        try {
            byte[] data = ObjectUtil.serializeObject((Object)object);
            this.sendMessage(this.getAddress(), port, data);
        }
        catch (NetworkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }

    @Override
    public void sendMessage(int port, byte[] data) throws NetworkException {
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        this.sendMessage(this.getAddress(), port, data);
    }

    @Override
    public void sendMessage(String address, int port, Object object) throws NetworkException {
        try {
            byte[] data = ObjectUtil.serializeObject((Object)object);
            this.sendMessage(address, port, data);
        }
        catch (NetworkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(String address, int port, byte[] data) throws NetworkException {
        if (this.socket == null) {
            throw new NetworkException("Socket is closed");
        }
        try {
            DatagramPacket packet = new DatagramPacket(data, data.length, InetAddress.getByName(address), port);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Sending message to [{}]:{}, message data: {}", new Object[]{address, port, data});
            }
            Object object = this.senderMonitor;
            synchronized (object) {
                this.socket.send(packet);
            }
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }
}

