/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal.duopresentation;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.DuoPresentationPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.horizontal.duopresentation.DuoPresentationPointsPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.duopresentation.DuoPresentationPointsRow;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class DuoPresentationJudgePoints
extends JPanel {
    private int judge;
    private TablaManager tablaManager;
    private MatchData matchData;
    private JLabel titleLabel = new JLabel();
    private DuoPresentationPointsRow[] rows = new DuoPresentationPointsRow[6];

    public DuoPresentationJudgePoints(int judge) {
        this.judge = judge;
        this.setLayout(new GridLayout(7, 1));
        this.titleLabel.setHorizontalAlignment(0);
        this.add(this.titleLabel);
        for (int i = 0; i < 6; ++i) {
            this.rows[i] = new DuoPresentationPointsRow(judge, i + 1);
            this.add(this.rows[i]);
        }
    }

    public void redrawElements() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DuoPresentationJudgePoints.this.matchData.isTabletReferee()) {
                    if (DuoPresentationJudgePoints.this.judge == 1 && DuoPresentationJudgePoints.this.matchData.isReferee1points()) {
                        DuoPresentationJudgePoints.this.titleLabel.setText(DuoPresentationJudgePoints.this.tablaManager.getLanguageText("text.judge") + " " + String.valueOf(DuoPresentationJudgePoints.this.judge) + " \u2713");
                    } else if (DuoPresentationJudgePoints.this.judge == 2 && DuoPresentationJudgePoints.this.matchData.isReferee2points()) {
                        DuoPresentationJudgePoints.this.titleLabel.setText(DuoPresentationJudgePoints.this.tablaManager.getLanguageText("text.judge") + " " + String.valueOf(DuoPresentationJudgePoints.this.judge) + " \u2713");
                    } else if (DuoPresentationJudgePoints.this.judge == 3 && DuoPresentationJudgePoints.this.matchData.isReferee3points()) {
                        DuoPresentationJudgePoints.this.titleLabel.setText(DuoPresentationJudgePoints.this.tablaManager.getLanguageText("text.judge") + " " + String.valueOf(DuoPresentationJudgePoints.this.judge) + " \u2713");
                    } else {
                        DuoPresentationJudgePoints.this.titleLabel.setText(DuoPresentationJudgePoints.this.tablaManager.getLanguageText("text.judge") + " " + String.valueOf(DuoPresentationJudgePoints.this.judge));
                    }
                } else {
                    DuoPresentationJudgePoints.this.titleLabel.setText(DuoPresentationJudgePoints.this.tablaManager.getLanguageText("text.judge") + " " + String.valueOf(DuoPresentationJudgePoints.this.judge));
                }
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationJudgePoints.this.titleLabel);
            }
        });
        for (DuoPresentationPointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.redrawElements();
        }
    }

    public void resetPoints() {
        for (DuoPresentationPointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.resetPoints();
        }
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        for (DuoPresentationPointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.setWindowKeyListener(windowKeyListener);
        }
    }

    public void setDuoPresentationPoints(DuoPresentationPoints duoPresentationPoints) {
        for (DuoPresentationPointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.setDuoPresentationPoints(duoPresentationPoints);
        }
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
        for (DuoPresentationPointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.setTablaManager(tablaManager);
        }
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
        for (DuoPresentationPointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.setMatchData(matchData);
        }
    }

    public void setDuoFieldSelector(DuoPresentationPointsPanel duoPresentationPointsPanel) {
        for (DuoPresentationPointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.setDuoFieldSelector(duoPresentationPointsPanel);
        }
    }

    public void selectField(int index) {
        int row = (index - 1) / 5;
        this.rows[row].selectField((index - 1) % 5 + 1);
    }

    public int getSelectedField() {
        for (int row = 0; row < this.rows.length; ++row) {
            int sel = this.rows[row].getSelectedField();
            if (sel <= 0) continue;
            return row * 5 + sel;
        }
        return 0;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.titleLabel != null) {
            this.titleLabel.setBackground(bg);
        }
        if (this.rows != null) {
            for (DuoPresentationPointsRow row : this.rows) {
                if (row == null) continue;
                row.setBackground(bg);
            }
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.titleLabel != null) {
            this.titleLabel.setForeground(fg);
        }
        if (this.rows != null) {
            for (DuoPresentationPointsRow row : this.rows) {
                if (row == null) continue;
                row.setForeground(fg);
            }
        }
    }
}

