/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.uuid;

import java.net.NetworkInterface;
import java.util.Enumeration;
import si.nevensrok.common.uuid.MachineIdGenerator;

public class MacMachineIdGenerator
implements MachineIdGenerator {
    @Override
    public Integer generateMachineId() {
        try {
            Enumeration<NetworkInterface> networkInterfaceEnumerator = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnumerator.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnumerator.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                byte[] macAddress = networkInterface.getHardwareAddress();
                int machineId = macAddress[5] & 0xFF;
                machineId += (macAddress[4] & 0xFF) << 8;
                machineId += (macAddress[3] & 0xFF) << 16;
                return machineId += (macAddress[2] & 0xFF) << 24;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error retriving machine MAC addresses", e);
        }
        throw new RuntimeException("No valid MAC addresses found");
    }
}

