/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import si.nevensrok.common.network.tcp.TcpNetworkClient;
import si.nevensrok.common.ssl.CertificateHostnameVerifier;
import si.nevensrok.common.ssl.SslContextGenerator;
import si.nevensrok.common.utils.CloseUtil;

public class SslTcpNetworkClient
extends TcpNetworkClient {
    private SSLContext sslContext;
    private SslContextGenerator sslContextGenerator;
    private HostnameVerifier hostnameVerifier = null;
    private boolean checkHostname = true;
    private boolean sslHandshakeSuccessful = false;

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setSslContextGenerator(SslContextGenerator sslContextGenerator) {
        this.sslContextGenerator = sslContextGenerator;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setCheckHostname(boolean checkHostname) {
        this.checkHostname = checkHostname;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.sslContext == null && this.sslContextGenerator == null) {
            throw new IllegalArgumentException("Property 'sslContext' or 'sslContextGenerator' is required");
        }
        if (this.hostnameVerifier == null) {
            this.hostnameVerifier = new CertificateHostnameVerifier();
        }
        super.afterPropertiesSet();
    }

    @Override
    protected Socket openSocket() throws Exception {
        Socket socket = null;
        try {
            SSLSocketFactory socketFactory = null;
            if (this.sslContext != null) {
                socketFactory = this.sslContext.getSocketFactory();
            } else if (this.sslContextGenerator != null) {
                socketFactory = this.sslContextGenerator.generateSSLContext().getSocketFactory();
            }
            InetSocketAddress socketAddress = new InetSocketAddress(this.getAddress(), (int)this.getPort());
            socket = new Socket();
            socket.connect(socketAddress, this.getConnectTimeout());
            SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket(socket, this.getAddress(), this.getPort(), true);
            sslSocket.startHandshake();
            SSLSession sslSession = sslSocket.getSession();
            if (this.checkHostname && !this.hostnameVerifier.verify(this.getAddress(), sslSession)) {
                throw new IOException("Hostname verification failed");
            }
            this.sslHandshakeSuccessful = true;
            return sslSocket;
        }
        catch (Exception e) {
            CloseUtil.close((Closeable[])new Closeable[]{socket});
            throw e;
        }
    }

    @Override
    public boolean isConnectionEstablished() {
        if (!super.isConnectionEstablished()) {
            return false;
        }
        return this.sslHandshakeSuccessful;
    }
}

