/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.bytes;

import java.nio.charset.Charset;
import si.nevensrok.common.buffer.WriteByteBuffer;
import si.nevensrok.common.bytes.ByteBlock;
import si.nevensrok.common.encryption.EncryptorDecryptor;

public class EncryptedByteBlock
implements ByteBlock {
    private static final int ENCRYPTED_BLOCK_SIZE = 1040;
    private static final int BUFFER_SIZE = 1024;
    private static final Charset UTF8 = Charset.forName("UTF8");
    private ByteBlock byteBlock;
    private EncryptorDecryptor encryptorDecryptor;
    private byte[] buffer;
    private int bufferPosition = 0;

    public EncryptedByteBlock(ByteBlock byteBlock, EncryptorDecryptor encryptorDecryptor) {
        this.byteBlock = byteBlock;
        this.encryptorDecryptor = encryptorDecryptor;
        this.readBuffer();
    }

    @Override
    public long getSize() {
        return this.byteBlock.getSize() / 1040L * 1024L;
    }

    @Override
    public void clear() {
        this.byteBlock.clear();
    }

    @Override
    public synchronized void setPosition(long position) {
        long blockPosition = position / 1024L * 1040L;
        if (this.byteBlock.getCurrentPosition() < blockPosition || this.byteBlock.getCurrentPosition() - 1040L > blockPosition) {
            this.byteBlock.setPosition(blockPosition);
            this.readBuffer();
        }
        this.bufferPosition = (int)(position % 1024L);
    }

    @Override
    public synchronized void changePositionBy(long positionDifference) {
        this.setPosition(this.getCurrentPosition() + positionDifference);
    }

    @Override
    public synchronized long getCurrentPosition() {
        return this.byteBlock.getCurrentPosition() / 1040L * 1024L + (long)this.bufferPosition;
    }

    @Override
    public synchronized byte readBit() {
        return (byte)(this.readByte() & 1);
    }

    @Override
    public synchronized void writeBit(byte bit) {
        this.writeByte(bit & 1);
    }

    @Override
    public synchronized boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public synchronized void writeBoolean(boolean value) {
        this.writeByte(value ? 1 : 0);
    }

    @Override
    public synchronized void writeByte(byte b) {
        this.writeToBuffer(b);
        this.writeBuffer();
    }

    @Override
    public synchronized void writeByte(int b) {
        this.writeByte((byte)b);
    }

    @Override
    public synchronized byte readByte() {
        if (this.bufferPosition >= this.buffer.length) {
            this.byteBlock.changePositionBy(1040L);
            this.readBuffer();
        }
        return this.buffer[this.bufferPosition++];
    }

    @Override
    public synchronized int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public synchronized void writeUnsignedByte(int b) {
        this.writeByte(b);
    }

    @Override
    public synchronized short readShort() {
        short value = (short)(this.readByte() << 8 & 0xFF00);
        value = (short)(value + (this.readByte() & 0xFF));
        return value;
    }

    @Override
    public synchronized void writeShort(short b) {
        this.writeToBuffer((byte)(b >> 8 & 0xFF));
        this.writeToBuffer((byte)(b & 0xFF));
        this.writeBuffer();
    }

    @Override
    public synchronized int readUnsignedShort() {
        int value = this.readByte() << 8 & 0xFF00;
        return value += this.readByte() & 0xFF;
    }

    @Override
    public synchronized void writeUnsignedShort(int b) {
        this.writeToBuffer((byte)(b >> 8 & 0xFF));
        this.writeToBuffer((byte)(b & 0xFF));
        this.writeBuffer();
    }

    @Override
    public synchronized int readInt() {
        int value = this.readByte() << 24 & 0xFF000000;
        value += this.readByte() << 16 & 0xFF0000;
        value += this.readByte() << 8 & 0xFF00;
        return value += this.readByte() & 0xFF;
    }

    @Override
    public synchronized void writeInt(int b) {
        this.writeToBuffer((byte)(b >> 24 & 0xFF));
        this.writeToBuffer((byte)(b >> 16 & 0xFF));
        this.writeToBuffer((byte)(b >> 8 & 0xFF));
        this.writeToBuffer((byte)(b & 0xFF));
        this.writeBuffer();
    }

    @Override
    public synchronized long readUnsignedInt() {
        long value = (long)this.readByte() << 24 & 0xFF000000L;
        value += (long)this.readByte() << 16 & 0xFF0000L;
        value += (long)this.readByte() << 8 & 0xFF00L;
        return value += (long)(this.readByte() & 0xFF);
    }

    @Override
    public synchronized void writeUnsignedInt(long b) {
        this.writeToBuffer((byte)(b >> 24 & 0xFFL));
        this.writeToBuffer((byte)(b >> 16 & 0xFFL));
        this.writeToBuffer((byte)(b >> 8 & 0xFFL));
        this.writeToBuffer((byte)(b & 0xFFL));
        this.writeBuffer();
    }

    @Override
    public synchronized long readLong() {
        long value = (long)this.readByte() << 56 & 0xFF00000000000000L;
        value += (long)this.readByte() << 48 & 0xFF000000000000L;
        value += (long)this.readByte() << 40 & 0xFF0000000000L;
        value += (long)this.readByte() << 32 & 0xFF00000000L;
        value += (long)this.readByte() << 24 & 0xFF000000L;
        value += (long)this.readByte() << 16 & 0xFF0000L;
        value += (long)this.readByte() << 8 & 0xFF00L;
        return value += (long)(this.readByte() & 0xFF);
    }

    @Override
    public synchronized void writeLong(long b) {
        this.writeToBuffer((byte)(b >> 56 & 0xFFL));
        this.writeToBuffer((byte)(b >> 48 & 0xFFL));
        this.writeToBuffer((byte)(b >> 40 & 0xFFL));
        this.writeToBuffer((byte)(b >> 32 & 0xFFL));
        this.writeToBuffer((byte)(b >> 24 & 0xFFL));
        this.writeToBuffer((byte)(b >> 16 & 0xFFL));
        this.writeToBuffer((byte)(b >> 8 & 0xFFL));
        this.writeToBuffer((byte)(b & 0xFFL));
        this.writeBuffer();
    }

    @Override
    public synchronized float readFloat() {
        int n = this.readInt();
        return Float.intBitsToFloat(n);
    }

    @Override
    public synchronized void writeFloat(float b) {
        this.writeInt(Float.floatToIntBits(b));
    }

    @Override
    public synchronized double readDouble() {
        long n = this.readLong();
        return Double.longBitsToDouble(n);
    }

    @Override
    public synchronized void writeDouble(double b) {
        this.writeLong(Double.doubleToLongBits(b));
    }

    @Override
    public synchronized byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return bytes;
    }

    @Override
    public synchronized void readBytes(byte[] buffer) {
        this.readBytes(buffer, 0, buffer.length);
    }

    @Override
    public synchronized void readBytes(byte[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            buffer[offset + i] = this.readByte();
        }
    }

    @Override
    public synchronized void writeBytes(byte[] buffer) {
        this.writeBytes(buffer, 0, buffer.length);
    }

    @Override
    public synchronized void writeBytes(byte[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.writeToBuffer(buffer[offset + i]);
        }
        this.writeBuffer();
    }

    @Override
    public synchronized char readAsciiCharacter() {
        return (char)this.readUnsignedByte();
    }

    @Override
    public synchronized void writeAsciiCharacter(char b) {
        this.writeByte(b);
    }

    @Override
    public synchronized char readUtf8Character() {
        int n = this.readUnsignedByte();
        if (n <= 127) {
            return (char)n;
        }
        if (n >= 192 && n <= 223) {
            int n2 = this.readUnsignedByte();
            if (n2 >= 128 && n2 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2}, UTF8).charAt(0);
            }
        } else if (n >= 224 && n <= 239) {
            int n2 = this.readUnsignedByte();
            int n3 = this.readUnsignedByte();
            if (n2 >= 128 && n2 <= 191 && n3 >= 128 && n3 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2, (byte)n3}, UTF8).charAt(0);
            }
        } else if (n >= 240 && n <= 247) {
            int n2 = this.readUnsignedByte();
            int n3 = this.readUnsignedByte();
            int n4 = this.readUnsignedByte();
            if (n2 >= 128 && n2 <= 191 && n3 >= 128 && n3 <= 191 && n4 >= 128 && n4 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2, (byte)n3, (byte)n4}, UTF8).charAt(0);
            }
        }
        throw new IllegalStateException("Unknown UTF8 character");
    }

    @Override
    public synchronized void writeUtf8Character(char b) {
        if (b <= '\u007f') {
            this.writeToBuffer((byte)b);
        } else {
            byte[] bytes = new String(new char[]{b}).getBytes(UTF8);
            for (int i = 0; i < bytes.length; ++i) {
                this.writeToBuffer(bytes[i]);
            }
        }
        this.writeBuffer();
    }

    @Override
    public synchronized String readAsciiString() {
        int n;
        StringBuilder value = new StringBuilder();
        while ((n = this.readUnsignedByte()) != 0) {
            value.append((char)n);
        }
        return value.toString();
    }

    @Override
    public synchronized void writeAsciiString(String b) {
        for (int i = 0; i < b.length(); ++i) {
            char c = b.charAt(i);
            this.writeToBuffer((byte)c);
        }
        this.writeToBuffer((byte)0);
        this.writeBuffer();
    }

    @Override
    public synchronized String readUtf8String() {
        int n;
        WriteByteBuffer buffer = new WriteByteBuffer();
        while ((n = this.readUnsignedByte()) != 0) {
            buffer.add((byte)n);
        }
        return new String(buffer.getBuffer(), 0, buffer.getLength(), UTF8);
    }

    @Override
    public synchronized void writeUtf8String(String b) {
        byte[] bytes = b.getBytes(UTF8);
        for (int i = 0; i < bytes.length; ++i) {
            this.writeToBuffer(bytes[i]);
        }
        this.writeToBuffer((byte)0);
        this.writeBuffer();
    }

    protected void writeToBuffer(byte b) {
        if (this.bufferPosition >= this.buffer.length) {
            this.writeBuffer();
            this.byteBlock.changePositionBy(1040L);
            this.readBuffer();
        }
        this.buffer[this.bufferPosition++] = b;
    }

    protected void readBuffer() {
        if (this.byteBlock.getSize() > this.byteBlock.getCurrentPosition()) {
            byte[] encrypted = new byte[1040];
            this.byteBlock.readBytes(encrypted);
            this.byteBlock.changePositionBy(-1040L);
            this.buffer = this.encryptorDecryptor.decrypt(encrypted);
            this.bufferPosition = 0;
        } else {
            this.buffer = new byte[1024];
            this.bufferPosition = 0;
        }
    }

    protected void writeBuffer() {
        byte[] encrypted = this.encryptorDecryptor.encrypt(this.buffer);
        this.byteBlock.writeBytes(encrypted);
        this.byteBlock.changePositionBy(-1040L);
    }
}

