(function() {
    let view = definePackage("jtekma.view");

    view.DuoPresentationsDisplay = class DuoPresentationsDisplay extends view.main {

        constructor(duoPresentationsData) {
            super("div");

            for (let duoPresentation of duoPresentationsData) {
                if (duoPresentation.status != "WAITING" && duoPresentation.status != "INQUEUE" && duoPresentation.status != "INPROGRESS" && duoPresentation.status != "FINISHED") {
                    continue;
                }
                this.addContent(new view.DuoPresentationDisplay(duoPresentation));
            }
        }

        getMatchByNumber(number) {
            for (let match of this.matchesData) {
                if (match.number == number) {
                    return match;
                }
            }
            return null;
        }

    };

    view.DuoPresentationDisplay = class DuoPresentationDisplay extends view.main {

        constructor(duoPresentationData) {
            super("div");
            this.addClass("match");

            let header = new view.div();
            header.addClass("header");

            let badge = new view.span(duoPresentationData.shortName);
            badge.addClass("badge");
            header.addContent(badge);
            header.addContent(" ");

            let label = new view.span(getSpringMessage("match.status." + duoPresentationData.status));
            if (duoPresentationData.status == "NOTNEEDED") {
                label.addClass("label label-default");
            }
            else if (duoPresentationData.status == "WAITING") {
                label.addClass("label label-danger");
            }
            else if (duoPresentationData.status == "INQUEUE") {
                label.addClass("label label-info");
            }
            else if (duoPresentationData.status == "INPROGRESS") {
                label.addClass("label label-warning");
            }
            else if (duoPresentationData.status == "FINISHED") {
                label.addClass("label label-success");
            }
            header.addContent(label);

            this.addContent(header);

            let competitorData = duoPresentationData.competitor;
            let competitor = new view.div();
            competitor.addClass("competitor1");
            let name = new view.div();
            name.addClass("name");
            if (isNotNull(competitorData)) {
                name.setContent(new view.div(competitorData.shortName + " / " + competitorData.shortClubName));
            }
            competitor.addContent(name);
            let points = new view.div();
            points.addClass("points");
            points.setContentText(duoPresentationData.points);
            competitor.addContent(points);
            this.addContent(competitor);
        }

    };

})();
