(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

    /*---------- Tatami fight ----------*/
	models.TatamiFightModel = Backbone.Model.extend({
		"defaults": {
			"fightNumber": 0,
			"match": null,
			"event": null,
			"duoPresentation": null
		}
	});

	models.TatamiFightCollection = Backbone.Collection.extend({
		"url": function() {
		  return contextPath + "/competition/data/tatami-fights";
		},
		"model": models.TatamiFightModel
	});

	views.TatamiFightView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/tatami-fight"),
		"className": "match",
		"initialize": function() {
			this.model.on("change",function() {
				this.render();
			}, this);
		},
		"render": function() {
			var data = this.model.toJSON();
			data.fightOrderNumber = this.fightOrderNumber;

			data.fights = [];
			this.collection.each(function(item, index) {
				var text = " ";
				var match = item.get("match");
				var event = item.get("event");
				var duoPresentation = item.get("duoPresentation");

				if (match != null) {
					if (match.competitor1 != null) {
						text += match.competitor1.shortName;
					}
					if (match.competitor2 != null) {
						if (text.length > 0) {
							text += "-";
						}
						text += match.competitor2.shortName;
					}
				}
				else if (event != null) {
					text = event.text;
				}
				else if (duoPresentation != null) {
                    if (duoPresentation.competitor != null) {
                        text += duoPresentation.competitor.shortName;
                    }
				}

				var matchData = {
					"number": index + 1,
					"text": text
				};
				data.fights.push(matchData);
			});

			$(this.el).html(Mustache.render(this.template, data));

			$("[rel='tooltip']", this.el).tooltip();

			var obj = this;

			$(".removeFightButton", this.el).on("click",function() {
				$.ajax({
					url: contextPath + "/competition/data/remove-fight-from-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("match").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveFightUpButton", this.el).on("click",function() {
				$.ajax({
					url: contextPath + "/competition/data/moveup-fight-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("match").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveFightDownButton", this.el).on("click",function() {
				$.ajax({
					url:contextPath+"/competition/data/movedown-fight-tatami/" + String(jtekma.displaySettings.get("tatami").get("id"))+"/" + String(obj.model.get("match").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".editEventButton", this.el).on("click",function() {
				var eventModel = new models.EventModel();
				eventModel.fetch({
					"data": {
						"eventId": obj.model.get("event").id
					},
					"async": false
				});
				var eventEditView = new views.EventEditView({
					"model": eventModel
				});
				eventEditView.trigger("show");
			});

			$(".removeEventButton", this.el).on("click",function() {
				$.ajax({
					url: contextPath + "/competition/data/remove-event-from-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("event").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveEventUpButton", this.el).on("click",function() {
				$.ajax({
					url: contextPath + "/competition/data/moveup-event-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("event").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveEventDownButton", this.el).on("click",function() {
				$.ajax({
					url: contextPath + "/competition/data/movedown-event-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("event").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".removeDuoPresentationButton", this.el).on("click",function() {
                $.ajax({
                    url: contextPath + "/competition/data/remove-duo-presentation-from-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("duoPresentation").id),
                    type: 'GET',
                    success: function(responseData){
                        jtekma.reloadData();
                    }
                });
            });

            $(".moveDuoPresentationUpButton", this.el).on("click",function() {
                $.ajax({
                    url: contextPath + "/competition/data/moveup-duo-presentation-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("duoPresentation").id),
                    type: 'GET',
                    success: function(responseData){
                        jtekma.reloadData();
                    }
                });
            });

            $(".moveDuoPresentationDownButton", this.el).on("click",function() {
                $.ajax({
                    url:contextPath+"/competition/data/movedown-duo-presentation-tatami/" + String(jtekma.displaySettings.get("tatami").get("id"))+"/" + String(obj.model.get("duoPresentation").id),
                    type: 'GET',
                    success: function(responseData){
                        jtekma.reloadData();
                    }
                });
            });

			$(".moveFightToList a", this.el).on("click",function() {
				var moveTo = Number($(this).attr("href").substring(1));
				$.ajax({
					url: contextPath + "/competition/data/move-fight-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("match").id) + "/" + String(moveTo),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveEventToList a", this.el).on("click",function() {
				var moveTo = Number($(this).attr("href").substring(1));
				$.ajax({
					url: contextPath + "/competition/data/move-event-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("event").id) + "/" + String(moveTo),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveDuoPresentationToList a", this.el).on("click",function() {
                var moveTo = Number($(this).attr("href").substring(1));
                $.ajax({
                    url: contextPath + "/competition/data/move-duo-presentation-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("duoPresentation").id) + "/" + String(moveTo),
                    type: 'GET',
                    success: function(responseData){
                        jtekma.reloadData();
                    }
                });
            });

			return this;
		}
	});

	views.TatamiFightsView = Backbone.View.extend({
		"initialize": function() {
			this.collection.on("reset",function() {
				this.render();
			}, this);
		},
		"render": function() {
			var collection = this.collection;

			$(this.el).html("");

			this.collection.each(function(item, index) {
				var tatamiFightView = new views.TatamiFightView({
					"collection": collection,
					"model": item
				});
				tatamiFightView.fightOrderNumber = index + 1;

				$(this.el).append(tatamiFightView.render().el);
			}, this);

			return this;
		}
	});

	/*---------- Tatami history ----------*/
	models.TatamiHistoryEventModel = Backbone.Model.extend({
		"defaults": {
			"eventDate": 0,
			"eventDateText": "",
			"eventType": "",
			"match": null,
			"duoPresentation": null
		}
	});

	models.TatamiHistoryEventCollection = Backbone.Collection.extend({
		"url": function() {
		  return contextPath + "/competition/data/tatami-history";
		},
		"model": models.TatamiHistoryEventModel
	});

	views.TatamiHistoryEventView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/tatami-history-event"),
		"className": "tatami-history-event",
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			var data = this.model.toJSON();

			if (this.model.get("eventType") == "PULLMATCH") {
				data.icon = "glyphicon glyphicon-arrow-up";
				data.iconTooltip = getSpringMessage("match.matchPulledTooltip");
			}
			else if (this.model.get("eventType") == "PUSHMATCH") {
				data.icon = "glyphicon glyphicon-arrow-down";
				data.iconTooltip = getSpringMessage("match.matchPushedToolpip");
			}

			$(this.el).html(Mustache.render(this.template, data));

			$("[rel='tooltip']", this.el).tooltip();

			return this;
		}
	});

	views.TatamiHistoryEventsView = Backbone.View.extend({
		"initialize": function() {
			this.collection.on("reset",function() {
				this.render();
			}, this);
		},
		"render": function() {
			var collection = this.collection;

			$(this.el).html("");

			this.collection.each(function(item, index) {
				var tatamiHistoryEventView = new views.TatamiHistoryEventView({
					"collection": collection,
					"model": item
				});

				$(this.el).append(tatamiHistoryEventView.render().el);
			}, this);

			return this;
		}
	});

	/*--------- Tatamis ---------*/
	models.TatamiModel = Backbone.Model.extend({
		"defaults": {
			"id": 0,
			"name": ""
		}
	});

	models.TatamiCollection = Backbone.Collection.extend({
		"url": function() {
		   return contextPath + "/competition/data/tatami";
		 },
		"model": models.TatamiModel
	});

	views.TatamiSelectView = Backbone.View.extend({
		"optionTemplate": "<option value=\"{{id}}\">{{name}}</option>",
		"initialize": function() {
			this.collection.on("reset",function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this).html("");

			var tatamis = this.collection;

			$(this.el).change(function() {
				var tatamiId = Number($(this).val());

				var tatami = tatamis.where({ "id": tatamiId });
				if (tatami.length > 0) {
					jtekma.displaySettings.set("tatami", tatami[0]);
				}
			});

			this.collection.each(function(item, index) {
				$(this.el).append(Mustache.render(this.optionTemplate, item.toJSON()));
			},this);

			$(this.el).chosen({
				"search_contains": true,
				"width": "135px"
			});

			if (this.collection.length > 0) {
				jtekma.displaySettings.set("tatami", this.collection.at(0));
			}

			return this;
		}
	});

})();