(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");
    var messages = definePackage("jtekma.gui.messages");

    views.DrawAvailableView = Backbone.View.extend({
		"competitorTemplate": "<div><button class=\"btn btn-default btn-sm\" competitorId=\"{{id}}\"><i class=\"glyphicon glyphicon-plus\"></i></button> {{name}} / {{clubName}}</div>",
		"initialize": function() {
			this.collection.on("draw-changed", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html("");

			var competitors = this.collection;

			competitors.each(function(item, index) {
				if (item.get("draw") == null) {
					$(this.el).append(Mustache.render(this.competitorTemplate, item.toJSON()));
				}
			}, this);

			$("button", this.el).on("click",function() {
			    var addToPosition = Number($("#addToPosition").val());
			    var addToGroup = Number($("#addToGroup").val());
				var competitorId = Number($(this).attr("competitorId"));

				var item = competitors.where({ "id": competitorId });
				var competitor = null;
				if (item.length > 0) {
				    competitor = item[0];
				}
				if (isNull(competitor)) {
				    return;
				}

				if (addToPosition > 0) {
				    if (addToGroup > 0) {
				        for (var c of competitors.where({ "draw": addToPosition, "drawGroup": addToGroup })) {
                            c.set("draw", null);
                            c.set("drawGroup", null);
                        }
				    }
				    else {
                        for (var c of competitors.where({ "draw": addToPosition })) {
                            c.set("draw", null);
                            c.set("drawGroup", null);
                        }
                    }
                    competitor.set("draw", addToPosition);
                    if (addToGroup > 0) {
                        competitor.set("drawGroup", addToGroup);
                    }
				}
				else {
				    var max = 64;
				    if (addToGroup > 0) {
				        max = 16;
				    }
                    var next = null;
                    for (var i = 1; i <= max; i++) {
                        if (addToGroup > 0) {
                            if (competitors.where({ "draw": i, "drawGroup": addToGroup }).length == 0) {
                                next = i;
                                break;
                            }
                        }
                        else {
                            if (competitors.where({ "draw": i }).length == 0) {
                                next = i;
                                break;
                            }
                        }
                    }
                    if (isNotNull(next)) {
                        competitor.set("draw", next);
                        if (addToGroup > 0) {
                            competitor.set("drawGroup", addToGroup);
                        }
                    }
				}
				competitors.trigger("draw-changed");
			});

			return this;
		}
	});

	views.DrawDrawedView = Backbone.View.extend({
		"competitorTemplate": "<div><button class=\"btn btn-default btn-sm\" competitorId=\"{{id}}\"><i class=\"glyphicon glyphicon-minus\"></i></button> {{draw}}. {{name}} / {{clubName}}</div>",
		"competitorEmptyTemplate": "<div><button class=\"btn btn-default btn-sm\" disabled=\"true\"><i class=\"glyphicon glyphicon-minus\"></i></button> {{draw}}.</div>",
		"initialize": function() {
			this.collection.on("draw-changed", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html("");

			var competitors = this.collection;

			var draw = [];
			for (var i = 0; i < 64; i++) {
				draw[i] = null;
			}

			this.collection.each(function(item, index) {
				var num = item.get("draw");
				if (num != null) {
					draw[num-1] = item;
				}
			}, this);

			for (var i = 0; i < 64; i++) {
				if (draw[i] != null) {
					$(this.el).append(Mustache.render(this.competitorTemplate, draw[i].toJSON()));
				}
				else {
					$(this.el).append(Mustache.render(this.competitorEmptyTemplate, {
						"draw": (i + 1)
					}));
				}
			}

			$("button", this.el).on("click", function() {
				var competitorId = Number($(this).attr("competitorId"));
				var item = competitors.where({ "id": competitorId });
				if (item.length > 0) {
					item[0].set("draw", null);
					item[0].set("drawGroup", null);
				}
				competitors.trigger("draw-changed");
			});

			return this;
		}
	});

	views.DrawGroupView = Backbone.View.extend({
        "competitorTemplate": "<div><button class=\"btn btn-default btn-sm\" competitorId=\"{{id}}\"><i class=\"glyphicon glyphicon-minus\"></i></button> {{draw}}. {{name}} / {{clubName}}</div>",
        "competitorEmptyTemplate": "<div><button class=\"btn btn-default btn-sm\" disabled=\"true\"><i class=\"glyphicon glyphicon-minus\"></i></button> {{draw}}.</div>",
        "initialize": function() {
            this.model.collection.on("draw-changed", function() {
                this.render();
            }, this);
        },
        "render": function() {
            $(this.el).html("");

            var groupNum = this.model.groupNum;
            var competitors = this.model.collection;

            var draw = [];
            for (var i = 0; i < 16; i++) {
                draw[i] = null;
            }

            competitors.each(function(item, index) {
                if (item.get("drawGroup") != groupNum) {
                    return;
                }
                var num = item.get("draw");
                if (num != null) {
                    draw[num-1] = item;
                }
            }, this);

            for (var i = 0; i < 16; i++) {
                if (draw[i] != null) {
                    $(this.el).append(Mustache.render(this.competitorTemplate, draw[i].toJSON()));
                }
                else {
                    $(this.el).append(Mustache.render(this.competitorEmptyTemplate, {
                        "draw": (i + 1)
                    }));
                }
            }

            $("button", this.el).on("click", function() {
                var competitorId = Number($(this).attr("competitorId"));
                var item = competitors.where({ "id": competitorId });
                if (item.length > 0) {
                    item[0].set("draw", null);
                    item[0].set("drawGroup", null);
                }
                competitors.trigger("draw-changed");
            });

            return this;
        }
    });

	views.DrawView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/draw"),
		"initialize": function() {
			this.collection.on("reset", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html(this.template);

			var category = jtekma.displaySettings.get("category");

			category.fetch({
				"async": false
			});

			var treeCategoryOptions = category.get("treeCategoryOptions");

			$("#categoryTreeType").val(treeCategoryOptions.treeType);
			$("#categoryRepasageType").val(treeCategoryOptions.repassageType);

			if (treeCategoryOptions.double3rdPlace) {
				$("#categoryDouble3rdPlace").attr("checked","true");
			}
			$("#categoryRepassageFromRound").val(treeCategoryOptions.repassageFromRound);

			new views.DrawAvailableView({
				"el": $("#available"),
				"collection": this.collection
			});
			new views.DrawDrawedView({
				"el": $("#draw"),
				"collection": this.collection
			});

			var competitors = this.collection;

			this.collection.on("draw-changed", function() {
				var max = 1;
				for (var i = 1; i <= 64; i++) {
					if (competitors.where({ "draw": i }).length != 0) {
						max = i;
					}
				}

				$("#categoryTreeType option").removeAttr("disabled");

				if (max > 2) {
					if ($("#categoryTreeType").val() == "TABLE2" || $("#categoryTreeType").val() == "BEST_OF_3") {
						$("#categoryTreeType").val("TABLE3");
					}
					$("#categoryTreeType option[value='TABLE2']").attr("disabled", "true");
					$("#categoryTreeType option[value='BEST_OF_3']").attr("disabled", "true");
				}
				if (max > 3) {
					if ($("#categoryTreeType").val() == "TABLE3") {
						$("#categoryTreeType").val("TABLE4");
					}
					$("#categoryTreeType option[value='TABLE3']").attr("disabled", "true");
				}
				if (max > 4) {
					if ($("#categoryTreeType").val() == "TABLE4") {
						$("#categoryTreeType").val("TABLE5");
					}
					if ($("#categoryTreeType").val() == "TREE4") {
						$("#categoryTreeType").val("TREE8");
					}
					$("#categoryTreeType option[value='TABLE4']").attr("disabled", "true");
					$("#categoryTreeType option[value='TREE4']").attr("disabled", "true");
				}
				if (max > 5) {
					if ($("#categoryTreeType").val() == "TABLE5") {
						$("#categoryTreeType").val("TREE8");
					}
					$("#categoryTreeType option[value='TABLE5']").attr("disabled", "true");
				}
				if (max > 8) {
					if ($("#categoryTreeType").val() == "TREE8") {
						$("#categoryTreeType").val("TREE16");
					}
					$("#categoryTreeType option[value='TREE8']").attr("disabled", "true");
				}
				if (max > 16) {
					if ($("#categoryTreeType").val() == "TREE16") {
						$("#categoryTreeType").val("TREE32");
					}
					$("#categoryTreeType option[value='TREE16']").attr("disabled", "true");
				}
				if (max > 32) {
					$("#categoryTreeType").val("TREE64");
					$("#categoryTreeType option[value='TREE32']").attr("disabled", "true");
				}
			}, this);

			this.collection.trigger("draw-changed");

			$(".btn-danger", this.el).on("click", function() {
				competitors.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
			});

			$(".btn-primary", this.el).on("click", function() {
				var data = {
					"categoryId": category.get("id"),
					"treeCategoryOptions": null,
					"draw": []
				};

				data.treeCategoryOptions = {
					"treeType": $("#categoryTreeType").val(),
					"repassageType": $("#categoryRepasageType").val(),
					"double3rdPlace": $("#categoryDouble3rdPlace").is(":checked"),
					"repassageFromRound": Number($("#categoryRepassageFromRound").val())
				};

				competitors.each(function(item, index) {
					data.draw.push({
						"competitorId": item.get("id"),
						"drawNumber": item.get("draw"),
						"drawGroup": item.get("drawGroup")
					});
				});

				$.ajax({
					url: contextPath + "/competition/data/save-draw",
					type: 'POST',
					contentType: "application/json; charset=utf-8",
					data: JSON.stringify(data),
					success: function(responseData) {
						if (responseData.success) {
							messages.showSuccessMessage(getSpringMessage("competition.text.drawSaved"));
						}
						else {
							messages.showErrorMessage(getSpringMessage("competition.text.drawSavedError"));
						}
					},
					error: function() {
						messages.showErrorMessage(getSpringMessage("competition.text.drawSavedError"));
					}
				});
			});

			$("button[link='clearButton']", this.el).on("click", function() {
				competitors.each(function(item, index) {
					item.set("draw", null);
					item.set("drawGroup", null);
				});
				competitors.trigger("draw-changed");
			});

			function executeDraw() {
				var sameClubCheck = $("#sameClubCheck").is(":checked");

				var draw = new models.CompetitorCollection();

				competitors.each(function(item, index) {
					if (isNull(item.get("draw"))) {
						draw.add(item);
					}
				});

				if (sameClubCheck) {
					var newDraw = [];
					var n = 0;
					while (draw.length > 0) {
						var clubId = draw.at(Math.floor(Math.random() * draw.length)).get("clubId");
						var competitorsFromClub = new models.CompetitorCollection();
						competitorsFromClub.reset(draw.where({ "clubId": clubId }));
						while (competitorsFromClub.length > 0) {
							var c = competitorsFromClub.at(Math.floor(Math.random() * competitorsFromClub.length));
							competitorsFromClub.remove(c);
							draw.remove(c);
							newDraw[n++] = c;
						}
					}
					draw = newDraw;
				}
				else {
					var newDraw = [];
					var n = 0;
					while (draw.length > 0) {
						var c = draw.at(Math.floor(Math.random() * draw.length));
						draw.remove(c);
						newDraw[n++] = c;
					}
					draw = newDraw;
				}

				for (var j = 0; j < draw.length; j++) {
					var next = null;
					for (var i = 1; i <= 64; i++) {
						if (competitors.where({ "draw": i }).length == 0) {
							next = i;
							break;
						}
					}
					draw[j].set("draw", next);
					draw[j].set("drawGroup", null);
				}

				competitors.trigger("draw-changed");
			}

			$("button[link='executeDraw']", this.el).on("click",function() {
				executeDraw();
			});

			$("button[link='clearAndExecuteDraw']", this.el).on("click",function() {
				competitors.each(function(item, index) {
					item.set("draw", null);
					item.set("drawGroup", null);
				});
				executeDraw();
			});

			return this;
		}
	});

	views.DrawDuo2023View = Backbone.View.extend({
        "template": templates.getTemplate("/competition/template/draw-duo2023"),
        "initialize": function() {
            this.collection.on("reset", function() {
                this.render();
            }, this);
        },
        "render": function() {
            $(this.el).html(this.template);

            var category = jtekma.displaySettings.get("category");

            category.fetch({
                "async": false
            });

            var draw2023Options = category.get("draw2023Options");

            if (draw2023Options.double3rdPlace) {
                $("#categoryDouble3rdPlace").attr("checked", "true");
            }
            if (draw2023Options.advancedLevel) {
                $("#advancedLevel").attr("checked", "true");
            }
            if (draw2023Options.noviceLevel) {
                $("#noviceLevel").attr("checked", "true");
            }

            new views.DrawAvailableView({
                "el": $("#available"),
                "collection": this.collection
            });
            for (var groupNum = 1; groupNum <= 4; groupNum++) {
                new views.DrawGroupView({
                    "el": $("#drawGroup" + String(groupNum)),
                    "model": {
                        "groupNum": groupNum,
                        "collection": this.collection
                    }
                });
            }

            var competitors = this.collection;

            this.collection.trigger("draw-changed");

            $(".btn-danger", this.el).on("click", function() {
                competitors.fetch({
                    "data": {
                        "categoryId": category.get("id")
                    },
                    "reset": true
                });
            });

            $(".btn-primary", this.el).on("click", function() {
                var data = {
                    "categoryId": category.get("id"),
                    "draw2023Options": null,
                    "draw": []
                };

                data.draw2023Options = {
                    "double3rdPlace": $("#categoryDouble3rdPlace").is(":checked")
                };

                competitors.each(function(item, index) {
                    data.draw.push({
                        "competitorId": item.get("id"),
                        "drawNumber": item.get("draw"),
                        "drawGroup": item.get("drawGroup")
                    });
                });

                $.ajax({
                    url: contextPath + "/competition/data/save-draw",
                    type: 'POST',
                    contentType: "application/json; charset=utf-8",
                    data: JSON.stringify(data),
                    success: function(responseData) {
                        if (responseData.success) {
                            messages.showSuccessMessage(getSpringMessage("competition.text.drawSaved"));
                        }
                        else {
                            messages.showErrorMessage(getSpringMessage("competition.text.drawSavedError"));
                        }
                    },
                    error: function() {
                        messages.showErrorMessage(getSpringMessage("competition.text.drawSavedError"));
                    }
                });
            });

            $("button[link='clearButton']", this.el).on("click", function() {
                competitors.each(function(item, index) {
                    item.set("draw", null);
                    item.set("drawGroup", null);
                });
                competitors.trigger("draw-changed");
            });

            function executeDraw() {
                var sameClubCheck = $("#sameClubCheck").is(":checked");

                var draw = new models.CompetitorCollection();

                competitors.each(function(item, index) {
                    if (isNull(item.get("draw"))) {
                        draw.add(item);
                    }
                });

                if (sameClubCheck) {
                    var newDraw = [];
                    var n = 0;
                    while (draw.length > 0) {
                        var clubId = draw.at(Math.floor(Math.random() * draw.length)).get("clubId");
                        var competitorsFromClub = new models.CompetitorCollection();
                        competitorsFromClub.reset(draw.where({ "clubId": clubId }));
                        while (competitorsFromClub.length > 0) {
                            var c = competitorsFromClub.at(Math.floor(Math.random() * competitorsFromClub.length));
                            competitorsFromClub.remove(c);
                            draw.remove(c);
                            newDraw[n++] = c;
                        }
                    }
                    draw = newDraw;
                }
                else {
                    var newDraw = [];
                    var n = 0;
                    while (draw.length > 0) {
                        var c = draw.at(Math.floor(Math.random() * draw.length));
                        draw.remove(c);
                        newDraw[n++] = c;
                    }
                    draw = newDraw;
                }

                var totalGroups = 1;
                if (competitors.length >= 19) {
                    totalGroups = 4;
                }
                else if (competitors.length >= 13) {
                    totalGroups = 3;
                }
                else if (competitors.length >= 7) {
                    totalGroups = 2;
                }

                for (var j = 0; j < draw.length; j++) {
                    var nextDraw = null;
                    var nextGroup = null;
                    for (var num = 1; num <= 16; num++) {
                        if (isNotNull(nextDraw) && isNotNull(nextGroup)) {
                            break;
                        }
                        for (var groupNum = 1; groupNum <= totalGroups; groupNum++) {
                            if (competitors.where({ "draw": num, "drawGroup": groupNum }).length == 0) {
                                nextDraw = num;
                                nextGroup = groupNum;
                                break;
                            }
                        }
                    }
                    draw[j].set("draw", nextDraw);
                    draw[j].set("drawGroup", groupNum);
                }

                competitors.trigger("draw-changed");
            }

            $("button[link='executeDraw']", this.el).on("click",function() {
                executeDraw();
            });

            $("button[link='clearAndExecuteDraw']", this.el).on("click",function() {
                competitors.each(function(item, index) {
                    item.set("draw", null);
                    item.set("drawGroup", null);
                });
                executeDraw();
            });

            return this;
        }
    });

})();