/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dl.hibernate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.batch.internal.AbstractBatchImpl;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresPartitionBatch
extends AbstractBatchImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresPartitionBatch.class);
    private final int batchSize;
    private int batchPosition;
    private boolean batchExecuted;
    private int statementPosition;
    private String currentStatementSql;
    private PreparedStatement currentStatement;

    public PostgresPartitionBatch(BatchKey key, JdbcCoordinator jdbcCoordinator, int batchSize) {
        super(key, jdbcCoordinator);
        if (!key.getExpectation().canBeBatched()) {
            throw new HibernateException("attempting to batch an operation which cannot be batched");
        }
        this.batchSize = batchSize;
    }

    public PreparedStatement getBatchStatement(String sql, boolean callable) {
        this.currentStatementSql = sql;
        this.currentStatement = super.getBatchStatement(sql, callable);
        return this.currentStatement;
    }

    public void addToBatch() {
        try {
            this.currentStatement.addBatch();
        }
        catch (SQLException e) {
            LOGGER.debug("SQLException escaped proxy", (Throwable)e);
            throw this.sqlExceptionHelper().convert(e, "could not perform addBatch", this.currentStatementSql);
        }
        ++this.statementPosition;
        if (this.statementPosition >= this.getKey().getBatchedStatementCount()) {
            ++this.batchPosition;
            if (this.batchPosition == this.batchSize) {
                this.notifyObserversImplicitExecution();
                this.performExecution();
                this.batchPosition = 0;
                this.batchExecuted = true;
            }
            this.statementPosition = 0;
        }
    }

    protected void doExecuteBatch() {
        if (this.batchPosition == 0) {
            if (!this.batchExecuted) {
                LOGGER.debug("No batched statements to execute");
            }
        } else {
            this.performExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performExecution() {
        LOGGER.debug("Executing batch size: {}", (Object)this.batchPosition);
        try {
            for (Map.Entry entry : this.getStatements().entrySet()) {
                try {
                    int[] rowCounts;
                    PreparedStatement statement = (PreparedStatement)entry.getValue();
                    try {
                        this.getJdbcCoordinator().getJdbcSessionOwner().getJdbcSessionContext().getObserver().jdbcExecuteBatchStart();
                        rowCounts = statement.executeBatch();
                    }
                    finally {
                        this.getJdbcCoordinator().getJdbcSessionOwner().getJdbcSessionContext().getObserver().jdbcExecuteBatchEnd();
                    }
                    this.checkRowCounts(rowCounts, statement);
                }
                catch (SQLException e) {
                    this.abortBatch();
                    throw this.sqlExceptionHelper().convert(e, "could not execute batch", (String)entry.getKey());
                    return;
                }
            }
        }
        catch (RuntimeException re) {
            LOGGER.error("Error performing execution", (Throwable)re);
            throw re;
        }
        finally {
            this.batchPosition = 0;
        }
    }

    private void checkRowCounts(int[] rowCounts, PreparedStatement ps) throws SQLException, HibernateException {
    }
}

