/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.yubikey;

import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import si.nevensrok.common.utils.ArrayUtil;
import si.nevensrok.common.yubikey.Crc16;
import si.nevensrok.common.yubikey.ModHexUtil;
import si.nevensrok.common.yubikey.SecretKeyFetcher;

public class YubicoOtpGenerator {
    private Random random = new Random();
    private SecretKeyFetcher secretKeyFetcher;

    public void setSecretKeyFetcher(SecretKeyFetcher secretKeyFetcher) {
        this.secretKeyFetcher = secretKeyFetcher;
    }

    public String generateOneTimeCode(String publicId, byte[] privateId, int usageCounter, int timestamp, int sessionCounter) {
        try {
            byte[] decryptedOtpBytes = new byte[16];
            System.arraycopy(privateId, 0, decryptedOtpBytes, 0, 6);
            decryptedOtpBytes[6] = (byte)(usageCounter & 0xFF);
            decryptedOtpBytes[7] = (byte)(usageCounter >> 8 & 0xFF);
            decryptedOtpBytes[8] = (byte)(timestamp & 0xFF);
            decryptedOtpBytes[9] = (byte)(timestamp >> 8 & 0xFF);
            decryptedOtpBytes[10] = (byte)(timestamp >> 16 & 0xFF);
            decryptedOtpBytes[11] = (byte)(sessionCounter & 0xFF);
            decryptedOtpBytes[12] = (byte)(this.random.nextInt(255) - 128);
            decryptedOtpBytes[13] = (byte)(this.random.nextInt(255) - 128);
            byte[] bytesForCrc = ArrayUtil.subArray((byte[])decryptedOtpBytes, (int)0, (int)14);
            int calculatedCrc16 = Crc16.calculateCrc16(bytesForCrc);
            decryptedOtpBytes[14] = (byte)(calculatedCrc16 & 0xFF);
            decryptedOtpBytes[15] = (byte)(calculatedCrc16 >> 8 & 0xFF);
            byte[] secretKeyBytes = this.secretKeyFetcher.fetchSecretKey(publicId);
            if (secretKeyBytes == null) {
                throw new RuntimeException("Secret key not found");
            }
            if (secretKeyBytes.length != 16) {
                throw new RuntimeException("Secret key bytes length is invalid");
            }
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, secretKey);
            byte[] encryptedOtpBytes = cipher.doFinal(decryptedOtpBytes);
            return publicId + ModHexUtil.toModhexString(encryptedOtpBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating OTP code", e);
        }
    }
}

