/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.restclient;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import si.nevensrok.common.restclient.RestApiException;
import si.nevensrok.common.restclient.RestApiResponseException;
import si.nevensrok.common.restclient.RestClientUrlStreamHandler;
import si.nevensrok.common.restclient.RestRequest;
import si.nevensrok.common.restclient.RestResponse;
import si.nevensrok.common.ssl.CustomSSLSocketFactory;
import si.nevensrok.common.ssl.CustomSslContextGenerator;
import si.nevensrok.common.utils.CloseUtil;
import si.nevensrok.common.utils.StringUtil;

public class RestClient {
    private int connectTimeout = 10000;
    private int readTimeout = 60000;
    private Proxy proxy;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier = null;
    private String userAgent = null;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setProxy(Proxy.Type proxyType, String url) {
        if (StringUtil.isEmpty((String)url)) {
            this.proxy = null;
            return;
        }
        url = url.trim();
        url = StringUtil.removePrefixIfPresent((String)"http://", (String)url);
        String[] parts = (url = StringUtil.removePrefixIfPresent((String)"socks://", (String)url)).split(":");
        if (parts.length == 1) {
            this.setProxy(proxyType, parts[0].trim(), 80);
        } else {
            this.setProxy(proxyType, parts[0].trim(), Integer.parseInt(parts[1].trim()));
        }
    }

    public void setProxy(Proxy.Type proxyType, String hostname, int port) {
        this.proxy = new Proxy(proxyType, new InetSocketAddress(hostname, port));
    }

    public void setHttpProxy(String url) {
        this.setProxy(Proxy.Type.HTTP, url);
    }

    public void setSocksProxy(String url) {
        this.setProxy(Proxy.Type.SOCKS, url);
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setIgnoreSslCertificateError(boolean ignore) {
        if (ignore) {
            CustomSslContextGenerator customSslContextGenerator = new CustomSslContextGenerator();
            customSslContextGenerator.setTrustAll(true);
            try {
                customSslContextGenerator.afterPropertiesSet();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sslSocketFactory = new CustomSSLSocketFactory(customSslContextGenerator.generateSSLContext());
        } else {
            this.sslSocketFactory = null;
        }
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void execute(String method, String url) {
        this.execute(method, url, null, null, null, null);
    }

    public void execute(String method, String url, String contentType, byte[] body) {
        this.execute(method, url, contentType, body, null, null);
    }

    public void execute(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters) {
        this.execute(method, url, contentType, body, queryParameters, null);
    }

    public void execute(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters, Map<String, String> headers) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(method);
        restRequest.setUrl(url);
        if (queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                restRequest.setQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                restRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        restRequest.setContentType(contentType);
        restRequest.setBody(body);
        RestResponse restResponse = this.execute(restRequest);
        if (!restResponse.isSuccessful()) {
            throw new RestApiResponseException("Error response code received", restResponse.getResponseCode());
        }
    }

    public byte[] executeAndRead(String method, String url) {
        return this.executeAndRead(method, url, null, null, null, null);
    }

    public byte[] executeAndRead(String method, String url, String contentType, byte[] body) {
        return this.executeAndRead(method, url, contentType, body, null, null);
    }

    public byte[] executeAndRead(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters) {
        return this.executeAndRead(method, url, contentType, body, queryParameters, null);
    }

    public byte[] executeAndRead(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters, Map<String, String> headers) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(method);
        restRequest.setUrl(url);
        if (queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                restRequest.setQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                restRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        restRequest.setContentType(contentType);
        restRequest.setBody(body);
        RestResponse restResponse = this.execute(restRequest);
        if (!restResponse.isSuccessful()) {
            throw new RestApiResponseException("Error response code received", restResponse.getResponseCode());
        }
        return restResponse.getBody();
    }

    public String executeAndReadAsString(String method, String url) {
        return this.executeAndReadAsString(method, url, null, null, null, null);
    }

    public String executeAndReadAsString(String method, String url, String contentType, byte[] body) {
        return this.executeAndReadAsString(method, url, contentType, body, null, null);
    }

    public String executeAndReadAsString(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters) {
        return this.executeAndReadAsString(method, url, contentType, body, queryParameters, null);
    }

    public String executeAndReadAsString(String method, String url, String contentType, byte[] body, Map<String, String> queryParameters, Map<String, String> headers) {
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(method);
        restRequest.setUrl(url);
        if (queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                restRequest.setQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                restRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        restRequest.setContentType(contentType);
        restRequest.setBody(body);
        RestResponse restResponse = this.execute(restRequest);
        if (!restResponse.isSuccessful()) {
            throw new RestApiResponseException("Error response code received", restResponse.getResponseCode());
        }
        return restResponse.getBodyAsString();
    }

    public RestResponse execute(RestRequest restRequest) {
        RestResponse restResponse;
        if (StringUtil.isEmpty((String)restRequest.getUrl())) {
            throw new RestApiException("Rest request url is empty");
        }
        if (StringUtil.isEmpty((String)restRequest.getMethod())) {
            throw new RestApiException("Rest request method is empty");
        }
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            String ua;
            StringBuilder fullUrl = new StringBuilder();
            fullUrl.append(restRequest.getUrl());
            for (Map.Entry<String, List<String>> entry : restRequest.getQueryParameters().entrySet()) {
                for (String value : entry.getValue()) {
                    if (fullUrl.indexOf("?") < 0) {
                        fullUrl.append("?");
                    } else {
                        fullUrl.append("&");
                    }
                    fullUrl.append(URLEncoder.encode(entry.getKey(), "UTF8"));
                    if (value == null) continue;
                    fullUrl.append("=");
                    fullUrl.append(URLEncoder.encode(value, "UTF8"));
                }
            }
            RestClientUrlStreamHandler restClientUrlStreamHandler = new RestClientUrlStreamHandler(this);
            URL url = new URL(null, fullUrl.toString(), restClientUrlStreamHandler);
            if (!"http".equalsIgnoreCase(url.getProtocol()) && !"https".equalsIgnoreCase(url.getProtocol())) {
                throw new IllegalArgumentException("Protocol '" + url.getProtocol() + "' is not supported");
            }
            httpURLConnection = (HttpURLConnection)url.openConnection();
            int connectTimeout = this.getConnectTimeout();
            if (restRequest.getConnectTimeout() != null) {
                connectTimeout = restRequest.getConnectTimeout();
            }
            if (connectTimeout < 0) {
                connectTimeout = 0;
            }
            httpURLConnection.setConnectTimeout(connectTimeout);
            int readTimeout = this.getReadTimeout();
            if (restRequest.getReadTimeout() != null) {
                readTimeout = restRequest.getReadTimeout();
            }
            if (readTimeout < 0) {
                readTimeout = 0;
            }
            httpURLConnection.setReadTimeout(readTimeout);
            httpURLConnection.setRequestMethod(restRequest.getMethod());
            boolean isCustomUserAgentPresent = false;
            for (Map.Entry<String, List<String>> entry : restRequest.getHeaders().entrySet()) {
                if (entry.getValue() == null) continue;
                for (String value : entry.getValue()) {
                    if (value == null) continue;
                    if ("User-Agent".equalsIgnoreCase((String)entry.getKey())) {
                        isCustomUserAgentPresent = true;
                    }
                    httpURLConnection.addRequestProperty((String)entry.getKey(), value);
                }
            }
            if (!isCustomUserAgentPresent && StringUtil.isNotEmpty((String)(ua = this.getUserAgent()))) {
                httpURLConnection.setRequestProperty("User-Agent", ua);
            }
            if (restRequest.getBody() != null) {
                httpURLConnection.setDoOutput(true);
                outputStream = httpURLConnection.getOutputStream();
                outputStream.write(restRequest.getBody());
                outputStream.flush();
                outputStream.close();
            }
            httpURLConnection.connect();
            RestResponse restResponse2 = new RestResponse();
            restResponse2.setResponseCode(httpURLConnection.getResponseCode());
            for (Map.Entry entry : httpURLConnection.getHeaderFields().entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                for (String value : (List)entry.getValue()) {
                    restResponse2.addHeader((String)entry.getKey(), value);
                }
            }
            inputStream = httpURLConnection.getErrorStream();
            if (inputStream == null) {
                inputStream = httpURLConnection.getInputStream();
            }
            if (inputStream != null) {
                int n;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                int exception = inputStream.read();
                while (n >= 0) {
                    buffer.write(n);
                    n = inputStream.read();
                }
                byte[] byArray = buffer.toByteArray();
                restResponse2.setBody(byArray);
            }
            restResponse = restResponse2;
        }
        catch (Throwable e) {
            try {
                throw new RestApiException("Error executing rest api method", e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{outputStream, inputStream});
                if (httpURLConnection != null) {
                    try {
                        httpURLConnection.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{outputStream, inputStream});
        if (httpURLConnection != null) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return restResponse;
    }

    static {
        try {
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            methodsField.setAccessible(true);
            String[] oldMethods = (String[])methodsField.get(null);
            LinkedHashSet<String> methodsSet = new LinkedHashSet<String>(Arrays.asList(oldMethods));
            methodsSet.add("PATCH");
            String[] newMethods = methodsSet.toArray(new String[methodsSet.size()]);
            methodsField.set(null, newMethods);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

