/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.settings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import si.nevensrok.common.settings.Settings;

public class Section {
    private String name;
    private Settings settings;
    private Map<String, Object> values = new HashMap<String, Object>();
    private Map<String, Section> sections = new HashMap<String, Section>();

    Section(String name, Settings settings) {
        this.name = name;
        this.settings = settings;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(String name) {
        Map<String, Object> map = this.values;
        synchronized (map) {
            return this.values.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String name, Object value) {
        Map<String, Object> map = this.values;
        synchronized (map) {
            this.values.put(name, value);
        }
        this.settings.markChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getValues() {
        Map<String, Object> map = this.values;
        synchronized (map) {
            return new HashSet<String>(this.values.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValuePresent(String name) {
        Map<String, Object> map = this.values;
        synchronized (map) {
            return this.values.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(String name) {
        Map<String, Object> map = this.values;
        synchronized (map) {
            this.values.remove(name);
        }
        this.settings.markChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Section getSection(String name) {
        Map<String, Section> map = this.sections;
        synchronized (map) {
            return this.sections.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSections() {
        Map<String, Section> map = this.sections;
        synchronized (map) {
            return new HashSet<String>(this.sections.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Section createSection(String name) {
        Section section;
        Map<String, Section> map = this.sections;
        synchronized (map) {
            if (this.sections.containsKey(name)) {
                return this.sections.get(name);
            }
            section = new Section(name, this.settings);
            this.sections.put(name, section);
        }
        this.settings.markChange();
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSectionPresent(String name) {
        Map<String, Section> map = this.sections;
        synchronized (map) {
            return this.sections.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSection(String name) {
        Map<String, Section> map = this.sections;
        synchronized (map) {
            this.sections.remove(name);
        }
        this.settings.markChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Object> map = this.values;
        synchronized (map) {
            this.values.clear();
        }
        map = this.sections;
        synchronized (map) {
            this.sections.clear();
        }
        this.settings.markChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> getCopyOfValues() {
        Map<String, Object> map = this.values;
        synchronized (map) {
            return new HashMap<String, Object>(this.values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Section> getCopyOfSections() {
        Map<String, Section> map = this.sections;
        synchronized (map) {
            return new HashMap<String, Section>(this.sections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSection(Section section) {
        Map<String, Section> map = this.sections;
        synchronized (map) {
            this.sections.put(section.getName(), section);
        }
    }
}

