/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.tools;

import si.nevensrok.common.utils.StringUtil;

public final class SimilarDataChecker {
    private SimilarDataChecker() {
    }

    public static boolean areClubsSimilar(String clubName1, String clubName2) {
        int distance = StringUtil.computeLevenshteinDistance((String)clubName1.toUpperCase(), (String)clubName2.toUpperCase());
        return !clubName1.equalsIgnoreCase(clubName2) && distance < 5;
    }

    public static boolean areCategoriesSimilar(String categoryName1, String categoryName2) {
        String cat1name = SimilarDataChecker.reduceCategoryName(categoryName1);
        String cat2name = SimilarDataChecker.reduceCategoryName(categoryName2);
        if (cat1name.isEmpty() && cat2name.isEmpty()) {
            return false;
        }
        int distance = StringUtil.computeLevenshteinDistance((String)categoryName1.toUpperCase(), (String)categoryName2.toUpperCase());
        return !cat1name.equalsIgnoreCase(cat2name) && distance < 2;
    }

    private static String reduceCategoryName(String categoryName) {
        categoryName = categoryName.toUpperCase();
        categoryName = categoryName.replaceAll("(\\s*)FIGHT(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)NE([\\s-]*)WAZA(\\s*)", "");
        categoryName = categoryName.replaceAll("U8", "");
        categoryName = categoryName.replaceAll("U10", "");
        categoryName = categoryName.replaceAll("U12", "");
        categoryName = categoryName.replaceAll("U14", "");
        categoryName = categoryName.replaceAll("U16", "");
        categoryName = categoryName.replaceAll("U18", "");
        categoryName = categoryName.replaceAll("U21", "");
        categoryName = categoryName.replaceAll("SENIORS", "");
        categoryName = categoryName.replaceAll("SENIORI", "");
        categoryName = categoryName.replaceAll("SENIORJI", "");
        categoryName = categoryName.replaceAll("JUNIORS", "");
        categoryName = categoryName.replaceAll("JUNIORJI", "");
        categoryName = categoryName.replaceAll("ASPIRANTS", "");
        categoryName = categoryName.replaceAll("ASPIRANTI", "");
        categoryName = categoryName.replaceAll("KADETI", "");
        categoryName = categoryName.replaceAll("\\d{2}", "");
        categoryName = categoryName.replaceAll("(\\s*)APSOLUTNA(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)MEN(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)WOMEN(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)MU\u0160KI(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)\u017dENE(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)MO\u0160KI(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)\u017dENSKE(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)MIX(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)MIKS(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)M(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)W(\\s*)", "");
        categoryName = categoryName.replaceAll("(\\s*)\u017d(\\s*)", "");
        categoryName = categoryName.replace('+', '-');
        return categoryName;
    }
}

