/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CompetitorRanking;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.DuoPresentationDetail;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchDetail;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.server.dl.dao.CompetitorDAO;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.CompetitorManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.MatchManager;

public class CompetitorManagerImpl
implements CompetitorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetitorManagerImpl.class);
    private static final float winPoints = 10.0f;
    private static final float losePoints = -5.0f;
    private static final float fightPointGainPoints = 0.8f;
    private static final float fightPointAgainstPoints = -0.4f;
    private static final float ipponPointGainPoints = 1.6f;
    private static final float ipponPointAgainstPoints = -0.8f;
    private static final float duoPointGainPoints = 0.1f;
    private CompetitorDAO competitorDAO;
    private MatchManager matchManager;
    private DuoPresentationManager duoPresentationManager;
    private RulesManager rulesManager;
    private CompetitionManager competitionManager;

    public void setCompetitorDAO(CompetitorDAO competitorDAO) {
        this.competitorDAO = competitorDAO;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setDuoPresentationManager(DuoPresentationManager duoPresentationManager) {
        this.duoPresentationManager = duoPresentationManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competitor createCompetitor(Competitor competitor) {
        LOGGER.debug("Creating competitor {}", (Object)competitor);
        return (Competitor)this.competitorDAO.create((Pojo)competitor);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Competitor> createCompetitors(List<Competitor> competitors) {
        LOGGER.debug("Creating competitors {}", competitors);
        return this.competitorDAO.createList(competitors);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competitor updateCompetitor(Competitor competitor) {
        LOGGER.debug("Updating competitor {}", (Object)competitor);
        if (competitor.getClub() != null) {
            this.competitorDAO.setCompetitorsClub(competitor, competitor.getClub());
        }
        return (Competitor)this.competitorDAO.update((Pojo)competitor);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteCompetitor(Competitor competitor) {
        LOGGER.debug("Deleting competitor {}", (Object)competitor);
        this.competitorDAO.changeCompetitorStatus(competitor, Competitor.Status.DELETED);
        this.competitorDAO.removeCompetitorFromAllCategories(competitor);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competitor getById(Long competitorId) {
        return (Competitor)this.competitorDAO.getById((Object)competitorId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<Competitor> findForCompetition(Competition competition, DataFilter dataFilter) {
        return this.competitorDAO.findForCompetition(competition, dataFilter);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<Competitor> findForClub(Club club, DataFilter dataFilter) {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("club", FieldFilter.Comparator.EQUAL, (Object)club.getId()));
        rootFilter.addFilter(dataFilter.getFilter());
        ((SimpleDataFilter)dataFilter).setFilter((Filter)rootFilter);
        return this.competitorDAO.find(dataFilter, false);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Competitor> getCompetitorsForCategory(Category category) {
        return this.competitorDAO.getCompetitorsForCategory(category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Competitor> getCompetitorsForCategory(Category category, Competitor.Type competitorType) {
        return this.competitorDAO.getCompetitorsForCategory(category, competitorType);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Competitor> getCompetitorsForClub(Club club) {
        return this.competitorDAO.getCompetitorsForClub(club);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Competitor> getCompetitorsForClub(Club club, Competitor.Type competitorType) {
        return this.competitorDAO.getCompetitorsForClub(club, competitorType);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void addCompetitorToCategory(Competitor competitor, Category category) {
        this.competitorDAO.addCompetitorToCategory(competitor, category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void removeCompetitorFromCategory(Competitor competitor, Category category) {
        this.competitorDAO.removeCompetitorFromCategory(competitor, category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setCompetitorCategories(Competitor competitor, Set<Category> categories) {
        this.competitorDAO.setCompetitorCategories(competitor, categories);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PersonCompetitor getActivePersonCompetitorByNameAndClub(Competition competition, String firstName, String lastName, Club club) {
        return this.competitorDAO.getActivePersonCompetitorByNameAndClub(competition, firstName, lastName, club);
    }

    @Transactional(value="jtekmaTransactionManager")
    public CoupleCompetitor getActiveCoupleCompetitorByNameAndClub(Competition competition, String firstName1, String lastName1, String firstName2, String lastName2, Club club) {
        return this.competitorDAO.getActiveCoupleCompetitorByNameAndClub(competition, firstName1, lastName1, firstName2, lastName2, club);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<CompetitorRanking> getFightingCompetitorRankings(Competition competition) {
        CompetitionRules competitionRules = this.rulesManager.getCompetitionRules((competition = this.competitionManager.getById(competition.getCompetitionId())).getRules());
        if (competitionRules == null) {
            throw new RuntimeException("Competition rules not found");
        }
        List competitors = this.competitorDAO.getCompetitorsForCompetiton(competition, Competitor.Type.COMPETITOR, 2);
        ArrayList<CompetitorRanking> competitorRankings = new ArrayList<CompetitorRanking>();
        Map matchDetails = this.matchManager.getMatchDetailsForCompetitors(new HashSet(competitors));
        for (Competitor competitor : matchDetails.keySet()) {
            CompetitorRanking competitorRanking = new CompetitorRanking();
            int matchCount = 0;
            float points = 0.0f;
            for (MatchDetail matchDetail : (Set)matchDetails.get(competitor)) {
                Competitor winner = competitionRules.getMatchWinner(matchDetail.getMatch(), matchDetail.getMatchPoints());
                Competitor looser = competitionRules.getMatchWinner(matchDetail.getMatch(), matchDetail.getMatchPoints());
                if (winner != null && winner.getCompetitorId().equals(competitor.getCompetitorId())) {
                    points += 10.0f;
                }
                if (looser != null && looser.getCompetitorId().equals(competitor.getCompetitorId())) {
                    points += -5.0f;
                }
                if (matchDetail.getMatch().getType() != Match.Type.FIGHT) continue;
                float points1 = competitionRules.sumPointsFor(Match.Type.FIGHT, CompetitorType.COMPETITOR1, matchDetail.getMatchPoints());
                float points2 = competitionRules.sumPointsFor(Match.Type.FIGHT, CompetitorType.COMPETITOR2, matchDetail.getMatchPoints());
                float ippon1 = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR1, matchDetail.getMatchPoints());
                float ippon2 = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR2, matchDetail.getMatchPoints());
                if (matchDetail.getMatch().getCompetitor1() != null && matchDetail.getMatch().getCompetitor1().getCompetitorId().equals(competitor.getCompetitorId())) {
                    points += points1 * 0.8f + points2 * -0.4f;
                    points += ippon1 * 1.6f + ippon2 * -0.8f;
                    ++matchCount;
                    continue;
                }
                if (matchDetail.getMatch().getCompetitor2() == null || !matchDetail.getMatch().getCompetitor2().getCompetitorId().equals(competitor.getCompetitorId())) continue;
                points += points2 * 0.8f + points1 * -0.4f;
                points += ippon2 * 1.6f + ippon1 * -0.8f;
                ++matchCount;
            }
            competitorRanking.setCompetitor(competitor);
            if (matchCount > 0 && points > 0.0f) {
                points = (float)Math.round(points / (float)matchCount * 1000.0f) / 1000.0f;
                competitorRanking.setPoints(Float.valueOf(points));
            } else {
                competitorRanking.setPoints(Float.valueOf(0.0f));
            }
            competitorRankings.add(competitorRanking);
        }
        Collections.sort(competitorRankings, new Comparator<CompetitorRanking>(){

            @Override
            public int compare(CompetitorRanking o1, CompetitorRanking o2) {
                return -o1.getPoints().compareTo(o2.getPoints());
            }
        });
        int n = 1;
        for (CompetitorRanking competitorRanking : competitorRankings) {
            competitorRanking.setPlace(Integer.valueOf(n++));
        }
        return competitorRankings;
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<CompetitorRanking> getNewazaCompetitorRankings(Competition competition) {
        CompetitionRules competitionRules = this.rulesManager.getCompetitionRules((competition = this.competitionManager.getById(competition.getCompetitionId())).getRules());
        if (competitionRules == null) {
            throw new RuntimeException("Competition rules not found");
        }
        List competitors = this.competitorDAO.getCompetitorsForCompetiton(competition, Competitor.Type.COMPETITOR, 2);
        ArrayList<CompetitorRanking> competitorRankings = new ArrayList<CompetitorRanking>();
        Map matchDetails = this.matchManager.getMatchDetailsForCompetitors(new HashSet(competitors));
        for (Competitor competitor : matchDetails.keySet()) {
            CompetitorRanking competitorRanking = new CompetitorRanking();
            int matchCount = 0;
            float points = 0.0f;
            for (MatchDetail matchDetail : (Set)matchDetails.get(competitor)) {
                Competitor winner = competitionRules.getMatchWinner(matchDetail.getMatch(), matchDetail.getMatchPoints());
                Competitor looser = competitionRules.getMatchWinner(matchDetail.getMatch(), matchDetail.getMatchPoints());
                if (winner != null && winner.getCompetitorId().equals(competitor.getCompetitorId())) {
                    points += 10.0f;
                }
                if (looser != null && looser.getCompetitorId().equals(competitor.getCompetitorId())) {
                    points += -5.0f;
                }
                if (matchDetail.getMatch().getType() != Match.Type.NEWAZA) continue;
                float points1 = competitionRules.sumPointsFor(Match.Type.NEWAZA, CompetitorType.COMPETITOR1, matchDetail.getMatchPoints());
                float points2 = competitionRules.sumPointsFor(Match.Type.NEWAZA, CompetitorType.COMPETITOR2, matchDetail.getMatchPoints());
                if (matchDetail.getMatch().getCompetitor1() != null && matchDetail.getMatch().getCompetitor1().getCompetitorId().equals(competitor.getCompetitorId())) {
                    points += points1 * 0.8f + points2 * -0.4f;
                    ++matchCount;
                    continue;
                }
                if (matchDetail.getMatch().getCompetitor2() == null || !matchDetail.getMatch().getCompetitor2().getCompetitorId().equals(competitor.getCompetitorId())) continue;
                points += points2 * 0.8f + points1 * -0.4f;
                ++matchCount;
            }
            competitorRanking.setCompetitor(competitor);
            if (matchCount > 0 && points > 0.0f) {
                points = (float)Math.round(points / (float)matchCount * 1000.0f) / 1000.0f;
                competitorRanking.setPoints(Float.valueOf(points));
            } else {
                competitorRanking.setPoints(Float.valueOf(0.0f));
            }
            competitorRankings.add(competitorRanking);
        }
        Collections.sort(competitorRankings, new Comparator<CompetitorRanking>(){

            @Override
            public int compare(CompetitorRanking o1, CompetitorRanking o2) {
                return -o1.getPoints().compareTo(o2.getPoints());
            }
        });
        int n = 1;
        for (CompetitorRanking competitorRanking : competitorRankings) {
            competitorRanking.setPlace(Integer.valueOf(n++));
        }
        return competitorRankings;
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<CompetitorRanking> getDuoCompetitorRankings(Competition competition) {
        float points;
        CompetitorRanking competitorRanking2;
        Competitor competitor;
        CompetitionRules competitionRules = this.rulesManager.getCompetitionRules((competition = this.competitionManager.getById(competition.getCompetitionId())).getRules());
        if (competitionRules == null) {
            throw new RuntimeException("Competition rules not found");
        }
        List competitors = this.competitorDAO.getCompetitorsForCompetiton(competition, Competitor.Type.COUPLE, 2);
        HashMap<Long, CompetitorRanking> competitorRankings = new HashMap<Long, CompetitorRanking>();
        Map matchDetails = this.matchManager.getMatchDetailsForCompetitors(new HashSet(competitors));
        Map duoPresentationDetails = this.duoPresentationManager.getDuoPresentationDetailsForCompetitors(new HashSet(competitors));
        for (Map.Entry entry : duoPresentationDetails.entrySet()) {
            competitor = (Competitor)entry.getKey();
            competitorRanking2 = (CompetitorRanking)competitorRankings.get(competitor.getId());
            if (competitorRanking2 == null) {
                competitorRanking2 = new CompetitorRanking();
                competitorRanking2.setCompetitor(competitor);
                competitorRanking2.setPoints(Float.valueOf(0.0f));
                competitorRankings.put(competitor.getId(), competitorRanking2);
            }
            int presentationCount = 0;
            points = 0.0f;
            for (DuoPresentationDetail duoPresentationDetail : (Set)entry.getValue()) {
                points += competitionRules.sumDuoPresentationPoints(duoPresentationDetail.getDuoPresentationPoints()) * 0.1f;
                ++presentationCount;
            }
            points = presentationCount > 0 && points > 0.0f ? (float)Math.round(points / (float)presentationCount * 1000.0f) / 1000.0f : 0.0f;
            competitorRanking2.setPoints(Float.valueOf(competitorRanking2.getPoints().floatValue() + points));
        }
        for (Map.Entry entry : matchDetails.entrySet()) {
            competitor = (Competitor)entry.getKey();
            competitorRanking2 = (CompetitorRanking)competitorRankings.get(competitor.getId());
            if (competitorRanking2 == null) {
                competitorRanking2 = new CompetitorRanking();
                competitorRanking2.setCompetitor(competitor);
                competitorRanking2.setPoints(Float.valueOf(0.0f));
                competitorRankings.put(competitor.getId(), competitorRanking2);
            }
            int matchCount = 0;
            points = 0.0f;
            for (MatchDetail matchDetail : (Set)entry.getValue()) {
                Competitor winner = competitionRules.getMatchWinner(matchDetail.getMatch(), matchDetail.getMatchPoints());
                Competitor looser = competitionRules.getMatchWinner(matchDetail.getMatch(), matchDetail.getMatchPoints());
                if (winner != null && winner.getCompetitorId().equals(competitor.getCompetitorId())) {
                    points += 10.0f;
                }
                if (looser != null && looser.getCompetitorId().equals(competitor.getCompetitorId())) {
                    points += -5.0f;
                }
                float points1 = 0.0f;
                float points2 = 0.0f;
                if (matchDetail.getMatch().getType() == Match.Type.DUO) {
                    points1 = competitionRules.sumPointsFor(Match.Type.DUO, CompetitorType.COMPETITOR1, matchDetail.getMatchPoints());
                    points2 = competitionRules.sumPointsFor(Match.Type.DUO, CompetitorType.COMPETITOR2, matchDetail.getMatchPoints());
                } else if (matchDetail.getMatch().getType() == Match.Type.DUO2023) {
                    points1 = competitionRules.sumPointsFor(Match.Type.DUO2023, CompetitorType.COMPETITOR1, matchDetail.getMatchPoints());
                    points2 = competitionRules.sumPointsFor(Match.Type.DUO2023, CompetitorType.COMPETITOR2, matchDetail.getMatchPoints());
                }
                if (matchDetail.getMatch().getCompetitor1() != null && matchDetail.getMatch().getCompetitor1().getCompetitorId().equals(competitor.getCompetitorId())) {
                    points += points1 * 0.1f;
                    ++matchCount;
                    continue;
                }
                if (matchDetail.getMatch().getCompetitor2() == null || !matchDetail.getMatch().getCompetitor2().getCompetitorId().equals(competitor.getCompetitorId())) continue;
                points += points2 * 0.1f;
                ++matchCount;
            }
            competitorRanking2.setCompetitor(competitor);
            points = matchCount > 0 && points > 0.0f ? (float)Math.round(points / (float)matchCount * 1000.0f) / 1000.0f : 0.0f;
            competitorRanking2.setPoints(Float.valueOf(competitorRanking2.getPoints().floatValue() + points));
        }
        ArrayList<CompetitorRanking> rankingList = new ArrayList<CompetitorRanking>(competitorRankings.values());
        Collections.sort(rankingList, new Comparator<CompetitorRanking>(){

            @Override
            public int compare(CompetitorRanking o1, CompetitorRanking o2) {
                return -o1.getPoints().compareTo(o2.getPoints());
            }
        });
        int n = 1;
        for (CompetitorRanking competitorRanking2 : rankingList) {
            competitorRanking2.setPlace(Integer.valueOf(n++));
        }
        return rankingList;
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Competitor> getActiveCompetitorsForCompetition(Competition competition) {
        return this.competitorDAO.getActiveCompetitorsForCompetition(competition);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Competitor> getActiveCompetitorsForCompetition(Competition competition, Competitor.Type competitorType) {
        return this.competitorDAO.getActiveCompetitorsForCompetition(competition, competitorType);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void resetShortNames(Competition competition, Competitor.Type type) {
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        dataFilter.setFilter((Filter)rootFilter);
        rootFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)Competitor.Status.ACTIVE));
        rootFilter.addFilter((Filter)new FieldFilter("type", FieldFilter.Comparator.EQUAL, (Object)type));
        PageDataResult dataResult = this.competitorDAO.findForCompetition(competition, (DataFilter)dataFilter);
        for (Competitor competitor : dataResult.getData()) {
            if (competitor instanceof PersonCompetitor) {
                PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
                personCompetitor.setShortName((!personCompetitor.getName().isEmpty() ? personCompetitor.getName().substring(0, 1) + ". " : "") + personCompetitor.getSurname());
            } else if (competitor instanceof CoupleCompetitor) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor;
                coupleCompetitor.setShortName((!coupleCompetitor.getSurname1().isEmpty() ? coupleCompetitor.getSurname1() + "/" : "") + coupleCompetitor.getSurname2());
            }
            this.competitorDAO.update((Pojo)competitor);
        }
    }

    @Transactional(value="jtekmaTransactionManager")
    public void switchNameAndSurname(Competition competition, Competitor.Type type) {
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        dataFilter.setFilter((Filter)rootFilter);
        rootFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)Competitor.Status.ACTIVE));
        rootFilter.addFilter((Filter)new FieldFilter("type", FieldFilter.Comparator.EQUAL, (Object)type));
        PageDataResult dataResult = this.competitorDAO.findForCompetition(competition, (DataFilter)dataFilter);
        for (Competitor competitor : dataResult.getData()) {
            if (competitor instanceof PersonCompetitor) {
                PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
                String name = personCompetitor.getName();
                String surname = personCompetitor.getSurname();
                personCompetitor.setSurname(name);
                personCompetitor.setName(surname);
                personCompetitor.setShortName((!personCompetitor.getName().isEmpty() ? personCompetitor.getName().substring(0, 1) + ". " : "") + personCompetitor.getSurname());
            } else if (competitor instanceof CoupleCompetitor) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor;
                String name1 = coupleCompetitor.getName1();
                String surname1 = coupleCompetitor.getSurname1();
                String name2 = coupleCompetitor.getName2();
                String surname2 = coupleCompetitor.getSurname2();
                coupleCompetitor.setSurname1(name1);
                coupleCompetitor.setName1(surname1);
                coupleCompetitor.setSurname2(name2);
                coupleCompetitor.setName2(surname2);
                coupleCompetitor.setShortName((!coupleCompetitor.getSurname1().isEmpty() ? coupleCompetitor.getSurname1() + "/" : "") + coupleCompetitor.getSurname2());
            }
            this.competitorDAO.update((Pojo)competitor);
        }
    }
}

