/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.importers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.jtekma.common.Gender;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.DuoCategory;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.category.WeightCategoryOption;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competition.CompetitionImport;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.GroupDraw;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.DuoPresentationGrading;
import si.nevensrok.jtekma.common.matches.DuoPresentationPoint;
import si.nevensrok.jtekma.common.matches.DuoPresentationValidAttack;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchGrading;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.MatchValidAttack;
import si.nevensrok.jtekma.common.matches.PointDetail;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.matches.Series;
import si.nevensrok.jtekma.common.matchupload.NextMatchUpload;
import si.nevensrok.jtekma.common.rules.SelectType;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.rules.TreeAdvancmentItem;
import si.nevensrok.jtekma.common.rules.TreeType;
import si.nevensrok.jtekma.common.tatami.Event;
import si.nevensrok.jtekma.common.tatami.Semaphore;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiHistory;
import si.nevensrok.jtekma.common.tatami.TatamiOnSemaphore;
import si.nevensrok.jtekma.schema.competition.AgeCategoryOptionType;
import si.nevensrok.jtekma.schema.competition.CategoryGroupType;
import si.nevensrok.jtekma.schema.competition.CategoryType;
import si.nevensrok.jtekma.schema.competition.ClubType;
import si.nevensrok.jtekma.schema.competition.CompetitionData;
import si.nevensrok.jtekma.schema.competition.CompetitionSettingType;
import si.nevensrok.jtekma.schema.competition.CompetitionStatusEnum;
import si.nevensrok.jtekma.schema.competition.CompetitorDrawType;
import si.nevensrok.jtekma.schema.competition.CompetitorType;
import si.nevensrok.jtekma.schema.competition.CoupleCompetitorType;
import si.nevensrok.jtekma.schema.competition.Duo2023CategoryType;
import si.nevensrok.jtekma.schema.competition.DuoCategoryType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationGradingType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationIdType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationPointType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationPointTypeEnum;
import si.nevensrok.jtekma.schema.competition.DuoPresentationType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationValidAttackType;
import si.nevensrok.jtekma.schema.competition.EventType;
import si.nevensrok.jtekma.schema.competition.FightOrderType;
import si.nevensrok.jtekma.schema.competition.FightingCategoryType;
import si.nevensrok.jtekma.schema.competition.GenderTypeEnum;
import si.nevensrok.jtekma.schema.competition.JudgeType;
import si.nevensrok.jtekma.schema.competition.MatchGradingType;
import si.nevensrok.jtekma.schema.competition.MatchIdType;
import si.nevensrok.jtekma.schema.competition.MatchPointDetailType;
import si.nevensrok.jtekma.schema.competition.MatchPointType;
import si.nevensrok.jtekma.schema.competition.MatchType;
import si.nevensrok.jtekma.schema.competition.MatchTypeEnum;
import si.nevensrok.jtekma.schema.competition.MatchValidAttackType;
import si.nevensrok.jtekma.schema.competition.NewazaCategoryType;
import si.nevensrok.jtekma.schema.competition.NextMatchUploadType;
import si.nevensrok.jtekma.schema.competition.PersonCompetitorType;
import si.nevensrok.jtekma.schema.competition.PointDetailChangeTypeEnum;
import si.nevensrok.jtekma.schema.competition.PointTypeEnum;
import si.nevensrok.jtekma.schema.competition.RankEnum;
import si.nevensrok.jtekma.schema.competition.RepassageTypeEnum;
import si.nevensrok.jtekma.schema.competition.RoundEnum;
import si.nevensrok.jtekma.schema.competition.SemaphoreType;
import si.nevensrok.jtekma.schema.competition.SeriesEnum;
import si.nevensrok.jtekma.schema.competition.SettingValueTypeEnum;
import si.nevensrok.jtekma.schema.competition.TatamiHistoryType;
import si.nevensrok.jtekma.schema.competition.TatamiOnSemaphoreType;
import si.nevensrok.jtekma.schema.competition.TatamiType;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentCompetitorTypeEnum;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentItemType;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentSelectTypeEnum;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentTreeType;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentType;
import si.nevensrok.jtekma.schema.competition.TreeCategoryType;
import si.nevensrok.jtekma.schema.competition.TreeTypeEnum;
import si.nevensrok.jtekma.schema.competition.WeightCategoryOptionType;
import si.nevensrok.jtekma.server.importers.CompetitionImporter;

public class CompetitionV1Importer
extends CompetitionImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetitionV1Importer.class);
    private static final String SETTINGS_DATE_FORMAT_TEXT = "yyyy-MM-dd HH:mm:ss.SSS Z";

    @Override
    public void importCompetition(CompetitionData competitionData) {
        Category category;
        AgeCategoryOption existing;
        Competition competition = new Competition();
        competition.setName(competitionData.getCompetition().getName());
        competition.setCompetitonDate(this.toDate(competitionData.getCompetition().getDate()));
        competition.setDescription(competitionData.getCompetition().getDescription());
        competition.setRules(competitionData.getCompetition().getRules());
        competition.setStatus((Competition.Status)ObjectUtil.ifNull((Object)this.toCompetitionStatus(competitionData.getCompetition().getStatus()), (Object)Competition.Status.FINISHED));
        competition = this.getCompetitionManager().createCompetition(competition);
        CompetitionImport competitionImport = new CompetitionImport();
        competitionImport.setCompetition(competition);
        competitionImport.setStartDate(Calendar.getInstance().getTime());
        competitionImport.setPrecentageDone(Integer.valueOf(0));
        competitionImport = this.getCompetitionImportManager().createCompetitionImport(competitionImport);
        HashMap<String, String> competitionSettings = new HashMap<String, String>();
        for (CompetitionSettingType competitionSettingType : competitionData.getCompetition().getCompetitionSettingList().getCompetitionSetting()) {
            Object value = null;
            if (competitionSettingType.getSettingValue() != null) {
                if (competitionSettingType.getValueType() == SettingValueTypeEnum.STRING) {
                    value = competitionSettingType.getSettingValue();
                } else if (competitionSettingType.getValueType() == SettingValueTypeEnum.NUMBER) {
                    try {
                        value = Long.parseLong(competitionSettingType.getSettingValue());
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Error parsing long", (Throwable)exception);
                    }
                } else if (competitionSettingType.getValueType() == SettingValueTypeEnum.DECIMAL) {
                    try {
                        value = Double.parseDouble(competitionSettingType.getSettingValue());
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Error parsing double", (Throwable)exception);
                    }
                } else if (competitionSettingType.getValueType() == SettingValueTypeEnum.DATE) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SETTINGS_DATE_FORMAT_TEXT);
                        value = simpleDateFormat.parseObject(competitionSettingType.getSettingValue());
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Error parsing date", (Throwable)exception);
                    }
                } else if (competitionSettingType.getValueType() == SettingValueTypeEnum.BOOLEAN) {
                    try {
                        value = Boolean.parseBoolean(competitionSettingType.getSettingValue());
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Error parsing boolean", (Throwable)exception);
                    }
                }
            }
            competitionSettings.put(competitionSettingType.getSettingKey(), (String)value);
        }
        this.getCompetitionManager().setCompetitionSettings(competition, competitionSettings, true);
        int importedObjects = 0;
        int totalObjects = 0;
        totalObjects += competitionData.getAgeCategoryOptionList().getAgeCategoryOption().size();
        totalObjects += competitionData.getWeightCategoryOptionList().getWeightCategoryOption().size();
        totalObjects += competitionData.getTreeAdvancmentList().getTreeAdvancment().size();
        totalObjects += competitionData.getClubList().getClub().size();
        totalObjects += competitionData.getCompetitorList().getCompetitor().size();
        totalObjects += competitionData.getCategoryList().getCategory().size() * 50;
        totalObjects += competitionData.getTatamiList().getTatami().size();
        totalObjects += competitionData.getSemaphoreList().getSemaphore().size();
        if (competitionData.getFightInfoList() != null) {
            totalObjects += competitionData.getFightInfoList().getFightInfo().size();
        }
        if (competitionData.getNextMatchUploadList() != null) {
            totalObjects += competitionData.getNextMatchUploadList().getNextMatchUpload().size();
        }
        if (competitionData.getCategoryGroupList() != null) {
            totalObjects += competitionData.getCategoryGroupList().getCategoryGroup().size();
        }
        if (competitionData.getJudgeList() != null) {
            totalObjects += competitionData.getJudgeList().getJudge().size();
        }
        for (AgeCategoryOptionType ageCategoryOptionType : competitionData.getAgeCategoryOptionList().getAgeCategoryOption()) {
            AgeCategoryOption ageCategoryOption = this.toAgeCategoryOption(ageCategoryOptionType);
            existing = this.getAgeCategoryOptionManager().getActiveAgeCategoryOptionByName(ageCategoryOption.getName());
            ageCategoryOption = existing == null ? this.getAgeCategoryOptionManager().createAgeCategoryOption(ageCategoryOption) : existing;
            this.getAgeCategories().put(ageCategoryOptionType.getId(), ageCategoryOption);
            competitionImport.setPrecentageDone(Integer.valueOf(Math.round((float)(++importedObjects) / (float)totalObjects * 100.0f)));
            competitionImport = this.getCompetitionImportManager().updateCompetitionImport(competitionImport);
        }
        for (WeightCategoryOptionType weightCategoryOptionType : competitionData.getWeightCategoryOptionList().getWeightCategoryOption()) {
            Object weightCategoryOption = this.toWeightCategoryOption(weightCategoryOptionType);
            existing = this.getWeightCategoryOptionManager().getActiveWeightCategory(weightCategoryOption.getWeight(), weightCategoryOption.getIsAbsolute(), weightCategoryOption.getGender());
            weightCategoryOption = existing == null ? this.getWeightCategoryOptionManager().createWeightCategoryOption(weightCategoryOption) : existing;
            this.getWeightCategories().put(weightCategoryOptionType.getId(), (WeightCategoryOption)weightCategoryOption);
            competitionImport.setPrecentageDone(Integer.valueOf(Math.round((float)(++importedObjects) / (float)totalObjects * 100.0f)));
            competitionImport = this.getCompetitionImportManager().updateCompetitionImport(competitionImport);
        }
        for (TreeAdvancmentType treeAdvancmentType : competitionData.getTreeAdvancmentList().getTreeAdvancment()) {
            Object treeAdvancment = this.toTreeAdvancment(treeAdvancmentType);
            existing = this.getTreeAdvancmentManager().getActiveTreeAdvancmentByName(treeAdvancment.getName());
            treeAdvancment = existing == null ? this.getTreeAdvancmentManager().createTreeAvancment(treeAdvancment) : existing;
            this.getTreeAdvancments().put(treeAdvancmentType.getId(), (TreeAdvancment)treeAdvancment);
            competitionImport.setPrecentageDone(Integer.valueOf(Math.round((float)(++importedObjects) / (float)totalObjects * 100.0f)));
            competitionImport = this.getCompetitionImportManager().updateCompetitionImport(competitionImport);
        }
        for (ClubType clubType : competitionData.getClubList().getClub()) {
            Club club = this.toClub(clubType);
            club.setCompetition(competition);
            club = this.getClubManager().createClub(club);
            this.getClubs().put(clubType.getId(), club);
            competitionImport.setPrecentageDone(Integer.valueOf(Math.round((float)(++importedObjects) / (float)totalObjects * 100.0f)));
            competitionImport = this.getCompetitionImportManager().updateCompetitionImport(competitionImport);
        }
        for (CompetitorType competitorType : competitionData.getCompetitorList().getCompetitor()) {
            Competitor competitor = this.toCompetitor(competitorType);
            competitor.setCompetition(competition);
            competitor = this.getCompetitorManager().createCompetitor(competitor);
            this.getCompetitors().put(competitorType.getId(), competitor);
            competitionImport.setPrecentageDone(Integer.valueOf(Math.round((float)(++importedObjects) / (float)totalObjects * 100.0f)));
            competitionImport = this.getCompetitionImportManager().updateCompetitionImport(competitionImport);
        }
        for (CategoryType categoryType : competitionData.getCategoryList().getCategory()) {
            Object draw;
            Category category2 = this.toCategory(categoryType);
            category2.setCompetition(competition);
            category2 = this.getCategoryManager().createCategory(category2);
            this.getCategories().put(categoryType.getId(), category2);
            competitionImport.setPrecentageDone(Integer.valueOf(Math.round((float)(importedObjects += 50) / (float)totalObjects * 100.0f)));
            competitionImport = this.getCompetitionImportManager().updateCompetitionImport(competitionImport);
            LinkedList<Competitor> competitorsForCategory = new LinkedList<Competitor>();
            for (String competitorId : categoryType.getCompetitorIdList().getId()) {
                competitorsForCategory.add(this.getCompetitors().get(competitorId));
            }
            this.getCategoryManager().setCompetitorsForCategory(category2, competitorsForCategory);
            if (categoryType instanceof TreeCategoryType) {
                TreeCategoryType treeCategoryType = (TreeCategoryType)categoryType;
                draw = new HashMap();
                for (CompetitorDrawType competitorDrawType : treeCategoryType.getCompetitorDrawList().getCompetitorDraw()) {
                    if (competitorDrawType.getDrawNumber() <= 0) continue;
                    draw.put(this.getCompetitors().get(competitorDrawType.getCompetitorId()), competitorDrawType.getDrawNumber());
                }
                this.getCategoryManager().setDraw(category2, (Map)draw);
            } else if (categoryType instanceof Duo2023CategoryType) {
                Duo2023CategoryType duo2023CategoryType = (Duo2023CategoryType)categoryType;
                draw = new HashMap();
                for (CompetitorDrawType competitorDrawType : duo2023CategoryType.getCompetitorDrawList().getCompetitorDraw()) {
                    int drawNumber = competitorDrawType.getDrawNumber();
                    int drawGroup = (Integer)ObjectUtil.ifNull((Object)competitorDrawType.getDrawGroup(), (Object)0);
                    if (drawNumber <= 0 || drawGroup <= 0) continue;
                    draw.put(this.getCompetitors().get(competitorDrawType.getCompetitorId()), new GroupDraw(Integer.valueOf(drawNumber), Integer.valueOf(drawGroup)));
                }
                this.getCategoryManager().setGroupDraw(category2, (Map)draw);
            }
            if (category2.getType() == Category.Type.CUSTOM) {
                Iterator<Match> matches = new LinkedList();
                for (MatchType matchType : categoryType.getMatches().getMatch()) {
                    Match match = new Match();
                    match.setCategory(category2);
                    match.setFightNumber(Integer.valueOf(matchType.getFightNumber()));
                    match.setNoWinner(Boolean.valueOf(false));
                    if (matchType.isFinished()) {
                        match.setStatus(Match.Status.FINISHED);
                    } else {
                        match.setStatus(Match.Status.WAITING);
                    }
                    match.setType(this.toMatchType(matchType.getMatchType()));
                    match.setNotNeeded(Boolean.valueOf(false));
                    match.setMatchEmpty(Boolean.valueOf(false));
                    match.setStartedAt(this.toDate(matchType.getStartedAt()));
                    match.setFinishedAt(this.toDate(matchType.getFinishedAt()));
                    match.setMatchDuration(matchType.getMatchDuration());
                    match.setFightTimeLeft(matchType.getFightTimeLeft());
                    match.setHosekomiTime(matchType.getHosekomiTime());
                    match.setInjuryTime1(matchType.getInjuryTime1());
                    match.setInjuryTime2(matchType.getInjuryTime2());
                    match.setChallengesWon1(matchType.getChallengesWon1());
                    match.setChallengesWon2(matchType.getChallengesWon2());
                    match.setChallengesLost1(matchType.getChallengesLost1());
                    match.setChallengesLost2(matchType.getChallengesLost2());
                    if (StringUtil.isNotEmpty((String)matchType.getCompetitor1Id())) {
                        match.setCompetitor1(this.getCompetitors().get(matchType.getCompetitor1Id()));
                    }
                    if (StringUtil.isNotEmpty((String)matchType.getCompetitor2Id())) {
                        match.setCompetitor2(this.getCompetitors().get(matchType.getCompetitor2Id()));
                    }
                    matches.add(match);
                }
                this.getMatchManager().createMatches(matches);
            }
            for (MatchType matchType : categoryType.getMatches().getMatch()) {
                PointDetail pointDetail;
                Object matchPointType32;
                MatchPoint matchPoint;
                Match match = this.getMatchManager().getMatchForCategory(category2, matchType.getFightNumber());
                if (match == null) {
                    match = new Match();
                    match.setCategory(category2);
                    if (matchType.isFinished()) {
                        match.setStatus(Match.Status.FINISHED);
                    } else {
                        match.setStatus(Match.Status.WAITING);
                    }
                    match.setType(this.toMatchType(matchType.getMatchType()));
                    match.setFightNumber(Integer.valueOf(matchType.getFightNumber()));
                    match.setNotNeeded(Boolean.FALSE);
                    match.setMatchEmpty(Boolean.FALSE);
                    match.setNoWinner(Boolean.valueOf(matchType.isNoWinner()));
                    match.setStartedAt(this.toDate(matchType.getStartedAt()));
                    match.setFinishedAt(this.toDate(matchType.getFinishedAt()));
                    match.setMatchDuration(matchType.getMatchDuration());
                    match.setFightTimeLeft(matchType.getFightTimeLeft());
                    match.setHosekomiTime(matchType.getHosekomiTime());
                    match.setInjuryTime1(matchType.getInjuryTime1());
                    match.setInjuryTime2(matchType.getInjuryTime2());
                    match.setChallengesWon1(matchType.getChallengesWon1());
                    match.setChallengesWon2(matchType.getChallengesWon2());
                    match.setChallengesLost1(matchType.getChallengesLost1());
                    match.setChallengesLost2(matchType.getChallengesLost2());
                    match = this.getMatchManager().createMatch(match);
                } else {
                    match.setNoWinner(Boolean.valueOf(matchType.isNoWinner()));
                    match.setStartedAt(this.toDate(matchType.getStartedAt()));
                    match.setFinishedAt(this.toDate(matchType.getFinishedAt()));
                    match.setMatchDuration(matchType.getMatchDuration());
                    match.setFightTimeLeft(matchType.getFightTimeLeft());
                    match.setHosekomiTime(matchType.getHosekomiTime());
                    match.setInjuryTime1(matchType.getInjuryTime1());
                    match.setInjuryTime2(matchType.getInjuryTime2());
                    match.setChallengesWon1(matchType.getChallengesWon1());
                    match.setChallengesWon2(matchType.getChallengesWon2());
                    match.setChallengesLost1(matchType.getChallengesLost1());
                    match.setChallengesLost2(matchType.getChallengesLost2());
                    this.getMatchManager().updateMatch(match);
                }
                this.getMatches().put(match, matchType);
                HashSet<MatchPoint> matchPoints = new HashSet<MatchPoint>();
                for (MatchPointType matchPointType2 : matchType.getCompetitor1Points().getMatchPoint()) {
                    matchPoint = this.toMatchPoint(matchPointType2);
                    matchPoint.setCompetitor(si.nevensrok.jtekma.common.rules.CompetitorType.COMPETITOR1);
                    matchPoints.add(matchPoint);
                }
                for (Object matchPointType32 : matchType.getCompetitor2Points().getMatchPoint()) {
                    matchPoint = this.toMatchPoint((MatchPointType)matchPointType32);
                    matchPoint.setCompetitor(si.nevensrok.jtekma.common.rules.CompetitorType.COMPETITOR2);
                    matchPoints.add(matchPoint);
                }
                this.getMatchManager().setMatchPointsForMatch(match, matchPoints);
                HashSet<PointDetail> pointDetails = new HashSet<PointDetail>();
                for (MatchPointDetailType matchPointDetailType : matchType.getCompetitor1PointDetails().getMatchPointDetail()) {
                    pointDetail = this.toPointDetail(matchPointDetailType);
                    pointDetail.setCompetitor(si.nevensrok.jtekma.common.rules.CompetitorType.COMPETITOR1);
                    pointDetails.add(pointDetail);
                }
                matchPointType32 = matchType.getCompetitor2PointDetails().getMatchPointDetail().iterator();
                while (matchPointType32.hasNext()) {
                    MatchPointDetailType matchPointDetailType2 = (MatchPointDetailType)matchPointType32.next();
                    pointDetail = this.toPointDetail(matchPointDetailType2);
                    pointDetail.setCompetitor(si.nevensrok.jtekma.common.rules.CompetitorType.COMPETITOR2);
                    pointDetails.add(pointDetail);
                }
                this.getMatchManager().setMatchPointDetailsForMatch(match, pointDetails);
                if (matchType.isFinished()) {
                    match.setStatus(Match.Status.FINISHED);
                    this.getMatchManager().setMatchStatus(match, match.getStatus());
                }
                if (matchType.getMatchValidAttackList() == null) continue;
                LinkedHashSet<MatchValidAttack> validAttacks = new LinkedHashSet<MatchValidAttack>();
                for (MatchValidAttackType matchValidAttackType : matchType.getMatchValidAttackList().getMatchValidAttack()) {
                    MatchValidAttack matchValidAttack = this.toMatchValidAttack(matchValidAttackType);
                    matchValidAttack.setMatch(match);
                    validAttacks.add(matchValidAttack);
                }
                this.getMatchManager().setValidAttacksForMatch(match, validAttacks);
            }
            if (categoryType.getDuoPresentations() != null) {
                for (DuoPresentationType duoPresentationType : categoryType.getDuoPresentations().getDuoPresentation()) {
                    Object duoPresentationPointType2;
                    Competitor competitor = this.getCompetitors().get(duoPresentationType.getCompetitorId());
                    Round round = this.toRound(duoPresentationType.getRound());
                    DuoPresentation duoPresentation = this.getDuoPresentationManager().getDuoPresentationsForCategory(category2, round, competitor);
                    if (duoPresentation == null) {
                        duoPresentation = new DuoPresentation();
                        duoPresentation.setCompetitor(competitor);
                        duoPresentation.setCategory(category2);
                        duoPresentation.setStatus(DuoPresentation.Status.WAITING);
                        duoPresentation.setRound(round);
                        duoPresentation.setGroupNumber(duoPresentationType.getGroupNumber());
                        duoPresentation.setGroupPosition(Integer.valueOf(duoPresentationType.getGroupPosition()));
                        duoPresentation.setNotNeeded(Boolean.FALSE);
                        duoPresentation.setStartedAt(this.toDate(duoPresentationType.getStartedAt()));
                        duoPresentation.setFinishedAt(this.toDate(duoPresentationType.getFinishedAt()));
                        duoPresentation.setMatchDuration(duoPresentationType.getMatchDuration());
                        duoPresentation = this.getDuoPresentationManager().createDuoPresentation(duoPresentation);
                    } else {
                        duoPresentation.setGroupNumber(duoPresentationType.getGroupNumber());
                        duoPresentation.setGroupPosition(Integer.valueOf(duoPresentationType.getGroupPosition()));
                        duoPresentation.setStartedAt(this.toDate(duoPresentationType.getStartedAt()));
                        duoPresentation.setFinishedAt(this.toDate(duoPresentationType.getFinishedAt()));
                        duoPresentation.setMatchDuration(duoPresentationType.getMatchDuration());
                        this.getDuoPresentationManager().updateDuoPresentation(duoPresentation);
                    }
                    this.getDuoPresentations().put(duoPresentation, duoPresentationType);
                    HashSet<DuoPresentationPoint> duoPresentationPoints = new HashSet<DuoPresentationPoint>();
                    for (Object duoPresentationPointType2 : duoPresentationType.getDuoPresentationPoints().getDuoPresentationPoint()) {
                        DuoPresentationPoint duoPresentationPoint = this.toDuoPresentationPoint((DuoPresentationPointType)duoPresentationPointType2);
                        duoPresentationPoints.add(duoPresentationPoint);
                    }
                    this.getDuoPresentationManager().setDuoPresentationPointsForDuoPresentation(duoPresentation, duoPresentationPoints);
                    if (duoPresentationType.isFinished()) {
                        duoPresentation.setStatus(DuoPresentation.Status.FINISHED);
                        this.getDuoPresentationManager().setDuoPresentationStatus(duoPresentation, duoPresentation.getStatus());
                    }
                    if (duoPresentationType.getDuoPresentationValidAttackList() == null) continue;
                    LinkedHashSet<DuoPresentationValidAttack> validAttacks = new LinkedHashSet<DuoPresentationValidAttack>();
                    duoPresentationPointType2 = duoPresentationType.getDuoPresentationValidAttackList().getDuoPresentationValidAttack().iterator();
                    while (duoPresentationPointType2.hasNext()) {
                        DuoPresentationValidAttackType duoPresentationValidAttackType = (DuoPresentationValidAttackType)duoPresentationPointType2.next();
                        DuoPresentationValidAttack duoPresentationValidAttack = this.toDuoPresentationValidAttack(duoPresentationValidAttackType);
                        duoPresentationValidAttack.setDuoPresentation(duoPresentation);
                        validAttacks.add(duoPresentationValidAttack);
                    }
                    this.getDuoPresentationManager().setValidAttacksForDuoPresentation(duoPresentation, validAttacks);
                }
            }
            if (category2.getType() != Category.Type.FIGHTING && category2.getType() != Category.Type.DUO && category2.getType() != Category.Type.DUO_2023 && category2.getType() != Category.Type.NEWAZA) continue;
            this.getCategoryTreeUpdateManager().updateCategory(category2);
        }
        for (TatamiType tatamiType : competitionData.getTatamiList().getTatami()) {
            Iterator categoryId2;
            Tatami tatami = this.toTatami(tatamiType);
            tatami.setCompetition(competition);
            tatami = this.getTatamiManager().createTatamiWithPassword(tatami);
            this.getTatamis().put(tatamiType.getId(), tatami);
            competitionImport.setPrecentageDone(Integer.valueOf(Math.round((float)(++importedObjects) / (float)totalObjects * 100.0f)));
            competitionImport = this.getCompetitionImportManager().updateCompetitionImport(competitionImport);
            HashSet<Category> categories = new HashSet<Category>();
            for (Iterator categoryId2 : tatamiType.getCategoryIdList().getCategoryId()) {
                category = this.getCategories().get(categoryId2);
                categories.add(category);
            }
            this.getTatamiManager().setCategoriesForTatami(tatami, categories);
            ArrayList fightOrderList = new ArrayList(tatamiType.getFightOrderList().getFightOrder());
            Collections.sort(fightOrderList, new Comparator<FightOrderType>(){

                @Override
                public int compare(FightOrderType o1, FightOrderType o2) {
                    return Integer.compare(o1.getFightNumber(), o2.getFightNumber());
                }
            });
            categoryId2 = fightOrderList.iterator();
            while (categoryId2.hasNext()) {
                FightOrderType fightOrderType = (FightOrderType)categoryId2.next();
                if (fightOrderType.getEvent() != null) {
                    EventType eventType = fightOrderType.getEvent();
                    Event event = new Event();
                    event.setText(eventType.getText());
                    event.setAutoRemove(Boolean.valueOf(eventType.isAutoRemove()));
                    this.getTatamiFightsManager().addEventToTatami(event, tatami);
                    continue;
                }
                if (fightOrderType.getMatch() != null) {
                    Match match;
                    MatchIdType matchIdType = fightOrderType.getMatch();
                    Category category3 = this.getCategories().get(matchIdType.getCategoryId());
                    if (category3 == null || (match = this.getMatchManager().getMatchForCategory(category3, matchIdType.getMatchNum())) == null) continue;
                    this.getTatamiFightsManager().addMatchToTatami(match, tatami);
                    continue;
                }
                if (fightOrderType.getDuoPresentation() == null) continue;
                DuoPresentationIdType duoPresentationIdType = fightOrderType.getDuoPresentation();
                Category category2 = this.getCategories().get(duoPresentationIdType.getCategoryId());
                Competitor competitor = this.getCompetitors().get(duoPresentationIdType.getCompetitorId());
                if (category2 == null || competitor == null) continue;
                Round round = this.toRound(duoPresentationIdType.getRound());
                DuoPresentation duoPresentation = this.getDuoPresentationManager().getDuoPresentationsForCategory(category2, round, competitor);
                if (duoPresentation == null) continue;
                this.getTatamiFightsManager().addDuoPresentationToTatami(duoPresentation, tatami);
            }
            if (tatamiType.getTatamiHistoryList() == null) continue;
            categoryId2 = tatamiType.getTatamiHistoryList().getTatamiHistory().iterator();
            while (categoryId2.hasNext()) {
                TatamiHistoryType tatamiHistoryType = (TatamiHistoryType)categoryId2.next();
                TatamiHistory tatamiHistory = this.toTatamiHistory(tatamiHistoryType);
                tatamiHistory.setTatami(tatami);
                this.getTatamiHistoryManager().createTatamiHistory(tatamiHistory);
            }
        }
        for (SemaphoreType semaphoreType : competitionData.getSemaphoreList().getSemaphore()) {
            Semaphore semaphore = this.toSemaphore(semaphoreType);
            semaphore.setCompetition(competition);
            semaphore = this.getSemaphoreManager().createSemaphoreWithPassword(semaphore);
            this.getSemaphores().put(semaphoreType.getId(), semaphore);
            competitionImport.setPrecentageDone(Integer.valueOf(Math.round((float)(++importedObjects) / (float)totalObjects * 100.0f)));
            competitionImport = this.getCompetitionImportManager().updateCompetitionImport(competitionImport);
            HashSet<TatamiOnSemaphore> tatamiOnSemaphores = new HashSet<TatamiOnSemaphore>();
            for (TatamiOnSemaphoreType tatamiOnSemaphoreType : semaphoreType.getTatamiOnSemaphoreList().getTatamiOnSemaphore()) {
                TatamiOnSemaphore tatamiOnSemaphore = new TatamiOnSemaphore();
                tatamiOnSemaphore.setTatami(this.getTatamis().get(tatamiOnSemaphoreType.getTatamiId()));
                tatamiOnSemaphore.setOrderNum(Integer.valueOf(tatamiOnSemaphoreType.getOrder()));
                tatamiOnSemaphores.add(tatamiOnSemaphore);
            }
            this.getSemaphoreManager().setTatamisForSemaphore(semaphore, tatamiOnSemaphores);
        }
        if (competitionData.getNextMatchUploadList() != null) {
            for (NextMatchUploadType nextMatchUploadType : competitionData.getNextMatchUploadList().getNextMatchUpload()) {
                NextMatchUpload nextMatchUpload = this.toNextMatchUploadType(nextMatchUploadType);
                nextMatchUpload.setCompetition(competition);
                nextMatchUpload = this.getNextMatchUploadManager().createNextMatchUpload(nextMatchUpload);
                ++importedObjects;
            }
        }
        if (competitionData.getCategoryGroupList() != null) {
            for (CategoryGroupType categoryGroupType : competitionData.getCategoryGroupList().getCategoryGroup()) {
                CategoryGroup categoryGroup = this.toCategoryGroup(categoryGroupType);
                categoryGroup.setCompetition(competition);
                categoryGroup = this.getCategoryGroupManager().createCategoryGroup(categoryGroup);
                LinkedList<Category> categoriesForGroup = new LinkedList<Category>();
                for (String categoryId2 : categoryGroupType.getCategoryIds().getId()) {
                    category = this.getCategories().get(categoryId2);
                    if (category == null) continue;
                    categoriesForGroup.add(category);
                }
                this.getCategoryGroupManager().setCategoriesForGroup(categoryGroup, categoriesForGroup);
                ++importedObjects;
            }
        }
        if (competitionData.getJudgeList() != null) {
            for (JudgeType judgeType : competitionData.getJudgeList().getJudge()) {
                Judge judge = this.toJudge(judgeType);
                judge.setCompetition(competition);
                judge = this.getJudgeManager().createJudgeWithPassword(judge);
                this.getJudges().put(judgeType.getId(), judge);
                LinkedHashSet<Tatami> tatamis = new LinkedHashSet<Tatami>();
                for (String tatamiId : judgeType.getJudgeOnTatamiList().getTatamiId()) {
                    Tatami tatami = this.getTatamis().get(tatamiId);
                    if (tatami == null) continue;
                    tatamis.add(tatami);
                }
                this.getJudgeManager().setTatamisForJudge(judge, tatamis);
                ++importedObjects;
            }
        }
        for (Map.Entry entry : this.getMatches().entrySet()) {
            if (((MatchType)entry.getValue()).getMatchGradingList() == null) continue;
            LinkedList<MatchGrading> matchGradings = new LinkedList<MatchGrading>();
            for (MatchGradingType matchGradingType : ((MatchType)entry.getValue()).getMatchGradingList().getMatchGrading()) {
                MatchGrading matchGrading = this.toMatchGrading(matchGradingType);
                matchGrading.setMatch((Match)entry.getKey());
                if (matchGrading.getJudge() == null) continue;
                matchGradings.add(matchGrading);
            }
            this.getMatchManager().setMatchGradings((Match)entry.getKey(), matchGradings);
        }
        for (Map.Entry entry : this.getDuoPresentations().entrySet()) {
            if (((DuoPresentationType)entry.getValue()).getDuoPresentationGradingList() == null) continue;
            LinkedList<DuoPresentationGrading> duoPresentationGradings = new LinkedList<DuoPresentationGrading>();
            for (DuoPresentationGradingType duoPresentationGradingType : ((DuoPresentationType)entry.getValue()).getDuoPresentationGradingList().getDuoPresentationGrading()) {
                DuoPresentationGrading duoPresentationGrading = this.toDuoPresentationGrading(duoPresentationGradingType);
                duoPresentationGrading.setDuoPresentation((DuoPresentation)entry.getKey());
                if (duoPresentationGrading.getJudge() == null) continue;
                duoPresentationGradings.add(duoPresentationGrading);
            }
            this.getDuoPresentationManager().setDuoPresentationGradings((DuoPresentation)entry.getKey(), duoPresentationGradings);
        }
        this.getCompetitionImportManager().deleteCompetitionImport(competitionImport);
    }

    private AgeCategoryOption toAgeCategoryOption(AgeCategoryOptionType ageCategoryOptionType) {
        AgeCategoryOption ageCategoryOption = new AgeCategoryOption();
        ageCategoryOption.setName(ageCategoryOptionType.getName());
        ageCategoryOption.setAge((Integer)ObjectUtil.ifNull((Object)ageCategoryOptionType.getAge(), (Object)18));
        ageCategoryOption.setFightTime((Integer)ObjectUtil.ifNull((Object)ageCategoryOptionType.getFightTime(), (Object)180));
        ageCategoryOption.setHosekomiTime((Integer)ObjectUtil.ifNull((Object)ageCategoryOptionType.getHosekomiTime(), (Object)15));
        ageCategoryOption.setNewazaPenaltyHansokumake((Integer)ObjectUtil.ifNull((Object)ageCategoryOptionType.getNewazaPenaltyHansokumake(), (Object)6));
        ageCategoryOption.setStatus(AgeCategoryOption.Status.ACTIVE);
        return ageCategoryOption;
    }

    private WeightCategoryOption toWeightCategoryOption(WeightCategoryOptionType weightCategoryOptionType) {
        WeightCategoryOption weightCategoryOption = new WeightCategoryOption();
        weightCategoryOption.setWeight(Integer.valueOf(weightCategoryOptionType.getWeight()));
        weightCategoryOption.setIsAbsolute(Boolean.valueOf(weightCategoryOptionType.isIsAbsolute()));
        weightCategoryOption.setGender(this.toGender(weightCategoryOptionType.getGender()));
        weightCategoryOption.setStatus(WeightCategoryOption.Status.ACTIVE);
        return weightCategoryOption;
    }

    private Gender toGender(GenderTypeEnum genderTypeEnum) {
        if (genderTypeEnum == null) {
            return null;
        }
        switch (genderTypeEnum) {
            case FEMALE: {
                return Gender.FEMALE;
            }
            case MALE: {
                return Gender.MALE;
            }
            case MIX: {
                return Gender.MIX;
            }
        }
        return null;
    }

    private Club toClub(ClubType clubType) {
        Club club = new Club();
        club.setName(clubType.getName());
        club.setShortName(clubType.getShortName());
        club.setStatus(Club.Status.ACTIVE);
        club.setCountForClubPlacings((Boolean)ObjectUtil.ifNull((Object)clubType.isCountForClubPlacings(), (Object)Boolean.TRUE));
        return club;
    }

    private Competitor toCompetitor(CompetitorType competitorType) {
        PersonCompetitor competitor = null;
        if (competitorType instanceof PersonCompetitorType) {
            competitor = new PersonCompetitor();
            competitor.setType(Competitor.Type.COMPETITOR);
            PersonCompetitorType personCompetitorType = (PersonCompetitorType)competitorType;
            PersonCompetitor personCompetitor = competitor;
            personCompetitor.setName(personCompetitorType.getName());
            personCompetitor.setSurname(personCompetitorType.getSurname());
            personCompetitor.setShortName(personCompetitorType.getShortName());
            personCompetitor.setYearOfBirth(Integer.valueOf(personCompetitorType.getYearOfBirth()));
            personCompetitor.setWeight(Integer.valueOf(personCompetitorType.getWeight()));
        } else if (competitorType instanceof CoupleCompetitorType) {
            competitor = new CoupleCompetitor();
            competitor.setType(Competitor.Type.COUPLE);
            CoupleCompetitorType coupleCompetitorType = (CoupleCompetitorType)competitorType;
            CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor;
            coupleCompetitor.setName1(coupleCompetitorType.getName1());
            coupleCompetitor.setSurname1(coupleCompetitorType.getSurname1());
            coupleCompetitor.setName2(coupleCompetitorType.getName2());
            coupleCompetitor.setSurname2(coupleCompetitorType.getSurname2());
            coupleCompetitor.setShortName(coupleCompetitorType.getShortName());
            coupleCompetitor.setYearOfBirth1(Integer.valueOf(coupleCompetitorType.getYearOfBirth1()));
            coupleCompetitor.setYearOfBirth2(Integer.valueOf(coupleCompetitorType.getYearOfBirth2()));
        }
        competitor.setStatus(Competitor.Status.ACTIVE);
        competitor.setClub(this.getClubs().get(competitorType.getClubId()));
        return competitor;
    }

    private TreeAdvancment toTreeAdvancment(TreeAdvancmentType treeAdvancmentType) {
        TreeAdvancment treeAdvancment = new TreeAdvancment();
        treeAdvancment.setName(treeAdvancmentType.getName());
        treeAdvancment.setTreeAdvancmentItems(new HashSet());
        treeAdvancment.setStatus(TreeAdvancment.Status.ACTIVE);
        for (TreeAdvancmentItemType treeAdvancmentItemType : treeAdvancmentType.getTreeAdvancmentItemList().getTreeAdvancmentItem()) {
            TreeAdvancmentItem treeAdvancmentItem = this.toTreeAdvancmentItem(treeAdvancmentItemType);
            treeAdvancment.getTreeAdvancmentItems().add(treeAdvancmentItem);
        }
        return treeAdvancment;
    }

    private TreeAdvancmentItem toTreeAdvancmentItem(TreeAdvancmentItemType treeAdvancmentItemType) {
        TreeAdvancmentItem treeAdvancmentItem = new TreeAdvancmentItem();
        treeAdvancmentItem.setForMatch(treeAdvancmentItem.getForMatch());
        treeAdvancmentItem.setCompetitorType(this.toCompetitorType(treeAdvancmentItemType.getCompetitorType()));
        treeAdvancmentItem.setFromMatch(Integer.valueOf(treeAdvancmentItemType.getFromMatch()));
        treeAdvancmentItem.setSelectType(this.toSelectType(treeAdvancmentItemType.getSelectType()));
        treeAdvancmentItem.setTreeType(this.toTreeAdvancmentTreeType(treeAdvancmentItemType.getTreeType()));
        return treeAdvancmentItem;
    }

    private si.nevensrok.jtekma.common.rules.CompetitorType toCompetitorType(TreeAdvancmentCompetitorTypeEnum treeAdvancmentCompetitorTypeEnum) {
        switch (treeAdvancmentCompetitorTypeEnum) {
            case COMPETITOR_1: {
                return si.nevensrok.jtekma.common.rules.CompetitorType.COMPETITOR1;
            }
            case COMPETITOR_2: {
                return si.nevensrok.jtekma.common.rules.CompetitorType.COMPETITOR2;
            }
        }
        return null;
    }

    private SelectType toSelectType(TreeAdvancmentSelectTypeEnum treeAdvancmentSelectTypeEnum) {
        switch (treeAdvancmentSelectTypeEnum) {
            case WINNER: {
                return SelectType.WINNER;
            }
            case LOSER: {
                return SelectType.LOSER;
            }
            case DRAW: {
                return SelectType.DRAW;
            }
        }
        return null;
    }

    private TreeType toTreeAdvancmentTreeType(TreeAdvancmentTreeType treeAdvancmentTreeType) {
        switch (treeAdvancmentTreeType) {
            case TREE: {
                return TreeType.TREE;
            }
            case TABLE: {
                return TreeType.TABLE;
            }
        }
        return null;
    }

    private Category toCategory(CategoryType categoryType) {
        FightingCategory category = null;
        if (categoryType instanceof FightingCategoryType) {
            FightingCategory fightingCategory;
            FightingCategoryType fightingCategoryType = (FightingCategoryType)categoryType;
            category = fightingCategory = new FightingCategory();
            fightingCategory.setType(Category.Type.FIGHTING);
            if (fightingCategoryType.getWeightCategoryOptionId() != null) {
                fightingCategory.setWeightCategoryOption(this.getWeightCategories().get(fightingCategoryType.getWeightCategoryOptionId()));
            }
            if (fightingCategoryType.getAgeCategoryOptionId() != null) {
                fightingCategory.setAgeCategoryOption(this.getAgeCategories().get(fightingCategoryType.getAgeCategoryOptionId()));
            }
        } else if (categoryType instanceof NewazaCategoryType) {
            NewazaCategoryType newazaCategoryType = (NewazaCategoryType)categoryType;
            NewazaCategory newazaCategory = new NewazaCategory();
            category = newazaCategory;
            newazaCategory.setType(Category.Type.NEWAZA);
            if (newazaCategoryType.getWeightCategoryOptionId() != null) {
                newazaCategory.setWeightCategoryOption(this.getWeightCategories().get(newazaCategoryType.getWeightCategoryOptionId()));
            }
            if (newazaCategoryType.getAgeCategoryOptionId() != null) {
                newazaCategory.setAgeCategoryOption(this.getAgeCategories().get(newazaCategoryType.getAgeCategoryOptionId()));
            }
        } else if (categoryType instanceof DuoCategoryType) {
            DuoCategoryType duoCategoryType = (DuoCategoryType)categoryType;
            DuoCategory duoCategory = new DuoCategory();
            category = duoCategory;
            duoCategory.setType(Category.Type.DUO);
            duoCategory.setGender(this.toGender(duoCategoryType.getGender()));
            if (duoCategoryType.getAgeCategoryOptionId() != null) {
                duoCategory.setAgeCategoryOption(this.getAgeCategories().get(duoCategoryType.getAgeCategoryOptionId()));
            }
        } else if (categoryType instanceof Duo2023CategoryType) {
            Duo2023CategoryType duo2023CategoryType = (Duo2023CategoryType)categoryType;
            Duo2023Category duo2023Category = new Duo2023Category();
            category = duo2023Category;
            duo2023Category.setType(Category.Type.DUO_2023);
            duo2023Category.setGender(this.toGender(duo2023CategoryType.getGender()));
            duo2023Category.setDouble3rdPlace(Boolean.valueOf(duo2023CategoryType.isDouble3RdPlace()));
            duo2023Category.setAdvancedLevel((Boolean)ObjectUtil.ifNull((Object)duo2023CategoryType.isAdvancedLevel(), (Object)Boolean.TRUE));
            duo2023Category.setNoviceLevel((Boolean)ObjectUtil.ifNull((Object)duo2023CategoryType.isNoviceLevel(), (Object)Boolean.TRUE));
            if (duo2023CategoryType.getAgeCategoryOptionId() != null) {
                duo2023Category.setAgeCategoryOption(this.getAgeCategories().get(duo2023CategoryType.getAgeCategoryOptionId()));
            }
        } else {
            category = new Category();
            category.setType(Category.Type.CUSTOM);
        }
        if (categoryType instanceof TreeCategoryType) {
            TreeCategory treeCategory = (TreeCategory)category;
            TreeCategoryType treeCategoryType = (TreeCategoryType)categoryType;
            treeCategory.setTreeType(this.toTreeType(treeCategoryType.getTreeType()));
            treeCategory.setRepassageType(this.toRepassageType(treeCategoryType.getRepassageType()));
            treeCategory.setDouble3rdPlace(Boolean.valueOf(treeCategoryType.isDouble3RdPlace()));
            treeCategory.setRepassageFromRound(Integer.valueOf(treeCategoryType.getRepassageFromRound()));
            treeCategory.setTreeAdvancment(this.getTreeAdvancments().get(treeCategoryType.getTreeAdvancmentId()));
        }
        category.setName(categoryType.getName());
        category.setShortName(categoryType.getShortName());
        category.setStatus(Category.Status.ACTIVE);
        category.setAutomationOrder(categoryType.getAutomationOrder());
        category.setCountForClubPlacings((Boolean)ObjectUtil.ifNull((Object)categoryType.isCountForClubPlacings(), (Object)Boolean.TRUE));
        return category;
    }

    private TreeCategory.TreeType toTreeType(TreeTypeEnum treeTypeEnum) {
        switch (treeTypeEnum) {
            case TABLE_2: {
                return TreeCategory.TreeType.TABLE2;
            }
            case TABLE_3: {
                return TreeCategory.TreeType.TABLE3;
            }
            case TABLE_4: {
                return TreeCategory.TreeType.TABLE4;
            }
            case TABLE_5: {
                return TreeCategory.TreeType.TABLE5;
            }
            case TREE_4: {
                return TreeCategory.TreeType.TREE4;
            }
            case TREE_8: {
                return TreeCategory.TreeType.TREE8;
            }
            case TREE_16: {
                return TreeCategory.TreeType.TREE16;
            }
            case TREE_32: {
                return TreeCategory.TreeType.TREE32;
            }
            case TREE_64: {
                return TreeCategory.TreeType.TREE64;
            }
            case BEST_OF_3: {
                return TreeCategory.TreeType.BEST_OF_3;
            }
        }
        return null;
    }

    private TreeCategory.RepassageType toRepassageType(RepassageTypeEnum repassageTypeEnum) {
        switch (repassageTypeEnum) {
            case NONE: {
                return TreeCategory.RepassageType.NONE;
            }
            case SINGLE: {
                return TreeCategory.RepassageType.SINGLE;
            }
            case DOUBLE: {
                return TreeCategory.RepassageType.DOUBLE;
            }
        }
        return null;
    }

    private MatchPoint toMatchPoint(MatchPointType matchPointType) {
        MatchPoint matchPoint = new MatchPoint();
        matchPoint.setPointType(this.toPointType(matchPointType.getPointType()));
        matchPoint.setPoints(Float.valueOf(matchPointType.getPoints()));
        matchPoint.setRound(matchPointType.getRound());
        matchPoint.setJudge(matchPointType.getJudge());
        matchPoint.setSeries(this.toSeries(matchPointType.getSeries()));
        matchPoint.setAttack(matchPointType.getAttack());
        matchPoint.setPart(matchPointType.getPart());
        return matchPoint;
    }

    private PointType toPointType(PointTypeEnum pointTypeEnum) {
        switch (pointTypeEnum) {
            case WAZARI: {
                return PointType.WAZARI;
            }
            case IPPON_1: {
                return PointType.IPPON1;
            }
            case IPPON_2: {
                return PointType.IPPON2;
            }
            case IPPON_3: {
                return PointType.IPPON3;
            }
            case IPPON_1_3_P: {
                return PointType.IPPON1_3P;
            }
            case IPPON_2_3_P: {
                return PointType.IPPON2_3P;
            }
            case IPPON_3_3_P: {
                return PointType.IPPON3_3P;
            }
            case IPPON_3_POINTS: {
                return PointType.IPPON3POINTS;
            }
            case SHIDO: {
                return PointType.SHIDO;
            }
            case CHUI: {
                return PointType.CHUI;
            }
            case HANSOKUMAKE: {
                return PointType.HANSOKUMAKE;
            }
            case JUDGE: {
                return PointType.JUDGE;
            }
            case POINT_1: {
                return PointType.POINT1;
            }
            case POINT_2: {
                return PointType.POINT2;
            }
            case POINT_3: {
                return PointType.POINT3;
            }
            case POINT_4: {
                return PointType.POINT4;
            }
            case POINT_5: {
                return PointType.POINT5;
            }
            case POINT_6: {
                return PointType.POINT6;
            }
            case POINT_7: {
                return PointType.POINT7;
            }
            case POINT_100: {
                return PointType.POINT100;
            }
            case ADVANTAGE: {
                return PointType.ADVANTAGE;
            }
            case FINISHINGMOVE: {
                return PointType.FINISHINGMOVE;
            }
            case PENALTY: {
                return PointType.PENALTY;
            }
            case VARIETY_SCORE_POINTS: {
                return PointType.VARIETY_SCORE_POINTS;
            }
        }
        return null;
    }

    private PointDetail toPointDetail(MatchPointDetailType matchPointDetailType) {
        PointDetail pointDetail = new PointDetail();
        pointDetail.setFightTime(Integer.valueOf(matchPointDetailType.getFightTime()));
        pointDetail.setPointType(this.toPointType(matchPointDetailType.getPointType()));
        pointDetail.setChangeType(this.toChangeType(matchPointDetailType.getChangeType()));
        return pointDetail;
    }

    private PointDetail.ChangeType toChangeType(PointDetailChangeTypeEnum pointDetailChangeTypeEnum) {
        switch (pointDetailChangeTypeEnum) {
            case ADD: {
                return PointDetail.ChangeType.ADD;
            }
            case REMOVE: {
                return PointDetail.ChangeType.REMOVE;
            }
        }
        return null;
    }

    private Match.Type toMatchType(MatchTypeEnum matchTypeEnum) {
        switch (matchTypeEnum) {
            case FIGHT: {
                return Match.Type.FIGHT;
            }
            case DUO: {
                return Match.Type.DUO;
            }
            case DUO_2023: {
                return Match.Type.DUO2023;
            }
            case NEWAZA: {
                return Match.Type.NEWAZA;
            }
        }
        return null;
    }

    private DuoPresentationPoint toDuoPresentationPoint(DuoPresentationPointType duoPresentationPointType) {
        DuoPresentationPoint duoPresentationPoint = new DuoPresentationPoint();
        duoPresentationPoint.setType(this.toDuoPresentationPointType(duoPresentationPointType.getType()));
        duoPresentationPoint.setPoints(Float.valueOf(duoPresentationPointType.getPoints()));
        duoPresentationPoint.setJudge(duoPresentationPointType.getJudge());
        duoPresentationPoint.setSeries(this.toSeries(duoPresentationPointType.getSeries()));
        duoPresentationPoint.setAttack(duoPresentationPointType.getAttack());
        duoPresentationPoint.setPart(duoPresentationPointType.getPart());
        return duoPresentationPoint;
    }

    private DuoPresentationPoint.Type toDuoPresentationPointType(DuoPresentationPointTypeEnum duoPresentationPointTypeEnum) {
        switch (duoPresentationPointTypeEnum) {
            case POINTS: {
                return DuoPresentationPoint.Type.POINTS;
            }
            case VARIETY_SCORE_POINTS: {
                return DuoPresentationPoint.Type.VARIETY_SCORE_POINTS;
            }
            case PENALTY: {
                return DuoPresentationPoint.Type.PENALTY;
            }
        }
        return null;
    }

    private Tatami toTatami(TatamiType tatamiType) {
        Tatami tatami = new Tatami();
        tatami.setName(tatamiType.getName());
        tatami.setPassword(tatamiType.getPassword());
        tatami.setDisplayText(tatamiType.getDisplayText());
        return tatami;
    }

    private TatamiHistory toTatamiHistory(TatamiHistoryType tatamiHistoryType) {
        TatamiHistory tatamiHistory = new TatamiHistory();
        tatamiHistory.setEventType(TatamiHistory.EventType.valueOf((String)tatamiHistoryType.getEventType().name()));
        tatamiHistory.setEventDate(this.toDate(tatamiHistoryType.getEventDate()));
        if (tatamiHistoryType.getMatch() != null) {
            Match match;
            MatchIdType matchIdType = tatamiHistoryType.getMatch();
            Category category = this.getCategories().get(matchIdType.getCategoryId());
            if (category != null && (match = this.getMatchManager().getMatchForCategory(category, matchIdType.getMatchNum())) != null) {
                tatamiHistory.setMatch(match);
            }
        } else if (tatamiHistoryType.getDuoPresentation() != null) {
            DuoPresentationIdType duoPresentationIdType = tatamiHistoryType.getDuoPresentation();
            Category category = this.getCategories().get(duoPresentationIdType.getCategoryId());
            Competitor competitor = this.getCompetitors().get(duoPresentationIdType.getCompetitorId());
            if (category != null && competitor != null) {
                Round round = this.toRound(duoPresentationIdType.getRound());
                DuoPresentation duoPresentation = this.getDuoPresentationManager().getDuoPresentationsForCategory(category, round, competitor);
                if (duoPresentation != null) {
                    tatamiHistory.setDuoPresentation(duoPresentation);
                }
            }
        }
        return tatamiHistory;
    }

    private Semaphore toSemaphore(SemaphoreType semaphoreType) {
        Semaphore semaphore = new Semaphore();
        semaphore.setName(semaphoreType.getName());
        semaphore.setPassword(semaphoreType.getPassword());
        semaphore.setDisplayRows(Integer.valueOf(semaphoreType.getDisplayRows()));
        return semaphore;
    }

    private NextMatchUpload toNextMatchUploadType(NextMatchUploadType nextMatchUploadType) {
        NextMatchUpload nextMatchUpload = new NextMatchUpload();
        nextMatchUpload.setStatus(NextMatchUpload.Status.valueOf((String)nextMatchUploadType.getStatus().name()));
        nextMatchUpload.setServerType(NextMatchUpload.ServerType.valueOf((String)nextMatchUploadType.getServerType().name()));
        nextMatchUpload.setUploadDelay(Long.valueOf(nextMatchUploadType.getUploadDelay()));
        nextMatchUpload.setHostname(nextMatchUploadType.getHostname());
        nextMatchUpload.setPort(Integer.valueOf(nextMatchUploadType.getPort()));
        nextMatchUpload.setUsername(nextMatchUploadType.getUsername());
        nextMatchUpload.setPassword(nextMatchUploadType.getPassword());
        nextMatchUpload.setFileDirectory(nextMatchUploadType.getFileDirectory());
        nextMatchUpload.setFileName(nextMatchUploadType.getFileName());
        nextMatchUpload.setPageTemplate(nextMatchUploadType.getPageTemplate());
        nextMatchUpload.setPageLocale(nextMatchUploadType.getPageLocale());
        return nextMatchUpload;
    }

    private CategoryGroup toCategoryGroup(CategoryGroupType categoryGroupType) {
        CategoryGroup categoryGroup = new CategoryGroup();
        categoryGroup.setName(categoryGroupType.getName());
        return categoryGroup;
    }

    private Judge toJudge(JudgeType judgeType) {
        Judge judge = new Judge();
        judge.setName(judgeType.getName());
        judge.setPassword(judgeType.getPassword());
        judge.setNormalReferee(Boolean.valueOf(judgeType.isNormalReferee()));
        judge.setVideoReferee(Boolean.valueOf(judgeType.isVideoReferee()));
        return judge;
    }

    private DuoPresentationGrading toDuoPresentationGrading(DuoPresentationGradingType duoPresentationGradingType) {
        DuoPresentationGrading duoPresentationGrading = new DuoPresentationGrading();
        duoPresentationGrading.setJudge(this.getJudges().get(duoPresentationGradingType.getJudgeId()));
        duoPresentationGrading.setJudgeNum(Integer.valueOf(duoPresentationGradingType.getJudgeNum()));
        duoPresentationGrading.setSentAt(this.toCalendar(duoPresentationGradingType.getSentAt()));
        duoPresentationGrading.setFinalResult((Boolean)ObjectUtil.ifNull((Object)duoPresentationGradingType.isFinalResult(), (Object)Boolean.FALSE));
        return duoPresentationGrading;
    }

    private DuoPresentationValidAttack toDuoPresentationValidAttack(DuoPresentationValidAttackType duoPresentationValidAttackType) {
        DuoPresentationValidAttack duoPresentationValidAttack = new DuoPresentationValidAttack();
        duoPresentationValidAttack.setSeries(this.toSeries(duoPresentationValidAttackType.getSeries()));
        duoPresentationValidAttack.setAttack(Integer.valueOf(duoPresentationValidAttackType.getAttack()));
        duoPresentationValidAttack.setAttackValid(Boolean.valueOf(duoPresentationValidAttackType.isAttackValid()));
        duoPresentationValidAttack.setSentAt(this.toCalendar(duoPresentationValidAttackType.getSentAt()));
        return duoPresentationValidAttack;
    }

    private MatchGrading toMatchGrading(MatchGradingType matchGradingType) {
        MatchGrading matchGrading = new MatchGrading();
        matchGrading.setJudge(this.getJudges().get(matchGradingType.getJudgeId()));
        matchGrading.setJudgeNum(Integer.valueOf(matchGradingType.getJudgeNum()));
        matchGrading.setSentAt(this.toCalendar(matchGradingType.getSentAt()));
        matchGrading.setFinalResult((Boolean)ObjectUtil.ifNull((Object)matchGradingType.isFinalResult(), (Object)Boolean.FALSE));
        return matchGrading;
    }

    private MatchValidAttack toMatchValidAttack(MatchValidAttackType matchValidAttackType) {
        MatchValidAttack matchValidAttack = new MatchValidAttack();
        matchValidAttack.setCompetitor(Integer.valueOf(matchValidAttackType.getCompetitor()));
        matchValidAttack.setSeries(this.toSeries(matchValidAttackType.getSeries()));
        matchValidAttack.setAttack(Integer.valueOf(matchValidAttackType.getAttack()));
        matchValidAttack.setAttackValid(Boolean.valueOf(matchValidAttackType.isAttackValid()));
        matchValidAttack.setSentAt(this.toCalendar(matchValidAttackType.getSentAt()));
        return matchValidAttack;
    }

    private Series toSeries(SeriesEnum series) {
        if (series == null) {
            return null;
        }
        switch (series) {
            case A: {
                return Series.A;
            }
            case B: {
                return Series.B;
            }
            case C: {
                return Series.C;
            }
        }
        return null;
    }

    private Rank toRank(RankEnum rank) {
        if (rank == null) {
            return null;
        }
        switch (rank) {
            case WORLD_LEVEL: {
                return Rank.WORLD_LEVEL;
            }
            case ADVANCED: {
                return Rank.ADVANCED;
            }
            case NOVICE: {
                return Rank.NOVICE;
            }
        }
        return null;
    }

    private Round toRound(RoundEnum round) {
        if (round == null) {
            return null;
        }
        switch (round) {
            case ROUND_1: {
                return Round.ROUND_1;
            }
            case ROUND_2: {
                return Round.ROUND_2;
            }
            case ROUND_3: {
                return Round.ROUND_3;
            }
            case ROUND_4: {
                return Round.ROUND_4;
            }
            case ROUND_5: {
                return Round.ROUND_5;
            }
        }
        return null;
    }

    private Date toDate(XMLGregorianCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.toGregorianCalendar().getTime();
    }

    private Calendar toCalendar(XMLGregorianCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.toGregorianCalendar();
    }

    private Competition.Status toCompetitionStatus(CompetitionStatusEnum status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case ACTIVE: {
                return Competition.Status.ACTIVE;
            }
            case FINISHED: {
                return Competition.Status.FINISHED;
            }
        }
        return null;
    }
}

