/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.security;

import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.system.CompetitionRole;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.common.system.Role;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.web.ManagersList;
import si.nevensrok.jtekma.server.web.common.UserData;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;

public class RequestRightChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestRightChecker.class);
    private ManagersList managersList;
    private UserData userData;

    public void setManagersList(ManagersList managersList) {
        this.managersList = managersList;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public void checkPermissions(JoinPoint joinPoint, MethodRight methodRight) throws Throwable {
        Right[] rights = methodRight.value();
        User user = this.userData.getLoginedUser();
        Competition competition = this.userData.getCompetition();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Checking rights {} for user {} and competition {}", new Object[]{rights, user, competition});
        }
        if (user == null) {
            throw new ForbiddenException("User is null");
        }
        if (competition == null) {
            throw new ForbiddenException("Competition is null");
        }
        if (user.getIsSuperAdmin() != null && user.getIsSuperAdmin().booleanValue()) {
            return;
        }
        CompetitionRole competitionRole = this.managersList.getUserManager().getRoleForUser(user, competition);
        if (competitionRole == null) {
            throw new ForbiddenException("CompetitionRole is null");
        }
        Role role = competitionRole.getRole();
        for (Right right : rights) {
            if (!this.managersList.getRightManager().hasRights(role, right)) continue;
            return;
        }
        throw new ForbiddenException("Access forbidden");
    }
}

