/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.reports;

import java.io.IOException;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.reports.DocumentType;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.reports.PlacingsReportModel;

@Controller
@RequestMapping(value={"/reports/placings"})
public class PlacingsReportController
extends CoreController {
    @RequestMapping(method={RequestMethod.GET})
    public String index(HttpServletRequest request, Model model, @ModelAttribute(value="placingsReport") PlacingsReportModel placingsReportModel) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        model.addAttribute("placingsActive", (Object)true);
        LinkedHashMap<String, String> documentTypes = new LinkedHashMap<String, String>();
        documentTypes.put(DocumentType.PDF.name(), this.getLanguageText(locale, "report.documentType.PDF"));
        documentTypes.put(DocumentType.ODT.name(), this.getLanguageText(locale, "report.documentType.ODT"));
        documentTypes.put(DocumentType.XLSX.name(), this.getLanguageText(locale, "report.documentType.XLSX"));
        documentTypes.put(DocumentType.ODS.name(), this.getLanguageText(locale, "report.documentType.ODS"));
        documentTypes.put(DocumentType.CSV.name(), this.getLanguageText(locale, "report.documentType.CSV"));
        model.addAttribute("documentTypes", documentTypes);
        LinkedHashMap<String, String> locales = new LinkedHashMap<String, String>();
        locales.put("en", this.getLanguageText(locale, "locale.english"));
        locales.put("sl", this.getLanguageText(locale, "locale.slovenian"));
        model.addAttribute("locales", locales);
        placingsReportModel.setLocale(RequestContextUtils.getLocale((HttpServletRequest)request).getLanguage());
        Category categoryExample = new Category();
        categoryExample.setStatus(Category.Status.ACTIVE);
        SimpleDataFilter categoryDataFilter = new SimpleDataFilter();
        categoryDataFilter.setFilter((Filter)new ExampleFilter((Object)categoryExample));
        categoryDataFilter.setSort(new Sort());
        categoryDataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        PageDataResult categoryDataResult = this.getManagersList().getCategoryManager().find(this.getUserData().getCompetition(), (DataFilter)categoryDataFilter);
        LinkedHashMap<Long, String> categories = new LinkedHashMap<Long, String>();
        for (Category category : categoryDataResult.getData()) {
            if (category instanceof TreeCategory) {
                categories.put(category.getCategoryId(), category.getName());
                placingsReportModel.getCategories().add(category.getCategoryId());
                continue;
            }
            if (!(category instanceof Duo2023Category)) continue;
            categories.put(category.getCategoryId(), category.getName());
            placingsReportModel.getCategories().add(category.getCategoryId());
        }
        model.addAttribute("categories", categories);
        SimpleDataFilter categoryGroupDataFilter = new SimpleDataFilter();
        categoryGroupDataFilter.setSort(new Sort());
        categoryGroupDataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        PageDataResult categoryGroupDataResult = this.getManagersList().getCategoryGroupManager().findCategoryGroups(this.getUserData().getCompetition(), (DataFilter)categoryGroupDataFilter);
        LinkedHashMap<Long, String> categoryGroups = new LinkedHashMap<Long, String>();
        categoryGroups.put(0L, "&nbsp;");
        for (CategoryGroup categoryGroup : categoryGroupDataResult.getData()) {
            categoryGroups.put(categoryGroup.getCategoryGroupId(), categoryGroup.getName());
        }
        model.addAttribute("categoryGroups", categoryGroups);
        Club clubExample = new Club();
        clubExample.setStatus(Club.Status.ACTIVE);
        SimpleDataFilter clubDataFilter = new SimpleDataFilter();
        clubDataFilter.setFilter((Filter)new ExampleFilter((Object)clubExample));
        clubDataFilter.setSort(new Sort());
        clubDataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        clubDataFilter.setItemLimit(Integer.valueOf(1000));
        PageDataResult clubDataResult = this.getManagersList().getClubManager().find(this.getUserData().getCompetition(), (DataFilter)clubDataFilter);
        LinkedHashMap<Long, String> clubs = new LinkedHashMap<Long, String>();
        clubs.put(0L, "&nbsp;");
        for (Club club : clubDataResult.getData()) {
            clubs.put(club.getClubId(), club.getName());
        }
        model.addAttribute("clubs", clubs);
        return "reports/placings";
    }

    @RequestMapping(method={RequestMethod.POST})
    public void download(HttpServletRequest request, HttpServletResponse response, @ModelAttribute(value="placingsReport") PlacingsReportModel placingsReportModel) throws IOException {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        if (placingsReportModel.getLocale() != null) {
            locale = new Locale(placingsReportModel.getLocale());
        }
        Club club = null;
        if (placingsReportModel.getForClub() != null && placingsReportModel.getForClub() > 0L) {
            club = this.getManagersList().getClubManager().getById(placingsReportModel.getForClub());
        }
        String fileName = this.getUserData().getCompetition().getName() + " - " + this.getLanguageText(locale, "report.filename.placings");
        if (club != null) {
            fileName = fileName + " - " + club.getName();
        }
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFD).replaceAll("[^\\p{Alnum}\\x20\\x2B\\x2D\\x2E\\x5F]", "");
        if (placingsReportModel.getDocumentType() == DocumentType.PDF) {
            response.setContentType("application/pdf");
            fileName = fileName + ".pdf";
        } else if (placingsReportModel.getDocumentType() == DocumentType.ODT) {
            response.setContentType("application/vnd.oasis.opendocument.text");
            fileName = fileName + ".odt";
        } else if (placingsReportModel.getDocumentType() == DocumentType.XLSX) {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            fileName = fileName + ".xlsx";
        } else if (placingsReportModel.getDocumentType() == DocumentType.ODS) {
            response.setContentType("application/application/vnd.oasis.opendocument.spreadsheet");
            fileName = fileName + ".ods";
        } else if (placingsReportModel.getDocumentType() == DocumentType.CSV) {
            response.setContentType("text/plain");
            fileName = fileName + ".csv";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        CategoryGroup categoryGroup = null;
        if (placingsReportModel.getForCategoryGroup() != null && placingsReportModel.getForCategoryGroup() > 0L) {
            categoryGroup = new CategoryGroup();
            categoryGroup.setCategoryGroupId(placingsReportModel.getForCategoryGroup());
        }
        LinkedList<Category> categories = new LinkedList<Category>();
        for (Long categoryId : placingsReportModel.getCategories()) {
            Category category = new Category();
            category.setCategoryId(categoryId);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId()) || categoryGroup != null && !this.getManagersList().getCategoryGroupManager().isInCategoryGroup(categoryGroup, category) || club != null && !this.getManagersList().getCategoryManager().hasCompetitorInCategory(category, club)) continue;
            categories.add(category);
        }
        ServletOutputStream outputStream = response.getOutputStream();
        boolean oneCategoryPerPage = placingsReportModel.getOneCategoryPerPage() == null ? false : placingsReportModel.getOneCategoryPerPage();
        this.getManagersList().getReportGenerator().generatePlacingsReport(placingsReportModel.getDocumentType(), locale, (OutputStream)outputStream, categories, oneCategoryPerPage);
        outputStream.close();
    }
}

