/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.form.FormButtonElement;
import org.odftoolkit.odfdom.dom.element.form.FormFormElement;
import org.odftoolkit.odfdom.dom.element.form.FormPropertiesElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.form.Form;
import org.odftoolkit.simple.form.FormControl;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Button
extends FormControl {
    Button(FormButtonElement element) {
        this.mElement = element;
        this.formElement = (FormFormElement)element.getParentNode();
    }

    public static Button getInstanceOf(FormButtonElement element) {
        Button btn = new Button(element);
        try {
            btn.loadDrawControl(((Document)((OdfFileDom)element.getOwnerDocument()).getDocument()).getContentRoot());
        }
        catch (Exception e) {
            Logger.getLogger(Button.class.getName()).log(Level.WARNING, "Cannot load the drawing shape of this button.");
        }
        return btn;
    }

    @Override
    public void setControlImplementation(String controlImpl) {
        ((FormButtonElement)this.mElement).setFormControlImplementationAttribute(controlImpl);
    }

    @Override
    FormPropertiesElement getFormPropertiesElementForWrite() {
        if (this.mFormProperties == null) {
            this.mFormProperties = ((FormButtonElement)this.mElement).newFormPropertiesElement();
        }
        return this.mFormProperties;
    }

    @Override
    public void setId(String id) {
        ((FormButtonElement)this.mElement).setFormIdAttribute(id);
    }

    @Override
    public String getId() {
        return ((FormButtonElement)this.mElement).getFormIdAttribute();
    }

    @Override
    public String getName() {
        return ((FormButtonElement)this.mElement).getFormNameAttribute();
    }

    @Override
    public void setName(String name) {
        ((FormButtonElement)this.mElement).setFormNameAttribute(name);
    }

    public void setLabel(String label) {
        ((FormButtonElement)this.mElement).setFormLabelAttribute(label);
    }

    public String getLabel() {
        return ((FormButtonElement)this.mElement).getFormLabelAttribute();
    }

    public void setValue(String value) {
        ((FormButtonElement)this.mElement).setFormValueAttribute(value);
    }

    public static Iterator<FormControl> getSimpleIterator(Form container) {
        return new SimpleButtonIterator(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleButtonIterator
    implements Iterator<FormControl> {
        private FormFormElement containerElement;
        private Button nextElement = null;
        private Button tempElement = null;

        private SimpleButtonIterator(Form container) {
            this.containerElement = container.getOdfElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public Button next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.nextElement.remove();
        }

        private Button findNext(Button thisButton) {
            FormButtonElement nextForm = null;
            nextForm = thisButton == null ? (FormButtonElement)OdfElement.findFirstChildNode(FormButtonElement.class, (Node)this.containerElement) : (FormButtonElement)OdfElement.findNextChildNode(FormButtonElement.class, (Node)thisButton.getOdfElement());
            if (nextForm != null) {
                return Button.getInstanceOf(nextForm);
            }
            return null;
        }
    }
}

