/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.servlet.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.googleauth.PasscodeGenerator;
import si.nevensrok.common.web.servlet.security.AdditionalSecurityProvider;
import si.nevensrok.common.web.servlet.security.GoogleAuthSecretsRepository;

public class GoogleAuthSecurityProvider
implements AdditionalSecurityProvider,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthSecurityProvider.class);
    private boolean optinalStep = true;
    private int intervalDifference = 2;
    private GoogleAuthSecretsRepository googleAuthSecretsRepository;

    public void setOptinalStep(boolean optinalStep) {
        this.optinalStep = optinalStep;
    }

    public void setIntervalDifference(int intervalDifference) {
        this.intervalDifference = intervalDifference;
    }

    public void setGoogleAuthSecretsRepository(GoogleAuthSecretsRepository googleAuthSecretsRepository) {
        this.googleAuthSecretsRepository = googleAuthSecretsRepository;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.googleAuthSecretsRepository == null) {
            throw new IllegalArgumentException("Property 'googleAuthSecretsRepository' is required");
        }
    }

    @Override
    public void sendSecurityCodeToUser(Object principal) {
    }

    @Override
    public void invalidSecurityCodeEntered(Object principal) {
    }

    @Override
    public boolean isSecurityCheckNeeded(Object principal) {
        if (!this.optinalStep) {
            return true;
        }
        return this.googleAuthSecretsRepository.fetchSecret(principal) != null;
    }

    @Override
    public boolean checkSecurityCode(Object principal, String securityCode) {
        try {
            String secret = this.googleAuthSecretsRepository.fetchSecret(principal);
            PasscodeGenerator passcodeGenerator = new PasscodeGenerator(secret);
            return passcodeGenerator.verifyTimeoutCode(securityCode, this.intervalDifference, this.intervalDifference);
        }
        catch (Exception e) {
            LOGGER.error("Error checking google auth security code", (Throwable)e);
            return false;
        }
    }
}

