/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario;

import com.sun.javafx.tk.Toolkit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.util.Callback;

public class Settings {
    private final Map<String, String> settings = new HashMap<String, String>(5);
    private final CopyOnWriteArrayList<Callback<String, Void>> listeners = new CopyOnWriteArrayList();
    private static final Object SETTINGS_KEY = new StringBuilder("SettingsKey");

    private static synchronized Settings getInstance() {
        Map<Object, Object> contextMap = Toolkit.getToolkit().getContextMap();
        Settings instance = (Settings)contextMap.get(SETTINGS_KEY);
        if (instance == null) {
            instance = new Settings();
            contextMap.put(SETTINGS_KEY, instance);
        }
        return instance;
    }

    public static void set(String key, String value) {
        Settings.getInstance().setImpl(key, value);
    }

    private void setImpl(String key, String value) {
        this.checkKeyArg(key);
        this.settings.put(key, value);
        for (Callback<String, Void> l : this.listeners) {
            l.call(key);
        }
    }

    public static String get(String key) {
        return Settings.getInstance().getImpl(key);
    }

    private String getImpl(String key) {
        this.checkKeyArg(key);
        String retVal = this.settings.get(key);
        if (retVal == null) {
            try {
                retVal = System.getProperty(key);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return retVal;
    }

    public static boolean getBoolean(String key) {
        return Settings.getInstance().getBooleanImpl(key);
    }

    private boolean getBooleanImpl(String key) {
        String value = this.getImpl(key);
        return "true".equals(value);
    }

    public static boolean getBoolean(String key, boolean defaultVal) {
        return Settings.getInstance().getBooleanImpl(key, defaultVal);
    }

    private boolean getBooleanImpl(String key, boolean defaultVal) {
        String value = this.getImpl(key);
        boolean retVal = defaultVal;
        if (value != null) {
            if ("false".equals(value)) {
                retVal = false;
            } else if ("true".equals(value)) {
                retVal = true;
            }
        }
        return retVal;
    }

    public static int getInt(String key, int defaultVal) {
        return Settings.getInstance().getIntImpl(key, defaultVal);
    }

    private int getIntImpl(String key, int defaultVal) {
        String value = this.getImpl(key);
        int retVal = defaultVal;
        try {
            retVal = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return retVal;
    }

    public static void addPropertyChangeListener(Callback<String, Void> pcl) {
        Settings.getInstance().addPropertyChangeListenerImpl(pcl);
    }

    private void addPropertyChangeListenerImpl(Callback<String, Void> pcl) {
        this.listeners.add(pcl);
    }

    public static void removePropertyChangeListener(Callback<String, Void> pcl) {
        Settings.getInstance().removePropertyChangeListenerImpl(pcl);
    }

    private void removePropertyChangeListenerImpl(Callback<String, Void> pcl) {
        this.listeners.remove(pcl);
    }

    private void checkKeyArg(String key) {
        if (null == key || "".equals(key)) {
            throw new IllegalArgumentException("null key not allowed");
        }
    }

    private Settings() {
    }
}

