/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ssl.CertificateAndKeyRepository;
import si.nevensrok.common.ssl.CertificateChainVerifier;
import si.nevensrok.common.ssl.RevokedCertificateChecker;
import si.nevensrok.common.utils.RegexUtil;
import si.nevensrok.common.x509cert.CertificateUtil;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class CustomKeyManager
extends X509ExtendedKeyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomKeyManager.class);
    private static final String KEY_TYPE_EC = "EC";
    private static final String KEY_TYPE_RSA = "RSA";
    private static final String KEY_TYPE_DSA = "DSA";
    private boolean checkDate = true;
    private boolean checkWithDateGracePeriod = true;
    private RevokedCertificateChecker revokedCertificateChecker;
    private CertificateAndKeyRepository certificateRepository;

    public CustomKeyManager() {
    }

    public CustomKeyManager(CertificateAndKeyRepository certificateRepository) {
        this.certificateRepository = certificateRepository;
    }

    public void setCheckDate(boolean checkDate) {
        this.checkDate = checkDate;
    }

    public void setCheckWithDateGracePeriod(boolean checkWithDateGracePeriod) {
        this.checkWithDateGracePeriod = checkWithDateGracePeriod;
    }

    public void setRevokedCertificateChecker(RevokedCertificateChecker revokedCertificateChecker) {
        this.revokedCertificateChecker = revokedCertificateChecker;
    }

    public void setCertificateRepository(CertificateAndKeyRepository certificateRepository) {
        this.certificateRepository = certificateRepository;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyType, issuers);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(keyType, issuers);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(keyType, issuers);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(keyType, issuers);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(keyType, issuers);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            LOGGER.trace("Searching for chain for [{}]", (Object)alias);
            List<X509Certificate> chain = this.loadCertificateChain(alias);
            LOGGER.trace("Chain size: {}", (Object)chain.size());
            return chain.toArray(new X509Certificate[chain.size()]);
        }
        catch (Exception e) {
            LOGGER.error("Error loading certificate chain", (Throwable)e);
            return null;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        LOGGER.trace("Searching for private key for [{}]", (Object)alias);
        if (!this.certificateRepository.isPrivateKeyPresent(alias)) {
            return null;
        }
        return this.certificateRepository.getPrivateKey(alias);
    }

    protected String[] getAliases(String keyType, Principal[] issuers) {
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Searching for aliasses with key type [{}] and issuers [{}]", new Object[]{keyType, issuers});
            }
            LinkedList<String> aliases = new LinkedList<String>();
            block2: for (String alias : this.certificateRepository.getAliasesWithPrivateKey()) {
                X509Certificate certificate;
                PrivateKey privateKey = this.certificateRepository.getPrivateKey(alias);
                if (privateKey instanceof RSAPrivateKey) {
                    if (!KEY_TYPE_RSA.equals(keyType)) {
                        continue;
                    }
                } else if (!(privateKey instanceof DSAPrivateKey) ? !(privateKey instanceof ECPrivateKey) || !KEY_TYPE_EC.equals(keyType) : !KEY_TYPE_DSA.equals(keyType)) continue;
                if (!this.isCertificateValid(certificate = (X509Certificate)this.certificateRepository.getCertificate(alias))) continue;
                if (issuers == null || issuers.length == 0) {
                    aliases.add(alias);
                    continue;
                }
                List<X509Certificate> chain = this.loadCertificateChain(alias);
                for (Principal principal : issuers) {
                    if (!this.isUsedBy(chain.get(chain.size() - 1), principal) || !this.isChainValid(chain)) continue;
                    aliases.add(alias);
                    continue block2;
                }
            }
            return aliases.toArray(new String[aliases.size()]);
        }
        catch (Exception e) {
            LOGGER.error("Error getting aliases", (Throwable)e);
            return null;
        }
    }

    protected String chooseAlias(String[] keyTypes, Principal[] issuers) {
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Searching for aliasses with key types [{}] and issuers [{}]", new Object[]{keyTypes, issuers});
            }
            for (String alias : this.certificateRepository.getAliasesWithPrivateKey()) {
                X509Certificate certificate;
                PrivateKey privateKey = this.certificateRepository.getPrivateKey(alias);
                if (privateKey instanceof RSAPrivateKey) {
                    if (!this.isKeyType(KEY_TYPE_RSA, keyTypes)) {
                        continue;
                    }
                } else if (!(privateKey instanceof DSAPrivateKey) ? !(privateKey instanceof ECPrivateKey) || !this.isKeyType(KEY_TYPE_EC, keyTypes) : !this.isKeyType(KEY_TYPE_DSA, keyTypes)) continue;
                if (!this.isCertificateValid(certificate = (X509Certificate)this.certificateRepository.getCertificate(alias))) continue;
                if (issuers == null || issuers.length == 0) {
                    return alias;
                }
                List<X509Certificate> chain = this.loadCertificateChain(alias);
                for (Principal principal : issuers) {
                    if (!this.isUsedBy(chain.get(chain.size() - 1), principal) || !this.isChainValid(chain)) continue;
                    return alias;
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error getting aliases", (Throwable)e);
            return null;
        }
    }

    protected String chooseAlias(String keyType, Principal[] issuers) {
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Choosing alias with key type [{}] and issuers [{}]", new Object[]{keyType, issuers});
            }
            for (String alias : this.certificateRepository.getAliasesWithPrivateKey()) {
                X509Certificate certificate;
                PrivateKey privateKey = this.certificateRepository.getPrivateKey(alias);
                if (privateKey instanceof RSAPrivateKey) {
                    if (!KEY_TYPE_RSA.equals(keyType)) {
                        continue;
                    }
                } else if (!(privateKey instanceof DSAPrivateKey) ? !(privateKey instanceof ECPrivateKey) || !KEY_TYPE_EC.equals(keyType) : !KEY_TYPE_DSA.equals(keyType)) continue;
                if (!this.isCertificateValid(certificate = (X509Certificate)this.certificateRepository.getCertificate(alias))) continue;
                if (issuers == null || issuers.length == 0) {
                    return alias;
                }
                List<X509Certificate> chain = this.loadCertificateChain(alias);
                for (Principal principal : issuers) {
                    if (!this.isUsedBy(chain.get(chain.size() - 1), principal) || !this.isChainValid(chain)) continue;
                    return alias;
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error getting aliases", (Throwable)e);
            return null;
        }
    }

    protected List<X509Certificate> loadCertificateChain(String alias) throws Exception {
        Certificate[] certChain;
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        for (Certificate certificate : certChain = this.certificateRepository.getCertificateChain(alias)) {
            chain.add((X509Certificate)certificate);
        }
        if (chain.size() == 1) {
            X509Certificate cert = (X509Certificate)chain.get(0);
            while (cert != null) {
                if ((cert = this.getIssuer((X509CertImpl)cert)) == null) continue;
                chain.add(cert);
            }
        }
        return chain;
    }

    protected boolean isUsedBy(X509Certificate certificate, Principal principal) {
        try {
            X500Name issuerName;
            X509CertImpl certImpl = (X509CertImpl)certificate;
            X509CertInfo certInfo = (X509CertInfo)certImpl.get("x509.info");
            if (certInfo.get("issuer") instanceof X500Name) {
                issuerName = (X500Name)certInfo.get("issuer");
            } else {
                CertificateIssuerName issuer = (CertificateIssuerName)certInfo.get("issuer");
                issuerName = (X500Name)issuer.get("dname");
            }
            String isserNameString = this.normalizeNameString(issuerName.getName());
            String principalNameString = this.normalizeNameString(issuerName.getName());
            return isserNameString.equals(principalNameString);
        }
        catch (Exception e) {
            LOGGER.trace("Error checking issuer name", (Throwable)e);
            return false;
        }
    }

    protected String normalizeNameString(String nameString) {
        return nameString.replaceAll(RegexUtil.escapePattern((String)", "), ",");
    }

    protected boolean isChainValid(List<X509Certificate> chain) {
        try {
            new CertificateChainVerifier().withCheckDate(this.checkDate).withCalendars(this.generateCalendarsToCheck()).withCertificateChain(chain).withRevokedCertificateChecker(this.revokedCertificateChecker).withNoCaCheck(true).check();
            return true;
        }
        catch (CertificateException e) {
            return false;
        }
    }

    protected X509Certificate getIssuer(X509CertImpl certificate) throws Exception {
        for (String alias : this.certificateRepository.getAliases()) {
            X509CertImpl candidate = (X509CertImpl)this.certificateRepository.getCertificate(alias);
            if (!CertificateUtil.isIssuedBy(certificate, candidate, true)) continue;
            try {
                certificate.verify(candidate.getPublicKey());
                return candidate;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    protected boolean isKeyType(String keyType, String[] possibleKeyTypes) {
        for (String kt : possibleKeyTypes) {
            if (!keyType.equalsIgnoreCase(kt)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCertificateValid(X509Certificate certificate) {
        try {
            new CertificateChainVerifier().withCheckDate(this.checkDate).withCalendars(this.generateCalendarsToCheck()).withCertificate(certificate).withRevokedCertificateChecker(this.revokedCertificateChecker).withNoCaCheck(true).check();
            return true;
        }
        catch (CertificateException e) {
            return false;
        }
    }

    protected Calendar[] generateCalendarsToCheck() {
        if (this.checkWithDateGracePeriod) {
            Calendar now = Calendar.getInstance();
            Calendar past = (Calendar)now.clone();
            past.add(13, -60);
            Calendar future = (Calendar)now.clone();
            future.add(13, 60);
            return new Calendar[]{now, past, future};
        }
        return new Calendar[]{Calendar.getInstance()};
    }
}

