/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ldap;

import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import org.apache.commons.codec.digest.UnixCrypt;
import si.nevensrok.common.utils.ByteUtil;
import si.nevensrok.common.utils.HashUtil;

public class LdapUtil {
    public static Object getAttributeValue(SearchResult searchResult, String attributeName) {
        try {
            Attribute attribute = searchResult.getAttributes().get(attributeName);
            if (attribute != null) {
                return attribute.get();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error fetching attribute", e);
        }
    }

    public static List<Object> getAttributeValues(SearchResult searchResult, String attributeName) {
        try {
            Attribute attribute = searchResult.getAttributes().get(attributeName);
            if (attribute != null) {
                LinkedList<Object> values = new LinkedList<Object>();
                NamingEnumeration<?> enumeration = attribute.getAll();
                while (enumeration.hasMore()) {
                    Object value = enumeration.next();
                    values.add(value);
                }
                return values;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error fetching attribute", e);
        }
    }

    public static String getAttributeValueString(SearchResult searchResult, String attributeName) {
        Object attributeValue = LdapUtil.getAttributeValue(searchResult, attributeName);
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof String) {
            return (String)attributeValue;
        }
        throw new RuntimeException("Attribute value type is not String");
    }

    public static byte[] getAttributeValueBytes(SearchResult searchResult, String attributeName) {
        Object attributeValue = LdapUtil.getAttributeValue(searchResult, attributeName);
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof byte[]) {
            return (byte[])attributeValue;
        }
        throw new RuntimeException("Attribute value type is not byte array");
    }

    public static boolean checkPassword(String password, String resultEntry) {
        try {
            if (resultEntry.startsWith("{MD5}")) {
                byte[] passwordHash = ByteUtil.fromBase64String((String)resultEntry.substring(5));
                return HashUtil.checkHash((byte[])password.getBytes("UTF-8"), (HashUtil.HashType)HashUtil.HashType.MD5, (byte[])passwordHash);
            }
            if (resultEntry.startsWith("{SHA1}")) {
                byte[] passwordHash = ByteUtil.fromBase64String((String)resultEntry.substring(6));
                return HashUtil.checkHash((byte[])password.getBytes("UTF-8"), (HashUtil.HashType)HashUtil.HashType.SHA1, (byte[])passwordHash);
            }
            if (resultEntry.startsWith("{SHA256}")) {
                byte[] passwordHash = ByteUtil.fromBase64String((String)resultEntry.substring(8));
                return HashUtil.checkHash((byte[])password.getBytes("UTF-8"), (HashUtil.HashType)HashUtil.HashType.SHA1, (byte[])passwordHash);
            }
            if (resultEntry.startsWith("{SSHA}")) {
                byte[] hashData = ByteUtil.fromBase64String((String)resultEntry.substring(6));
                byte[] hash = new byte[20];
                byte[] salt = new byte[hashData.length - 20];
                System.arraycopy(hashData, 0, hash, 0, 20);
                System.arraycopy(hashData, 20, salt, 0, hashData.length - 20);
                byte[] givenPasswordBytes = password.getBytes("UTF-8");
                byte[] givenPasswordHash = new byte[givenPasswordBytes.length + salt.length];
                System.arraycopy(givenPasswordBytes, 0, givenPasswordHash, 0, givenPasswordBytes.length);
                System.arraycopy(salt, 0, givenPasswordHash, givenPasswordBytes.length, salt.length);
                return HashUtil.checkHash((byte[])givenPasswordHash, (HashUtil.HashType)HashUtil.HashType.SHA1, (byte[])hash);
            }
            if (resultEntry.startsWith("{CRYPT}")) {
                return UnixCrypt.crypt((String)password, (String)resultEntry.substring(7, 9)).equals(resultEntry.substring(7));
            }
            return password.equals(resultEntry);
        }
        catch (Exception e) {
            throw new RuntimeException("Error checking password", e);
        }
    }

    public static String escapeSearchText(String text) {
        if (text == null) {
            return null;
        }
        return text.replace("\\", "\\5C").replace("*", "\\2A").replace("(", "\\28").replace(")", "\\29").replace("\u0000", "\\00");
    }

    public static String extractName(String dn) {
        int equalsIndex = dn.indexOf(61);
        int commaIndex = dn.indexOf(44);
        if (equalsIndex < 0) {
            throw new IllegalArgumentException("Dn '" + dn + "' is in invalid ldap format");
        }
        if (commaIndex < 0 || commaIndex < equalsIndex) {
            throw new IllegalArgumentException("Dn '" + dn + "' is in invalid ldap format");
        }
        return dn.substring(equalsIndex + 1, commaIndex);
    }
}

