/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import si.nevensrok.common.utils.ObjectUtil;

public final class HashUtil {
    private HashUtil() {
    }

    public static byte[] generateHash(byte[] data, HashType hashType) {
        return HashUtil.generateHash(Arrays.asList(new byte[][]{data}), hashType);
    }

    public static byte[] generateHash(Collection<byte[]> data, HashType hashType) {
        try {
            String digestType = null;
            switch (hashType) {
                case MD5: {
                    digestType = "MD5";
                    break;
                }
                case SHA1: {
                    digestType = "SHA-1";
                    break;
                }
                case SHA256: {
                    digestType = "SHA-256";
                }
            }
            MessageDigest messageDigest = MessageDigest.getInstance(digestType);
            for (byte[] b : data) {
                messageDigest.update(b);
            }
            return messageDigest.digest();
        }
        catch (Exception e) {
            throw new RuntimeException("Error calculation hash", e);
        }
    }

    public static boolean checkHash(byte[] data, HashType hashType, byte[] hash) {
        byte[] calculatedHash = HashUtil.generateHash(data, hashType);
        if (hash.length != calculatedHash.length) {
            return false;
        }
        for (int i = 0; i < calculatedHash.length; ++i) {
            if (calculatedHash[i] == hash[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] generateHash(Object obj, HashType hashType) {
        try {
            String digestType = null;
            switch (hashType) {
                case MD5: {
                    digestType = "MD5";
                    break;
                }
                case SHA1: {
                    digestType = "SHA-1";
                    break;
                }
                case SHA256: {
                    digestType = "SHA-256";
                }
            }
            MessageDigest messageDigest = MessageDigest.getInstance(digestType);
            if (obj != null) {
                Class<?> clazz = obj.getClass();
                if (obj instanceof Byte) {
                    messageDigest.update((Byte)obj);
                } else if (obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Boolean || obj instanceof Character || obj instanceof String) {
                    messageDigest.update(obj.toString().getBytes("UTF8"));
                } else if (obj instanceof byte[]) {
                    messageDigest.update((byte[])obj);
                } else if (obj instanceof Object[]) {
                    Object[] array;
                    for (Object val : array = (Object[])obj) {
                        byte[] b = HashUtil.generateHash(val, hashType);
                        messageDigest.update(b);
                    }
                } else if (obj instanceof Collection) {
                    Collection list = (Collection)obj;
                    for (Object val : list) {
                        byte[] b = HashUtil.generateHash(val, hashType);
                        messageDigest.update(b);
                    }
                } else if (!clazz.equals(Object.class)) {
                    for (Field field : clazz.getDeclaredFields()) {
                        Object val = ObjectUtil.getValue(field, obj);
                        byte[] b = HashUtil.generateHash(val, hashType);
                        messageDigest.update(b);
                    }
                }
            }
            byte[] hash = messageDigest.digest();
            return hash;
        }
        catch (Exception e) {
            throw new RuntimeException("Error calculation hash", e);
        }
    }

    public static boolean checkHash(Object obj, HashType hashType, byte[] hash) {
        byte[] calculatedHash = HashUtil.generateHash(obj, hashType);
        if (hash.length != calculatedHash.length) {
            return false;
        }
        for (int i = 0; i < calculatedHash.length; ++i) {
            if (calculatedHash[i] == hash[i]) continue;
            return false;
        }
        return true;
    }

    public static enum HashType {
        MD5,
        SHA1,
        SHA256;

    }
}

