var DialogButton = Backbone.Model.extend({
	defaults: {
		"text": "",
		"click": null,
		"class": "btn btn-primary",
		"close": false
	},
	initialize: function() {
		
	}
});

var DialogButtonList = Backbone.Collection.extend({
	model: DialogButton
});

var DialogData = Backbone.Model.extend({
	defaults: {
		"type": "info",
		"title": "",
		"content": ""
	},
	initialize:function() {
		this.set({ buttons: new DialogButtonList() }, { silent: true });
	}
});

var DialogButtonView = Backbone.View.extend({
	'tagName': "button",
	'initialize': function() {
		
		
	},
	'render': function() {
		var obj = this;
		this.$el.text(this.model.get("text"));
		this.$el.attr("type", "button");
		this.$el.attr("class", this.model.get("class"));
		
		if (this.model.get("close")) {
			this.$el.attr("data-dismiss", "modal");
		}
		
		this.$el.on("click",function() {
			var func = obj.model.get("click");
			if (func != null) {
				func();
			}
		});
		
		return this;
	}
});

var DialogView = Backbone.View.extend({
	'tagName':"div",
	'template': "",
	'initialize': function() {
		this.template = templates.getTemplate("/templates/dialog");
		this.$el.attr("class","modal fade");
	},
	show:function() {
		var obj = this;
		
		$("body").append(this.el);
		
		this.$el.modal({
	    	show: false
	    });
	    
		this.$el.on("hidden.bs.modal",function () {
			obj.$el.remove();
		});
		
		this.render();
		this.$el.modal("show");
	},
	hide: function() {
		
	},
	'render': function() {
		var obj = this;
		var data = {
			title: obj.model.get("title")
		};
		this.$el.html(Mustache.render(this.template,data));
		this.$el.find("div.dialogContent").html(this.model.get("content"));
		
		//add buttons
		for (var i = 0; i < this.model.get("buttons").length; i++) {
			var button = this.model.get("buttons").at(i);
			var dialogButtonView = new DialogButtonView({ model: button });
			this.$el.find(".modal-footer").append(dialogButtonView.render().el);
		}
		
		return this;
	}
});

var dialog = {
	showDialog: function(title,content,buttons,openFunction) {
		var dialogData=new DialogData({
			type:"info",
			title:title,
			content:content
		});
		for (var i=0;i<buttons.length;i++) {
			var button=buttons[i];
			dialogData.get("buttons").add(new DialogButton({
				"text":button.text,
				"class":button.class,
				"close":button.close,
				"click":button.click
			}));
		}
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		if (openFunction) {
			$(dialogView.el).on("show",function () {
				openFunction(dialogView.el);
			});
		}
		
		dialogView.show();
		
		return dialogView.el;
	},
	showInfoMessage: function(message,title) {
		var dialogTitle=getSpringMessage("common.title.info");
		if (title) {
			dialogTitle=title;
		}
		
		var dialogData=new DialogData({
			type:"info",
			title:dialogTitle,
			content:message
		});
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.close"),
			"class":"btn btn-primary",
			"close":true
		}));
		
		dialogView.show();
	},
	showErrorMessage: function(message) {
		var dialogTitle=getSpringMessage("common.title.error");
		if (title) {
			dialogTitle=title;
		}
		
		var dialogData=new DialogData({
			type:"info",
			title:dialogTitle,
			content:message
		});
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.close"),
			"class":"btn btn-primary",
			"close":true
		}));
		
		dialogView.show();
	},
	showPopup: function(item,title,content) {
		$(item).popover({
			trigger:"hover",
			title:title,
			content:content
		});
		$(item).popover('show');
	},
	showConfirmation: function(title,text,confirmationAction) {
		var dialogData=new DialogData({
			type:"info",
			title:title,
			content:text
		});
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.confirm"),
			"class":"btn btn-primary",
			"close":false,
			"click":function() {
				$(dialogView.el).modal("hide");
				confirmationAction();
			}
		}));
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.cancel"),
			"class":"btn btn-danger",
			"close":true
		}));
		
		dialogView.show();
	},
	showConfirmationRedirect: function(title,text,url) {
		dialog.showConfirmation(title,text,function() {
			window.location=url;
		});
	}
};
