(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	models.DuoPresentationPoints = Backbone.Model.extend({
		"url": function() {
		  return contextPath + "/competition/data/duo-presentation-points";
		},
		"defaults": {
			"competitor": "",
			"club": "",
			"points": null,
			"penalty": 0,
			"finished": false
		}
	});

	models.DuoPresentationModel = Backbone.Model.extend({
		"defaults": {
			"id": 0,
			"name": "",
			"shortName": "",
			"competitor": null,
			"points": 0,
			"status": "",
			"categoryName": "",
			"categoryShortName": "",
			"canRemove": false
		},
		"parse": function(response, options) {
			response.isNotNeeded = response.status == "NOTNEEDED";
			response.isWaiting = response.status == "WAITING";
			response.isInQueue = response.status == "INQUEUE";
			response.isInProgress = response.status == "INPROGRESS";
			response.isFinished = response.status == "FINISHED";
			response.canAdd = response.isWaiting;
			return response;
		}
	});

	models.DuoPresentationCollection = Backbone.Collection.extend({
		"url": function() {
		  return contextPath + "/competition/data/duo-presentation";
		},
		"model": models.DuoPresentationModel
	});

	views.DuoPresentationView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/duo-presentation"),
		"className": "match",
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html(Mustache.render(this.template, this.model.toJSON()));

			$("[rel='tooltip']", this.el).tooltip();

			var obj = this;

			$(".editButton", this.el).on("click",function() {
				var editDuoPresentationModel = {
					"duoPresentation": obj.model
				};
                editDuoPresentationModel.points = new models.DuoPresentationPoints();
                editDuoPresentationModel.points.fetch({
                    "data": {
                        "duoPresentationId": obj.model.get("id")
                    },
                    "async": false
                });

				var duoPresentationEditView = new views.DuoPresentationEditView({
					"model": editDuoPresentationModel
				});
				duoPresentationEditView.trigger("show");
			});

			$(".addToTatamiButton", this.el).on("click", function() {
				$.ajax({
					url: contextPath + "/competition/data/add-duo-presentation-to-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("id")),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			return this;
		}
	});

	views.DuoPresentationsView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/duo-presentations"),
		"initialize": function() {
		    this.render();
			this.model.duoPresentations.on("reset", function() {
				this.renderDuoPresentations();
			}, this);
			this.model.matches.on("reset", function() {
                this.renderMatches();
            }, this);
		},
		"render": function() {
			$(this.el).html(this.template);
			$("[rel='tooltip']", this.el).tooltip();
			return this;
		},
		"renderDuoPresentations": function() {
		    $("#duo-presentations-div").html("");
            this.model.duoPresentations.each(function(duoPresentation, index) {
                if (duoPresentation.get("status") == "WAITING"
                        || duoPresentation.get("status") == "INQUEUE"
                        || duoPresentation.get("status") == "INPROGRESS"
                        || duoPresentation.get("status") == "FINISHED") {

                    var duoPresentationView = new views.DuoPresentationView({
                        "model": duoPresentation
                    });
                    $("#duo-presentations-div").append(duoPresentationView.render().el);
                }
			});
		},
		"renderMatches": function() {
		$("#matches-div").html("");
            this.model.matches.each(function(match, index) {
                if (match.get("status") == "WAITING"
                        || match.get("status") == "INQUEUE"
                        || match.get("status") == "INPROGRESS"
                        || match.get("status") == "FINISHED") {

                    var matchView = new views.MatchView({
                        "model": match
                    });
                    $("#matches-div").append(matchView.render().el);
                }
            });
		}
	});

})();