(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");

    /*------------ Constants ------------*/
    var constants = definePackage("jtekma.constants");
    constants.fullIpponPoints = 50;
	constants.newazaFinishingMovePoints = 100;

    /*------------ Messages ------------*/
    var messages = definePackage("jtekma.gui.messages");
	messages.showInfoMessage = (text) => {
		$("#message-area").html(Mustache.render(
		  "<div class=\"alert alert-info\">{{text}}<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&#215;</button></div>",
		  {
		    "text": text
		  }
		));
	}

	messages.showSuccessMessage = (text) => {
		$("#message-area").html(Mustache.render(
		  "<div class=\"alert alert-success\">{{text}}<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&#215;</button></div>",
		  {
		    "text": text
		  }
		));
	}

	messages.showErrorMessage = (text) => {
		$("#message-area").html(Mustache.render(
		  "<div class=\"alert alert-danger\">{{text}}<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&#215;</button></div>",
		  {
		    "text": text
		  }
		));
	}

	/*-------- Display settings------*/
    models.DisplaySettings = Backbone.Model.extend({
        "defaults": {
            "category": null,
            "type": "",
            "tatami": null
        }
    });

    /*----- Competitors ---------*/
    models.CompetitorModel = Backbone.Model.extend({
        "defaults": {
            "id": 0,
            "name": "",
            "shortName": "",
            "clubId": 0,
            "clubName": "",
            "shortClubName": "",
            "type": "",
            "draw": 0,
            "drawGroup": 0
        }
    });

    models.CompetitorCollection = Backbone.Collection.extend({
        "url": function() {
          return contextPath + "/competition/data/competitor";
        },
        "model": models.CompetitorModel
    });

    /*-------- Event -------*/
    models.EventModel = Backbone.Model.extend({
        "url": function() {
          return contextPath + "/competition/data/event";
        },
        "defaults": {
            "id": null,
            "text": "",
            "autoRemove": false
        }
    });

    /*----- Category selector ---------*/
    models.CategoryModel = Backbone.Model.extend({
        "defaults": {
            "id": 0,
            "name": "",
            "type": "",
            "treeType": "",
            "show": true
        }
    });

    models.CategoryCollection = Backbone.Collection.extend({
        "url": function() {
          return contextPath + "/competition/data/category";
        },
        "model": models.CategoryModel
    });

})();(function() {
    var jtekma = definePackage("jtekma");
    var views = definePackage("jtekma.views");

    /*-------- Event -------*/
    views.EventEditView = Backbone.View.extend({
		"tagName": "div",
		"template": templates.getTemplate("/competition/template/edit-event"),
		"initialize": function() {
			$(this.el).attr("class","modal fade");

			var obj = this;

			this.on("show", function() {
				$("body").append(obj.el);

				$(obj.el).modal({
			    	show:false
			    });

				$(obj.el).on("hidden.bs.modal",function () {
					$(obj.el).remove();
				});

				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render": function() {
			var obj = this;

			$(this.el).html(Mustache.render(this.template,this.model.toJSON()));

			$(".btn-primary", this.el).on("click",function() {
				obj.model.set("text", $("textarea[name='event-text']", obj.el).val());
				obj.model.set("autoRemove", $("input[name='autoRemove']", obj.el).is(":checked"));

				var url = obj.model.url() + "?tatamiId=" + jtekma.displaySettings.get("tatami").get("id");
				if (obj.model.get("id") != null) {
					url = obj.model.url() + "?eventId=" + obj.model.get("id");
				}

				$.ajax({
					"async": false,
					"url": url,
					"type": "POST",
					"contentType": "application/json; charset=utf-8",
					"data": JSON.stringify(obj.model.toJSON())
				});
				$(obj.el).modal("hide");

				jtekma.reloadData();
			});

			return this;
		}
	});

    /*----- Category selector ---------*/
    views.CategorySelectView = Backbone.View.extend({
        "optionTemplate": "<option value=\"{{id}}\">{{name}}</option>",
        "initialize": function() {
            this.collection.on("reset", function() {
                this.render();
            }, this);
        },
        "render": function() {
            var obj = this;
            this.collection.each(function(item, index) {
                item.on("change:show", function() {
                    obj.reloadCategories();
                });
            });

            $(this).html("");

            var categories = this.collection;

            $(this.el).change(function() {
                var categoryId = Number($(this).val());

                var category = categories.where({ "id": categoryId });
                if (category.length > 0) {
                    jtekma.displaySettings.set("category", category[0]);
                }
            });

            this.collection.each(function(item, index) {
                if (item.get("show")) {
                    $(this.el).append(Mustache.render(this.optionTemplate, item.toJSON()));
                }
            }, this);

            $(this.el).chosen({
                "search_contains": true,
                "width": "200px"
            });

            var enabledCategories = this.collection.where({ "show": true });

            if (enabledCategories.length > 0) {
                jtekma.displaySettings.set("category", enabledCategories[0]);
            }

            return this;
        },
        "reloadCategories": function() {
            var selectedCategoryId = $(this.el).val();

            $(this.el).html("");

            this.collection.each(function(item, index) {
                if (item.get("show")) {
                    $(this.el).append(Mustache.render(this.optionTemplate, item.toJSON()));
                }
            }, this);
            $("option[value='" + selectedCategoryId + "']", this.el).prop("selected", true);

            $(this.el).trigger("liszt:updated");
            $(this.el).trigger('chosen:updated');

            var enabledCategories = this.collection.where({ "show": true });

            if (enabledCategories.length > 0) {
                if (selectedCategoryId) {
                    var category = this.collection.where({ "id": Number(selectedCategoryId), "show": true });
                    if (category.length > 0) {
                        jtekma.displaySettings.set("category", category[0]);
                    }
                    else {
                        jtekma.displaySettings.set("category", enabledCategories[0]);
                    }
                }
                else {
                    jtekma.displaySettings.set("category", enabledCategories[0]);
                }
            }
        }
    });

    views.CategoryEnableView = Backbone.View.extend({
        "optionTemplate": "<li><input style=\"margin-right:5px;margin-top:-3px;\" type=\"checkbox\"{{#show}} checked=\"true\"{{/show}} categoryId=\"{{id}}\" /><label>{{name}}</label></li>",
        "initialize": function() {
            this.collection.on("reset", function() {
                this.render();
            }, this);
        },
        "render": function() {
            $(this).html("");

            var categories = this.collection;

            this.collection.each(function(item, index) {
                $(this.el).append(Mustache.render(this.optionTemplate, item.toJSON()));
            }, this);

            $("input[type='checkbox']", this.el).change(function() {
                var categoryId = Number($(this).attr("categoryId"));
                var showCategory = $(this).is(":checked");

                var category = categories.where({ "id": categoryId });
                if (category.length > 0) {
                    category[0].set("show", showCategory);
                }

                $.ajax({
                    "url": contextPath + "/competition/data/show-category/" + String(categoryId) + "/" + String(showCategory),
                    "type": "GET"
                });
            });

            $("input[type='checkbox']", this.el).on("click", function(e) {
                e.stopPropagation();
            });

            $("label", this.el).on("click", function(e) {
                $(this).parent().find("input[type='checkbox']").click();
                e.stopPropagation();
            });

            return this;
        }
    });

})();(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

    models.FightPoints = Backbone.Model.extend({
		"url": function() {
		  return contextPath + "/competition/data/fight-points";
		},
		"defaults": {
		    "rules": "",
			"competitor1": "",
			"club1": "",
			"wazari1": 0,
			"ippon1_1": 0,
			"ippon1_2": 0,
			"ippon1_3": 0,
			"ippon1_1_3p": 0,
			"ippon1_2_3p": 0,
			"ippon1_3_3p": 0,
			"shido1": 0,
			"chui1": 0,
			"hansokumake1": 0,
			"competitor2": "",
			"club2": "",
			"wazari2": 0,
			"ippon2_1": 0,
			"ippon2_2": 0,
			"ippon2_3": 0,
			"ippon2_1_3p": 0,
            "ippon2_2_3p": 0,
            "ippon2_3_3p": 0,
			"shido2": 0,
			"chui2": 0,
			"hansokumake2": 0,
			"noWinner": false,
			"finished": false,
			"matchTime": null,
			"hosekomiTime": null,
			"injuryTime1": null,
			"injuryTime2": null,
			"challengesWon1": 0,
			"challengesWon2": 0,
			"challengesLost1": 0,
			"challengesLost2": 0
		}
	});

	models.DuoPoints = Backbone.Model.extend({
		"url": function() {
		  return contextPath + "/competition/data/duo-points";
		},
		"defaults": {
			"competitor1": "",
			"club1": "",
			"rounds1": null,
			"competitor2": "",
			"club2": "",
			"rounds2": null,
			"noWinner": false,
			"finished": false,
			"injuryTime1": null,
			"injuryTime2": null,
			"challengesWon1": 0,
            "challengesWon2": 0,
            "challengesLost1": 0,
            "challengesLost2": 0
		}
	});

	models.NewazaPoints = Backbone.Model.extend({
		"url": function() {
		  return contextPath + "/competition/data/newaza-points";
		},
		"defaults": {
			"competitor1": "",
			"club1": "",
			"point1_2": 0,
			"point1_3": 0,
			"point1_4": 0,
			"point1_100": 0,
			"advantage1": 0,
			"penalty1": 0,
			"hansokumake1": 0,
			"competitor2": "",
			"club2": "",
			"point2_2": 0,
			"point2_3": 0,
			"point2_4": 0,
			"point2_100": 0,
			"advantage2": 0,
			"penalty2": 0,
			"hansokumake2": 0,
			"noWinner": false,
			"finished": false,
			"matchTime": null,
			"hosekomiTime": null,
			"injuryTime1": null,
			"injuryTime2": null,
			"challengesWon1": 0,
            "challengesWon2": 0,
            "challengesLost1": 0,
            "challengesLost2": 0
		}
	});

	models.Duo2023Points = Backbone.Model.extend({
    		"url": function() {
    		  return contextPath + "/competition/data/duo-2023-points";
    		},
    		"defaults": {
    			"competitor1": "",
    			"club1": "",
    			"competitor2": "",
                "club2": "",
                "attacks": null,
    			"points1": null,
    			"points2": null,
    			"penalty1": 0,
    			"penalty2": 0,
    			"noWinner": false,
    			"injuryTime1": null,
                "injuryTime2": null,
                "challengesWon1": 0,
                "challengesWon2": 0,
                "challengesLost1": 0,
                "challengesLost2": 0,
    			"finished": false
    		}
    	});

	models.MatchModel = Backbone.Model.extend({
		"defaults": {
			"id": 0,
			"number": 0,
			"name": "",
			"shortName": "",
			"competitor1": null,
			"competitor2": null,
			"points1": 0,
			"points2": 0,
			"status": "",
			"type": "",
			"categoryName": "",
			"categoryShortName": "",
			"canRemove": false
		},
		"parse": function(response, options) {
			response.isNotNeeded = response.status == "NOTNEEDED";
			response.isWaiting = response.status == "WAITING";
			response.isInQueue = response.status == "INQUEUE";
			response.isInProgress = response.status == "INPROGRESS";
			response.isFinished = response.status == "FINISHED";
			response.canAdd = response.isWaiting;
			return response;
		}
	});

	models.MatchCollection = Backbone.Collection.extend({
		"url": function() {
		  return contextPath + "/competition/data/match";
		},
		"model": models.MatchModel
	});

	views.MatchView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/match"),
		"className": "match",
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html(Mustache.render(this.template, this.model.toJSON()));

			$("[rel='tooltip']", this.el).tooltip();

			var obj = this;

			$(".detailsButton", this.el).on("click",function() {
				var matchDetailsView = new views.MatchDetailsView({
					"model": obj.model
				});
				matchDetailsView.trigger("show");
			});

			$(".editButton", this.el).on("click",function() {
				var editFightModel = {
					"match": obj.model
				};
				if (obj.model.get("type") == "FIGHT") {
					editFightModel.points = new models.FightPoints();
					editFightModel.points.fetch({
						"data": {
							"matchId": obj.model.get("id")
						},
						"async": false
					});
				}
				else if (obj.model.get("type") == "DUO") {
					editFightModel.points = new models.DuoPoints();
					editFightModel.points.fetch({
						"data": {
							"matchId": obj.model.get("id")
						},
						"async": false
					});
				}
				else if (obj.model.get("type") == "NEWAZA") {
					editFightModel.points = new models.NewazaPoints();
					editFightModel.points.fetch({
						"data": {
							"matchId": obj.model.get("id")
						},
						"async": false
					});
				}
				else if (obj.model.get("type") == "DUO2023") {
                    editFightModel.points = new models.Duo2023Points();
                    editFightModel.points.fetch({
                        "data": {
                            "matchId": obj.model.get("id")
                        },
                        "async": false
                    });
                }

				var matchEditView = new views.MatchEditView({
					"model": editFightModel
				});
				matchEditView.trigger("show");
			});

			$(".addToTatamiButton", this.el).on("click", function() {
				$.ajax({
					url: contextPath + "/competition/data/add-fight-to-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("id")),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".removeButton", this.el).on("click", function() {
				$.ajax({
					url: contextPath + "/competition/data/remove-match/" + String(obj.model.get("id")),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			return this;
		}
	});

	views.MatchesView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/matches"),
		"initialize": function() {
			this.collection.on("reset",function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html(this.template);

			$("[rel='tooltip']", this.el).tooltip();

			jtekma.displaySettings.get("category").fetch({
				"async": false
			});

			var category = this.collection.category;
			var treeCategoryOptions = category.get("treeCategoryOptions");

			if (treeCategoryOptions && (
			      treeCategoryOptions.treeType == "TABLE3"
			      || treeCategoryOptions.treeType == "TABLE4"
			      )
			    ) {
			    var matchesToShow = [];
                if (treeCategoryOptions.treeType == "TABLE3") {
                    matchesToShow.push(5);
                    matchesToShow.push(4);
                    matchesToShow.push(8);
                }
                else if (treeCategoryOptions.treeType == "TABLE4") {
                    matchesToShow.push(7);
                    matchesToShow.push(8);
                    matchesToShow.push(2);
                    matchesToShow.push(4);
                    matchesToShow.push(9);
                    matchesToShow.push(5);
                }
                for (var i in matchesToShow) {
                    var match = this.collection.where({"number": matchesToShow[i]})[0];
                    if (match.get("status") == "WAITING"
                            || match.get("status") == "INQUEUE"
                            || match.get("status") == "INPROGRESS"
                            || match.get("status") == "FINISHED") {

                        var matchView = new views.MatchView({
                            "model": match
                        });
                        $("#matches-div").append(matchView.render().el);
                    }
                }
			}
			else {
                for (var i = 1; i <= 124; i++) {
                    var match = this.collection.where({"number": i})[0];
                    if (match.get("status") == "WAITING"
                            || match.get("status") == "INQUEUE"
                            || match.get("status") == "INPROGRESS"
                            || match.get("status") == "FINISHED") {

                        var matchView = new views.MatchView({
                            "model": match
                        });
                        $("#matches-div").append(matchView.render().el);
                    }
                }
			}

			return this;
		}
	});

	views.CustomMatchesView = Backbone.View.extend({
		"template" : templates.getTemplate("/competition/template/custom-matches"),
		"initialize": function() {
			this.collection.on("reset",function() {
				this.render();
			}, this);
		},
		"render":function() {
			$(this.el).html(this.template);

			$(".addMatchButton", this.el).on("click", function() {
				var matchAddView = new views.MatchAddView();
				matchAddView.trigger("show");
			});

			$("[rel='tooltip']", this.el).tooltip();

			jtekma.displaySettings.get("category").fetch({
				"async": false
			});

			this.collection.each(function(match, index) {
				if (match.get("status") == "WAITING"
						|| match.get("status") == "INQUEUE"
						|| match.get("status") == "INPROGRESS"
						|| match.get("status") == "FINISHED") {

					var matchView = new views.MatchView({
						"model": match
					});
					$("#matches-div").append(matchView.render().el);
				}

			}, this);

			return this;
		}
	});

})();(function() {
    var jtekma = definePackage("jtekma");
    var views = definePackage("jtekma.views");

    var constants = definePackage("jtekma.constants");

	views.MatchDetailsView = Backbone.View.extend({
		"tagName": "div",
		"template": templates.getTemplate("/competition/template/match-details"),
		"initialize": function() {
			$(this.el).attr("class", "modal fade");

			var obj = this;

			this.on("show",function() {
				$("body").append(obj.el);

				$(obj.el).modal({
			    	show: false
			    });

				$(obj.el).on("hidden.bs.modal",function () {
					$(obj.el).remove();
				});

				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render": function() {
			var obj = this;

			$(this.el).html(Mustache.render(this.template,this.model.toJSON()));

			$.ajax({
				url: contextPath + "/competition/data/match-details/" + String(obj.model.get("id")),
				type: 'GET',
				success: function(responseData) {
					var chartType = responseData.chartType;
					var data = responseData.chartData;
					var categories = responseData.categories;
					var xAxisLabel = responseData.xAxisLabel;
					var yAxisLabel = responseData.yAxisLabel;
					var tooltipText = responseData.tooltipText;

					$("#match-points-graph").highcharts({
						chart: {
							type: chartType
						},
						title:{
							text: "",
							style: {
								display: 'none'
							}
						},
						xAxis:{
							title:{
								text: xAxisLabel
							},
							categories: categories
						},
						yAxis:{
							title:{
								text: yAxisLabel
							},
							min: 0
						},
						colors: ['#AA4643', '#4572A7'],
						tooltip: {
							formatter: function() {
								var text = tooltipText;
								text = text.replace("%s",this.series.name);
								text = text.replace("%x",this.x);
								text = text.replace("%y",this.y);
								return text;
							}
						},
						credits: {
							enabled: false
						},
						series:data
					});
				}
			});

			return this;
		}
	});

	views.MatchEditView = Backbone.View.extend({
		"tagName": "div",
		"fightTemplate": templates.getTemplate("/competition/template/edit-match-fight"),
		"duoTemplate": templates.getTemplate("/competition/template/edit-match-duo"),
		"duo2023Template": templates.getTemplate("/competition/template/edit-match-duo-2023"),
		"newazaTemplate": templates.getTemplate("/competition/template/edit-match-newaza"),
		"initialize": function() {
			$(this.el).attr("class", "modal fade");

			var obj = this;

			this.on("show",function() {
				$("body").append(obj.el);

				$(obj.el).modal({
			    	show: false
			    });

				$(obj.el).on("hidden.bs.modal", function () {
					$(obj.el).remove();
				});

				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render": function() {
			var obj = this;

			if (this.model.match.get("type") == "FIGHT") {
				$(this.el).html(Mustache.render(this.fightTemplate, this.model.points.toJSON()));

				function calculateFightPointsSum() {
					if (Number($("input[name='hansokumake1']",obj.el).val()) > 0) {
						$("input[name='sum1']",obj.el).val("0");
						$("input[name='sum2']",obj.el).val(constants.fullIpponPoints);
					}
					else if (Number($("input[name='hansokumake2']",obj.el).val()) > 0) {
						$("input[name='sum1']",obj.el).val(constants.fullIpponPoints);
						$("input[name='sum2']",obj.el).val("0");
					}
					else if ((Number($("input[name='ippon1_1']",obj.el).val()) > 0 || Number($("input[name='ippon1_1_3p']",obj.el).val()) > 0)
							&& (Number($("input[name='ippon1_2']",obj.el).val()) > 0 || Number($("input[name='ippon1_2_3p']",obj.el).val()) > 0)
							&& (Number($("input[name='ippon1_3']",obj.el).val()) > 0 || Number($("input[name='ippon1_3_3p']",obj.el).val()) > 0)) {
						$("input[name='sum1']",obj.el).val(constants.fullIpponPoints);
						$("input[name='sum2']",obj.el).val("0");
					}
					else if ((Number($("input[name='ippon1_2']",obj.el).val()) > 0 || Number($("input[name='ippon1_2_3p']",obj.el).val()) > 0)
							&& (Number($("input[name='ippon2_2']",obj.el).val()) > 0 || Number($("input[name='ippon2_2_3p']",obj.el).val()) > 0)
							&& (Number($("input[name='ippon2_3']",obj.el).val()) > 0 || Number($("input[name='ippon2_3_3p']",obj.el).val()) > 0)) {
						$("input[name='sum1']",obj.el).val("0");
						$("input[name='sum2']",obj.el).val(constants.fullIpponPoints);
					}
					else {
						var sum1=Number($("input[name='wazari1']",obj.el).val())
									+ Number($("input[name='ippon1_1']",obj.el).val()) * 2
									+ Number($("input[name='ippon1_2']",obj.el).val()) * 2
									+ Number($("input[name='ippon1_3']",obj.el).val()) * 2
									+ Number($("input[name='ippon1_1_3p']",obj.el).val()) * 3
									+ Number($("input[name='ippon1_2_3p']",obj.el).val()) * 3
									+ Number($("input[name='ippon1_3_3p']",obj.el).val()) * 3;
						var sum2=Number($("input[name='wazari2']",obj.el).val())
									+ Number($("input[name='ippon2_1']",obj.el).val()) * 2
									+ Number($("input[name='ippon2_2']",obj.el).val()) * 2
									+ Number($("input[name='ippon2_3']",obj.el).val()) * 2
									+ Number($("input[name='ippon2_1_3p']",obj.el).val()) * 3
									+ Number($("input[name='ippon2_2_3p']",obj.el).val()) * 3
									+ Number($("input[name='ippon2_3_3p']",obj.el).val()) * 3;

						$("input[name='sum1']",obj.el).val(sum1);
						$("input[name='sum2']",obj.el).val(sum2);
					}
				}

				$("input.fightPointsInput", this.el).on("change", function() {
					calculateFightPointsSum();
				});

				calculateFightPointsSum();

				$("input.fightPointsInput", this.el).spinner({
					"min": 0,
					"change": function() {
						calculateFightPointsSum();
					},
					"stop": function() {
						calculateFightPointsSum();
					}
				});
			}
			else if (this.model.match.get("type") == "DUO") {
				$(this.el).html(Mustache.render(this.duoTemplate, this.model.points.toJSON()));

				function calculateDuoPointsSum() {
					var sum1 = 0;
					var sum2 = 0;
					for (var round = 1; round <= 5; round++) {
						var roundSum1 = 0;
						var roundSum2 = 0;
						var min1 = Number.MAX_VALUE;
						var max1 = 0;
						var min2 = Number.MAX_VALUE;
						var max2 = 0;
						for (var judge = 1; judge <= 5; judge++) {
							var points1 = Number($("[competitor='1'] [round='"+round+"'] [judge='"+judge+"'] input", obj.el).val());
							var points2 = Number($("[competitor='2'] [round='"+round+"'] [judge='"+judge+"'] input", obj.el).val());
							roundSum1 += points1;
							roundSum2 += points2;

							if (points1 > max1) {
								max1 = points1;
							}
							if (points1 < min1) {
								min1 = points1;
							}
							if (points2 > max2) {
								max2 = points2;
							}
							if (points2 < min2) {
								min2 = points2;
							}
						}
						roundSum1 -= min1 + max1;
						roundSum2 -= min2 + max2;

						sum1 += roundSum1;
						sum2 += roundSum2;
						$("[competitor='1'] [round='"+round+"'] [judge='sum'] input", obj.el).val(String(roundSum1));
						$("[competitor='2'] [round='"+round+"'] [judge='sum'] input", obj.el).val(String(roundSum2));
					}
					$("[competitor='1'] input.fightPointsSummaryInput", obj.el).val(String(sum1));
					$("[competitor='2'] input.fightPointsSummaryInput", obj.el).val(String(sum2));
				}

				$("input.duoPointsInput", this.el).on("change",function() {
					calculateDuoPointsSum();
				});

				calculateDuoPointsSum();
			}
			else if (this.model.match.get("type") == "NEWAZA") {
				$(this.el).html(Mustache.render(this.newazaTemplate,this.model.points.toJSON()));

				function calculateNewazaPointsSum() {
					if (Number($("input[name='hansokumake1']", obj.el).val()) > 0) {
						$("input[name='sum1']",obj.el).val("0");
						$("input[name='sum2']",obj.el).val(constants.newazaFinishingMovePoints);
					}
					else if (Number($("input[name='hansokumake2']", obj.el).val()) > 0) {
						$("input[name='sum1']",obj.el).val(constants.newazaFinishingMovePoints);
						$("input[name='sum2']",obj.el).val("0");
					}
					else if (Number($("input[name='point1_100']", obj.el).val()) > 0) {
						$("input[name='sum1']",obj.el).val(constants.newazaFinishingMovePoints);
						$("input[name='sum2']",obj.el).val("0");
					}
					else if (Number($("input[name='point2_100']", obj.el).val()) > 0) {
						$("input[name='sum1']",obj.el).val("0");
						$("input[name='sum2']",obj.el).val(constants.newazaFinishingMovePoints);
					}
					else {
						var sum1 = Number($("input[name='point1_2']",obj.el).val()) * 2
									+ Number($("input[name='point1_3']",obj.el).val()) * 3
									+ Number($("input[name='point1_4']",obj.el).val()) * 4;

						var sum2 = Number($("input[name='point2_2']",obj.el).val()) * 2
									+ Number($("input[name='point2_3']",obj.el).val()) * 3
									+ Number($("input[name='point2_4']",obj.el).val()) * 4;

						$("input[name='sum1']",obj.el).val(sum1);
						$("input[name='sum2']",obj.el).val(sum2);
					}
				}

				$("input.newazaPointsInput", this.el).on("change",function() {
					calculateNewazaPointsSum();
				});

				calculateNewazaPointsSum();

				$("input.newazaPointsInput", this.el).spinner({
					"min":0,
					"change":function() {
						calculateNewazaPointsSum();
					},
					"stop":function() {
						calculateNewazaPointsSum();
					}
				});
			}
			else if (this.model.match.get("type") == "DUO2023") {
                $(this.el).html(Mustache.render(this.duo2023Template, this.model.points.toJSON()));

                $("[competitor='1'] input.duoPresentationPointsInput", obj.el).val("0");
                $("[competitor='2'] input.duoPresentationPointsInput", obj.el).val("0");

                for (var dpp of obj.model.points.get("points1")) {
                    $("[competitor='1'] input[judge='" + String(dpp.judge) + "'][series='" + dpp.series + "'][attack='" + String(dpp.attack) + "'][part='" + String(dpp.part) + "']", obj.el).val(dpp.points);
                }
                for (var dpp of obj.model.points.get("points2")) {
                    $("[competitor='2'] input[judge='" + String(dpp.judge) + "'][series='" + dpp.series + "'][attack='" + String(dpp.attack) + "'][part='" + String(dpp.part) + "']", obj.el).val(dpp.points);
                }

                $("[competitor='1'] input[name='varietyP3']", obj.el).val(obj.model.points.get("variety1P3"));
                $("[competitor='1'] input[name='varietyP4']", obj.el).val(obj.model.points.get("variety1P4"));
                $("[competitor='2'] input[name='varietyP3']", obj.el).val(obj.model.points.get("variety2P3"));
                $("[competitor='2'] input[name='varietyP4']", obj.el).val(obj.model.points.get("variety2P4"));

                $("[competitor='1'] input[name='penalty']", obj.el).val(obj.model.points.get("penalty1"));
                $("[competitor='2'] input[name='penalty']", obj.el).val(obj.model.points.get("penalty2"));

                function calculateDuoPointsSum() {
                    var sum1 = 0;
                    var sum2 = 0;

                    var inputs1 = $("[competitor='1'] input.duoPresentationPointsInput", obj.el);
                    var inputs2 = $("[competitor='2'] input.duoPresentationPointsInput", obj.el);

                    for (var i = 0; i < inputs1.length; i++) {
                        var points = Number($(inputs1[i]).val());
                        if (isValidNumber(points)) {
                            sum1 += points;
                        }
                    }
                    for (var i = 0; i < inputs2.length; i++) {
                        var points = Number($(inputs2[i]).val());
                        if (isValidNumber(points)) {
                            sum2 += points;
                        }
                    }

                    var variety13 = Number($("[competitor='1'] input[name='varietyP3']", obj.el).val());
                    if (isValidNumber(variety13)) {
                        sum1 += variety13;
                    }

                    var variety14 = Number($("[competitor='1'] input[name='varietyP4']", obj.el).val());
                    if (isValidNumber(variety14)) {
                        sum1 += variety14;
                    }

                    var variety23 = Number($("[competitor='2'] input[name='varietyP3']", obj.el).val());
                    if (isValidNumber(variety23)) {
                        sum1 += variety23;
                    }

                    var variety24 = Number($("[competitor='2'] input[name='varietyP4']", obj.el).val());
                    if (isValidNumber(variety24)) {
                        sum1 += variety24;
                    }

                    var penalty1 = Number($("[competitor='1'] input[name='penalty']", obj.el).val());
                    if (isValidNumber(penalty1)) {
                        sum1 -= penalty1;
                    }

                    var penalty2 = Number($("[competitor='2'] input[name='penalty']", obj.el).val());
                    if (isValidNumber(penalty2)) {
                        sum2 -= penalty2;
                    }

                    $("[competitor='1'] input.fightPointsSummaryInput", obj.el).val(String(sum1));
                    $("[competitor='2'] input.fightPointsSummaryInput", obj.el).val(String(sum2));
                }

                $("input.duoPresentationPointsInput", this.el).on("change", function() {
                    calculateDuoPointsSum();
                });

                $("input[name='varietyP3']", this.el).on("change", function() {
                    calculateDuoPointsSum();
                });

                $("input[name='varietyP4']", this.el).on("change", function() {
                    calculateDuoPointsSum();
                });

                $("input[name='penalty']", this.el).on("change", function() {
                    calculateDuoPointsSum();
                });

                calculateDuoPointsSum();
            }

			$(".btn-primary", this.el).on("click",function() {
				if (obj.model.match.get("type") == "FIGHT") {
					$("input.fightPointsInput", obj.el).each(function(index, item) {
						var name = $(this).attr("name");
						var value = Math.round(Number($(this).val()));
						obj.model.points.set(name, value);
					});

					if ($("input[name='matchTime']", obj.el).val().length > 0) {
						obj.model.points.set("matchTime", Math.round(Number($("input[name='matchTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("matchTime", null);
					}

					if ($("input[name='hosekomiTime']", obj.el).val().length > 0) {
						obj.model.points.set("hosekomiTime", Math.round(Number($("input[name='hosekomiTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("hosekomiTime", null);
					}
				}
				else if (obj.model.match.get("type") == "DUO") {
					for (var round = 1; round <= 5; round++) {
						for (var judge = 1; judge <= 5; judge++) {
							var points1 = Number($("[competitor='1'] [round='" + round + "'] [judge='" + judge + "'] input", obj.el).val());
							var points2 = Number($("[competitor='2'] [round='" + round + "'] [judge='" + judge + "'] input", obj.el).val());
							obj.model.points.get("rounds1")[round-1].judges[judge-1].points = points1;
							obj.model.points.get("rounds2")[round-1].judges[judge-1].points = points2;
						}
					}
				}
				else if (obj.model.match.get("type") == "NEWAZA") {
					$("input.newazaPointsInput", obj.el).each(function(index, item) {
						var name = $(this).attr("name");
						var value = Math.round(Number($(this).val()));
						obj.model.points.set(name,value);
					});

					if ($("input[name='matchTime']", obj.el).val().length > 0) {
						obj.model.points.set("matchTime", Math.round(Number($("input[name='matchTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("matchTime", null);
					}

					if ($("input[name='hosekomiTime']", obj.el).val().length > 0) {
						obj.model.points.set("hosekomiTime", Math.round(Number($("input[name='hosekomiTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("hosekomiTime", null);
					}
				}
				else if (obj.model.match.get("type") == "DUO2023") {
                    var points1 = [];
                    var points2 = [];

                    var inputs1 = $("[competitor='1'] input.duoPresentationPointsInput", obj.el);
                    for (var i = 0; i < inputs1.length; i++) {
                        var input = $(inputs1[i]);
                        var p = Number(input.val());
                        if (isValidNumber(p)) {
                            points1.push({
                                "judge": Number(input.attr("judge")),
                                "series": input.attr("series"),
                                "attack": Number(input.attr("attack")),
                                "part": Number(input.attr("part")),
                                "points": p
                            });
                        }
                    }

                    var inputs2 = $("[competitor='2'] input.duoPresentationPointsInput", obj.el);
                    for (var i = 0; i < inputs2.length; i++) {
                        var input = $(inputs2[i]);
                        var p = Number(input.val());
                        if (isValidNumber(p)) {
                            points2.push({
                                "judge": Number(input.attr("judge")),
                                "series": input.attr("series"),
                                "attack": Number(input.attr("attack")),
                                "part": Number(input.attr("part")),
                                "points": p
                            });
                        }
                    }

                    obj.model.points.set("points1", points1);
                    obj.model.points.set("points2", points2);

                    var variety13 = Number($("[competitor='1'] input[name='varietyP3']", obj.el).val());
                    if (isValidNumber(variety13)) {
                        obj.model.points.set("variety1P3", variety13);
                    }
                    else {
                        obj.model.points.set("variety1P3", 0);
                    }

                    var variety14 = Number($("[competitor='1'] input[name='varietyP4']", obj.el).val());
                    if (isValidNumber(variety14)) {
                        obj.model.points.set("variety1P4", variety14);
                    }
                    else {
                        obj.model.points.set("variety1P4", 0);
                    }

                    var variety23 = Number($("[competitor='2'] input[name='varietyP3']", obj.el).val());
                    if (isValidNumber(variety23)) {
                        obj.model.points.set("variety2P3", variety23);
                    }
                    else {
                        obj.model.points.set("variety2P3", 0);
                    }

                    var variety24 = Number($("[competitor='2'] input[name='varietyP4']", obj.el).val());
                    if (isValidNumber(variety24)) {
                        obj.model.points.set("variety2P4", variety24);
                    }
                    else {
                        obj.model.points.set("variety2P4", 0);
                    }

                    var penalty1 = Number($("[competitor='1'] input[name='penalty']", obj.el).val());
                    if (isValidNumber(penalty1)) {
                        obj.model.points.set("penalty1", penalty1);
                    }
                    else {
                        obj.model.points.set("penalty1", 0);
                    }

                    var penalty2 = Number($("[competitor='2'] input[name='penalty']", obj.el).val());
                    if (isValidNumber(penalty2)) {
                        obj.model.points.set("penalty2", penalty2);
                    }
                    else {
                        obj.model.points.set("penalty2", 0);
                    }
				}

				if ($("input[name='injuryTime1']", obj.el).val().length > 0) {
					obj.model.points.set("injuryTime1", Math.round(Number($("input[name='injuryTime1']", obj.el).val())));
				}
				else {
					obj.model.points.set("injuryTime1", null);
				}
				if ($("input[name='injuryTime2']", obj.el).val().length > 0) {
					obj.model.points.set("injuryTime2", Math.round(Number($("input[name='injuryTime2']", obj.el).val())));
				}
				else {
					obj.model.points.set("injuryTime2",null);
				}

				if ($("input[name='challengesWon1']", obj.el).val().length > 0) {
                    obj.model.points.set("challengesWon1", Math.round(Number($("input[name='challengesWon1']", obj.el).val())));
                }
                else {
                    obj.model.points.set("challengesWon1", null);
                }
                if ($("input[name='challengesWon2']", obj.el).val().length > 0) {
                    obj.model.points.set("challengesWon2", Math.round(Number($("input[name='challengesWon2']", obj.el).val())));
                }
                else {
                    obj.model.points.set("challengesWon2", null);
                }
                if ($("input[name='challengesLost1']", obj.el).val().length > 0) {
                    obj.model.points.set("challengesLost1", Math.round(Number($("input[name='challengesLost1']", obj.el).val())));
                }
                else {
                    obj.model.points.set("challengesLost1", null);
                }
                if ($("input[name='challengesLost2']", obj.el).val().length > 0) {
                    obj.model.points.set("challengesLost2", Math.round(Number($("input[name='challengesLost2']", obj.el).val())));
                }
                else {
                    obj.model.points.set("challengesLost2", null);
                }

				obj.model.points.set("noWinner", $("input[name='noWinner']", obj.el).is(":checked"));
				obj.model.points.set("finished", $("input[name='finished']", obj.el).is(":checked"));

				$.ajax({
					"async": false,
					"url": obj.model.points.url() + "?matchId=" + obj.model.match.get("id"),
					"type": "POST",
					"contentType": "application/json; charset=utf-8",
					"data": JSON.stringify(obj.model.points.toJSON())
				});
				$(obj.el).modal("hide");
				jtekma.reloadData();
			});

			return this;
		}
	});

})();(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	views.MatchAddView = Backbone.View.extend({
		"tagName": "div",
		"template": templates.getTemplate("/competition/template/add-match"),
		"initialize": function() {
			$(this.el).attr("class","modal fade");

			var obj = this;

			this.on("show",function() {
				$("body").append(obj.el);

				$(obj.el).modal({
			    	show: false
			    });

				$(obj.el).on("hidden.bs.modal", function () {
					$(obj.el).remove();
				});

				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render":function() {
			var obj = this;

			var competitorCollection = new models.CompetitorCollection();
			competitorCollection.fetch({
				"data": {
					"categoryId": jtekma.displaySettings.get("category").get("id")
				},
				"async": false
			});

			var data = {
				"competitors": competitorCollection.toJSON()
			};

			$(this.el).html(Mustache.render(this.template, data));

			$("[name='competitor1']", obj.el).chosen({
				"search_contains": true,
				"width": "250px"
			});

			$("[name='competitor2']", obj.el).chosen({
				"search_contains": true,
				"width": "250px"
			});

			$(".btn-primary", this.el).on("click", function() {
				var data = {
					"competitor1id": Number($("[name='competitor1']", obj.el).val()),
					"competitor2id": Number($("[name='competitor2']", obj.el).val()),
					"type": $("[name='match-type']", obj.el).val()
				};

				$.ajax({
					"async": false,
					"url": contextPath + "/competition/data/add-match?categoryId=" + jtekma.displaySettings.get("category").get("id"),
					"type": "POST",
					"contentType": "application/json; charset=utf-8",
					"data": JSON.stringify(data)
				});
				$(obj.el).modal("hide");
				jtekma.reloadData();
			});

			return this;
		}
	});

})();(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	models.DuoPresentationPoints = Backbone.Model.extend({
		"url": function() {
		  return contextPath + "/competition/data/duo-presentation-points";
		},
		"defaults": {
			"competitor": "",
			"club": "",
			"points": null,
			"penalty": 0,
			"finished": false
		}
	});

	models.DuoPresentationModel = Backbone.Model.extend({
		"defaults": {
			"id": 0,
			"name": "",
			"shortName": "",
			"competitor": null,
			"points": 0,
			"status": "",
			"categoryName": "",
			"categoryShortName": "",
			"canRemove": false
		},
		"parse": function(response, options) {
			response.isNotNeeded = response.status == "NOTNEEDED";
			response.isWaiting = response.status == "WAITING";
			response.isInQueue = response.status == "INQUEUE";
			response.isInProgress = response.status == "INPROGRESS";
			response.isFinished = response.status == "FINISHED";
			response.canAdd = response.isWaiting;
			return response;
		}
	});

	models.DuoPresentationCollection = Backbone.Collection.extend({
		"url": function() {
		  return contextPath + "/competition/data/duo-presentation";
		},
		"model": models.DuoPresentationModel
	});

	views.DuoPresentationView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/duo-presentation"),
		"className": "match",
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html(Mustache.render(this.template, this.model.toJSON()));

			$("[rel='tooltip']", this.el).tooltip();

			var obj = this;

			$(".editButton", this.el).on("click",function() {
				var editDuoPresentationModel = {
					"duoPresentation": obj.model
				};
                editDuoPresentationModel.points = new models.DuoPresentationPoints();
                editDuoPresentationModel.points.fetch({
                    "data": {
                        "duoPresentationId": obj.model.get("id")
                    },
                    "async": false
                });

				var duoPresentationEditView = new views.DuoPresentationEditView({
					"model": editDuoPresentationModel
				});
				duoPresentationEditView.trigger("show");
			});

			$(".addToTatamiButton", this.el).on("click", function() {
				$.ajax({
					url: contextPath + "/competition/data/add-duo-presentation-to-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("id")),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			return this;
		}
	});

	views.DuoPresentationsView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/duo-presentations"),
		"initialize": function() {
		    this.render();
			this.model.duoPresentations.on("reset", function() {
				this.renderDuoPresentations();
			}, this);
			this.model.matches.on("reset", function() {
                this.renderMatches();
            }, this);
		},
		"render": function() {
			$(this.el).html(this.template);
			$("[rel='tooltip']", this.el).tooltip();
			return this;
		},
		"renderDuoPresentations": function() {
		    $("#duo-presentations-div").html("");
            this.model.duoPresentations.each(function(duoPresentation, index) {
                if (duoPresentation.get("status") == "WAITING"
                        || duoPresentation.get("status") == "INQUEUE"
                        || duoPresentation.get("status") == "INPROGRESS"
                        || duoPresentation.get("status") == "FINISHED") {

                    var duoPresentationView = new views.DuoPresentationView({
                        "model": duoPresentation
                    });
                    $("#duo-presentations-div").append(duoPresentationView.render().el);
                }
			});
		},
		"renderMatches": function() {
		$("#matches-div").html("");
            this.model.matches.each(function(match, index) {
                if (match.get("status") == "WAITING"
                        || match.get("status") == "INQUEUE"
                        || match.get("status") == "INPROGRESS"
                        || match.get("status") == "FINISHED") {

                    var matchView = new views.MatchView({
                        "model": match
                    });
                    $("#matches-div").append(matchView.render().el);
                }
            });
		}
	});

})();(function() {
    var jtekma = definePackage("jtekma");
    var views = definePackage("jtekma.views");

	views.DuoPresentationEditView = Backbone.View.extend({
		"tagName": "div",
		"template": templates.getTemplate("/competition/template/edit-duo-presentation"),
		"initialize": function() {
			$(this.el).attr("class", "modal fade");

			var obj = this;

			this.on("show",function() {
				$("body").append(obj.el);

				$(obj.el).modal({
			    	show: false
			    });

				$(obj.el).on("hidden.bs.modal", function () {
					$(obj.el).remove();
				});

				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render": function() {
			var obj = this;

            $(this.el).html(Mustache.render(this.template, this.model.points.toJSON()));

            $("input.duoPresentationPointsInput", obj.el).val("0");

            for (var dpp of obj.model.points.get("points")) {
                $("input[judge='" + String(dpp.judge) + "'][series='" + dpp.series + "'][attack='" + String(dpp.attack) + "'][part='" + String(dpp.part) + "']", obj.el).val(dpp.points);
            }

            $("input[name='varietyP3']", obj.el).val(obj.model.points.get("varietyP3"));
            $("input[name='varietyP4']", obj.el).val(obj.model.points.get("varietyP4"));
            $("input[name='penalty']", obj.el).val(obj.model.points.get("penalty"));

            function calculateDuoPresentationPointsSum() {
                var sum = 0;

                var inputs = $("input.duoPresentationPointsInput");

                for (var i = 0; i < inputs.length; i++) {
                    var points = Number($(inputs[i]).val());
                    if (isValidNumber(points)) {
                        sum += points;
                    }
                }

                var variety3 = Number($("input[name='varietyP3']", obj.el).val());
                if (isValidNumber(variety3)) {
                    sum += variety3;
                }

                var variety4 = Number($("input[name='varietyP4']", obj.el).val());
                if (isValidNumber(variety4)) {
                    sum += variety4;
                }

                var penalty = Number($("input[name='penalty']", obj.el).val());
                if (isValidNumber(penalty)) {
                    sum -= penalty;
                }

                $("input.fightPointsSummaryInput", obj.el).val(String(sum));
            }

            $("input.duoPresentationPointsInput", this.el).on("change",function() {
                calculateDuoPresentationPointsSum();
            });

            $("input[name='varietyP3']", this.el).on("change",function() {
                calculateDuoPresentationPointsSum();
            });

            $("input[name='varietyP4']", this.el).on("change",function() {
                calculateDuoPresentationPointsSum();
            });

            $("input[name='penalty']", this.el).on("change",function() {
                calculateDuoPresentationPointsSum();
            });

            calculateDuoPresentationPointsSum();

			$(".btn-primary", this.el).on("click",function() {
			    var points = [];
			    var inputs = $("input.duoPresentationPointsInput");
                for (var i = 0; i < inputs.length; i++) {
                    var input = $(inputs[i]);
                    var p = Number(input.val());
                    if (isValidNumber(p)) {
                        points.push({
                            "judge": Number(input.attr("judge")),
                            "series": input.attr("series"),
                            "attack": Number(input.attr("attack")),
                            "part": Number(input.attr("part")),
                            "points": p
                        });
                    }
                }
                obj.model.points.set("points", points);

                var variety3 = Number($("input[name='varietyP3']", obj.el).val());
                if (isValidNumber(variety3)) {
                    obj.model.points.set("varietyP3", variety3);
                }
                else {
                    obj.model.points.set("varietyP3", 0);
                }

                var variety4 = Number($("input[name='varietyP4']", obj.el).val());
                if (isValidNumber(variety4)) {
                    obj.model.points.set("varietyP4", variety4);
                }
                else {
                    obj.model.points.set("varietyP4", 0);
                }

                var penalty = Number($("input[name='penalty']", obj.el).val());
                if (isValidNumber(penalty)) {
                    obj.model.points.set("penalty", penalty);
                }
                else {
                    obj.model.points.set("penalty", 0);
                }

				obj.model.points.set("finished", $("input[name='finished']", obj.el).is(":checked"));

				$.ajax({
					"async": false,
					"url": obj.model.points.url() + "?duoPresentationId=" + obj.model.duoPresentation.get("id"),
					"type": "POST",
					"contentType": "application/json; charset=utf-8",
					"data": JSON.stringify(obj.model.points.toJSON())
				});
				$(obj.el).modal("hide");
				jtekma.reloadData();
			});

			return this;
		}
	});

})();(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

    /*---------- Tatami fight ----------*/
	models.TatamiFightModel = Backbone.Model.extend({
		"defaults": {
			"fightNumber": 0,
			"match": null,
			"event": null,
			"duoPresentation": null
		}
	});

	models.TatamiFightCollection = Backbone.Collection.extend({
		"url": function() {
		  return contextPath + "/competition/data/tatami-fights";
		},
		"model": models.TatamiFightModel
	});

	views.TatamiFightView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/tatami-fight"),
		"className": "match",
		"initialize": function() {
			this.model.on("change",function() {
				this.render();
			}, this);
		},
		"render": function() {
			var data = this.model.toJSON();
			data.fightOrderNumber = this.fightOrderNumber;

			data.fights = [];
			this.collection.each(function(item, index) {
				var text = " ";
				var match = item.get("match");
				var event = item.get("event");
				var duoPresentation = item.get("duoPresentation");

				if (match != null) {
					if (match.competitor1 != null) {
						text += match.competitor1.shortName;
					}
					if (match.competitor2 != null) {
						if (text.length > 0) {
							text += "-";
						}
						text += match.competitor2.shortName;
					}
				}
				else if (event != null) {
					text = event.text;
				}
				else if (duoPresentation != null) {
                    if (duoPresentation.competitor != null) {
                        text += duoPresentation.competitor.shortName;
                    }
				}

				var matchData = {
					"number": index + 1,
					"text": text
				};
				data.fights.push(matchData);
			});

			$(this.el).html(Mustache.render(this.template, data));

			$("[rel='tooltip']", this.el).tooltip();

			var obj = this;

			$(".removeFightButton", this.el).on("click",function() {
				$.ajax({
					url: contextPath + "/competition/data/remove-fight-from-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("match").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveFightUpButton", this.el).on("click",function() {
				$.ajax({
					url: contextPath + "/competition/data/moveup-fight-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("match").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveFightDownButton", this.el).on("click",function() {
				$.ajax({
					url:contextPath+"/competition/data/movedown-fight-tatami/" + String(jtekma.displaySettings.get("tatami").get("id"))+"/" + String(obj.model.get("match").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".editEventButton", this.el).on("click",function() {
				var eventModel = new models.EventModel();
				eventModel.fetch({
					"data": {
						"eventId": obj.model.get("event").id
					},
					"async": false
				});
				var eventEditView = new views.EventEditView({
					"model": eventModel
				});
				eventEditView.trigger("show");
			});

			$(".removeEventButton", this.el).on("click",function() {
				$.ajax({
					url: contextPath + "/competition/data/remove-event-from-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("event").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveEventUpButton", this.el).on("click",function() {
				$.ajax({
					url: contextPath + "/competition/data/moveup-event-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("event").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveEventDownButton", this.el).on("click",function() {
				$.ajax({
					url: contextPath + "/competition/data/movedown-event-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("event").id),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".removeDuoPresentationButton", this.el).on("click",function() {
                $.ajax({
                    url: contextPath + "/competition/data/remove-duo-presentation-from-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("duoPresentation").id),
                    type: 'GET',
                    success: function(responseData){
                        jtekma.reloadData();
                    }
                });
            });

            $(".moveDuoPresentationUpButton", this.el).on("click",function() {
                $.ajax({
                    url: contextPath + "/competition/data/moveup-duo-presentation-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("duoPresentation").id),
                    type: 'GET',
                    success: function(responseData){
                        jtekma.reloadData();
                    }
                });
            });

            $(".moveDuoPresentationDownButton", this.el).on("click",function() {
                $.ajax({
                    url:contextPath+"/competition/data/movedown-duo-presentation-tatami/" + String(jtekma.displaySettings.get("tatami").get("id"))+"/" + String(obj.model.get("duoPresentation").id),
                    type: 'GET',
                    success: function(responseData){
                        jtekma.reloadData();
                    }
                });
            });

			$(".moveFightToList a", this.el).on("click",function() {
				var moveTo = Number($(this).attr("href").substring(1));
				$.ajax({
					url: contextPath + "/competition/data/move-fight-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("match").id) + "/" + String(moveTo),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveEventToList a", this.el).on("click",function() {
				var moveTo = Number($(this).attr("href").substring(1));
				$.ajax({
					url: contextPath + "/competition/data/move-event-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("event").id) + "/" + String(moveTo),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".moveDuoPresentationToList a", this.el).on("click",function() {
                var moveTo = Number($(this).attr("href").substring(1));
                $.ajax({
                    url: contextPath + "/competition/data/move-duo-presentation-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("duoPresentation").id) + "/" + String(moveTo),
                    type: 'GET',
                    success: function(responseData){
                        jtekma.reloadData();
                    }
                });
            });

			return this;
		}
	});

	views.TatamiFightsView = Backbone.View.extend({
		"initialize": function() {
			this.collection.on("reset",function() {
				this.render();
			}, this);
		},
		"render": function() {
			var collection = this.collection;

			$(this.el).html("");

			this.collection.each(function(item, index) {
				var tatamiFightView = new views.TatamiFightView({
					"collection": collection,
					"model": item
				});
				tatamiFightView.fightOrderNumber = index + 1;

				$(this.el).append(tatamiFightView.render().el);
			}, this);

			return this;
		}
	});

	/*---------- Tatami history ----------*/
	models.TatamiHistoryEventModel = Backbone.Model.extend({
		"defaults": {
			"eventDate": 0,
			"eventDateText": "",
			"eventType": "",
			"match": null
		}
	});

	models.TatamiHistoryEventCollection = Backbone.Collection.extend({
		"url": function() {
		  return contextPath + "/competition/data/tatami-history";
		},
		"model": models.TatamiHistoryEventModel
	});

	views.TatamiHistoryEventView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/tatami-history-event"),
		"className": "tatami-history-event",
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			var data = this.model.toJSON();

			if (this.model.get("eventType") == "PULLMATCH") {
				data.icon = "glyphicon glyphicon-arrow-up";
				data.iconTooltip = getSpringMessage("match.matchPulledTooltip");
			}
			else if (this.model.get("eventType") == "PUSHMATCH") {
				data.icon = "glyphicon glyphicon-arrow-down";
				data.iconTooltip = getSpringMessage("match.matchPushedToolpip");
			}

			$(this.el).html(Mustache.render(this.template, data));

			$("[rel='tooltip']", this.el).tooltip();

			return this;
		}
	});

	views.TatamiHistoryEventsView = Backbone.View.extend({
		"initialize": function() {
			this.collection.on("reset",function() {
				this.render();
			}, this);
		},
		"render": function() {
			var collection = this.collection;

			$(this.el).html("");

			this.collection.each(function(item, index) {
				var tatamiHistoryEventView = new views.TatamiHistoryEventView({
					"collection": collection,
					"model": item
				});

				$(this.el).append(tatamiHistoryEventView.render().el);
			}, this);

			return this;
		}
	});

	/*--------- Tatamis ---------*/
	models.TatamiModel = Backbone.Model.extend({
		"defaults": {
			"id": 0,
			"name": ""
		}
	});

	models.TatamiCollection = Backbone.Collection.extend({
		"url": function() {
		   return contextPath + "/competition/data/tatami";
		 },
		"model": models.TatamiModel
	});

	views.TatamiSelectView = Backbone.View.extend({
		"optionTemplate": "<option value=\"{{id}}\">{{name}}</option>",
		"initialize": function() {
			this.collection.on("reset",function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this).html("");

			var tatamis = this.collection;

			$(this.el).change(function() {
				var tatamiId = Number($(this).val());

				var tatami = tatamis.where({ "id": tatamiId });
				if (tatami.length > 0) {
					jtekma.displaySettings.set("tatami", tatami[0]);
				}
			});

			this.collection.each(function(item, index) {
				$(this.el).append(Mustache.render(this.optionTemplate, item.toJSON()));
			},this);

			$(this.el).chosen({
				"search_contains": true,
				"width": "135px"
			});

			if (this.collection.length > 0) {
				jtekma.displaySettings.set("tatami", this.collection.at(0));
			}

			return this;
		}
	});

})();(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	views.TreeView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/tree"),
		"initialize": function() {
			this.collection.on("reset", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html(this.template);

			$("[rel='tooltip']", this.el).tooltip();

			var category = jtekma.displaySettings.get("category");
			var treeCategoryOptions = category.get("treeCategoryOptions");

			if (treeCategoryOptions.treeType == "TREE4") {
				$("#tree-div").attr("style", "width:560px;height:330px;");
				for (var i = 117; i <= 118; i++) {
					var match = this.collection.where({"number":i})[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:20px;top:" + String((i - 117) * 80 + 40) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 124; i <= 124; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:260px;top:" + String((i - 124) * (-80) + 80) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				//repasague
				for (var i = 123; i <= 123; i++) {
					var match = this.collection.where({"number":i})[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:260px;top:" + String((i - 123) * (-80) + 240) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
			}
			else if (treeCategoryOptions.treeType == "TREE8") {
				$("#tree-div").attr("style", "width:770px;height:560px;");
				for (var i = 105; i <= 108; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:20px;top:" + String((i - 105) * 80 + 40) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 117; i <= 118; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:260px;top:" + String((i - 117) * 160 + 80)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 124; i <= 124; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:500px;top:" + String((i - 124) * 80 + 160) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				//repasague
				for (var i = 119; i <= 120; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:20px;top:" + String((i - 119) * 80 + 390) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 121; i <= 122; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:260px;top:" + String((i - 121) * 80 + 390) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				if (!treeCategoryOptions.double3rdPlace) {
					for (var i = 123; i <= 123; i++) {
						var match = this.collection.where({ "number": i })[0];
						var matchView = new views.MatchView({
							"model": match,
							"attributes": {
								"style": "position:absolute;left:500px;top:" + String((i - 123) * 80 + 430) + "px;"
							}
						});
						$("#tree-div").append(matchView.render().el);
					}
				}
			}
			else if (treeCategoryOptions.treeType == "TREE16") {
				$("#tree-div").attr("style", "width:1220px;height:1040px;");
				for (var i = 81; i <= 88; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:20px;top:" + String((i - 81) * 80 + 40) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 105; i <= 108; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:260px;top:" + String((i - 105) * 160 + 80) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 117; i <= 118; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:500px;top:" + String((i - 117) * 320 + 160) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 124; i <= 124; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:740px;top:" + String((i - 124) * 80 + 320) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				//repasague
				for (var i = 109; i <= 112; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:20px;top:" + String((i - 109) * 80 + 700) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 113; i <= 116; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:260px;top:" + String((i - 113) * 80 + 700) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 119; i <= 120; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:500px;top:" + String((i - 119) * 160 + 740) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 121; i <= 122; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:740px;top:" + String((i - 121) * 160 + 740) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				if (!treeCategoryOptions.double3rdPlace) {
					for (var i = 123; i <= 123; i++) {
						var match = this.collection.where({ "number": i })[0];
						var matchView = new views.MatchView({
							"model": match,
							"attributes": {
								"style": "position:absolute;left:980px;top:" + String((i - 123) * 80 + 820) + "px;"
							}
						});
						$("#tree-div").append(matchView.render().el);
					}
				}
			}
			else if (treeCategoryOptions.treeType == "TREE32") {
				$("#tree-div").attr("style","width:1700px;height:2010px;");
				for (var i = 33; i <= 48; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:20px;top:" + String((i - 33) * 80 + 40) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 81; i <= 88; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:260px;top:" + String((i - 81) * 160 + 80) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 105; i <= 108; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:500px;top:" + String((i - 105) * 320 + 160) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 117; i <= 118; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:740px;top:" + String((i - 117) * 640 + 320) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 124; i <= 124; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:980px;top:" + String((i - 124) * 80 + 640) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				//repasague
				for (var i = 89; i <= 96; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:20px;top:" + String((i - 89) * 80 + 1360) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 97; i <= 104; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:260px;top:" + String((i - 97) * 80 + 1360) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 109; i <= 112; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:500px;top:" + String((i - 109) * 160 + 1400) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 113; i <= 116; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:740px;top:" + String((i - 113) * 160 + 1400) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 119; i <= 120; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:980px;top:" + String((i - 119) * 320 + 1480) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 121; i <= 122; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:1220px;top:" + String((i - 121) * 320 + 1480) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				if (!treeCategoryOptions.double3rdPlace) {
					for (var i = 123; i <= 123; i++) {
						var match = this.collection.where({ "number": i })[0];
						var matchView = new views.MatchView({
							"model": match,
							"attributes": {
								"style": "position:absolute;left:1460px;top:" + String((i - 123) * 80 + 1650) + "px;"
							}
						});
						$("#tree-div").append(matchView.render().el);
					}
				}
			}
			else if (treeCategoryOptions.treeType == "TREE64") {
				$("#tree-div").attr("style","width:2200px;height:3960px;");
				for (var i = 1; i <= 32; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:20px;top:" + String((i - 1) * 80 + 40) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 33; i <= 48; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:260px;top:" + String((i - 33) * 160 + 80) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 81; i <= 88; i++) {
					var match = this.collection.where({ "number" : i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:500px;top:" + String((i - 81) * 320 + 160) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 105; i <= 108; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:740px;top:" + String((i - 105) * 640 + 320) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 117; i <= 118; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:980px;top:" + String((i - 117) * 1280 + 640) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 124; i <= 124; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:1220px;top:" + String((i - 124) * 80 + 1280) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				//repasague
				for (var i = 49; i <= 64; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:20px;top:" + String((i - 49) * 80 + 2660) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 65; i <= 80; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:260px;top:" + String((i - 65) * 80 + 2660) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 89; i <= 96; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:500px;top:" + String((i - 89) * 160 + 2700) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 97; i <= 104; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:740px;top:" + String((i - 97) * 160 + 2700) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 109; i <= 112; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:980px;top:" + String((i - 109) * 320 + 2780) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 113; i <= 116; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:1220px;top:" + String((i - 113) * 320 + 2780) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 119; i <= 120; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:1460px;top:" + String((i - 119) * 640 + 2950) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i = 121; i <= 122; i++) {
					var match = this.collection.where({ "number": i })[0];
					var matchView = new views.MatchView({
						"model": match,
						"attributes": {
							"style": "position:absolute;left:1700px;top:" + String((i - 121) * 640 + 2950) + "px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				if (!treeCategoryOptions.double3rdPlace) {
					for (var i = 123; i <= 123; i++) {
						var match = this.collection.where({ "number": i })[0];
						var matchView = new views.MatchView({
							"model": match,
							"attributes": {
								"style": "position:absolute;left:1940px;top:" + String((i - 123) * 80 + 3260) + "px;"
							}
						});
						$("#tree-div").append(matchView.render().el);
					}
				}
			}

			return this;
		}
	});

})();(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	models.TableModel = Backbone.Model.extend({
		"url": function() {
		  return contextPath + "/competition/data/table";
		},
		"defaults": {
			"rows": null
		}
	});

	views.TableView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/table"),
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			var tableData = this.model.toJSON();
			var treeCategoryOptions = jtekma.displaySettings.get("category").get("treeCategoryOptions");
			tableData.matchesGuide3 = treeCategoryOptions.treeType == "TABLE3";
			tableData.matchesGuide4 = treeCategoryOptions.treeType == "TABLE4";
			tableData.matchesGuide5 = treeCategoryOptions.treeType == "TABLE5";

			$(this.el).html(Mustache.render(this.template, tableData));

			$("[rel='tooltip']", this.el).tooltip();

			return this;
		}
	});

})();(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	models.DuoTableModel = Backbone.Model.extend({
		"url": function() {
          return contextPath + "/competition/data/duo-table";
        },
        "defaults": {
            "rows": null
        }
	});

    views.DuoTablesView = Backbone.View.extend({
        "template": templates.getTemplate("/competition/template/duo-tables"),
        "initialize": function() {
            this.model.duoTable.on("change", function() {
                this.renderDuoTable();
            }, this);
            this.model.matches.on("reset", function() {
                this.renderMatches();
            }, this);
            this.render();
        },
        "render": function() {
            var category = jtekma.displaySettings.get("category");
        	var draw2023Options = category.get("draw2023Options");

            var data = {};
            $(this.el).html(Mustache.render(this.template, data));

            $("#qualification").hide();
            $("#knockout").hide();

            $("#roundButtons label", this.el).on("click", function() {
                $("#qualification").hide();
                $("#knockout").hide();
                jtekma.displaySettings.set("duo2023DisplayTab", $(this).attr("link"));
                $("#" + $(this).attr("link")).show();
            });

            var duo2023DisplayTab = jtekma.displaySettings.get("duo2023DisplayTab");
            if (!isTextEmpty(duo2023DisplayTab)) {
                var button = $("label[link='" + duo2023DisplayTab + "']");
                if (button.length > 0) {
                    button.click();
                }
                else {
                    $("#roundButtons label:first").click();
                }
            }
            else {
                $("#roundButtons label:first").click();
            }

            return this;
        },
        "renderDuoTable": function() {
            var element = $("#qualification .duo-table-div");
            element.html("");
            var duoTableView = new views.DuoTableView({
                "el": element,
                "model": this.model.duoTable
            });
            duoTableView.render();
        },
        "renderMatches": function() {
            var category = jtekma.displaySettings.get("category");
            var draw2023Options = category.get("draw2023Options");

            // world level
            var element = $("#knockoutWl");
            element.html("");

            element.attr("style", "width:770px;height:320px;");
            for (var i = 1; i <= 2; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:20px;top:" + String((i - 1) * 80 + 10) + "px;"
                    }
                });
                element.append(matchView.render().el);
            }
            if (!draw2023Options.double3rdPlace) {
                for (var i = 3; i <= 3; i++) {
                    var match = this.model.matches.where({ "number": i })[0];
                    var matchView = new views.MatchView({
                        "model": match,
                        "attributes": {
                            "style": "position:absolute;left:260px;top:210px;"
                        }
                    });
                    element.append(matchView.render().el);
                }
            }
            for (var i = 4; i <= 4; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:260px;top:50px;"
                    }
                });
                element.append(matchView.render().el);
            }

            // advanced level
            element = $("#knockoutAdv");
            element.html("");

            element.attr("style", "width:770px;height:320px;");
            for (var i = 5; i <= 6; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:20px;top:" + String((i - 5) * 80 + 10) + "px;"
                    }
                });
                element.append(matchView.render().el);
            }
            if (!draw2023Options.double3rdPlace) {
                for (var i = 7; i <= 7; i++) {
                    var match = this.model.matches.where({ "number": i })[0];
                    var matchView = new views.MatchView({
                        "model": match,
                        "attributes": {
                            "style": "position:absolute;left:260px;top:210px;"
                        }
                    });
                    element.append(matchView.render().el);
                }
            }
            for (var i = 8; i <= 8; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:260px;top:50px;"
                    }
                });
                element.append(matchView.render().el);
            }

            // novice level
            element = $("#knockoutNov");
            element.html("");

            element.attr("style", "width:770px;height:320px;");
            for (var i = 9; i <= 10; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:20px;top:" + String((i - 9) * 80 + 10) + "px;"
                    }
                });
                element.append(matchView.render().el);
            }
            if (!draw2023Options.double3rdPlace) {
                for (var i = 11; i <= 11; i++) {
                    var match = this.model.matches.where({ "number": i })[0];
                    var matchView = new views.MatchView({
                        "model": match,
                        "attributes": {
                            "style": "position:absolute;left:260px;top:210px;"
                        }
                    });
                    element.append(matchView.render().el);
                }
            }
            for (var i = 12; i <= 12; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:260px;top:50px;"
                    }
                });
                element.append(matchView.render().el);
            }
        }
    });

	views.DuoTableView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/duo-table"),
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			var duoTableData = this.model.toJSON();
			$(this.el).html(Mustache.render(this.template, duoTableData));
			return this;
		}
	});

})();(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	views.TableOrTreeView = Backbone.View.extend({
		"initialize": function() {

		},
		"render":function() {
			$(this.el).html("");

			var category = jtekma.displaySettings.get("category");
			var treeCategoryOptions = category.get("treeCategoryOptions");

			category.fetch({
				"async": false
			});

			if (category.get("type") == "FIGHTING" || category.get("type") == "DUO" || category.get("type") == "NEWAZA") {
				if ((treeCategoryOptions.treeType == "TABLE2")
						|| (treeCategoryOptions.treeType == "TABLE3")
						|| (treeCategoryOptions.treeType == "TABLE4")
						|| (treeCategoryOptions.treeType == "TABLE5")) {

					var tableModel = new models.TableModel();
					tableModel.fetch({
						"data": {
							"categoryId": category.get("id")
						},
						"async": false
					});

					if (treeCategoryOptions.treeType == "TABLE2") {
						tableModel.set("num", [1,2]);
					}
					else if (treeCategoryOptions.treeType == "TABLE3") {
						tableModel.set("num", [1,2,3]);
					}
					else if (treeCategoryOptions.treeType == "TABLE4") {
						tableModel.set("num", [1,2,3,4]);
					}
					else if (treeCategoryOptions.treeType == "TABLE5") {
						tableModel.set("num", [1,2,3,4,5]);
					}

					var tableView = new views.TableView({
						"el": $(this.el),
						"model": tableModel
					});
					tableView.render();
				}
				else {
					var matchCollection = new models.MatchCollection();
					new views.TreeView({
						"el": $(this.el),
						"collection": matchCollection
					});
					matchCollection.fetch({
						"data": {
							"categoryId": category.get("id")
						},
						"reset": true
					});
				}
			}
			else if (category.get("type") == "DUO_2023") {
			    var data = {
			        "duoTable": new models.DuoTableModel(),
			        "matches": new models.MatchCollection()
			    };
                new views.DuoTablesView({
                    "el": $(this.el),
                    "model": data
                });
                data.duoTable.fetch({
                    "data": {
                        "categoryId": category.get("id")
                    },
                    "reset": true
                });
                data.matches.fetch({
                    "data": {
                        "categoryId": category.get("id")
                    },
                    "reset": true
                });
			}
			else { //CUSTOM
				$(this.el).text(category.get("type"));
			}

			return this;
		}
	});

})();(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");
    var messages = definePackage("jtekma.gui.messages");

    views.DrawAvailableView = Backbone.View.extend({
		"competitorTemplate": "<div><button class=\"btn btn-default btn-sm\" competitorId=\"{{id}}\"><i class=\"glyphicon glyphicon-plus\"></i></button> {{name}} / {{clubName}}</div>",
		"initialize": function() {
			this.collection.on("draw-changed", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html("");

			var competitors = this.collection;

			competitors.each(function(item, index) {
				if (item.get("draw") == null) {
					$(this.el).append(Mustache.render(this.competitorTemplate, item.toJSON()));
				}
			}, this);

			$("button", this.el).on("click",function() {
			    var addToPosition = Number($("#addToPosition").val());
			    var addToGroup = Number($("#addToGroup").val());
				var competitorId = Number($(this).attr("competitorId"));

				var item = competitors.where({ "id": competitorId });
				var competitor = null;
				if (item.length > 0) {
				    competitor = item[0];
				}
				if (isNull(competitor)) {
				    return;
				}

				if (addToPosition > 0) {
				    if (addToGroup > 0) {
				        for (var c of competitors.where({ "draw": addToPosition, "drawGroup": addToGroup })) {
                            c.set("draw", null);
                            c.set("drawGroup", null);
                        }
				    }
				    else {
                        for (var c of competitors.where({ "draw": addToPosition })) {
                            c.set("draw", null);
                            c.set("drawGroup", null);
                        }
                    }
                    competitor.set("draw", addToPosition);
                    if (addToGroup > 0) {
                        competitor.set("drawGroup", addToGroup);
                    }
				}
				else {
				    var max = 64;
				    if (addToGroup > 0) {
				        max = 16;
				    }
                    var next = null;
                    for (var i = 1; i <= max; i++) {
                        if (addToGroup > 0) {
                            if (competitors.where({ "draw": i, "drawGroup": addToGroup }).length == 0) {
                                next = i;
                                break;
                            }
                        }
                        else {
                            if (competitors.where({ "draw": i }).length == 0) {
                                next = i;
                                break;
                            }
                        }
                    }
                    if (isNotNull(next)) {
                        competitor.set("draw", next);
                        if (addToGroup > 0) {
                            competitor.set("drawGroup", addToGroup);
                        }
                    }
				}
				competitors.trigger("draw-changed");
			});

			return this;
		}
	});

	views.DrawDrawedView = Backbone.View.extend({
		"competitorTemplate": "<div><button class=\"btn btn-default btn-sm\" competitorId=\"{{id}}\"><i class=\"glyphicon glyphicon-minus\"></i></button> {{draw}}. {{name}} / {{clubName}}</div>",
		"competitorEmptyTemplate": "<div><button class=\"btn btn-default btn-sm\" disabled=\"true\"><i class=\"glyphicon glyphicon-minus\"></i></button> {{draw}}.</div>",
		"initialize": function() {
			this.collection.on("draw-changed", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html("");

			var competitors = this.collection;

			var draw = [];
			for (var i = 0; i < 64; i++) {
				draw[i] = null;
			}

			this.collection.each(function(item, index) {
				var num = item.get("draw");
				if (num != null) {
					draw[num-1] = item;
				}
			}, this);

			for (var i = 0; i < 64; i++) {
				if (draw[i] != null) {
					$(this.el).append(Mustache.render(this.competitorTemplate, draw[i].toJSON()));
				}
				else {
					$(this.el).append(Mustache.render(this.competitorEmptyTemplate, {
						"draw": (i + 1)
					}));
				}
			}

			$("button", this.el).on("click", function() {
				var competitorId = Number($(this).attr("competitorId"));
				var item = competitors.where({ "id": competitorId });
				if (item.length > 0) {
					item[0].set("draw", null);
					item[0].set("drawGroup", null);
				}
				competitors.trigger("draw-changed");
			});

			return this;
		}
	});

	views.DrawGroupView = Backbone.View.extend({
        "competitorTemplate": "<div><button class=\"btn btn-default btn-sm\" competitorId=\"{{id}}\"><i class=\"glyphicon glyphicon-minus\"></i></button> {{draw}}. {{name}} / {{clubName}}</div>",
        "competitorEmptyTemplate": "<div><button class=\"btn btn-default btn-sm\" disabled=\"true\"><i class=\"glyphicon glyphicon-minus\"></i></button> {{draw}}.</div>",
        "initialize": function() {
            this.model.collection.on("draw-changed", function() {
                this.render();
            }, this);
        },
        "render": function() {
            $(this.el).html("");

            var groupNum = this.model.groupNum;
            var competitors = this.model.collection;

            var draw = [];
            for (var i = 0; i < 16; i++) {
                draw[i] = null;
            }

            competitors.each(function(item, index) {
                if (item.get("drawGroup") != groupNum) {
                    return;
                }
                var num = item.get("draw");
                if (num != null) {
                    draw[num-1] = item;
                }
            }, this);

            for (var i = 0; i < 16; i++) {
                if (draw[i] != null) {
                    $(this.el).append(Mustache.render(this.competitorTemplate, draw[i].toJSON()));
                }
                else {
                    $(this.el).append(Mustache.render(this.competitorEmptyTemplate, {
                        "draw": (i + 1)
                    }));
                }
            }

            $("button", this.el).on("click", function() {
                var competitorId = Number($(this).attr("competitorId"));
                var item = competitors.where({ "id": competitorId });
                if (item.length > 0) {
                    item[0].set("draw", null);
                    item[0].set("drawGroup", null);
                }
                competitors.trigger("draw-changed");
            });

            return this;
        }
    });

	views.DrawView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/draw"),
		"initialize": function() {
			this.collection.on("reset", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html(this.template);

			var category = jtekma.displaySettings.get("category");

			category.fetch({
				"async": false
			});

			var treeCategoryOptions = category.get("treeCategoryOptions");

			$("#categoryTreeType").val(treeCategoryOptions.treeType);
			$("#categoryRepasageType").val(treeCategoryOptions.repassageType);

			if (treeCategoryOptions.double3rdPlace) {
				$("#categoryDouble3rdPlace").attr("checked","true");
			}
			$("#categoryRepassageFromRound").val(treeCategoryOptions.repassageFromRound);

			new views.DrawAvailableView({
				"el": $("#available"),
				"collection": this.collection
			});
			new views.DrawDrawedView({
				"el": $("#draw"),
				"collection": this.collection
			});

			var competitors = this.collection;

			this.collection.on("draw-changed", function() {
				var max = 1;
				for (var i = 1; i <= 64; i++) {
					if (competitors.where({ "draw": i }).length != 0) {
						max = i;
					}
				}

				$("#categoryTreeType option").removeAttr("disabled");

				if (max > 2) {
					if ($("#categoryTreeType").val() == "TABLE2" || $("#categoryTreeType").val() == "BEST_OF_3") {
						$("#categoryTreeType").val("TABLE3");
					}
					$("#categoryTreeType option[value='TABLE2']").attr("disabled", "true");
					$("#categoryTreeType option[value='BEST_OF_3']").attr("disabled", "true");
				}
				if (max > 3) {
					if ($("#categoryTreeType").val() == "TABLE3") {
						$("#categoryTreeType").val("TABLE4");
					}
					$("#categoryTreeType option[value='TABLE3']").attr("disabled", "true");
				}
				if (max > 4) {
					if ($("#categoryTreeType").val() == "TABLE4") {
						$("#categoryTreeType").val("TABLE5");
					}
					if ($("#categoryTreeType").val() == "TREE4") {
						$("#categoryTreeType").val("TREE8");
					}
					$("#categoryTreeType option[value='TABLE4']").attr("disabled", "true");
					$("#categoryTreeType option[value='TREE4']").attr("disabled", "true");
				}
				if (max > 5) {
					if ($("#categoryTreeType").val() == "TABLE5") {
						$("#categoryTreeType").val("TREE8");
					}
					$("#categoryTreeType option[value='TABLE5']").attr("disabled", "true");
				}
				if (max > 8) {
					if ($("#categoryTreeType").val() == "TREE8") {
						$("#categoryTreeType").val("TREE16");
					}
					$("#categoryTreeType option[value='TREE8']").attr("disabled", "true");
				}
				if (max > 16) {
					if ($("#categoryTreeType").val() == "TREE16") {
						$("#categoryTreeType").val("TREE32");
					}
					$("#categoryTreeType option[value='TREE16']").attr("disabled", "true");
				}
				if (max > 32) {
					$("#categoryTreeType").val("TREE64");
					$("#categoryTreeType option[value='TREE32']").attr("disabled", "true");
				}
			}, this);

			this.collection.trigger("draw-changed");

			$(".btn-danger", this.el).on("click", function() {
				competitors.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
			});

			$(".btn-primary", this.el).on("click", function() {
				var data = {
					"categoryId": category.get("id"),
					"treeCategoryOptions": null,
					"draw": []
				};

				data.treeCategoryOptions = {
					"treeType": $("#categoryTreeType").val(),
					"repassageType": $("#categoryRepasageType").val(),
					"double3rdPlace": $("#categoryDouble3rdPlace").is(":checked"),
					"repassageFromRound": Number($("#categoryRepassageFromRound").val())
				};

				competitors.each(function(item, index) {
					data.draw.push({
						"competitorId": item.get("id"),
						"drawNumber": item.get("draw"),
						"drawGroup": item.get("drawGroup")
					});
				});

				$.ajax({
					url: contextPath + "/competition/data/save-draw",
					type: 'POST',
					contentType: "application/json; charset=utf-8",
					data: JSON.stringify(data),
					success: function(responseData) {
						if (responseData.success) {
							messages.showSuccessMessage(getSpringMessage("competition.text.drawSaved"));
						}
						else {
							messages.showErrorMessage(getSpringMessage("competition.text.drawSavedError"));
						}
					},
					error: function() {
						messages.showErrorMessage(getSpringMessage("competition.text.drawSavedError"));
					}
				});
			});

			$("button[link='clearButton']", this.el).on("click", function() {
				competitors.each(function(item, index) {
					item.set("draw", null);
					item.set("drawGroup", null);
				});
				competitors.trigger("draw-changed");
			});

			function executeDraw() {
				var sameClubCheck = $("#sameClubCheck").is(":checked");

				var draw = new models.CompetitorCollection();

				competitors.each(function(item, index) {
					if (isNull(item.get("draw"))) {
						draw.add(item);
					}
				});

				if (sameClubCheck) {
					var newDraw = [];
					var n = 0;
					while (draw.length > 0) {
						var clubId = draw.at(Math.floor(Math.random() * draw.length)).get("clubId");
						var competitorsFromClub = new models.CompetitorCollection();
						competitorsFromClub.reset(draw.where({ "clubId": clubId }));
						while (competitorsFromClub.length > 0) {
							var c = competitorsFromClub.at(Math.floor(Math.random() * competitorsFromClub.length));
							competitorsFromClub.remove(c);
							draw.remove(c);
							newDraw[n++] = c;
						}
					}
					draw = newDraw;
				}
				else {
					var newDraw = [];
					var n = 0;
					while (draw.length > 0) {
						var c = draw.at(Math.floor(Math.random() * draw.length));
						draw.remove(c);
						newDraw[n++] = c;
					}
					draw = newDraw;
				}

				for (var j = 0; j < draw.length; j++) {
					var next = null;
					for (var i = 1; i <= 64; i++) {
						if (competitors.where({ "draw": i }).length == 0) {
							next = i;
							break;
						}
					}
					draw[j].set("draw", next);
					draw[j].set("drawGroup", null);
				}

				competitors.trigger("draw-changed");
			}

			$("button[link='executeDraw']", this.el).on("click",function() {
				executeDraw();
			});

			$("button[link='clearAndExecuteDraw']", this.el).on("click",function() {
				competitors.each(function(item, index) {
					item.set("draw", null);
					item.set("drawGroup", null);
				});
				executeDraw();
			});

			return this;
		}
	});

	views.DrawDuo2023View = Backbone.View.extend({
        "template": templates.getTemplate("/competition/template/draw-duo2023"),
        "initialize": function() {
            this.collection.on("reset", function() {
                this.render();
            }, this);
        },
        "render": function() {
            $(this.el).html(this.template);

            var category = jtekma.displaySettings.get("category");

            category.fetch({
                "async": false
            });

            var draw2023Options = category.get("draw2023Options");

            if (draw2023Options.double3rdPlace) {
                $("#categoryDouble3rdPlace").attr("checked", "true");
            }
            if (draw2023Options.advancedLevel) {
                $("#advancedLevel").attr("checked", "true");
            }
            if (draw2023Options.noviceLevel) {
                $("#noviceLevel").attr("checked", "true");
            }

            new views.DrawAvailableView({
                "el": $("#available"),
                "collection": this.collection
            });
            for (var groupNum = 1; groupNum <= 4; groupNum++) {
                new views.DrawGroupView({
                    "el": $("#drawGroup" + String(groupNum)),
                    "model": {
                        "groupNum": groupNum,
                        "collection": this.collection
                    }
                });
            }

            var competitors = this.collection;

            this.collection.trigger("draw-changed");

            $(".btn-danger", this.el).on("click", function() {
                competitors.fetch({
                    "data": {
                        "categoryId": category.get("id")
                    },
                    "reset": true
                });
            });

            $(".btn-primary", this.el).on("click", function() {
                var data = {
                    "categoryId": category.get("id"),
                    "draw2023Options": null,
                    "draw": []
                };

                data.draw2023Options = {
                    "double3rdPlace": $("#categoryDouble3rdPlace").is(":checked")
                };

                competitors.each(function(item, index) {
                    data.draw.push({
                        "competitorId": item.get("id"),
                        "drawNumber": item.get("draw"),
                        "drawGroup": item.get("drawGroup")
                    });
                });

                $.ajax({
                    url: contextPath + "/competition/data/save-draw",
                    type: 'POST',
                    contentType: "application/json; charset=utf-8",
                    data: JSON.stringify(data),
                    success: function(responseData) {
                        if (responseData.success) {
                            messages.showSuccessMessage(getSpringMessage("competition.text.drawSaved"));
                        }
                        else {
                            messages.showErrorMessage(getSpringMessage("competition.text.drawSavedError"));
                        }
                    },
                    error: function() {
                        messages.showErrorMessage(getSpringMessage("competition.text.drawSavedError"));
                    }
                });
            });

            $("button[link='clearButton']", this.el).on("click", function() {
                competitors.each(function(item, index) {
                    item.set("draw", null);
                    item.set("drawGroup", null);
                });
                competitors.trigger("draw-changed");
            });

            function executeDraw() {
                var sameClubCheck = $("#sameClubCheck").is(":checked");

                var draw = new models.CompetitorCollection();

                competitors.each(function(item, index) {
                    if (isNull(item.get("draw"))) {
                        draw.add(item);
                    }
                });

                if (sameClubCheck) {
                    var newDraw = [];
                    var n = 0;
                    while (draw.length > 0) {
                        var clubId = draw.at(Math.floor(Math.random() * draw.length)).get("clubId");
                        var competitorsFromClub = new models.CompetitorCollection();
                        competitorsFromClub.reset(draw.where({ "clubId": clubId }));
                        while (competitorsFromClub.length > 0) {
                            var c = competitorsFromClub.at(Math.floor(Math.random() * competitorsFromClub.length));
                            competitorsFromClub.remove(c);
                            draw.remove(c);
                            newDraw[n++] = c;
                        }
                    }
                    draw = newDraw;
                }
                else {
                    var newDraw = [];
                    var n = 0;
                    while (draw.length > 0) {
                        var c = draw.at(Math.floor(Math.random() * draw.length));
                        draw.remove(c);
                        newDraw[n++] = c;
                    }
                    draw = newDraw;
                }

                var totalGroups = 1;
                if (competitors.length >= 19) {
                    totalGroups = 4;
                }
                else if (competitors.length >= 13) {
                    totalGroups = 3;
                }
                else if (competitors.length >= 7) {
                    totalGroups = 2;
                }

                for (var j = 0; j < draw.length; j++) {
                    var nextDraw = null;
                    var nextGroup = null;
                    for (var num = 1; num <= 16; num++) {
                        if (isNotNull(nextDraw) && isNotNull(nextGroup)) {
                            break;
                        }
                        for (var groupNum = 1; groupNum <= totalGroups; groupNum++) {
                            if (competitors.where({ "draw": num, "drawGroup": groupNum }).length == 0) {
                                nextDraw = num;
                                nextGroup = groupNum;
                                break;
                            }
                        }
                    }
                    draw[j].set("draw", nextDraw);
                    draw[j].set("drawGroup", groupNum);
                }

                competitors.trigger("draw-changed");
            }

            $("button[link='executeDraw']", this.el).on("click",function() {
                executeDraw();
            });

            $("button[link='clearAndExecuteDraw']", this.el).on("click",function() {
                competitors.each(function(item, index) {
                    item.set("draw", null);
                    item.set("drawGroup", null);
                });
                executeDraw();
            });

            return this;
        }
    });

})();(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

    // placings
    models.PlacingModel = Backbone.Model.extend({
        "defaults": {
            "place": 0,
            "competitor": null
        }
    });

    models.PlacingCollection = Backbone.Collection.extend({
        "url": function() {
          return contextPath + "/competition/data/placings";
        },
        "model": models.PlacingModel
    });

    views.PlacingView = Backbone.View.extend({
        "template": templates.getTemplate("/competition/template/placings"),
        "initialize": function() {
            this.collection.on("reset",function() {
                this.render();
            }, this);
        },
        "render": function() {
            var data = {
                "placings": this.collection.toJSON()
            };
            $(this.el).html(Mustache.render(this.template, data));

            $("[rel='tooltip']", this.el).tooltip();

            return this;
        }
    });

    // duo 2023 placings
    models.Duo2023PlacingModel = Backbone.Model.extend({
        "defaults": {
            "rank": null,
            "place": 0,
            "competitor": null
        }
    });

    models.Duo2023PlacingCollection = Backbone.Collection.extend({
        "url": function() {
          return contextPath + "/competition/data/duo-2023-placings";
        },
        "model": models.Duo2023PlacingModel
    });

    views.Duo2023PlacingView = Backbone.View.extend({
        "template": templates.getTemplate("/competition/template/duo-2023-placings"),
        "initialize": function() {
            this.collection.on("reset",function() {
                this.render();
            }, this);
        },
        "render": function() {
            var data = {};

            this.collection.each(function(item, index) {
                if (item.get("rank") == "WORLD_LEVEL") {
                    if (isNull(data.worldLevel)) {
                        data.showWorldLevel = true;
                        data.worldLevel = [];
                    }
                    data.worldLevel.push(item.toJSON());
                }
                else if (item.get("rank") == "ADVANCED") {
                    if (isNull(data.advanced)) {
                        data.showAdvanced = true;
                        data.advanced = [];
                    }
                    data.advanced.push(item.toJSON());
                }
                else if (item.get("rank") == "NOVICE") {
                    if (isNull(data.novice)) {
                        data.showNovice = true;
                        data.novice = [];
                    }
                    data.novice.push(item.toJSON());
                }
            });

            $(this.el).html(Mustache.render(this.template, data));

            $("[rel='tooltip']", this.el).tooltip();

            return this;
        }
    });

})();(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

    jtekma.displaySettings = new models.DisplaySettings();

    jtekma.reloadData = function() {
        jtekma.displaySettings.trigger("change:tatami");
        jtekma.displaySettings.trigger("change:category");
    }

	jtekma.displaySettings.on("change:category change:type", function() {
		$("#competition-main").html("");

		var category = this.get("category");
		
		if (isNull(category)) {
			return;
		}
		
		if (category.get("type") == "FIGHTING" || category.get("type") == "DUO" || category.get("type") == "NEWAZA") {
			if (this.get("type") == "draw") {
				var competitorCollection = new models.CompetitorCollection();
				new views.DrawView({
					"el": $("#competition-main"),
					"collection": competitorCollection
				});
				competitorCollection.fetch({
					"data": {
						"categoryId": this.get("category").get("id")
					},
					"reset": true
				});
			}
			else if (this.get("type") == "tree") {
				var tableOrTreeView = new views.TableOrTreeView({
					"el": $("#competition-main")
				});
				tableOrTreeView.render();
			}
			else if (this.get("type") == "matches") {
				var matchCollection = new models.MatchCollection();
				matchCollection.category = category;
				new views.MatchesView({
					"el": $("#competition-main"),
					"collection": matchCollection
				});
				matchCollection.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
			}
			else if (this.get("type") == "placings") {
				var placingCollection = new models.PlacingCollection();
				new views.PlacingView({
					"el": $("#competition-main"),
					"collection": placingCollection
				});
				placingCollection.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
			}
		}
		else if (category.get("type") == "DUO_2023") {
            if (this.get("type") == "draw") {
				var competitorCollection = new models.CompetitorCollection();
				new views.DrawDuo2023View({
					"el": $("#competition-main"),
					"collection": competitorCollection
				});
				competitorCollection.fetch({
					"data": {
						"categoryId": this.get("category").get("id")
					},
					"reset": true
				});
			}
			else if (this.get("type") == "tree") {
				var tableOrTreeView = new views.TableOrTreeView({
                    "el": $("#competition-main")
                });
                tableOrTreeView.render();
			}
			else if (this.get("type") == "matches") {
			    var data = {
			        "category": category,
			        "duoPresentations": new models.DuoPresentationCollection(),
			        "matches": new models.MatchCollection()
			    };
				new views.DuoPresentationsView({
					"el": $("#competition-main"),
					"model": data
				});
				data.duoPresentations.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
				data.matches.fetch({
                    "data": {
                        "categoryId": category.get("id")
                    },
                    "reset": true
                });
			}
			else if (this.get("type") == "placings") {
				var placingCollection = new models.Duo2023PlacingCollection();
				new views.Duo2023PlacingView({
					"el": $("#competition-main"),
					"collection": placingCollection
				});
				placingCollection.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
			}
		}
		else if (this.get("category").get("type") == "CUSTOM") {
			if (this.get("type") == "matches") {
				var matchCollection = new models.MatchCollection();
				new views.CustomMatchesView({
					"el": $("#competition-main"),
					"collection": matchCollection
				});
				matchCollection.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
			}
		}
	}, jtekma.displaySettings);
	
	jtekma.displaySettings.on("change:tatami change:tatami-display-type", function() {
		$("#tatami-fights").html("");
		
		if (this.get("tatami-display-type")=="nextFights") {
			var tatamiFightCollection = new models.TatamiFightCollection();
			
			new views.TatamiFightsView({
				"el": $("#tatami-fights"),
				"collection": tatamiFightCollection
			});
			
			if (this.get("tatami") != null) {
				tatamiFightCollection.fetch({
					"data": {
						"tatamiId": this.get("tatami").get("id")
					},
					"reset": true
				});
			}
		}
		else if (this.get("tatami-display-type") == "history") {
			var tatamiHistoryEventCollection = new models.TatamiHistoryEventCollection();
			
			new views.TatamiHistoryEventsView({
				"el": $("#tatami-fights"),
				"collection": tatamiHistoryEventCollection
			});
			
			if (this.get("tatami") != null) {
				tatamiHistoryEventCollection.fetch({
					"data": {
						"tatamiId": this.get("tatami").get("id")
					},
					"reset": true
				});
			}
		}
	}, jtekma.displaySettings);
	
	/*----- Competition ---------*/
	models.Competition = Backbone.Model.extend({
		"defaults": {
			"id": 0,
			"name": "",
			"date": null,
			"status": "",
			"canManage": false
		},
		"url": function() {
		  return contextPath + "/competition/data/current-competition";
		},
		"initialize": function() {
			
		}
	});
	
	views.Competition = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/competition"),
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html(this.template);
			
			$("[rel='tooltip']", this.el).tooltip();
			
			$("#displayButtons label", this.el).on("click", function() {
				jtekma.displaySettings.set("type", $(this).attr("link"));
			});
			
			$("#displayButtons label:first").click();
			
			var categoryCollection = new models.CategoryCollection();
			new views.CategorySelectView({
				"el": $("#category-select"),
				"collection": categoryCollection
			});
			new views.CategoryEnableView({
				"el": $("#category-enable-list"),
				"collection": categoryCollection
			});
			categoryCollection.fetch({ "reset": true });
			
			var tatamiCollection = new models.TatamiCollection();
			new views.TatamiSelectView({
				"el": $("#tatami-select"),
				"collection": tatamiCollection
			});
			tatamiCollection.fetch({ "reset": true });
			
			$(".addEventButton", this.el).on("click", function() {
				var eventModel = new models.EventModel();
				var eventEditView = new views.EventEditView({
					"model": eventModel
				});
				eventEditView.trigger("show");
			});
			
			$("#tatamiDisplayButtons label", this.el).on("click", function() {
				jtekma.displaySettings.set("tatami-display-type", $(this).attr("link"));
			});
			
			$("#tatamiDisplayButtons label:first").click();
			
			$(".refreshButton", this.el).on("click",function() {
				jtekma.reloadData();
			});
			
			var autoReload = false;
			
			$(".autoRefreshButton", this.el).on("click", function() {
				autoReload = $(this).attr("class").indexOf("active") < 0;
				if (autoReload) {
					jtekma.reloadData();
				}
			});
			
			setInterval(function(){
				if (autoReload) {
					jtekma.reloadData();
				}
			}, 30000);
			
			return this;
		}
	});
	
})();

$(document).ready(function() {
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	var competition = new models.Competition();
	
	new views.Competition({
		"el": $("#competition-div"),
		"model": competition
	});
	
	competition.fetch();
});