/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchRound;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Semaphore;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiFightData;
import si.nevensrok.jtekma.common.tatami.TatamiFightOrder;
import si.nevensrok.jtekma.common.tatami.TatamiOnSemaphore;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.SemaphoreManager;
import si.nevensrok.jtekma.server.management.TatamiManager;
import si.nevensrok.jtekma.server.tools.MatchRoundTool;
import si.nevensrok.jtekma.services.SemaphoreService;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.services.common.ServiceException;

public class SemaphoreServiceImpl
implements SemaphoreService {
    private SemaphoreManager semaphoreManager;
    private TatamiManager tatamiManager;
    private MatchManager matchManager;
    private CategoryManager categoryManager;
    private DuoPresentationManager duoPresentationManager;

    public void setSemaphoreManager(SemaphoreManager semaphoreManager) {
        this.semaphoreManager = semaphoreManager;
    }

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setDuoPresentationManager(DuoPresentationManager duoPresentationManager) {
        this.duoPresentationManager = duoPresentationManager;
    }

    public boolean checkLogin(Credentials credentials) throws ServiceException {
        Semaphore semaphore = this.semaphoreManager.getSemaphoreByCredentials(credentials);
        return semaphore != null;
    }

    public TatamiFightData getTatamiFightData(Credentials credentials) throws ServiceException {
        Semaphore semaphore = this.semaphoreManager.getSemaphoreByCredentials(credentials);
        if (semaphore == null) {
            throw new ServiceException("Invalid credentials");
        }
        TatamiFightData tatamiFightData = new TatamiFightData();
        tatamiFightData.setDisplayRows(semaphore.getDisplayRows());
        LinkedList<TatamiFightOrder> tatamiFightOrders = new LinkedList<TatamiFightOrder>();
        tatamiFightData.setTatamiFightOrders(tatamiFightOrders);
        ArrayList tatamiOnSemaphores = new ArrayList(this.semaphoreManager.getTatamisForSemaphore(semaphore));
        Collections.sort(tatamiOnSemaphores, new Comparator<TatamiOnSemaphore>(){

            @Override
            public int compare(TatamiOnSemaphore o1, TatamiOnSemaphore o2) {
                return o1.getOrderNum().compareTo(o2.getOrderNum());
            }
        });
        for (TatamiOnSemaphore tatamiOnSemaphore : tatamiOnSemaphores) {
            TatamiFightOrder tatamiFightOrder = new TatamiFightOrder();
            tatamiFightOrders.add(tatamiFightOrder);
            Tatami tatami = tatamiOnSemaphore.getTatami();
            tatami.setPassword(null);
            tatamiFightOrder.setTatami(tatami);
            tatamiFightOrder.setFightOrders(this.tatamiManager.getFightOrderForTatami(tatami));
            for (FightOrder fightOrder : tatamiFightOrder.getFightOrders()) {
                DuoPresentation duoPresentation;
                Category category = null;
                Match match = fightOrder.getMatch();
                if (match != null) {
                    match = this.matchManager.getByIdWithCompetitors(match.getMatchId());
                    fightOrder.setMatch(match);
                    category = this.categoryManager.getCategoryForMatch(match);
                    match.setCategory(category);
                }
                if ((duoPresentation = fightOrder.getDuoPresentation()) != null) {
                    duoPresentation = this.duoPresentationManager.getByIdWithCompetitor(duoPresentation.getDuoPresentationId());
                    fightOrder.setDuoPresentation(duoPresentation);
                    category = this.categoryManager.getCategoryForDuoPresentation(duoPresentation);
                    duoPresentation.setCategory(category);
                }
                if (category == null) continue;
                if (category instanceof TreeCategory) {
                    TreeCategory treeCategory = (TreeCategory)category;
                    if (match != null) {
                        fightOrder.setMatchRound(MatchRoundTool.getMatchRound((int)match.getFightNumber(), (TreeCategory)treeCategory));
                    }
                }
                if (!(category instanceof Duo2023Category)) continue;
                Round round = null;
                Rank rank = null;
                MatchRound matchRound = null;
                if (match != null) {
                    if (match.getFightNumber() >= 1 && match.getFightNumber() <= 4) {
                        rank = Rank.WORLD_LEVEL;
                        if (match.getFightNumber() == 1 || match.getFightNumber() == 2) {
                            round = Round.ROUND_4;
                            matchRound = MatchRound.HALF_FINALS;
                        } else if (match.getFightNumber() == 3) {
                            round = Round.ROUND_5;
                            matchRound = MatchRound.FOR_3RD_PLACE;
                        } else if (match.getFightNumber() == 4) {
                            round = Round.ROUND_5;
                            matchRound = MatchRound.FINALS;
                        }
                    } else if (match.getFightNumber() >= 5 && match.getFightNumber() <= 8) {
                        rank = Rank.ADVANCED;
                        if (match.getFightNumber() == 5 || match.getFightNumber() == 6) {
                            round = Round.ROUND_4;
                            matchRound = MatchRound.HALF_FINALS;
                        } else if (match.getFightNumber() == 7) {
                            round = Round.ROUND_5;
                            matchRound = MatchRound.FOR_3RD_PLACE;
                        } else if (match.getFightNumber() == 8) {
                            round = Round.ROUND_5;
                            matchRound = MatchRound.FINALS;
                        }
                    } else if (match.getFightNumber() >= 9 && match.getFightNumber() <= 12) {
                        rank = Rank.NOVICE;
                        if (match.getFightNumber() == 9 || match.getFightNumber() == 10) {
                            round = Round.ROUND_4;
                            matchRound = MatchRound.HALF_FINALS;
                        } else if (match.getFightNumber() == 11) {
                            round = Round.ROUND_5;
                            matchRound = MatchRound.FOR_3RD_PLACE;
                        } else if (match.getFightNumber() == 12) {
                            round = Round.ROUND_5;
                            matchRound = MatchRound.FINALS;
                        }
                    }
                } else if (duoPresentation != null) {
                    round = duoPresentation.getRound();
                }
                fightOrder.setRound(round);
                fightOrder.setRank(rank);
                fightOrder.setMatchRound(matchRound);
            }
        }
        return tatamiFightData;
    }
}

