/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.filter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.NestedServletException;
import si.nevensrok.jtekma.server.web.common.exceptions.HttpException;

public class GeneralFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (NestedServletException e) {
            LOGGER.error("Error processing request", (Throwable)e);
            if (e.getCause() instanceof HttpException) {
                HttpException httpException = (HttpException)e.getCause();
                response.setStatus(httpException.getResponseCode());
                response.setContentType("text/plain; charset=utf-8");
                String message = httpException.getMessage();
                if (message != null) {
                    response.getOutputStream().write(message.getBytes(StandardCharsets.UTF_8));
                }
            }
            throw e;
        }
        catch (HttpException e) {
            LOGGER.error("Error processing request", (Throwable)e);
            response.setStatus(e.getResponseCode());
            response.setContentType("text/plain; charset=utf-8");
            String message = e.getMessage();
            if (message != null) {
                response.getOutputStream().write(message.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error processing request", e);
            throw e;
        }
    }
}

