/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.reports;

import java.io.IOException;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.server.reports.DocumentType;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.reports.TreeReportModel;

@Controller
@RequestMapping(value={"/reports/competitor-ranking"})
public class CompetitorRankingsReportController
extends CoreController {
    @RequestMapping(method={RequestMethod.GET})
    public String index(HttpServletRequest request, Model model, @ModelAttribute(value="competitorRankingReport") TreeReportModel competitorRankingReport) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        model.addAttribute("competitorRankingActive", (Object)true);
        LinkedHashMap<String, String> documentTypes = new LinkedHashMap<String, String>();
        documentTypes.put(DocumentType.PDF.name(), this.getLanguageText(locale, "report.documentType.PDF"));
        documentTypes.put(DocumentType.ODT.name(), this.getLanguageText(locale, "report.documentType.ODT"));
        model.addAttribute("documentTypes", documentTypes);
        LinkedHashMap<String, String> locales = new LinkedHashMap<String, String>();
        locales.put("en", this.getLanguageText(locale, "locale.english"));
        locales.put("sl", this.getLanguageText(locale, "locale.slovenian"));
        model.addAttribute("locales", locales);
        competitorRankingReport.setLocale(RequestContextUtils.getLocale((HttpServletRequest)request).getLanguage());
        return "reports/competitor-rankings";
    }

    @RequestMapping(method={RequestMethod.POST})
    public void download(HttpServletRequest request, HttpServletResponse response, @ModelAttribute(value="competitorRankingReport") TreeReportModel competitorRankingReport) throws IOException {
        Competition competition;
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        if (competitorRankingReport.getLocale() != null) {
            locale = new Locale(competitorRankingReport.getLocale());
        }
        if ((competition = this.getManagersList().getCompetitionManager().getById(this.getUserData().getCompetition().getCompetitionId())) == null) {
            return;
        }
        List competitorRankings = this.getManagersList().getCompetitorManager().getCompetitorRankings(competition, Competitor.Type.COMPETITOR);
        while (competitorRankings.size() > 50) {
            competitorRankings.remove(competitorRankings.size() - 1);
        }
        List coupleRankings = this.getManagersList().getCompetitorManager().getCompetitorRankings(competition, Competitor.Type.COUPLE);
        while (coupleRankings.size() > 50) {
            coupleRankings.remove(coupleRankings.size() - 1);
        }
        String fileName = this.getUserData().getCompetition().getName() + " - " + this.getLanguageText(locale, "report.filename.competitorRanking");
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFD).replaceAll("[^\\p{Alnum}\\x20\\x2B\\x2D\\x2E\\x5F]", "");
        if (competitorRankingReport.getDocumentType() == DocumentType.PDF) {
            response.setContentType("application/pdf");
            fileName = fileName + ".pdf";
        } else if (competitorRankingReport.getDocumentType() == DocumentType.ODT) {
            response.setContentType("application/vnd.oasis.opendocument.text");
            fileName = fileName + ".odt";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        ServletOutputStream outputStream = response.getOutputStream();
        this.getManagersList().getReportGenerator().generateCompetitorRankingReport(competitorRankingReport.getDocumentType(), locale, (OutputStream)outputStream, competitorRankings, coupleRankings);
        outputStream.close();
    }
}

