/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.competition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.common.web.util.ControllerUtil;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.matches.Series;
import si.nevensrok.jtekma.common.reports.ReportData;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.DuoPresentationAttack;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.rules.rules2023.CompetitionRules2023;
import si.nevensrok.jtekma.server.web.common.CommonResponse;
import si.nevensrok.jtekma.server.web.common.competition.AddMatchData;
import si.nevensrok.jtekma.server.web.common.competition.Duo2023Points;
import si.nevensrok.jtekma.server.web.common.competition.DuoPoints;
import si.nevensrok.jtekma.server.web.common.competition.DuoPresentationAttackPoint;
import si.nevensrok.jtekma.server.web.common.competition.FightPoints;
import si.nevensrok.jtekma.server.web.common.competition.Match;
import si.nevensrok.jtekma.server.web.common.competition.NewazaPoints;
import si.nevensrok.jtekma.server.web.common.json.ChartData;
import si.nevensrok.jtekma.server.web.common.json.ReportChartData;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.CompetitorNameUtil;
import si.nevensrok.jtekma.server.web.tools.MatchPointsUtil;

@Controller
@RequestMapping(value={"/competition/data"})
public class CompetitionDataMatchController
extends CoreController {
    @RequestMapping(value={"/match"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Match> getMatchList(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="categoryId") Long categoryId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        LinkedList<Match> matches = new LinkedList<Match>();
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        TreeCategory treeCategory = null;
        if (category instanceof TreeCategory) {
            treeCategory = (TreeCategory)category;
        }
        Duo2023Category duo2023Category = null;
        if (category instanceof Duo2023Category) {
            duo2023Category = (Duo2023Category)category;
        }
        List matchList = this.getManagersList().getMatchManager().getMatchesForCategory(category);
        HashMap matchPoints = new HashMap();
        for (Map.Entry entry : this.getManagersList().getMatchManager().getMatchPointsForMatches(new HashSet(matchList)).entrySet()) {
            matchPoints.put(((si.nevensrok.jtekma.common.matches.Match)entry.getKey()).getMatchId(), entry.getValue());
        }
        for (si.nevensrok.jtekma.common.matches.Match match : matchList) {
            Competitor winner;
            match.setCategory(category);
            Match m = new Match(match);
            if (treeCategory != null) {
                m.setName(this.getTools().getMatchTool().getMatchName(locale, treeCategory, match));
                m.setShortName(this.getTools().getMatchTool().getMatchShortName(treeCategory, match));
                m.setCanRemove(false);
            } else if (duo2023Category != null) {
                m.setName(this.getTools().getMatchTool().getMatchName(locale, duo2023Category, match));
                m.setShortName(this.getTools().getMatchTool().getMatchShortName(duo2023Category, match));
                m.setCanRemove(false);
            } else {
                m.setName(this.getLanguageText(locale, "match.matchNum") + " " + String.valueOf(match.getFightNumber()));
                m.setShortName(String.valueOf(match.getFightNumber()));
                m.setCanRemove(true);
            }
            Set points = (Set)matchPoints.get(match.getMatchId());
            m.setPoints1(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points)));
            m.setPoints2(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points)));
            if (match.getStatus() == Match.Status.FINISHED && (winner = competitionRules.getMatchWinner(match, points)) != null) {
                if (m.getCompetitor1() != null) {
                    m.getCompetitor1().setWinner(winner.getCompetitorId().equals(m.getCompetitor1().getId()));
                }
                if (m.getCompetitor2() != null) {
                    m.getCompetitor2().setWinner(winner.getCompetitorId().equals(m.getCompetitor2().getId()));
                }
            }
            matches.add(m);
        }
        return matches;
    }

    @RequestMapping(value={"/match/{matchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Match getMatchById(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Competitor winner;
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            match.setCategory(category);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
            if (competitionRules == null) {
                throw new RuntimeException("CompetitionRules for competition not found");
            }
            TreeCategory treeCategory = null;
            if (category instanceof TreeCategory) {
                treeCategory = (TreeCategory)category;
            }
            Match m = new Match(match);
            if (treeCategory != null) {
                m.setName(this.getTools().getMatchTool().getMatchName(locale, treeCategory, match));
                m.setShortName(this.getTools().getMatchTool().getMatchShortName(treeCategory, match));
            }
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            m.setPoints1(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points)));
            m.setPoints2(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points)));
            if (match.getStatus() == Match.Status.FINISHED && (winner = competitionRules.getMatchWinner(match, points)) != null) {
                if (m.getCompetitor1() != null) {
                    m.getCompetitor1().setWinner(winner.getCompetitorId().equals(m.getCompetitor1().getId()));
                }
                if (m.getCompetitor2() != null) {
                    m.getCompetitor2().setWinner(winner.getCompetitorId().equals(m.getCompetitor2().getId()));
                }
            }
            return m;
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/add-match"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse addMatch(HttpServletResponse response, @RequestBody AddMatchData addMatchData, @RequestParam(value="categoryId") Long categoryId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        if (category.getType() != Category.Type.CUSTOM) {
            throw new RuntimeException("Category type is not custom");
        }
        if (addMatchData.getCompetitor1id() != null && addMatchData.getCompetitor2id() != null && addMatchData.getType() != null) {
            Competitor competitor1 = null;
            Competitor competitor2 = null;
            for (Competitor competitor : this.getManagersList().getCompetitorManager().getCompetitorsForCategory(category)) {
                if (competitor.getCompetitorId().equals(addMatchData.getCompetitor1id())) {
                    competitor1 = competitor;
                }
                if (!competitor.getCompetitorId().equals(addMatchData.getCompetitor2id())) continue;
                competitor2 = competitor;
            }
            if (competitor1 != null || competitor2 != null) {
                si.nevensrok.jtekma.common.matches.Match match = new si.nevensrok.jtekma.common.matches.Match();
                match.setCompetitor1(competitor1);
                match.setCompetitor2(competitor2);
                match.setNoWinner(Boolean.valueOf(false));
                match.setStatus(Match.Status.WAITING);
                match.setType(addMatchData.getType());
                match.setNotNeeded(Boolean.valueOf(false));
                match.setMatchEmpty(Boolean.valueOf(false));
                match = this.getManagersList().getCategoryTreeUpdateManager().addMatch(category, match);
                return new CommonResponse(true);
            }
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/remove-match/{matchId}"})
    @ResponseBody
    public CommonResponse removeMatch(HttpServletResponse response, @PathVariable(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            if (category.getType() != Category.Type.CUSTOM) {
                throw new RuntimeException("Category type is not custom");
            }
            this.getManagersList().getMatchManager().deleteMatch(match);
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/fight-points"}, method={RequestMethod.GET})
    @ResponseBody
    public FightPoints getFightPoints(HttpServletResponse response, @RequestParam(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            match.setCategory(category);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
            Match m = new Match(match);
            FightPoints fightPoints = new FightPoints();
            fightPoints.setRules(competitionRules.getName());
            fightPoints.setNoWinner(match.getNoWinner());
            fightPoints.setFinished(match.getStatus() == Match.Status.FINISHED);
            fightPoints.setMatchTime(match.getFightTimeLeft());
            fightPoints.setHosekomiTime(match.getHosekomiTime());
            fightPoints.setInjuryTime1(match.getInjuryTime1());
            fightPoints.setInjuryTime2(match.getInjuryTime2());
            fightPoints.setChallengesWon1(match.getChallengesWon1());
            fightPoints.setChallengesWon2(match.getChallengesWon2());
            fightPoints.setChallengesLost1(match.getChallengesLost1());
            fightPoints.setChallengesLost2(match.getChallengesLost2());
            if (m.getCompetitor1() != null) {
                fightPoints.setCompetitor1(m.getCompetitor1().getName());
                fightPoints.setClub1(m.getCompetitor1().getClubName());
            }
            if (m.getCompetitor2() != null) {
                fightPoints.setCompetitor2(m.getCompetitor2().getName());
                fightPoints.setClub2(m.getCompetitor2().getClubName());
            }
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            for (MatchPoint matchPoint : points) {
                if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                    if (matchPoint.getPointType() == PointType.WAZARI) {
                        fightPoints.setWazari1(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.IPPON1) {
                        fightPoints.setIppon1_1(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.IPPON2) {
                        fightPoints.setIppon1_2(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.IPPON3) {
                        fightPoints.setIppon1_3(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.SHIDO) {
                        fightPoints.setShido1(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.CHUI) {
                        fightPoints.setChui1(Math.round(matchPoint.getPoints().floatValue()));
                    } else if (matchPoint.getPointType() == PointType.HANSOKUMAKE) {
                        fightPoints.setHansokumake1(Math.round(matchPoint.getPoints().floatValue()));
                    }
                    if (competitionRules instanceof CompetitionRules2023) {
                        if (matchPoint.getPointType() == PointType.IPPON1_3P) {
                            fightPoints.setIppon1_1_3p(Math.round(matchPoint.getPoints().floatValue()));
                            continue;
                        }
                        if (matchPoint.getPointType() == PointType.IPPON2_3P) {
                            fightPoints.setIppon1_2_3p(Math.round(matchPoint.getPoints().floatValue()));
                            continue;
                        }
                        if (matchPoint.getPointType() != PointType.IPPON3_3P) continue;
                        fightPoints.setIppon1_3_3p(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() != PointType.IPPON3POINTS) continue;
                    fightPoints.setIppon1_3_3p(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                if (matchPoint.getPointType() == PointType.WAZARI) {
                    fightPoints.setWazari2(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.IPPON1) {
                    fightPoints.setIppon2_1(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.IPPON2) {
                    fightPoints.setIppon2_2(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.IPPON3) {
                    fightPoints.setIppon2_3(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.SHIDO) {
                    fightPoints.setShido2(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.CHUI) {
                    fightPoints.setChui2(Math.round(matchPoint.getPoints().floatValue()));
                } else if (matchPoint.getPointType() == PointType.HANSOKUMAKE) {
                    fightPoints.setHansokumake2(Math.round(matchPoint.getPoints().floatValue()));
                }
                if (competitionRules instanceof CompetitionRules2023) {
                    if (matchPoint.getPointType() == PointType.IPPON1_3P) {
                        fightPoints.setIppon2_1_3p(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.IPPON2_3P) {
                        fightPoints.setIppon2_2_3p(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() != PointType.IPPON3_3P) continue;
                    fightPoints.setIppon2_3_3p(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() != PointType.IPPON3POINTS) continue;
                fightPoints.setIppon2_3_3p(Math.round(matchPoint.getPoints().floatValue()));
            }
            return fightPoints;
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/fight-points"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse setFightPoints(HttpServletResponse response, @RequestBody FightPoints fightPoints, @RequestParam(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
            LinkedHashSet<MatchPoint> points = new LinkedHashSet<MatchPoint>();
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.WAZARI).setPoints(Float.valueOf(fightPoints.getWazari1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON1).setPoints(Float.valueOf(fightPoints.getIppon1_1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON2).setPoints(Float.valueOf(fightPoints.getIppon1_2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON3).setPoints(Float.valueOf(fightPoints.getIppon1_3().floatValue()));
            if (competitionRules instanceof CompetitionRules2023) {
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON1_3P).setPoints(Float.valueOf(fightPoints.getIppon1_1_3p().floatValue()));
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON2_3P).setPoints(Float.valueOf(fightPoints.getIppon1_2_3p().floatValue()));
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON3_3P).setPoints(Float.valueOf(fightPoints.getIppon1_3_3p().floatValue()));
            } else {
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.IPPON3POINTS).setPoints(Float.valueOf(fightPoints.getIppon1_3_3p().floatValue()));
            }
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.SHIDO).setPoints(Float.valueOf(fightPoints.getShido1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.CHUI).setPoints(Float.valueOf(fightPoints.getChui1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.HANSOKUMAKE).setPoints(Float.valueOf(fightPoints.getHansokumake1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.WAZARI).setPoints(Float.valueOf(fightPoints.getWazari2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON1).setPoints(Float.valueOf(fightPoints.getIppon2_1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON2).setPoints(Float.valueOf(fightPoints.getIppon2_2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON3).setPoints(Float.valueOf(fightPoints.getIppon2_3().floatValue()));
            if (competitionRules instanceof CompetitionRules2023) {
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON1_3P).setPoints(Float.valueOf(fightPoints.getIppon2_1_3p().floatValue()));
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON2_3P).setPoints(Float.valueOf(fightPoints.getIppon2_2_3p().floatValue()));
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON3_3P).setPoints(Float.valueOf(fightPoints.getIppon2_3_3p().floatValue()));
            } else {
                MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.IPPON3POINTS).setPoints(Float.valueOf(fightPoints.getIppon2_3_3p().floatValue()));
            }
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.SHIDO).setPoints(Float.valueOf(fightPoints.getShido2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.CHUI).setPoints(Float.valueOf(fightPoints.getChui2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.HANSOKUMAKE).setPoints(Float.valueOf(fightPoints.getHansokumake2().floatValue()));
            this.getManagersList().getMatchManager().setMatchPointsForMatch(match, points);
            match.setNoWinner(Boolean.valueOf(Boolean.TRUE.equals(fightPoints.getNoWinner())));
            this.getManagersList().getMatchManager().setNoWinner(match);
            if (fightPoints.getFinished() != null && fightPoints.getFinished().booleanValue()) {
                if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.INPROGRESS || match.getStatus() == Match.Status.INQUEUE || match.getStatus() == Match.Status.FINISHED) {
                    this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.FINISHED);
                }
            } else if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.FINISHED) {
                this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.WAITING);
            }
            if (fightPoints.getMatchTime() != null && fightPoints.getMatchTime() >= 0) {
                match.setFightTimeLeft(fightPoints.getMatchTime());
            } else {
                match.setFightTimeLeft(null);
            }
            this.getManagersList().getMatchManager().setFightTimeLeft(match);
            if (fightPoints.getHosekomiTime() != null && fightPoints.getHosekomiTime() >= 0) {
                match.setHosekomiTime(fightPoints.getHosekomiTime());
            } else {
                match.setHosekomiTime(null);
            }
            this.getManagersList().getMatchManager().setHosekomiTime(match);
            if (fightPoints.getInjuryTime1() != null && fightPoints.getInjuryTime1() >= 0) {
                match.setInjuryTime1(fightPoints.getInjuryTime1());
            } else {
                match.setInjuryTime1(null);
            }
            if (fightPoints.getInjuryTime2() != null && fightPoints.getInjuryTime2() >= 0) {
                match.setInjuryTime2(fightPoints.getInjuryTime2());
            } else {
                match.setInjuryTime2(null);
            }
            this.getManagersList().getMatchManager().setInjuryTime(match);
            if (fightPoints.getChallengesWon1() != null && fightPoints.getChallengesWon1() >= 0) {
                match.setChallengesWon1(fightPoints.getChallengesWon1());
            } else {
                match.setChallengesWon1(Integer.valueOf(0));
            }
            if (fightPoints.getChallengesWon2() != null && fightPoints.getChallengesWon2() >= 0) {
                match.setChallengesWon2(fightPoints.getChallengesWon2());
            } else {
                match.setChallengesWon2(Integer.valueOf(0));
            }
            if (fightPoints.getChallengesLost1() != null && fightPoints.getChallengesLost1() >= 0) {
                match.setChallengesLost1(fightPoints.getChallengesLost1());
            } else {
                match.setChallengesLost1(Integer.valueOf(0));
            }
            if (fightPoints.getChallengesLost2() != null && fightPoints.getChallengesLost2() >= 0) {
                match.setChallengesLost2(fightPoints.getChallengesLost2());
            } else {
                match.setChallengesLost2(Integer.valueOf(0));
            }
            this.getManagersList().getMatchManager().setChallenges(match);
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/duo-points"}, method={RequestMethod.GET})
    @ResponseBody
    public DuoPoints getDuoPoints(HttpServletResponse response, @RequestParam(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            match.setCategory(category);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            Match m = new Match(match);
            DuoPoints duoPoints = new DuoPoints();
            duoPoints.setNoWinner(match.getNoWinner());
            duoPoints.setFinished(match.getStatus() == Match.Status.FINISHED);
            duoPoints.setInjuryTime1(match.getInjuryTime1());
            duoPoints.setInjuryTime2(match.getInjuryTime2());
            duoPoints.setChallengesWon1(match.getChallengesWon1());
            duoPoints.setChallengesWon2(match.getChallengesWon2());
            duoPoints.setChallengesLost1(match.getChallengesLost1());
            duoPoints.setChallengesLost2(match.getChallengesLost2());
            if (m.getCompetitor1() != null) {
                duoPoints.setCompetitor1(m.getCompetitor1().getName());
                duoPoints.setClub1(m.getCompetitor1().getClubName());
            }
            if (m.getCompetitor2() != null) {
                duoPoints.setCompetitor2(m.getCompetitor2().getName());
                duoPoints.setClub2(m.getCompetitor2().getClubName());
            }
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            for (MatchPoint matchPoint : points) {
                if (matchPoint.getPointType() != PointType.JUDGE) continue;
                int round = matchPoint.getRound() - 1;
                int judge = matchPoint.getJudge() - 1;
                if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                    duoPoints.getRounds1()[round].getJudges()[judge].setPoints(matchPoint.getPoints());
                    continue;
                }
                if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                duoPoints.getRounds2()[round].getJudges()[judge].setPoints(matchPoint.getPoints());
            }
            return duoPoints;
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/duo-points"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse setDuoPoints(HttpServletResponse response, @RequestBody DuoPoints duoPoints, @RequestParam(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            LinkedHashSet<MatchPoint> points = new LinkedHashSet<MatchPoint>();
            for (int round = 1; round <= 5; ++round) {
                for (int judge = 1; judge <= 5; ++judge) {
                    MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, round, judge).setPoints(duoPoints.getRounds1()[round - 1].getJudges()[judge - 1].getPoints());
                    MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, round, judge).setPoints(duoPoints.getRounds2()[round - 1].getJudges()[judge - 1].getPoints());
                }
            }
            this.getManagersList().getMatchManager().setMatchPointsForMatch(match, points);
            match.setNoWinner(Boolean.valueOf(Boolean.TRUE.equals(duoPoints.getNoWinner())));
            this.getManagersList().getMatchManager().setNoWinner(match);
            if (duoPoints.getFinished() != null && duoPoints.getFinished().booleanValue()) {
                if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.INPROGRESS || match.getStatus() == Match.Status.INQUEUE || match.getStatus() == Match.Status.FINISHED) {
                    this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.FINISHED);
                }
            } else if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.FINISHED) {
                this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.WAITING);
            }
            if (duoPoints.getInjuryTime1() != null && duoPoints.getInjuryTime1() >= 0) {
                match.setInjuryTime1(duoPoints.getInjuryTime1());
            } else {
                match.setInjuryTime1(null);
            }
            if (duoPoints.getInjuryTime2() != null && duoPoints.getInjuryTime2() >= 0) {
                match.setInjuryTime2(duoPoints.getInjuryTime2());
            } else {
                match.setInjuryTime2(null);
            }
            this.getManagersList().getMatchManager().setInjuryTime(match);
            if (duoPoints.getChallengesWon1() != null && duoPoints.getChallengesWon1() >= 0) {
                match.setChallengesWon1(duoPoints.getChallengesWon1());
            } else {
                match.setChallengesWon1(Integer.valueOf(0));
            }
            if (duoPoints.getChallengesWon2() != null && duoPoints.getChallengesWon2() >= 0) {
                match.setChallengesWon2(duoPoints.getChallengesWon2());
            } else {
                match.setChallengesWon2(Integer.valueOf(0));
            }
            if (duoPoints.getChallengesLost1() != null && duoPoints.getChallengesLost1() >= 0) {
                match.setChallengesLost1(duoPoints.getChallengesLost1());
            } else {
                match.setChallengesLost1(Integer.valueOf(0));
            }
            if (duoPoints.getChallengesLost2() != null && duoPoints.getChallengesLost2() >= 0) {
                match.setChallengesLost2(duoPoints.getChallengesLost2());
            } else {
                match.setChallengesLost2(Integer.valueOf(0));
            }
            this.getManagersList().getMatchManager().setChallenges(match);
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/newaza-points"}, method={RequestMethod.GET})
    @ResponseBody
    public NewazaPoints getNewazaPoints(HttpServletResponse response, @RequestParam(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            match.setCategory(category);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            Match m = new Match(match);
            NewazaPoints newazaPoints = new NewazaPoints();
            newazaPoints.setNoWinner(match.getNoWinner());
            newazaPoints.setFinished(match.getStatus() == Match.Status.FINISHED);
            newazaPoints.setMatchTime(match.getFightTimeLeft());
            newazaPoints.setHosekomiTime(match.getHosekomiTime());
            newazaPoints.setInjuryTime1(match.getInjuryTime1());
            newazaPoints.setInjuryTime2(match.getInjuryTime2());
            newazaPoints.setChallengesWon1(match.getChallengesWon1());
            newazaPoints.setChallengesWon2(match.getChallengesWon2());
            newazaPoints.setChallengesLost1(match.getChallengesLost1());
            newazaPoints.setChallengesLost2(match.getChallengesLost2());
            if (m.getCompetitor1() != null) {
                newazaPoints.setCompetitor1(m.getCompetitor1().getName());
                newazaPoints.setClub1(m.getCompetitor1().getClubName());
            }
            if (m.getCompetitor2() != null) {
                newazaPoints.setCompetitor2(m.getCompetitor2().getName());
                newazaPoints.setClub2(m.getCompetitor2().getClubName());
            }
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            for (MatchPoint matchPoint : points) {
                if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                    if (matchPoint.getPointType() == PointType.POINT2) {
                        newazaPoints.setPoint1_2(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.POINT3) {
                        newazaPoints.setPoint1_3(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.POINT4) {
                        newazaPoints.setPoint1_4(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.POINT100) {
                        newazaPoints.setPoint1_100(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.ADVANTAGE) {
                        newazaPoints.setAdvantage1(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() == PointType.PENALTY) {
                        newazaPoints.setPenalty1(Math.round(matchPoint.getPoints().floatValue()));
                        continue;
                    }
                    if (matchPoint.getPointType() != PointType.HANSOKUMAKE) continue;
                    newazaPoints.setHansokumake1(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                if (matchPoint.getPointType() == PointType.POINT2) {
                    newazaPoints.setPoint2_2(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() == PointType.POINT3) {
                    newazaPoints.setPoint2_3(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() == PointType.POINT4) {
                    newazaPoints.setPoint2_4(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() == PointType.POINT100) {
                    newazaPoints.setPoint2_100(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() == PointType.ADVANTAGE) {
                    newazaPoints.setAdvantage2(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() == PointType.PENALTY) {
                    newazaPoints.setPenalty2(Math.round(matchPoint.getPoints().floatValue()));
                    continue;
                }
                if (matchPoint.getPointType() != PointType.HANSOKUMAKE) continue;
                newazaPoints.setHansokumake2(Math.round(matchPoint.getPoints().floatValue()));
            }
            return newazaPoints;
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/newaza-points"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse setNewazaPoints(HttpServletResponse response, @RequestBody NewazaPoints newazaPoints, @RequestParam(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            LinkedHashSet<MatchPoint> points = new LinkedHashSet<MatchPoint>();
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.POINT2).setPoints(Float.valueOf(newazaPoints.getPoint1_2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.POINT3).setPoints(Float.valueOf(newazaPoints.getPoint1_3().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.POINT4).setPoints(Float.valueOf(newazaPoints.getPoint1_4().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.POINT100).setPoints(Float.valueOf(newazaPoints.getPoint1_100().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.ADVANTAGE).setPoints(Float.valueOf(newazaPoints.getAdvantage1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.PENALTY).setPoints(Float.valueOf(newazaPoints.getPenalty1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, PointType.HANSOKUMAKE).setPoints(Float.valueOf(newazaPoints.getHansokumake1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.POINT2).setPoints(Float.valueOf(newazaPoints.getPoint2_2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.POINT3).setPoints(Float.valueOf(newazaPoints.getPoint2_3().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.POINT4).setPoints(Float.valueOf(newazaPoints.getPoint2_4().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.POINT100).setPoints(Float.valueOf(newazaPoints.getPoint2_100().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.ADVANTAGE).setPoints(Float.valueOf(newazaPoints.getAdvantage2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.PENALTY).setPoints(Float.valueOf(newazaPoints.getPenalty2().floatValue()));
            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, PointType.HANSOKUMAKE).setPoints(Float.valueOf(newazaPoints.getHansokumake2().floatValue()));
            this.getManagersList().getMatchManager().setMatchPointsForMatch(match, points);
            match.setNoWinner(Boolean.valueOf(Boolean.TRUE.equals(newazaPoints.getNoWinner())));
            this.getManagersList().getMatchManager().setNoWinner(match);
            if (newazaPoints.getFinished() != null && newazaPoints.getFinished().booleanValue()) {
                if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.INPROGRESS || match.getStatus() == Match.Status.INQUEUE || match.getStatus() == Match.Status.FINISHED) {
                    this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.FINISHED);
                }
            } else if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.FINISHED) {
                this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.WAITING);
            }
            if (newazaPoints.getMatchTime() != null && newazaPoints.getMatchTime() >= 0) {
                match.setFightTimeLeft(newazaPoints.getMatchTime());
            } else {
                match.setFightTimeLeft(null);
            }
            this.getManagersList().getMatchManager().setFightTimeLeft(match);
            if (newazaPoints.getHosekomiTime() != null && newazaPoints.getHosekomiTime() >= 0) {
                match.setHosekomiTime(newazaPoints.getHosekomiTime());
            } else {
                match.setHosekomiTime(null);
            }
            this.getManagersList().getMatchManager().setHosekomiTime(match);
            if (newazaPoints.getInjuryTime1() != null && newazaPoints.getInjuryTime1() >= 0) {
                match.setInjuryTime1(newazaPoints.getInjuryTime1());
            } else {
                match.setInjuryTime1(null);
            }
            if (newazaPoints.getInjuryTime2() != null && newazaPoints.getInjuryTime2() >= 0) {
                match.setInjuryTime2(newazaPoints.getInjuryTime2());
            } else {
                match.setInjuryTime2(null);
            }
            this.getManagersList().getMatchManager().setInjuryTime(match);
            if (newazaPoints.getChallengesWon1() != null && newazaPoints.getChallengesWon1() >= 0) {
                match.setChallengesWon1(newazaPoints.getChallengesWon1());
            } else {
                match.setChallengesWon1(Integer.valueOf(0));
            }
            if (newazaPoints.getChallengesWon2() != null && newazaPoints.getChallengesWon2() >= 0) {
                match.setChallengesWon2(newazaPoints.getChallengesWon2());
            } else {
                match.setChallengesWon2(Integer.valueOf(0));
            }
            if (newazaPoints.getChallengesLost1() != null && newazaPoints.getChallengesLost1() >= 0) {
                match.setChallengesLost1(newazaPoints.getChallengesLost1());
            } else {
                match.setChallengesLost1(Integer.valueOf(0));
            }
            if (newazaPoints.getChallengesLost2() != null && newazaPoints.getChallengesLost2() >= 0) {
                match.setChallengesLost2(newazaPoints.getChallengesLost2());
            } else {
                match.setChallengesLost2(Integer.valueOf(0));
            }
            this.getManagersList().getMatchManager().setChallenges(match);
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/duo-2023-points"}, method={RequestMethod.GET})
    @ResponseBody
    public Duo2023Points getDuo2023Points(HttpServletResponse response, @RequestParam(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            match.setCategory(category);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
            if (competitionRules == null) {
                throw new RuntimeException("CompetitionRules for competition not found");
            }
            AgeCategoryOption ageCategoryOption = null;
            if (category instanceof Duo2023Category) {
                ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getForCategory((Duo2023Category)category);
            }
            Match m = new Match(match);
            int round = 4;
            if (match.getFightNumber() == 3 || match.getFightNumber() == 4 || match.getFightNumber() == 7 || match.getFightNumber() == 8) {
                round = 5;
            }
            Duo2023Points duo2023Points = new Duo2023Points();
            duo2023Points.setNoWinner(match.getNoWinner());
            duo2023Points.setFinished(match.getStatus() == Match.Status.FINISHED);
            duo2023Points.setInjuryTime1(match.getInjuryTime1());
            duo2023Points.setInjuryTime2(match.getInjuryTime2());
            duo2023Points.setChallengesWon1(match.getChallengesWon1());
            duo2023Points.setChallengesWon2(match.getChallengesWon2());
            duo2023Points.setChallengesLost1(match.getChallengesLost1());
            duo2023Points.setChallengesLost2(match.getChallengesLost2());
            duo2023Points.setAttacks(new ArrayList<DuoPresentationAttack>(competitionRules.getDuoPresentationAttacks(ageCategoryOption, round)));
            if (m.getCompetitor1() != null) {
                duo2023Points.setCompetitor1(m.getCompetitor1().getName());
                duo2023Points.setClub1(m.getCompetitor1().getClubName());
            }
            if (m.getCompetitor2() != null) {
                duo2023Points.setCompetitor2(m.getCompetitor2().getName());
                duo2023Points.setClub2(m.getCompetitor2().getClubName());
            }
            Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            duo2023Points.setPoints1(new LinkedList<DuoPresentationAttackPoint>());
            duo2023Points.setPoints2(new LinkedList<DuoPresentationAttackPoint>());
            for (MatchPoint matchPoint : points) {
                if (matchPoint.getPointType() == PointType.PENALTY) {
                    if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                        duo2023Points.setPenalty1(matchPoint.getPoints().intValue());
                        continue;
                    }
                    if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                    duo2023Points.setPenalty2(matchPoint.getPoints().intValue());
                    continue;
                }
                if (matchPoint.getPointType() == PointType.VARIETY_SCORE_POINTS) {
                    if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                        if (matchPoint.getPart() != null && matchPoint.getPart() == 3) {
                            duo2023Points.setVariety1P3(matchPoint.getPoints().intValue());
                            continue;
                        }
                        if (matchPoint.getPart() == null || matchPoint.getPart() != 4) continue;
                        duo2023Points.setVariety1P4(matchPoint.getPoints().intValue());
                        continue;
                    }
                    if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                    if (matchPoint.getPart() != null && matchPoint.getPart() == 3) {
                        duo2023Points.setVariety2P3(matchPoint.getPoints().intValue());
                        continue;
                    }
                    if (matchPoint.getPart() == null || matchPoint.getPart() != 4) continue;
                    duo2023Points.setVariety2P4(matchPoint.getPoints().intValue());
                    continue;
                }
                if (matchPoint.getPointType() != PointType.JUDGE) continue;
                if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                    duo2023Points.getPoints1().add(new DuoPresentationAttackPoint(matchPoint.getJudge(), matchPoint.getSeries(), matchPoint.getAttack(), matchPoint.getPart(), matchPoint.getPoints().intValue()));
                    continue;
                }
                if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                duo2023Points.getPoints2().add(new DuoPresentationAttackPoint(matchPoint.getJudge(), matchPoint.getSeries(), matchPoint.getAttack(), matchPoint.getPart(), matchPoint.getPoints().intValue()));
            }
            return duo2023Points;
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/duo-2023-points"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse setDuo2023Points(HttpServletResponse response, @RequestBody Duo2023Points duo2023Points, @RequestParam(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
            if (competitionRules == null) {
                throw new RuntimeException("CompetitionRules for competition not found");
            }
            AgeCategoryOption ageCategoryOption = null;
            if (category instanceof Duo2023Category) {
                ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getForCategory((Duo2023Category)category);
            }
            int round = 4;
            if (match.getFightNumber() == 3 || match.getFightNumber() == 4 || match.getFightNumber() == 7 || match.getFightNumber() == 8) {
                round = 5;
            }
            LinkedHashSet<MatchPoint> points = new LinkedHashSet<MatchPoint>();
            MatchPointsUtil.getOrCreateDuoPresentationVarietyPoint(points, CompetitorType.COMPETITOR1, 3).setPoints(Float.valueOf(duo2023Points.getVariety1P3().floatValue()));
            MatchPointsUtil.getOrCreateDuoPresentationVarietyPoint(points, CompetitorType.COMPETITOR1, 4).setPoints(Float.valueOf(duo2023Points.getVariety1P4().floatValue()));
            MatchPointsUtil.getOrCreateDuoPresentationVarietyPoint(points, CompetitorType.COMPETITOR2, 3).setPoints(Float.valueOf(duo2023Points.getVariety2P3().floatValue()));
            MatchPointsUtil.getOrCreateDuoPresentationVarietyPoint(points, CompetitorType.COMPETITOR2, 4).setPoints(Float.valueOf(duo2023Points.getVariety2P4().floatValue()));
            MatchPointsUtil.getOrCreateMatchPenaltyPoint(points, CompetitorType.COMPETITOR1).setPoints(Float.valueOf(duo2023Points.getPenalty1().floatValue()));
            MatchPointsUtil.getOrCreateMatchPenaltyPoint(points, CompetitorType.COMPETITOR2).setPoints(Float.valueOf(duo2023Points.getPenalty2().floatValue()));
            for (DuoPresentationAttack duoPresentationAttack : competitionRules.getDuoPresentationAttacks(ageCategoryOption, round)) {
                for (int judge = 1; judge <= 3; ++judge) {
                    for (int part = 1; part <= 5; ++part) {
                        DuoPresentationAttackPoint duoPresentationAttackPoint2;
                        DuoPresentationAttackPoint duoPresentationAttackPoint1;
                        int j = judge;
                        int p = part;
                        if (CollectionUtil.isNotEmpty(duo2023Points.getPoints1()) && (duoPresentationAttackPoint1 = (DuoPresentationAttackPoint)duo2023Points.getPoints1().stream().filter(ap -> ap.getSeries().name().equals(duoPresentationAttack.getSeries().name()) && ap.getAttack().equals(duoPresentationAttack.getAttack()) && ap.getJudge() == j && ap.getPart() == p).findFirst().orElse(null)) != null) {
                            MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR1, judge, Series.valueOf((String)duoPresentationAttack.getSeries().name()), duoPresentationAttackPoint1.getAttack(), part).setPoints(Float.valueOf(duoPresentationAttackPoint1.getPoints().floatValue()));
                        }
                        if (!CollectionUtil.isNotEmpty(duo2023Points.getPoints2()) || (duoPresentationAttackPoint2 = (DuoPresentationAttackPoint)duo2023Points.getPoints2().stream().filter(ap -> ap.getSeries().name().equals(duoPresentationAttack.getSeries().name()) && ap.getAttack().equals(duoPresentationAttack.getAttack()) && ap.getJudge() == j && ap.getPart() == p).findFirst().orElse(null)) == null) continue;
                        MatchPointsUtil.getOrCreateMatchPoint(points, CompetitorType.COMPETITOR2, judge, Series.valueOf((String)duoPresentationAttack.getSeries().name()), duoPresentationAttackPoint2.getAttack(), part).setPoints(Float.valueOf(duoPresentationAttackPoint2.getPoints().floatValue()));
                    }
                }
            }
            boolean pointsEmpty = true;
            for (MatchPoint matchPoint : points) {
                if (!(matchPoint.getPoints().floatValue() > 0.0f)) continue;
                pointsEmpty = false;
                break;
            }
            if (pointsEmpty) {
                points.clear();
            }
            this.getManagersList().getMatchManager().setMatchPointsForMatch(match, points);
            if (pointsEmpty) {
                this.getManagersList().getMatchManager().setMatchGradings(match, new LinkedList());
                this.getManagersList().getMatchManager().setValidAttacksForMatch(match, new HashSet());
            }
            match.setNoWinner(Boolean.valueOf(Boolean.TRUE.equals(duo2023Points.getNoWinner())));
            this.getManagersList().getMatchManager().setNoWinner(match);
            if (duo2023Points.getFinished() != null && duo2023Points.getFinished().booleanValue()) {
                if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.INPROGRESS || match.getStatus() == Match.Status.INQUEUE || match.getStatus() == Match.Status.FINISHED) {
                    this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.FINISHED);
                }
            } else if (match.getStatus() == Match.Status.WAITING || match.getStatus() == Match.Status.FINISHED) {
                this.getManagersList().getMatchManager().setMatchStatus(match, Match.Status.WAITING);
            }
            if (duo2023Points.getInjuryTime1() != null && duo2023Points.getInjuryTime1() >= 0) {
                match.setInjuryTime1(duo2023Points.getInjuryTime1());
            } else {
                match.setInjuryTime1(null);
            }
            if (duo2023Points.getInjuryTime2() != null && duo2023Points.getInjuryTime2() >= 0) {
                match.setInjuryTime2(duo2023Points.getInjuryTime2());
            } else {
                match.setInjuryTime2(null);
            }
            this.getManagersList().getMatchManager().setInjuryTime(match);
            if (duo2023Points.getChallengesWon1() != null && duo2023Points.getChallengesWon1() >= 0) {
                match.setChallengesWon1(duo2023Points.getChallengesWon1());
            } else {
                match.setChallengesWon1(Integer.valueOf(0));
            }
            if (duo2023Points.getChallengesWon2() != null && duo2023Points.getChallengesWon2() >= 0) {
                match.setChallengesWon2(duo2023Points.getChallengesWon2());
            } else {
                match.setChallengesWon2(Integer.valueOf(0));
            }
            if (duo2023Points.getChallengesLost1() != null && duo2023Points.getChallengesLost1() >= 0) {
                match.setChallengesLost1(duo2023Points.getChallengesLost1());
            } else {
                match.setChallengesLost1(Integer.valueOf(0));
            }
            if (duo2023Points.getChallengesLost2() != null && duo2023Points.getChallengesLost2() >= 0) {
                match.setChallengesLost2(duo2023Points.getChallengesLost2());
            } else {
                match.setChallengesLost2(Integer.valueOf(0));
            }
            this.getManagersList().getMatchManager().setChallenges(match);
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/match-details/{matchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ReportChartData<Float> getMatchDetails(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="matchId") Long matchId) {
        ReportChartData<Float> reportChartData;
        block13: {
            si.nevensrok.jtekma.common.matches.Match match;
            Locale locale;
            block14: {
                ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
                locale = RequestContextUtils.getLocale((HttpServletRequest)request);
                reportChartData = new ReportChartData<Float>();
                match = this.getManagersList().getMatchManager().getByIdWithCompetitors(matchId);
                if (match == null) break block13;
                Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
                match.setCategory(category);
                Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
                if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                    throw new ForbiddenException("Invalid competition for category");
                }
                reportChartData.setChartData(new ArrayList());
                reportChartData.setCategories(new LinkedList<String>());
                reportChartData.setyAxisLabel(this.getLanguageText(locale, "competition.chart.points"));
                if (match.getType() != Match.Type.FIGHT && match.getType() != Match.Type.NEWAZA) break block14;
                reportChartData.setChartType("line");
                reportChartData.setxAxisLabel(this.getLanguageText(locale, "competition.chart.time"));
                reportChartData.setTooltipText(this.getLanguageText(locale, "competition.chart.tooltipForTime"));
                List reportDatas = this.getManagersList().getMatchManager().getPointsReportForFightMatch(match);
                for (int i = 0; i < 2; ++i) {
                    Object competitor;
                    ReportData reportData = (ReportData)reportDatas.get(i);
                    ChartData chartData = new ChartData();
                    reportChartData.getChartData().add(chartData);
                    chartData.setName("");
                    if (i == 0) {
                        competitor = match.getCompetitor1();
                        if (competitor != null) {
                            chartData.setName(CompetitorNameUtil.getCompetitorFullName((Competitor)competitor));
                        }
                    } else if (i == 1 && (competitor = match.getCompetitor2()) != null) {
                        chartData.setName(CompetitorNameUtil.getCompetitorFullName((Competitor)competitor));
                    }
                    chartData.setData(new LinkedList());
                    competitor = reportData.getData().iterator();
                    while (competitor.hasNext()) {
                        ReportData.Data data = (ReportData.Data)competitor.next();
                        chartData.getData().add(Float.valueOf(((Integer)data.getValue()).floatValue()));
                        if (i != 0) continue;
                        reportChartData.getCategories().add(((Integer)data.getIndex()).toString());
                    }
                }
                break block13;
            }
            if (match.getType() != Match.Type.DUO) break block13;
            reportChartData.setChartType("column");
            reportChartData.setxAxisLabel(this.getLanguageText(locale, "competition.chart.round"));
            reportChartData.setTooltipText(this.getLanguageText(locale, "competition.chart.tooltipForRound"));
            List reportDatas = this.getManagersList().getMatchManager().getPointsReportForDuoMatch(match);
            for (int i = 0; i < 2; ++i) {
                Competitor competitor;
                ReportData reportData = (ReportData)reportDatas.get(i);
                ChartData chartData = new ChartData();
                reportChartData.getChartData().add(chartData);
                chartData.setName("");
                if (i == 0) {
                    competitor = match.getCompetitor1();
                    if (competitor != null) {
                        chartData.setName(CompetitorNameUtil.getCompetitorFullName(competitor));
                    }
                } else if (i == 1 && (competitor = match.getCompetitor2()) != null) {
                    chartData.setName(CompetitorNameUtil.getCompetitorFullName(competitor));
                }
                chartData.setData(new LinkedList());
                for (ReportData.Data data : reportData.getData()) {
                    chartData.getData().add(data.getValue());
                    if (i != 0) continue;
                    reportChartData.getCategories().add(((Integer)data.getIndex()).toString());
                }
            }
        }
        return reportChartData;
    }
}

