/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dto.matches;

import java.io.Serializable;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.jtekma.server.dl.dto.judges.JudgeDTO;
import si.nevensrok.jtekma.server.dl.dto.judges.JudgeOnTatamiDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.DuoPresentationDTO;

@Entity
@Table(name="duo_presentation_gradings")
public class DuoPresentationGradingDTO {
    @Id
    private DuoPresentationGradingKey duoPresentationGradingKey;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="judge_id", nullable=false, updatable=false)
    private JudgeDTO judge;
    @Column(name="sent_at", nullable=false)
    private Calendar sentAt;
    @Column(name="final_result")
    private Boolean finalResult;

    public DuoPresentationGradingDTO() {
    }

    public DuoPresentationGradingDTO(DuoPresentationDTO duoPresentation, Integer judgeNum) {
        this.duoPresentationGradingKey = new DuoPresentationGradingKey(duoPresentation, judgeNum);
    }

    public DuoPresentationGradingKey getDuoPresentationGradingKey() {
        return this.duoPresentationGradingKey;
    }

    public void setDuoPresentationGradingKey(DuoPresentationGradingKey duoPresentationGradingKey) {
        this.duoPresentationGradingKey = duoPresentationGradingKey;
    }

    public JudgeDTO getJudge() {
        return this.judge;
    }

    public void setJudge(JudgeDTO judge) {
        this.judge = judge;
    }

    public Calendar getSentAt() {
        return this.sentAt;
    }

    public void setSentAt(Calendar sentAt) {
        this.sentAt = sentAt;
    }

    public Boolean getFinalResult() {
        return this.finalResult;
    }

    public void setFinalResult(Boolean finalResult) {
        this.finalResult = finalResult;
    }

    public String toString() {
        return new ObjectToString(DuoPresentationGradingDTO.class).addProperty("duoPresentationGradingKey", (Object)this.duoPresentationGradingKey).addProperty("judge", (Object)this.judge).addPropertyCalendar("sentAt", this.sentAt).addProperty("finalResult", (Object)this.finalResult).generateString();
    }

    @Embeddable
    public static class DuoPresentationGradingKey
    implements Serializable {
        private static final long serialVersionUID = -4721800740223050313L;
        @ManyToOne(fetch=FetchType.LAZY)
        @JoinColumn(name="duo_presentation_id", nullable=false, updatable=false)
        private DuoPresentationDTO duoPresentation;
        @Column(name="judge_num", nullable=false, updatable=false)
        private Integer judgeNum;

        public DuoPresentationGradingKey() {
        }

        public DuoPresentationGradingKey(DuoPresentationDTO duoPresentation, Integer judgeNum) {
            this.duoPresentation = duoPresentation;
            this.judgeNum = judgeNum;
        }

        public DuoPresentationDTO getDuoPresentation() {
            return this.duoPresentation;
        }

        public void setDuoPresentation(DuoPresentationDTO duoPresentation) {
            this.duoPresentation = duoPresentation;
        }

        public Integer getJudgeNum() {
            return this.judgeNum;
        }

        public void setJudgeNum(Integer judgeNum) {
            this.judgeNum = judgeNum;
        }

        public String toString() {
            return new ObjectToString(JudgeOnTatamiDTO.JudgeOnTatamiKey.class).addPropertyObjectHash("duoPresentation", (Object)this.duoPresentation).addProperty("judgeNum", (Object)this.judgeNum).generateString();
        }
    }
}

