/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.tatami.Event;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dl.dto.category.CategoryDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.DuoPresentationDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.MatchDTO;
import si.nevensrok.jtekma.server.dl.dto.tatami.EventDTO;
import si.nevensrok.jtekma.server.dl.dto.tatami.FightOrderDTO;
import si.nevensrok.jtekma.server.dl.dto.tatami.IsOnTatamiDTO;
import si.nevensrok.jtekma.server.dl.dto.tatami.TatamiDTO;

public class TatamiDAO
extends ExtendedDao<Long, TatamiDTO, Tatami> {
    public TatamiDAO() {
        super(TatamiDTO.class, Tatami.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("tatamiId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("name")) {
            return "name";
        }
        if (fieldName.equalsIgnoreCase("password")) {
            return "password";
        }
        if (fieldName.equalsIgnoreCase("competition")) {
            return "competition.id";
        }
        if (fieldName.equalsIgnoreCase("tabletReferees")) {
            return "tabletReferees";
        }
        if (fieldName.equalsIgnoreCase("videoReferee")) {
            return "videoReferee";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public void updateTatamiPassword(Tatami tatami) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update TatamiDTO set password=");
        sql.append(paramsBinder.addParam(tatami.getPassword()));
        sql.append(" where id=");
        sql.append(paramsBinder.addParam(tatami.getTatamiId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public Tatami getActiveTatamiByName(Competition competition, String name) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select tatami from TatamiDTO as tatami where tatami.competition.competitionId=");
        sql.append(paramsBinder.addParam(competition.getCompetitionId()));
        sql.append(" and UPPER(tatami.name)=UPPER(");
        sql.append(paramsBinder.addParam(name));
        sql.append(")");
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.setMaxResults(1);
        TatamiDTO tatamiDTO = (TatamiDTO)TatamiDAO.getSingleResult((Query)query);
        Tatami tatami = null;
        if (tatamiDTO != null) {
            tatami = (Tatami)this.getAdapterPool().create(Tatami.class, (Object)tatamiDTO);
        }
        this.flush();
        return tatami;
    }

    public void setCategoriesForTatami(Tatami tatami, Set<Category> categories) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from IsOnTatamiDTO where isOnTatamiKey.tatami.id=");
        sql.append(paramsBinder.addParam(tatami.getTatamiId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        TatamiDTO tatamiDTO = new TatamiDTO();
        tatamiDTO.setTatamiId(tatami.getTatamiId());
        for (Category category : categories) {
            CategoryDTO categoryDTO = new CategoryDTO();
            categoryDTO.setCategoryId(category.getCategoryId());
            IsOnTatamiDTO isOnTatamiDTO = new IsOnTatamiDTO(categoryDTO, tatamiDTO);
            this.getCurrentSession().save((Object)isOnTatamiDTO);
        }
        this.flush();
    }

    public Set<Category> getCategoriesForTatami(Tatami tatami) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select isOnTatami.isOnTatamiKey.category from IsOnTatamiDTO as isOnTatami where isOnTatami.isOnTatamiKey.tatami.id=");
        sql.append(paramsBinder.addParam(tatami.getTatamiId()));
        sql.append(" and isOnTatami.isOnTatamiKey.category.status=");
        sql.append(paramsBinder.addParam((Object)Category.Status.ACTIVE));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        List list = query.getResultList();
        HashSet<Category> categories = new HashSet<Category>();
        for (Object item : list) {
            Category category = (Category)this.getAdapterPool().create(Category.class, item);
            categories.add(category);
        }
        this.flush();
        return categories;
    }

    public boolean isCategoryOnTatami(Tatami tatami, Category category) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) from IsOnTatamiDTO as isOnTatami where isOnTatami.isOnTatamiKey.tatami.id=");
        sql.append(paramsBinder.addParam(tatami.getTatamiId()));
        sql.append(" and isOnTatami.isOnTatamiKey.category.id=");
        sql.append(paramsBinder.addParam(category.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        Long count = (Long)TatamiDAO.getSingleResult((Query)query);
        this.flush();
        return count > 0L;
    }

    public void setFightOrderForTatami(Tatami tatami, List<FightOrder> fightOrders) {
        TatamiDTO tatamiDTO = new TatamiDTO();
        tatamiDTO.setTatamiId(tatami.getTatamiId());
        HashSet<Integer> currentFightNumbers = new HashSet<Integer>();
        for (FightOrder fightOrder : this.getFightOrderForTatami(tatami, null)) {
            currentFightNumbers.add(fightOrder.getFightNumber());
        }
        for (FightOrder fightOrder : fightOrders) {
            currentFightNumbers.remove(fightOrder.getFightNumber());
            FightOrderDTO fightOrderDTO = new FightOrderDTO(tatamiDTO, fightOrder.getFightNumber());
            if (fightOrder.getMatch() != null && fightOrder.getMatch().getMatchId() != null) {
                MatchDTO matchDTO = new MatchDTO();
                matchDTO.setMatchId(fightOrder.getMatch().getMatchId());
                fightOrderDTO.setMatch(matchDTO);
            }
            if (fightOrder.getEvent() != null) {
                EventDTO eventDTO = (EventDTO)this.getAdapterPool().create(EventDTO.class, (Object)fightOrder.getEvent());
                fightOrderDTO.setEvent(eventDTO);
            }
            if (fightOrder.getDuoPresentation() != null) {
                DuoPresentationDTO duoPresentationDTO = new DuoPresentationDTO();
                duoPresentationDTO.setDuoPresentationId(fightOrder.getDuoPresentation().getDuoPresentationId());
                fightOrderDTO.setDuoPresentation(duoPresentationDTO);
            }
            this.getCurrentSession().saveOrUpdate((Object)fightOrderDTO);
        }
        for (Integer fightNumber : currentFightNumbers) {
            ParamsBinder paramsBinder = new ParamsBinder();
            StringBuilder sql = new StringBuilder();
            sql.append("delete from FightOrderDTO where fightOrderKey.tatami.id = ");
            sql.append(paramsBinder.addParam(tatami.getTatamiId()));
            sql.append(" and fightOrderKey.fightNumber = ");
            sql.append(paramsBinder.addParam(fightNumber));
            Query query = this.createQuery(sql.toString());
            paramsBinder.bindParams(query);
            query.executeUpdate();
        }
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from EventDTO as event where event.tatami.id = ");
        sql.append(paramsBinder.addParam(tatami.getTatamiId()));
        sql.append(" and 0 = (select count(*) from FightOrderDTO as fightOrder where fightOrder.event.id = event.id)");
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public List<FightOrder> getFightOrderForTatami(Tatami tatami, Integer count) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select fightOrder");
        sql.append(", (select match from MatchDTO as match where match.id = fightOrder.match.id) as match");
        sql.append(", (select event from EventDTO as event where event.id = fightOrder.event.id) as event");
        sql.append(", (select duoPresentation from DuoPresentationDTO as duoPresentation where duoPresentation.id = fightOrder.duoPresentation.id) as duoPresentation");
        sql.append(" from FightOrderDTO as fightOrder where fightOrder.fightOrderKey.tatami.id = ");
        sql.append(paramsBinder.addParam(tatami.getTatamiId()));
        sql.append(" order by fightOrder.fightOrderKey.fightNumber");
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        if (count != null && count > 0) {
            query.setMaxResults(count.intValue());
        }
        List list = query.getResultList();
        LinkedList<FightOrder> fightOrders = new LinkedList<FightOrder>();
        for (Object item : list) {
            Object[] parts = (Object[])item;
            FightOrderDTO fightOrderDTO = (FightOrderDTO)parts[0];
            FightOrder fightOrder = new FightOrder();
            fightOrder.setFightNumber(fightOrderDTO.getFightOrderKey().getFightNumber());
            fightOrder.setMatch((Match)this.getAdapterPool().create(Match.class, parts[1]));
            fightOrder.setEvent((Event)this.getAdapterPool().create(Event.class, parts[2]));
            fightOrder.setDuoPresentation((DuoPresentation)this.getAdapterPool().create(DuoPresentation.class, parts[3]));
            fightOrders.add(fightOrder);
        }
        this.flush();
        return fightOrders;
    }

    public Tatami getTatamiForEvent(Event event) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select event.tatami from EventDTO as event where event.id=");
        sql.append(paramsBinder.addParam(event.getEventId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.setMaxResults(1);
        TatamiDTO tatamiDTO = (TatamiDTO)TatamiDAO.getSingleResult((Query)query);
        Tatami tatami = null;
        if (tatamiDTO != null) {
            tatami = (Tatami)this.getAdapterPool().create(Tatami.class, (Object)tatamiDTO);
        }
        this.flush();
        return tatami;
    }

    public Tatami getTatamiForMatch(Match match) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select fightOrder.fightOrderKey.tatami from FightOrderDTO as fightOrder where fightOrder.match.id=");
        sql.append(paramsBinder.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.setMaxResults(1);
        TatamiDTO tatamiDTO = (TatamiDTO)TatamiDAO.getSingleResult((Query)query);
        Tatami tatami = null;
        if (tatamiDTO != null) {
            tatami = (Tatami)this.getAdapterPool().create(Tatami.class, (Object)tatamiDTO);
        }
        this.flush();
        return tatami;
    }

    public Tatami getTatamiForDuoPresentation(DuoPresentation duoPresentation) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select fightOrder.fightOrderKey.tatami from FightOrderDTO as fightOrder where fightOrder.duoPresentation.id=");
        sql.append(paramsBinder.addParam(duoPresentation.getDuoPresentationId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.setMaxResults(1);
        TatamiDTO tatamiDTO = (TatamiDTO)TatamiDAO.getSingleResult((Query)query);
        Tatami tatami = null;
        if (tatamiDTO != null) {
            tatami = (Tatami)this.getAdapterPool().create(Tatami.class, (Object)tatamiDTO);
        }
        this.flush();
        return tatami;
    }

    public Tatami getTatamiForActiveCompetition(String name) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select tatami from TatamiDTO as tatami where tatami.name=");
        sql.append(paramsBinder.addParam(name));
        sql.append(" and tatami.competition.status=");
        sql.append(paramsBinder.addParam((Object)Competition.Status.ACTIVE));
        sql.append(" order by tatami.competition.competitonDate desc");
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.setMaxResults(1);
        TatamiDTO tatamiDTO = (TatamiDTO)TatamiDAO.getSingleResult((Query)query);
        Tatami tatami = null;
        if (tatamiDTO != null) {
            tatami = (Tatami)this.getAdapterPool().create(Tatami.class, (Object)tatamiDTO);
        }
        this.flush();
        return tatami;
    }

    public Map<Category, Set<Tatami>> getTatamisForCategories(Set<Category> categories) {
        HashMap<Category, Set<Tatami>> tatamis = new HashMap<Category, Set<Tatami>>();
        for (Category category : categories) {
            LinkedHashSet<Tatami> tatamiList = new LinkedHashSet<Tatami>();
            tatamis.put(category, tatamiList);
            ParamsBinder paramsBinder = new ParamsBinder();
            StringBuilder sql = new StringBuilder();
            sql.append("select isOnTatami.isOnTatamiKey.tatami from IsOnTatamiDTO as isOnTatami where isOnTatami.isOnTatamiKey.category.categoryId=");
            sql.append(paramsBinder.addParam(category.getCategoryId()));
            Query query = this.createQuery(sql.toString());
            paramsBinder.bindParams(query);
            List list = query.getResultList();
            for (TatamiDTO tatamiDTO : list) {
                Tatami tatami = (Tatami)this.getAdapterPool().create(Tatami.class, (Object)tatamiDTO);
                tatamiList.add(tatami);
            }
        }
        this.flush();
        return tatamis;
    }

    public List<Tatami> getTatamisForJudge(Judge judge) {
        LinkedList<Tatami> tatamis = new LinkedList<Tatami>();
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select jot.judgeOnTatamiKey.tatami from JudgeOnTatamiDTO as jot where jot.judgeOnTatamiKey.judge.judgeId = ");
        sql.append(paramsBinder.addParam(judge.getJudgeId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        List list = query.getResultList();
        for (TatamiDTO tatamiDTO : list) {
            Tatami tatami = (Tatami)this.getAdapterPool().create(Tatami.class, (Object)tatamiDTO);
            tatamis.add(tatami);
        }
        this.flush();
        return tatamis;
    }
}

