/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.CoreDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.common.dl.adapters.database.DatabaseAdapterPool;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchGrading;
import si.nevensrok.jtekma.server.dl.dto.judges.JudgeDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.MatchDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.MatchGradingDTO;

public class MatchGradingDAO
extends CoreDao {
    protected DatabaseAdapterPool adapterPool;

    public void setDatabaseAdapterPool(DatabaseAdapterPool adapterPool) {
        this.adapterPool = adapterPool;
    }

    public DatabaseAdapterPool getAdapterPool() {
        return this.adapterPool;
    }

    public MatchGrading getMatchGrading(Match match, Judge judge) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select mg from MatchGradingDTO as mg where mg.matchGradingKey.match.matchId = ");
        sql.append(paramsBinder.addParam(match.getMatchId()));
        sql.append(" and mg.judge.judgeId = ");
        sql.append(paramsBinder.addParam(judge.getJudgeId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        MatchGradingDTO matchGradingDTO = (MatchGradingDTO)MatchGradingDAO.getSingleResult((Query)query);
        MatchGrading matchGrading = null;
        if (matchGradingDTO != null) {
            matchGrading = new MatchGrading();
            matchGrading.setMatch((Match)this.adapterPool.create(Match.class, (Object)matchGradingDTO.getMatchGradingKey().getMatch()));
            matchGrading.setJudgeNum(matchGradingDTO.getMatchGradingKey().getJudgeNum());
            matchGrading.setJudge((Judge)this.adapterPool.create(Judge.class, (Object)matchGradingDTO.getJudge()));
            matchGrading.setSentAt(matchGradingDTO.getSentAt());
            matchGrading.setFinalResult(matchGradingDTO.getFinalResult());
        }
        this.flush();
        return matchGrading;
    }

    public List<MatchGrading> getMatchGradings(Match match) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select mg from MatchGradingDTO as mg where mg.matchGradingKey.match.matchId = ");
        sql.append(paramsBinder.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        LinkedList<MatchGrading> matchGradings = new LinkedList<MatchGrading>();
        List list = query.getResultList();
        for (MatchGradingDTO matchGradingDTO : list) {
            MatchGrading matchGrading = new MatchGrading();
            matchGrading.setMatch((Match)this.adapterPool.create(Match.class, (Object)matchGradingDTO.getMatchGradingKey().getMatch()));
            matchGrading.setJudgeNum(matchGradingDTO.getMatchGradingKey().getJudgeNum());
            matchGrading.setJudge((Judge)this.adapterPool.create(Judge.class, (Object)matchGradingDTO.getJudge()));
            matchGrading.setSentAt(matchGradingDTO.getSentAt());
            matchGrading.setFinalResult(matchGradingDTO.getFinalResult());
            matchGradings.add(matchGrading);
        }
        this.flush();
        return matchGradings;
    }

    public MatchGrading getOrCreateMatchGrading(Match match, Judge judge, boolean normalReferee) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select mg from MatchGradingDTO as mg where mg.matchGradingKey.match.matchId = ");
        sql.append(paramsBinder.addParam(match.getMatchId()));
        sql.append(" and mg.judge.judgeId = ");
        sql.append(paramsBinder.addParam(judge.getJudgeId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        MatchGradingDTO matchGradingDTO = (MatchGradingDTO)MatchGradingDAO.getSingleResult((Query)query);
        MatchGrading matchGrading = null;
        if (matchGradingDTO == null) {
            paramsBinder = new ParamsBinder();
            sql = new StringBuilder();
            sql.append("select mg.matchGradingKey.judgeNum from MatchGradingDTO as mg where mg.matchGradingKey.match.matchId = ");
            sql.append(paramsBinder.addParam(match.getMatchId()));
            query = this.createQuery(sql.toString());
            paramsBinder.bindParams(query);
            boolean free1 = true;
            boolean free2 = true;
            boolean free3 = true;
            boolean free4 = true;
            for (Integer num : query.getResultList()) {
                if (num == 1) {
                    free1 = false;
                    continue;
                }
                if (num == 2) {
                    free2 = false;
                    continue;
                }
                if (num == 3) {
                    free3 = false;
                    continue;
                }
                if (num != 4) continue;
                free4 = false;
            }
            int judgeNum = -1;
            if (normalReferee) {
                if (free1) {
                    judgeNum = 1;
                } else if (free2) {
                    judgeNum = 2;
                } else if (free3) {
                    judgeNum = 3;
                }
                if (judgeNum < 0) {
                    throw new IllegalStateException("Too many judges present for duo match");
                }
            } else {
                if (free4) {
                    judgeNum = 4;
                }
                if (judgeNum < 0) {
                    throw new IllegalStateException("Too many judges present for duo match");
                }
            }
            MatchDTO matchDTO = new MatchDTO();
            matchDTO.setMatchId(match.getMatchId());
            JudgeDTO judgeDTO = new JudgeDTO();
            judgeDTO.setJudgeId(judge.getJudgeId());
            matchGradingDTO = new MatchGradingDTO(matchDTO, judgeNum);
            matchGradingDTO.setJudge(judgeDTO);
            matchGradingDTO.setSentAt(Calendar.getInstance());
            matchGradingDTO = (MatchGradingDTO)this.saveInstance(matchGradingDTO);
            matchGrading = new MatchGrading();
            matchGrading.setMatch(match);
            matchGrading.setJudgeNum(Integer.valueOf(judgeNum));
            matchGrading.setJudge(judge);
            matchGrading.setSentAt(matchGradingDTO.getSentAt());
            matchGrading.setFinalResult(matchGradingDTO.getFinalResult());
        } else {
            matchGrading = new MatchGrading();
            matchGrading.setMatch((Match)this.adapterPool.create(Match.class, (Object)matchGradingDTO.getMatchGradingKey().getMatch()));
            matchGrading.setJudgeNum(matchGradingDTO.getMatchGradingKey().getJudgeNum());
            matchGrading.setJudge((Judge)this.adapterPool.create(Judge.class, (Object)matchGradingDTO.getJudge()));
            matchGrading.setSentAt(matchGradingDTO.getSentAt());
            matchGrading.setFinalResult(matchGradingDTO.getFinalResult());
        }
        this.flush();
        return matchGrading;
    }

    public MatchGrading updateMatchGrading(MatchGrading matchGrading) {
        MatchDTO matchDTO = new MatchDTO();
        matchDTO.setMatchId(matchGrading.getMatch().getMatchId());
        JudgeDTO judgeDTO = new JudgeDTO();
        judgeDTO.setJudgeId(matchGrading.getJudge().getJudgeId());
        MatchGradingDTO matchGradingDTO = new MatchGradingDTO(matchDTO, matchGrading.getJudgeNum());
        matchGradingDTO.setJudge(judgeDTO);
        matchGradingDTO.setSentAt(matchGrading.getSentAt());
        matchGradingDTO.setFinalResult(matchGrading.getFinalResult());
        matchGradingDTO = (MatchGradingDTO)this.saveInstance(matchGradingDTO);
        matchGrading = new MatchGrading();
        matchGrading.setMatch((Match)this.adapterPool.create(Match.class, (Object)matchGradingDTO.getMatchGradingKey().getMatch()));
        matchGrading.setJudgeNum(matchGradingDTO.getMatchGradingKey().getJudgeNum());
        matchGrading.setJudge((Judge)this.adapterPool.create(Judge.class, (Object)matchGradingDTO.getJudge()));
        matchGrading.setSentAt(matchGradingDTO.getSentAt());
        matchGrading.setFinalResult(matchGradingDTO.getFinalResult());
        this.flush();
        return matchGrading;
    }

    public void setMatchGradings(Match match, List<MatchGrading> matchGradings) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete MatchGradingDTO where matchGradingKey.match.matchId = ");
        sql.append(paramsBinder.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        if (CollectionUtil.isNotEmpty(matchGradings)) {
            MatchDTO matchDTO = new MatchDTO();
            matchDTO.setMatchId(match.getMatchId());
            for (MatchGrading matchGrading : matchGradings) {
                JudgeDTO judgeDTO = new JudgeDTO();
                judgeDTO.setJudgeId(matchGrading.getJudge().getJudgeId());
                MatchGradingDTO matchGradingDTO = new MatchGradingDTO(matchDTO, matchGrading.getJudgeNum());
                matchGradingDTO.setJudge(judgeDTO);
                matchGradingDTO.setSentAt(matchGrading.getSentAt());
                matchGradingDTO.setFinalResult(matchGrading.getFinalResult());
                this.saveInstance(matchGradingDTO);
            }
        }
        this.flush();
    }

    public void deleteAllForJudge(Judge judge) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete MatchGradingDTO where judge.judgeId = ");
        sql.append(paramsBinder.addParam(judge.getJudgeId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        this.flush();
    }
}

