/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.streams;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import si.nevensrok.common.buffer.WriteByteBuffer;

public class DataInputStream
extends InputStream {
    private static final Charset UTF8 = Charset.forName("UTF8");
    private InputStream inputStream;
    private boolean littleEndian = true;

    public DataInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public DataInputStream(InputStream inputStream, boolean littleEndian) {
        this.inputStream = inputStream;
        this.littleEndian = littleEndian;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public void setLittleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public byte readBit() throws IOException {
        return (byte)(this.readByte() & 1);
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new IOException("End of stream reached");
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new IOException("End of stream reached");
        }
        return n & 0xFF;
    }

    public short readShort() throws IOException {
        short value = 0;
        int n1 = this.read();
        if (n1 < 0) {
            throw new IOException("End of stream reached");
        }
        int n2 = this.read();
        if (n2 < 0) {
            throw new IOException("End of stream reached");
        }
        if (this.littleEndian) {
            value = (short)(value + (n2 << 8 & 0xFF00));
            value = (short)(value + (n1 & 0xFF));
        } else {
            value = (short)(value + (n1 << 8 & 0xFF00));
            value = (short)(value + (n2 & 0xFF));
        }
        return value;
    }

    public int readUnsignedShort() throws IOException {
        int value = 0;
        int n1 = this.read();
        if (n1 < 0) {
            throw new IOException("End of stream reached");
        }
        int n2 = this.read();
        if (n2 < 0) {
            throw new IOException("End of stream reached");
        }
        if (this.littleEndian) {
            value += n2 << 8 & 0xFF00;
            value += n1 & 0xFF;
        } else {
            value += n1 << 8 & 0xFF00;
            value += n2 & 0xFF;
        }
        return value;
    }

    public int readInt() throws IOException {
        int value = 0;
        int n1 = this.read();
        if (n1 < 0) {
            throw new IOException("End of stream reached");
        }
        int n2 = this.read();
        if (n2 < 0) {
            throw new IOException("End of stream reached");
        }
        int n3 = this.read();
        if (n3 < 0) {
            throw new IOException("End of stream reached");
        }
        int n4 = this.read();
        if (n4 < 0) {
            throw new IOException("End of stream reached");
        }
        if (this.littleEndian) {
            value += n4 << 24 & 0xFF000000;
            value += n3 << 16 & 0xFF0000;
            value += n2 << 8 & 0xFF00;
            value += n1 & 0xFF;
        } else {
            value += n1 << 24 & 0xFF000000;
            value += n2 << 16 & 0xFF0000;
            value += n3 << 8 & 0xFF00;
            value += n4 & 0xFF;
        }
        return value;
    }

    public long readUnsignedInt() throws IOException {
        long value = 0L;
        int n1 = this.read();
        if (n1 < 0) {
            throw new IOException("End of stream reached");
        }
        int n2 = this.read();
        if (n2 < 0) {
            throw new IOException("End of stream reached");
        }
        int n3 = this.read();
        if (n3 < 0) {
            throw new IOException("End of stream reached");
        }
        int n4 = this.read();
        if (n4 < 0) {
            throw new IOException("End of stream reached");
        }
        if (this.littleEndian) {
            value += (long)n4 << 24 & 0xFF000000L;
            value += (long)n3 << 16 & 0xFF0000L;
            value += (long)n2 << 8 & 0xFF00L;
            value += (long)(n1 & 0xFF);
        } else {
            value += (long)n1 << 24 & 0xFF000000L;
            value += (long)n2 << 16 & 0xFF0000L;
            value += (long)n3 << 8 & 0xFF00L;
            value += (long)(n4 & 0xFF);
        }
        return value;
    }

    public long readLong() throws IOException {
        long value = 0L;
        int n1 = this.read();
        if (n1 < 0) {
            throw new IOException("End of stream reached");
        }
        int n2 = this.read();
        if (n2 < 0) {
            throw new IOException("End of stream reached");
        }
        int n3 = this.read();
        if (n3 < 0) {
            throw new IOException("End of stream reached");
        }
        int n4 = this.read();
        if (n4 < 0) {
            throw new IOException("End of stream reached");
        }
        int n5 = this.read();
        if (n5 < 0) {
            throw new IOException("End of stream reached");
        }
        int n6 = this.read();
        if (n6 < 0) {
            throw new IOException("End of stream reached");
        }
        int n7 = this.read();
        if (n7 < 0) {
            throw new IOException("End of stream reached");
        }
        int n8 = this.read();
        if (n8 < 0) {
            throw new IOException("End of stream reached");
        }
        if (this.littleEndian) {
            value += (long)n8 << 56 & 0xFF00000000000000L;
            value += (long)n7 << 48 & 0xFF000000000000L;
            value += (long)n6 << 40 & 0xFF0000000000L;
            value += (long)n5 << 32 & 0xFF00000000L;
            value += (long)n4 << 24 & 0xFF000000L;
            value += (long)n3 << 16 & 0xFF0000L;
            value += (long)n2 << 8 & 0xFF00L;
            value += (long)(n1 & 0xFF);
        } else {
            value += (long)n1 << 56 & 0xFF00000000000000L;
            value += (long)n2 << 48 & 0xFF000000000000L;
            value += (long)n3 << 40 & 0xFF0000000000L;
            value += (long)n4 << 32 & 0xFF00000000L;
            value += (long)n5 << 24 & 0xFF000000L;
            value += (long)n6 << 16 & 0xFF0000L;
            value += (long)n7 << 8 & 0xFF00L;
            value += (long)(n8 & 0xFF);
        }
        return value;
    }

    public float readFloat() throws IOException {
        int n = this.readInt();
        return Float.intBitsToFloat(n);
    }

    public double readDouble() throws IOException {
        long n = this.readLong();
        return Double.longBitsToDouble(n);
    }

    public char readAsciiCharacter() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new IOException("End of stream reached");
        }
        return (char)n;
    }

    public char readUtf8Character() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new IOException("End of stream reached");
        }
        if (n <= 127) {
            return (char)n;
        }
        if (n >= 192 && n <= 223) {
            int n2 = this.read();
            if (n2 < 0) {
                throw new IOException("End of stream reached");
            }
            if (n2 >= 128 && n2 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2}, UTF8).charAt(0);
            }
        } else if (n >= 224 && n <= 239) {
            int n2 = this.read();
            if (n2 < 0) {
                throw new IOException("End of stream reached");
            }
            int n3 = this.read();
            if (n3 < 0) {
                throw new IOException("End of stream reached");
            }
            if (n2 >= 128 && n2 <= 191 && n3 >= 128 && n3 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2, (byte)n3}, UTF8).charAt(0);
            }
        } else if (n >= 240 && n <= 247) {
            int n2 = this.read();
            if (n2 < 0) {
                throw new IOException("End of stream reached");
            }
            int n3 = this.read();
            if (n3 < 0) {
                throw new IOException("End of stream reached");
            }
            int n4 = this.read();
            if (n4 < 0) {
                throw new IOException("End of stream reached");
            }
            if (n2 >= 128 && n2 <= 191 && n3 >= 128 && n3 <= 191 && n4 >= 128 && n4 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2, (byte)n3, (byte)n4}, UTF8).charAt(0);
            }
        }
        throw new IOException("Unknown UTF8 character");
    }

    public byte[] readBytes(int length) throws IOException {
        int n;
        byte[] bytes = new byte[length];
        for (int dataRead = 0; dataRead < length; dataRead += n) {
            n = this.read(bytes, dataRead, length - dataRead);
            if (n >= 0) continue;
            throw new IOException("End of stream reached");
        }
        return bytes;
    }

    public String readAsciiString() throws IOException {
        StringBuilder value = new StringBuilder();
        while (true) {
            int n;
            if ((n = this.read()) < 0) {
                throw new IOException("End of stream reached");
            }
            if (n == 0) break;
            value.append((char)n);
        }
        return value.toString();
    }

    public String readUtf8String() throws IOException {
        WriteByteBuffer buffer = new WriteByteBuffer();
        while (true) {
            int n;
            if ((n = this.read()) < 0) {
                throw new IOException("End of stream reached");
            }
            if (n == 0) break;
            buffer.add((byte)n);
        }
        return new String(buffer.getBuffer(), 0, buffer.getLength(), UTF8);
    }
}

