/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.reports.impl;

import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import si.nevensrok.common.comparators.IntegerComparator;
import si.nevensrok.common.documents.common.Alignment;
import si.nevensrok.common.documents.common.BorderMargin;
import si.nevensrok.common.documents.common.Content;
import si.nevensrok.common.documents.common.Document;
import si.nevensrok.common.documents.common.Heading;
import si.nevensrok.common.documents.common.Image;
import si.nevensrok.common.documents.common.PageBreak;
import si.nevensrok.common.documents.common.PageDirection;
import si.nevensrok.common.documents.common.PageSize;
import si.nevensrok.common.documents.common.Paragraph;
import si.nevensrok.common.documents.common.Table;
import si.nevensrok.common.documents.common.TableCell;
import si.nevensrok.common.documents.common.TableRow;
import si.nevensrok.common.documents.common.VerticalAlignment;
import si.nevensrok.common.messagesource.MessageLoader;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.common.utils.MapUtil;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competitors.CompetitorRanking;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.server.reports.impl.CategoryData;
import si.nevensrok.jtekma.server.reports.impl.CategoryPlacingData;
import si.nevensrok.jtekma.server.reports.impl.CompetitorPlacingData;
import si.nevensrok.jtekma.server.reports.impl.MatchData;
import si.nevensrok.jtekma.server.reports.impl.MatchTreeImageGenerator;
import si.nevensrok.jtekma.server.reports.impl.MedalsCount;
import si.nevensrok.jtekma.server.reports.impl.PlacingData;

public class DocumentGenerator {
    private static final DecimalFormat COMPETITOR_RANKING_POINTS_FORMAT;
    private MessageLoader messageLoader;
    private MatchTreeImageGenerator matchTreeImageGenerator;

    public void setMessageLoader(MessageLoader messageLoader) {
        this.messageLoader = messageLoader;
    }

    public void setMatchTreeImageGenerator(MatchTreeImageGenerator matchTreeImageGenerator) {
        this.matchTreeImageGenerator = matchTreeImageGenerator;
    }

    public Document generateClubPlacingsDocument(Locale locale, List<PlacingData> placings) {
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "clubPlacing.title"), Heading.HeadingType.H1));
        for (PlacingData placingData : placings) {
            StringBuilder line = new StringBuilder();
            line.append(placingData.getPlacing());
            line.append(". ");
            line.append(placingData.getName());
            line.append(", ");
            line.append(placingData.getPoints());
            line.append(" ");
            line.append(this.messageLoader.getMessage(locale, "clubPlacing.points"));
            Paragraph paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        return document;
    }

    public Document generateCompetitorPlacingsDocument(Locale locale, List<CategoryPlacingData> categoryPlacingDataList, boolean oneCategoryPerPage) {
        Document document = new Document();
        boolean firstCategory = true;
        for (CategoryPlacingData categoryPlacingData : categoryPlacingDataList) {
            if (firstCategory) {
                firstCategory = false;
            } else if (oneCategoryPerPage) {
                document.addContent((Content)new PageBreak());
            }
            document.addContent((Content)new Heading(categoryPlacingData.getCategoryName(), Heading.HeadingType.H1));
            if (CollectionUtil.isNotEmpty(categoryPlacingData.getPlacingDatas())) {
                for (PlacingData placingData : categoryPlacingData.getPlacingDatas()) {
                    StringBuilder line = new StringBuilder();
                    line.append(placingData.getPlacing());
                    line.append(". ");
                    line.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(line.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
                continue;
            }
            if (!MapUtil.isNotEmpty(categoryPlacingData.getPlacingsForRanks())) continue;
            for (Map.Entry entry : categoryPlacingData.getPlacingsForRanks().entrySet()) {
                Rank rank = (Rank)entry.getKey();
                if (rank == Rank.WORLD_LEVEL) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.worldLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.ADVANCED) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.advancedLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.NOVICE) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.noviceLevel"), Heading.HeadingType.H3));
                }
                for (PlacingData placingData : (List)entry.getValue()) {
                    StringBuilder line = new StringBuilder();
                    line.append(placingData.getPlacing());
                    line.append(". ");
                    line.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(line.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
            }
        }
        return document;
    }

    public Document generateTreeReport(Locale locale, List<CategoryData> categoryDatas, boolean empty) {
        Document document = new Document();
        boolean firstCategory = true;
        for (CategoryData categoryData : categoryDatas) {
            if (firstCategory) {
                firstCategory = false;
            } else if (categoryData.getMatchDatas().size() == 28) {
                document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
            } else {
                document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
            }
            document.addContent((Content)new Heading(categoryData.getCategoryName(), Heading.HeadingType.H1));
            String[][] tableContent = categoryData.getTableContent();
            if (tableContent != null && (categoryData.getTreeType() == TreeCategory.TreeType.TABLE2 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE3 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE4 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE5)) {
                Table table = new Table();
                document.addContent((Content)table);
                float fontSize = 8.0f;
                String[][] tableRow = new TableRow();
                table.addTableRow((TableRow)tableRow);
                TableCell tableCell = new TableCell();
                tableCell.setWidth(7.0f);
                Paragraph competitorParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.competitor"));
                competitorParagraph.setFontSize(Float.valueOf(fontSize));
                competitorParagraph.setBold(Boolean.TRUE);
                tableCell.addContent(competitorParagraph);
                tableRow.addTableCell(tableCell);
                for (int i = 1; i <= 5; ++i) {
                    TableCell matchTableCell = new TableCell();
                    matchTableCell.setWidth(3.0f);
                    matchTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    Paragraph matchParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.match") + " " + i);
                    matchParagraph.setFontSize(Float.valueOf(fontSize));
                    matchParagraph.setBold(Boolean.TRUE);
                    matchParagraph.setAlignment(Alignment.CENTER);
                    matchTableCell.addContent(matchParagraph);
                    tableRow.addTableCell(matchTableCell);
                }
                TableCell winsTableCell = new TableCell();
                winsTableCell.setWidth(3.0f);
                winsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph winsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.wins"));
                winsParagraph.setFontSize(Float.valueOf(fontSize));
                winsParagraph.setBold(Boolean.TRUE);
                winsParagraph.setAlignment(Alignment.CENTER);
                winsTableCell.addContent(winsParagraph);
                tableRow.addTableCell(winsTableCell);
                TableCell fiWinsTableCell = new TableCell();
                fiWinsTableCell.setWidth(3.0f);
                fiWinsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph fiWinsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.fiWins"));
                fiWinsParagraph.setFontSize(Float.valueOf(fontSize));
                fiWinsParagraph.setBold(Boolean.TRUE);
                fiWinsParagraph.setAlignment(Alignment.CENTER);
                fiWinsTableCell.addContent(fiWinsParagraph);
                tableRow.addTableCell(fiWinsTableCell);
                TableCell pointsTableCell = new TableCell();
                pointsTableCell.setWidth(3.0f);
                pointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph pointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.points"));
                pointsParagraph.setFontSize(Float.valueOf(fontSize));
                pointsParagraph.setBold(Boolean.TRUE);
                pointsParagraph.setAlignment(Alignment.CENTER);
                pointsTableCell.addContent(pointsParagraph);
                tableRow.addTableCell(pointsTableCell);
                for (String[] row : tableContent) {
                    TableRow tableRow2 = new TableRow();
                    table.addTableRow(tableRow2);
                    TableCell competitorTableCell2 = new TableCell();
                    competitorTableCell2.setWidth(7.0f);
                    Paragraph competitorParagraph2 = new Paragraph(row[0]);
                    competitorParagraph2.setFontSize(Float.valueOf(fontSize));
                    competitorTableCell2.addContent(competitorParagraph2);
                    tableRow2.addTableCell(competitorTableCell2);
                    for (int i = 1; i <= 5; ++i) {
                        TableCell matchTableCell = new TableCell();
                        matchTableCell.setWidth(3.0f);
                        Paragraph matchParagraph = new Paragraph(row[i]);
                        matchParagraph.setFontSize(Float.valueOf(fontSize));
                        matchParagraph.setAlignment(Alignment.CENTER);
                        matchTableCell.addContent(matchParagraph);
                        tableRow2.addTableCell(matchTableCell);
                    }
                    TableCell winsTableCell2 = new TableCell();
                    winsTableCell2.setWidth(3.0f);
                    Paragraph winsParagraph2 = new Paragraph(row[6]);
                    winsParagraph2.setFontSize(Float.valueOf(fontSize));
                    winsParagraph2.setAlignment(Alignment.CENTER);
                    winsTableCell2.addContent(winsParagraph2);
                    tableRow2.addTableCell(winsTableCell2);
                    TableCell fiWinsTableCell2 = new TableCell();
                    fiWinsTableCell2.setWidth(3.0f);
                    Paragraph fiWinsParagraph2 = new Paragraph(row[7]);
                    fiWinsParagraph2.setFontSize(Float.valueOf(fontSize));
                    fiWinsParagraph2.setAlignment(Alignment.CENTER);
                    fiWinsTableCell2.addContent(fiWinsParagraph2);
                    tableRow2.addTableCell(fiWinsTableCell2);
                    TableCell pointsTableCell2 = new TableCell();
                    pointsTableCell2.setWidth(3.0f);
                    Paragraph pointsParagraph2 = new Paragraph(row[8]);
                    pointsParagraph2.setFontSize(Float.valueOf(fontSize));
                    pointsParagraph2.setAlignment(Alignment.CENTER);
                    pointsTableCell2.addContent(pointsParagraph2);
                    tableRow2.addTableCell(pointsTableCell2);
                }
            }
            boolean duoTableAdded = false;
            String[][] duoTable = categoryData.getDuoTableContent();
            if (duoTable != null) {
                duoTableAdded = true;
                Table table = new Table();
                document.addContent((Content)table);
                float f = 8.0f;
                String[][] tableRow = new TableRow();
                table.addTableRow((TableRow)tableRow);
                TableCell competitorTableCell = new TableCell();
                competitorTableCell.setWidth(7.0f);
                Paragraph competitorParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.competitor"));
                competitorParagraph.setFontSize(Float.valueOf(f));
                competitorParagraph.setBold(Boolean.TRUE);
                competitorTableCell.addContent(competitorParagraph);
                tableRow.addTableCell(competitorTableCell);
                TableCell round1pointsTableCell = new TableCell();
                round1pointsTableCell.setWidth(3.0f);
                round1pointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph round1pointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.round1points"));
                round1pointsParagraph.setFontSize(Float.valueOf(f));
                round1pointsParagraph.setBold(Boolean.TRUE);
                round1pointsParagraph.setAlignment(Alignment.CENTER);
                round1pointsTableCell.addContent(round1pointsParagraph);
                tableRow.addTableCell(round1pointsTableCell);
                TableCell round2pointsTableCell = new TableCell();
                round2pointsTableCell.setWidth(3.0f);
                round2pointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph round2pointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.round2points"));
                round2pointsParagraph.setFontSize(Float.valueOf(f));
                round2pointsParagraph.setBold(Boolean.TRUE);
                round2pointsParagraph.setAlignment(Alignment.CENTER);
                round2pointsTableCell.addContent(round2pointsParagraph);
                tableRow.addTableCell(round2pointsTableCell);
                TableCell round3pointsTableCell = new TableCell();
                round3pointsTableCell.setWidth(3.0f);
                round3pointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph round3pointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.round3points"));
                round3pointsParagraph.setFontSize(Float.valueOf(f));
                round3pointsParagraph.setBold(Boolean.TRUE);
                round3pointsParagraph.setAlignment(Alignment.CENTER);
                round3pointsTableCell.addContent(round3pointsParagraph);
                tableRow.addTableCell(round3pointsTableCell);
                TableCell varietyPointsTableCell = new TableCell();
                varietyPointsTableCell.setWidth(3.0f);
                varietyPointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph varietyPointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.varietyPoints"));
                varietyPointsParagraph.setFontSize(Float.valueOf(f));
                varietyPointsParagraph.setBold(Boolean.TRUE);
                varietyPointsParagraph.setAlignment(Alignment.CENTER);
                varietyPointsTableCell.addContent(varietyPointsParagraph);
                tableRow.addTableCell(varietyPointsTableCell);
                TableCell pointsTableCell = new TableCell();
                pointsTableCell.setWidth(3.0f);
                pointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph pointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.points"));
                pointsParagraph.setFontSize(Float.valueOf(f));
                pointsParagraph.setBold(Boolean.TRUE);
                pointsParagraph.setAlignment(Alignment.CENTER);
                pointsTableCell.addContent(pointsParagraph);
                tableRow.addTableCell(pointsTableCell);
                for (String[] row : duoTable) {
                    TableRow tableRow3 = new TableRow();
                    table.addTableRow(tableRow3);
                    TableCell competitorTableCell3 = new TableCell();
                    competitorTableCell3.setWidth(7.0f);
                    Paragraph competitorParagraph3 = new Paragraph(row[0]);
                    competitorParagraph3.setFontSize(Float.valueOf(f));
                    competitorTableCell3.addContent(competitorParagraph3);
                    tableRow3.addTableCell(competitorTableCell3);
                    TableCell round1pointsTableCell2 = new TableCell();
                    round1pointsTableCell2.setWidth(3.0f);
                    round1pointsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    Paragraph round1pointsParagraph2 = new Paragraph(row[1]);
                    round1pointsParagraph2.setFontSize(Float.valueOf(f));
                    round1pointsParagraph2.setAlignment(Alignment.CENTER);
                    round1pointsTableCell2.addContent(round1pointsParagraph2);
                    tableRow3.addTableCell(round1pointsTableCell2);
                    TableCell round2pointsTableCell2 = new TableCell();
                    round2pointsTableCell2.setWidth(3.0f);
                    round2pointsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    Paragraph round2pointsParagraph2 = new Paragraph(row[2]);
                    round2pointsParagraph2.setFontSize(Float.valueOf(f));
                    round2pointsParagraph2.setAlignment(Alignment.CENTER);
                    round2pointsTableCell2.addContent(round2pointsParagraph2);
                    tableRow3.addTableCell(round2pointsTableCell2);
                    TableCell round3pointsTableCell2 = new TableCell();
                    round3pointsTableCell2.setWidth(3.0f);
                    round3pointsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    Paragraph round3pointsParagraph2 = new Paragraph(row[3]);
                    round3pointsParagraph2.setFontSize(Float.valueOf(f));
                    round3pointsParagraph2.setAlignment(Alignment.CENTER);
                    round3pointsTableCell2.addContent(round3pointsParagraph2);
                    tableRow3.addTableCell(round3pointsTableCell2);
                    TableCell varietyPointsTableCell2 = new TableCell();
                    varietyPointsTableCell2.setWidth(3.0f);
                    varietyPointsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    Paragraph varietyPointsParagraph2 = new Paragraph(row[4]);
                    varietyPointsParagraph2.setFontSize(Float.valueOf(f));
                    varietyPointsParagraph2.setAlignment(Alignment.CENTER);
                    varietyPointsTableCell2.addContent(varietyPointsParagraph2);
                    tableRow3.addTableCell(varietyPointsTableCell2);
                    TableCell pointsTableCell3 = new TableCell();
                    pointsTableCell3.setWidth(3.0f);
                    Paragraph pointsParagraph3 = new Paragraph(row[5]);
                    pointsParagraph3.setFontSize(Float.valueOf(f));
                    pointsParagraph3.setAlignment(Alignment.CENTER);
                    pointsTableCell3.addContent(pointsParagraph3);
                    tableRow3.addTableCell(pointsTableCell3);
                }
            }
            if (MapUtil.isNotEmpty(categoryData.getMatchDataForRank())) {
                if (duoTableAdded) {
                    document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                }
                document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "competitors.knockout"), Heading.HeadingType.H2));
                for (Map.Entry entry : categoryData.getMatchDataForRank().entrySet()) {
                    if (entry.getKey() == Rank.WORLD_LEVEL) {
                        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.worldLevel"), Heading.HeadingType.H3));
                    } else if (entry.getKey() == Rank.ADVANCED) {
                        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.advancedLevel"), Heading.HeadingType.H3));
                    } else if (entry.getKey() == Rank.NOVICE) {
                        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.noviceLevel"), Heading.HeadingType.H3));
                    }
                    BufferedImage image = this.matchTreeImageGenerator.generateDuoKnockoutMatches((List)entry.getValue(), categoryData.isDisplay3rdPlaceMatch());
                    Image imageContent = new Image(image, Alignment.CENTER);
                    imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                    document.addContent((Content)imageContent);
                }
            }
            if (CollectionUtil.isNotEmpty(categoryData.getMatchDatas())) {
                if (!categoryData.isCustom()) {
                    BufferedImage image;
                    if (categoryData.getTreeType() == TreeCategory.TreeType.BEST_OF_3) {
                        image = this.matchTreeImageGenerator.generateBestOf3Fights(categoryData.getMatchDatas());
                        Image image2 = new Image(image, Alignment.CENTER);
                        image2.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)image2);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TABLE2 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE3 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE4 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE5) {
                        image = this.matchTreeImageGenerator.generateTableFights(categoryData.getMatchDatas());
                        Image image3 = new Image(image, Alignment.CENTER);
                        image3.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)image3);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE4) {
                        boolean display3rdplace = categoryData.isDisplay3rdPlaceMatch();
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.NONE) {
                            display3rdplace = false;
                        }
                        BufferedImage bufferedImage = this.matchTreeImageGenerator.generateTree4Fights(categoryData.getMatchDatas(), display3rdplace);
                        Image imageContent = new Image(bufferedImage, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE8) {
                        boolean displayRepassage = categoryData.getRepassageType() != TreeCategory.RepassageType.NONE;
                        BufferedImage bufferedImage = this.matchTreeImageGenerator.generateTree8Fights(categoryData.getMatchDatas(), displayRepassage, categoryData.isDisplay3rdPlaceMatch());
                        Image imageContent = new Image(bufferedImage, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE16) {
                        image = this.matchTreeImageGenerator.generateTree16Fights(categoryData.getMatchDatas());
                        Image image4 = new Image(image, Alignment.CENTER);
                        image4.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)image4);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassage")));
                            BufferedImage imageRepasague = this.matchTreeImageGenerator.generateTree16RepassageFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            Image image5 = new Image(imageRepasague, Alignment.CENTER);
                            image5.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)image5);
                        }
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE32) {
                        image = this.matchTreeImageGenerator.generateTree32Fights(categoryData.getMatchDatas());
                        Image image6 = new Image(image, Alignment.CENTER);
                        image6.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)image6);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            Paragraph repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassage"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            BufferedImage imageRepasague = this.matchTreeImageGenerator.generateTree32RepassageFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            Image image7 = new Image(imageRepasague, Alignment.CENTER);
                            document.addContent((Content)image7);
                        }
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE64) {
                        Paragraph firstPartParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.firstPart"));
                        firstPartParagraph.setBold(Boolean.TRUE);
                        document.addContent((Content)firstPartParagraph);
                        BufferedImage bufferedImage = this.matchTreeImageGenerator.generateTree64_1Fights(categoryData.getMatchDatas());
                        Image imageContent = new Image(bufferedImage, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                        Paragraph secondPartParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.secondPart"));
                        secondPartParagraph.setBold(Boolean.TRUE);
                        document.addContent((Content)secondPartParagraph);
                        BufferedImage bufferedImage2 = this.matchTreeImageGenerator.generateTree64_2Fights(categoryData.getMatchDatas());
                        imageContent = new Image(bufferedImage2, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            Paragraph repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassageFirstPart"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            BufferedImage imageRepasague = this.matchTreeImageGenerator.generateTree64_1RepassageFights(categoryData.getMatchDatas());
                            imageContent = new Image(imageRepasague, Alignment.CENTER);
                            imageContent.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)imageContent);
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassageSecondPart"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            imageRepasague = this.matchTreeImageGenerator.generateTree64_2RepassageFights(categoryData.getMatchDatas());
                            imageContent = new Image(imageRepasague, Alignment.CENTER);
                            imageContent.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)imageContent);
                        }
                        document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            Paragraph forThirdParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.forThirdPlace"));
                            forThirdParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)forThirdParagraph);
                            BufferedImage bufferedImage3 = this.matchTreeImageGenerator.generateTree64ForThirdFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            imageContent = new Image(bufferedImage3, Alignment.LEFT);
                            imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                            document.addContent((Content)imageContent);
                        }
                        Paragraph finalsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.finals"));
                        finalsParagraph.setBold(Boolean.TRUE);
                        document.addContent((Content)finalsParagraph);
                        BufferedImage bufferedImage4 = this.matchTreeImageGenerator.generateTree64FinalsFights(categoryData.getMatchDatas());
                        imageContent = new Image(bufferedImage4, Alignment.LEFT);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                    }
                } else {
                    LinkedList<MatchData> matchesLeft = new LinkedList<MatchData>(categoryData.getMatchDatas());
                    LinkedList<MatchData> linkedList = new LinkedList<MatchData>();
                    while (!matchesLeft.isEmpty()) {
                        linkedList.add(matchesLeft.poll());
                        if (linkedList.size() != 3) continue;
                        BufferedImage image = this.matchTreeImageGenerator.generateMatchRowFights(linkedList);
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        linkedList.clear();
                    }
                    if (!linkedList.isEmpty()) {
                        BufferedImage image = this.matchTreeImageGenerator.generateMatchRowFights(linkedList);
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                    }
                }
            }
            if (CollectionUtil.isNotEmpty(categoryData.getPlacingDatas())) {
                if (categoryData.getPlacingDatas().size() > 16 && categoryData.getPlacingDatas().size() < 33) {
                    document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                }
                Paragraph placingParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.placing"));
                placingParagraph.setBold(Boolean.TRUE);
                document.addContent((Content)placingParagraph);
                for (PlacingData placingData : categoryData.getPlacingDatas()) {
                    StringBuilder line = new StringBuilder();
                    line.append(placingData.getPlacing());
                    line.append(". ");
                    line.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(line.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
                continue;
            }
            if (!MapUtil.isNotEmpty(categoryData.getPlacingsForRanks())) continue;
            Paragraph placingParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.placing"));
            placingParagraph.setBold(Boolean.TRUE);
            document.addContent((Content)placingParagraph);
            for (Map.Entry<Rank, List<PlacingData>> entry : categoryData.getPlacingsForRanks().entrySet()) {
                Rank rank = entry.getKey();
                if (CollectionUtil.isEmpty((Collection)entry.getValue())) continue;
                if (rank == Rank.WORLD_LEVEL) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.worldLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.ADVANCED) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.advancedLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.NOVICE) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.noviceLevel"), Heading.HeadingType.H3));
                }
                for (PlacingData placingData : entry.getValue()) {
                    StringBuilder line = new StringBuilder();
                    line.append(placingData.getPlacing());
                    line.append(". ");
                    line.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(line.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
            }
        }
        return document;
    }

    public Document generateCompetitorRankingDocument(Locale locale, List<CompetitorRanking> competitorRankings, List<CompetitorRanking> coupleRankings) {
        Paragraph paragraph;
        StringBuilder line;
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "competitorRanking.title"), Heading.HeadingType.H1));
        for (CompetitorRanking competitorRanking : competitorRankings) {
            PersonCompetitor personCompetitor = (PersonCompetitor)competitorRanking.getCompetitor();
            line = new StringBuilder();
            line.append(competitorRanking.getPlace());
            line.append(". ");
            line.append(personCompetitor.getName() + " " + personCompetitor.getSurname() + " / " + personCompetitor.getClub().getName());
            line.append(", ");
            line.append(COMPETITOR_RANKING_POINTS_FORMAT.format(competitorRanking.getPoints()));
            line.append(" ");
            line.append(this.messageLoader.getMessage(locale, "competitorRanking.points"));
            paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "coupleRanking.title"), Heading.HeadingType.H1));
        for (CompetitorRanking competitorRanking : coupleRankings) {
            CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitorRanking.getCompetitor();
            line = new StringBuilder();
            line.append(competitorRanking.getPlace());
            line.append(". ");
            line.append(coupleCompetitor.getName1() + " " + coupleCompetitor.getSurname1() + ", " + coupleCompetitor.getName2() + " " + coupleCompetitor.getSurname2() + " / " + coupleCompetitor.getClub().getName());
            line.append(", ");
            line.append(COMPETITOR_RANKING_POINTS_FORMAT.format(competitorRanking.getPoints()));
            line.append(" ");
            line.append(this.messageLoader.getMessage(locale, "competitorRanking.points"));
            paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        return document;
    }

    public Document generateResultsForClubDocument(Locale locale, List<CompetitorPlacingData> competitorPlacingDataList, Map<Integer, Integer> placingCount) {
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "resultsForClub.title"), Heading.HeadingType.H1));
        for (CompetitorPlacingData competitorPlacingData : competitorPlacingDataList) {
            StringBuilder line = new StringBuilder();
            line.append(competitorPlacingData.getCategory().getName());
            line.append(" - ");
            if (competitorPlacingData.getRank() != null) {
                if (competitorPlacingData.getRank() == Rank.WORLD_LEVEL) {
                    line.append(this.messageLoader.getMessage(locale, "table.worldLevel"));
                } else if (competitorPlacingData.getRank() == Rank.ADVANCED) {
                    line.append(this.messageLoader.getMessage(locale, "table.advancedLevel"));
                } else if (competitorPlacingData.getRank() == Rank.NOVICE) {
                    line.append(this.messageLoader.getMessage(locale, "table.noviceLevel"));
                }
                line.append(" ");
            }
            line.append(competitorPlacingData.getPlacing());
            line.append(". ");
            if (competitorPlacingData.getCompetitor() instanceof PersonCompetitor) {
                PersonCompetitor personCompetitor = (PersonCompetitor)competitorPlacingData.getCompetitor();
                line.append(personCompetitor.getName() + " " + personCompetitor.getSurname() + " / " + personCompetitor.getClub().getName());
            } else if (competitorPlacingData.getCompetitor() instanceof CoupleCompetitor) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitorPlacingData.getCompetitor();
                line.append(coupleCompetitor.getName1() + " " + coupleCompetitor.getSurname1() + ", " + coupleCompetitor.getName2() + " " + coupleCompetitor.getSurname2() + " / " + coupleCompetitor.getClub().getName());
            }
            Paragraph paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "resultsForClub.placingsCount"), Heading.HeadingType.H1));
        ArrayList<Integer> placingList = new ArrayList<Integer>(placingCount.keySet());
        Collections.sort(placingList, new IntegerComparator());
        for (Integer placing : placingList) {
            StringBuilder line = new StringBuilder();
            line.append(placing);
            line.append(". ");
            line.append(this.messageLoader.getMessage(locale, "resultsForClub.placing"));
            line.append(" - ");
            line.append(placingCount.get(placing));
            Paragraph paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        return document;
    }

    public Document generateMedalsForClubsDocument(Locale locale, List<MedalsCount> medalsCountList) {
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "medalsForClubs.title"), Heading.HeadingType.H1));
        Table table = new Table();
        TableRow header = new TableRow();
        header.addTableCell(DocumentGenerator.geenrateTableCell("", Alignment.CENTER, 3.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.club"), Alignment.LEFT, 10.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.firstPlace"), Alignment.CENTER, 7.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.secondPlace"), Alignment.CENTER, 7.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.thirdPlace"), Alignment.CENTER, 7.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.total"), Alignment.CENTER, 7.0f));
        table.addTableRow(header);
        for (MedalsCount medalsCount : medalsCountList) {
            TableRow tableRow = new TableRow();
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getPlacing()), Alignment.CENTER, 3.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(medalsCount.getClub().getName(), Alignment.LEFT, 10.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getFirstPlace()), Alignment.CENTER, 7.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getSecondPlace()), Alignment.CENTER, 7.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getThirdPlace()), Alignment.CENTER, 7.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getTotal()), Alignment.CENTER, 7.0f));
            table.addTableRow(tableRow);
        }
        document.addContent((Content)table);
        return document;
    }

    private static TableCell geenrateTableCell(String text, Alignment alignment, float width) {
        TableCell tableCell = new TableCell(text, alignment);
        tableCell.setWidth(width);
        return tableCell;
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        COMPETITOR_RANKING_POINTS_FORMAT = new DecimalFormat("0.00#");
    }
}

