/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.DuoPresentationGrading;
import si.nevensrok.jtekma.common.matches.DuoPresentationPoint;
import si.nevensrok.jtekma.common.matches.DuoPresentationValidAttack;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dl.dao.DuoPresentationDAO;
import si.nevensrok.jtekma.server.dl.dao.DuoPresentationGradingDAO;
import si.nevensrok.jtekma.server.dl.dao.DuoPresentationValidAttackDAO;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CategoryTreeUpdateManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.TatamiFightsManager;
import si.nevensrok.jtekma.server.management.TatamiManager;

public class DuoPresentationManagerImpl
implements DuoPresentationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoPresentationManagerImpl.class);
    private DuoPresentationDAO duoPresentationDAO;
    private DuoPresentationGradingDAO duoPresentationGradingDAO;
    private DuoPresentationValidAttackDAO duoPresentationValidAttackDAO;
    private CategoryManager categoryManager;
    private CategoryTreeUpdateManager categoryTreeUpdateManager;
    private TatamiManager tatamiManager;
    private TatamiFightsManager tatamiFightsManager;

    public void setDuoPresentationDAO(DuoPresentationDAO duoPresentationDAO) {
        this.duoPresentationDAO = duoPresentationDAO;
    }

    public void setDuoPresentationGradingDAO(DuoPresentationGradingDAO duoPresentationGradingDAO) {
        this.duoPresentationGradingDAO = duoPresentationGradingDAO;
    }

    public void setDuoPresentationValidAttackDAO(DuoPresentationValidAttackDAO duoPresentationValidAttackDAO) {
        this.duoPresentationValidAttackDAO = duoPresentationValidAttackDAO;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setCategoryTreeUpdateManager(CategoryTreeUpdateManager categoryTreeUpdateManager) {
        this.categoryTreeUpdateManager = categoryTreeUpdateManager;
    }

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setTatamiFightsManager(TatamiFightsManager tatamiFightsManager) {
        this.tatamiFightsManager = tatamiFightsManager;
    }

    @Transactional(value="jtekmaTransactionManager")
    public DuoPresentation createDuoPresentation(DuoPresentation duoPresentation) {
        LOGGER.debug("Creating duo presentation {}", (Object)duoPresentation);
        return (DuoPresentation)this.duoPresentationDAO.create((Pojo)duoPresentation);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<DuoPresentation> createDuoPresentations(List<DuoPresentation> duoPresentations) {
        return this.duoPresentationDAO.createList(duoPresentations);
    }

    @Transactional(value="jtekmaTransactionManager")
    public DuoPresentation updateDuoPresentation(DuoPresentation duoPresentation) {
        LOGGER.debug("Updating duo presentation {}", (Object)duoPresentation);
        return (DuoPresentation)this.duoPresentationDAO.update((Pojo)duoPresentation);
    }

    @Transactional(value="jtekmaTransactionManager")
    public DuoPresentation getById(Long duoPresentationId) {
        return (DuoPresentation)this.duoPresentationDAO.getById((Object)duoPresentationId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public DuoPresentation getByIdWithCompetitor(Long duoPresentationId) {
        return this.duoPresentationDAO.getByIdWithCompetitor(duoPresentationId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<DuoPresentation> getDuoPresentationsForCategory(Category category) {
        return this.duoPresentationDAO.getDuoPresentationsForCategory(category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public DuoPresentation getDuoPresentationsForCategory(Category category, Round round, Competitor competitor) {
        return this.duoPresentationDAO.getDuoPresentationsForCategory(category, round, competitor);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setDuoPresentationStatus(DuoPresentation duoPresentation, DuoPresentation.Status status) {
        Tatami tatami;
        this.duoPresentationDAO.setDuoPresentationStatus(duoPresentation, status);
        Category category = this.categoryManager.getCategoryForDuoPresentation(duoPresentation);
        if (category instanceof Duo2023Category) {
            this.categoryTreeUpdateManager.updateCategory(category);
        }
        if (status == DuoPresentation.Status.FINISHED && (tatami = this.tatamiManager.getTatamiForDuoPresentation(duoPresentation)) != null) {
            this.tatamiFightsManager.checkMatchFights(tatami);
        }
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setDuoPresentationStartedAt(DuoPresentation duoPresentation) {
        this.duoPresentationDAO.setDuoPresentationStartedAt(duoPresentation);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setDuoPresentationFinishedAt(DuoPresentation duoPresentation) {
        Integer matchDuration = null;
        if (duoPresentation.getStartedAt() != null && duoPresentation.getFinishedAt() != null) {
            matchDuration = (int)((duoPresentation.getFinishedAt().getTime() - duoPresentation.getStartedAt().getTime()) / 1000L);
        }
        duoPresentation.setMatchDuration(matchDuration);
        this.duoPresentationDAO.setDuoPresentationFinishedAt(duoPresentation);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void updateDuoPresentationAdvancementData(Collection<DuoPresentation> duoPresentations) {
        this.duoPresentationDAO.updateDuoPresentationAdvancementData(duoPresentations);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Set<DuoPresentationPoint> getDuoPresentationPointsForDuoPresentation(DuoPresentation duoPresentation) {
        return this.duoPresentationDAO.getDuoPresentationPointsForDuoPresentation(duoPresentation);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<DuoPresentation, Set<DuoPresentationPoint>> getDuoPresentationsForDuoPresentations(Set<DuoPresentation> duoPresentations) {
        return this.duoPresentationDAO.getDuoPresentationsForDuoPresentations(duoPresentations);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setDuoPresentationPointsForDuoPresentation(DuoPresentation duoPresentation, Set<DuoPresentationPoint> duoPresentationPoints) {
        this.duoPresentationDAO.setDuoPresentationPointsForDuoPresentation(duoPresentation, duoPresentationPoints);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setDuoPresentationPointsForDuoPresentation(DuoPresentation duoPresentation, int judgeNum, Set<DuoPresentationPoint> duoPresentationPoints) {
        this.duoPresentationDAO.setDuoPresentationPointsForDuoPresentation(duoPresentation, judgeNum, duoPresentationPoints);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setVRDuoPresentationPointsForDuoPresentation(DuoPresentation duoPresentation, Set<DuoPresentationPoint> duoPresentationPoints) {
        this.duoPresentationDAO.setVRDuoPresentationPointsForDuoPresentation(duoPresentation, duoPresentationPoints);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setValidAttacksForDuoPresentation(DuoPresentation duoPresentation, Set<DuoPresentationValidAttack> validAttacks) {
        this.duoPresentationValidAttackDAO.setValidAttacksForDuoPresentation(duoPresentation, validAttacks);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Set<DuoPresentationValidAttack> getValidAttacksForDuoPresentation(DuoPresentation duoPresentation) {
        return this.duoPresentationValidAttackDAO.getValidAttacksForDuoPresentation(duoPresentation);
    }

    @Transactional(value="jtekmaTransactionManager")
    public DuoPresentationGrading getDuoPresentationGrading(DuoPresentation duoPresentation, Judge judge) {
        return this.duoPresentationGradingDAO.getDuoPresentationGrading(duoPresentation, judge);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<DuoPresentationGrading> getDuoPresentationGradings(DuoPresentation duoPresentation) {
        return this.duoPresentationGradingDAO.getDuoPresentationGradings(duoPresentation);
    }

    @Transactional(value="jtekmaTransactionManager")
    public DuoPresentationGrading getOrCreateDuoPresentationGrading(DuoPresentation duoPresentation, Judge judge, boolean normalReferee) {
        return this.duoPresentationGradingDAO.getOrCreateDuoPresentationGrading(duoPresentation, judge, normalReferee);
    }

    @Transactional(value="jtekmaTransactionManager")
    public DuoPresentationGrading updateDuoPresentationGrading(DuoPresentationGrading duoPresentationGrading) {
        return this.duoPresentationGradingDAO.updateDuoPresentationGrading(duoPresentationGrading);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setDuoPresentationGradings(DuoPresentation duoPresentation, List<DuoPresentationGrading> duoPresentationGradings) {
        this.duoPresentationGradingDAO.setDuoPresentationGradings(duoPresentation, duoPresentationGradings);
    }
}

