/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.HashMap;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryMatchCount;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.DuoCategory;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.competition.AgeCategoryKey;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competition.CompetitionDuration;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.server.management.AgeCategoryOptionManager;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionDurationCalculationManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.MatchManager;

public class CompetitionDurationCalculationManagerImpl
implements CompetitionDurationCalculationManager {
    private static final Float MATCH_DURATION_KOEFICIENT = Float.valueOf(1.7f);
    private static final Float PREDICTION_MATCH_DURATION_KOEFICIENT = Float.valueOf(1.05f);
    private static final int MIN_MATCH_TIME = 30;
    private static final int MAX_MATCH_TIME = 600;
    private CategoryManager categoryManager;
    private AgeCategoryOptionManager ageCategoryOptionManager;
    private MatchManager matchManager;
    private DuoPresentationManager duoPresentationManager;

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setAgeCategoryOptionManager(AgeCategoryOptionManager ageCategoryOptionManager) {
        this.ageCategoryOptionManager = ageCategoryOptionManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setDuoPresentationManager(DuoPresentationManager duoPresentationManager) {
        this.duoPresentationManager = duoPresentationManager;
    }

    @Transactional(value="jtekmaTransactionManager")
    public CompetitionDuration calculateCompetitionDuration(Competition competition) {
        CompetitionDuration competitionDuration = new CompetitionDuration();
        competitionDuration.setTimeRequiredForCategories(new HashMap());
        competitionDuration.setPredictedTimeRequiredForCategories(new HashMap());
        competitionDuration.setMatchCountForAgeCategories(new HashMap());
        competitionDuration.setTimeRequiredForAgeCategories(new HashMap());
        competitionDuration.setPredictedTimeRequiredForAgeCategories(new HashMap());
        int totalMatches = 0;
        int finishedMatches = 0;
        int neededMatches = 0;
        int totalPresentations = 0;
        int finishedPresentations = 0;
        int neededPresentations = 0;
        int totalTimeRequired = 0;
        int predictedTotalTimeRequired = 0;
        Category categoryExample = new Category();
        categoryExample.setStatus(Category.Status.ACTIVE);
        SimpleDataFilter categoryDataFilter = new SimpleDataFilter();
        categoryDataFilter.setFilter((Filter)new ExampleFilter((Object)categoryExample));
        HashMap<AgeCategoryKey, Integer> ageCategoryTotalMatchTime = new HashMap<AgeCategoryKey, Integer>();
        HashMap<AgeCategoryKey, Integer> ageCategoryFinishedMatches = new HashMap<AgeCategoryKey, Integer>();
        HashMap<AgeCategoryKey, Integer> ageCategoryTotalDuoPresentationTime = new HashMap<AgeCategoryKey, Integer>();
        HashMap<AgeCategoryKey, Integer> ageCategoryFinishedDuoPresentations = new HashMap<AgeCategoryKey, Integer>();
        List categories = this.categoryManager.find(competition, (DataFilter)categoryDataFilter).getData();
        competitionDuration.setMatchCountForCategories(new HashMap());
        for (Category category : categories) {
            List matches = this.matchManager.getMatchesForCategory(category);
            List duoPresentations = this.duoPresentationManager.getDuoPresentationsForCategory(category);
            CategoryMatchCount categoryMatchCount = this.createCategoryMatchCount(matches, duoPresentations);
            competitionDuration.getMatchCountForCategories().put(category, categoryMatchCount);
            AgeCategoryOption ageCategoryOption = null;
            Category.Type categoryType = null;
            if (category instanceof FightingCategory) {
                categoryType = Category.Type.FIGHTING;
                FightingCategory fightingCategory = (FightingCategory)category;
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory(fightingCategory);
            } else if (category instanceof NewazaCategory) {
                categoryType = Category.Type.NEWAZA;
                NewazaCategory newazaCategory = (NewazaCategory)category;
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory(newazaCategory);
            } else if (category instanceof DuoCategory) {
                categoryType = Category.Type.DUO;
                DuoCategory duoCategory = (DuoCategory)category;
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory(duoCategory);
            } else if (category instanceof Duo2023Category) {
                categoryType = Category.Type.DUO_2023;
                Duo2023Category duo2023Category = (Duo2023Category)category;
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory(duo2023Category);
            }
            if (ageCategoryOption == null || categoryType == null) continue;
            AgeCategoryKey ageCategoryKey = new AgeCategoryKey(ageCategoryOption, categoryType);
            if (categoryMatchCount.getAverageMatchTime() > 0) {
                int matchTime = (Integer)ObjectUtil.ifNull(ageCategoryTotalMatchTime.get(ageCategoryKey), (Object)0) + categoryMatchCount.getAverageMatchTime() * categoryMatchCount.getFinishedMatches();
                ageCategoryTotalMatchTime.put(ageCategoryKey, matchTime);
                int matchNum = (Integer)ObjectUtil.ifNull(ageCategoryFinishedMatches.get(ageCategoryKey), (Object)0) + categoryMatchCount.getFinishedMatches();
                ageCategoryFinishedMatches.put(ageCategoryKey, matchNum);
            }
            if (categoryMatchCount.getAveragePresentationTime() <= 0) continue;
            int duoPresentationTime = (Integer)ObjectUtil.ifNull(ageCategoryTotalDuoPresentationTime.get(ageCategoryKey), (Object)0) + categoryMatchCount.getAveragePresentationTime() * categoryMatchCount.getFinishedPresentations();
            ageCategoryTotalDuoPresentationTime.put(ageCategoryKey, duoPresentationTime);
            int duoPresentationNum = (Integer)ObjectUtil.ifNull(ageCategoryFinishedDuoPresentations.get(ageCategoryKey), (Object)0) + categoryMatchCount.getFinishedPresentations();
            ageCategoryFinishedDuoPresentations.put(ageCategoryKey, duoPresentationNum);
        }
        for (Category category : categories) {
            CategoryMatchCount categoryMatchCount = (CategoryMatchCount)competitionDuration.getMatchCountForCategories().get(category);
            totalMatches += categoryMatchCount.getTotalMatches().intValue();
            finishedMatches += categoryMatchCount.getFinishedMatches().intValue();
            neededMatches += categoryMatchCount.getNeededMatches().intValue();
            totalPresentations += categoryMatchCount.getTotalPresentations().intValue();
            finishedPresentations += categoryMatchCount.getFinishedPresentations().intValue();
            neededPresentations += categoryMatchCount.getNeededPresentations().intValue();
            int matchDuration = 180;
            int predictedMatchDuration = 0;
            int presentationDuration = 120;
            int predictedPresentationDuration = 0;
            AgeCategoryOption ageCategoryOption = null;
            Category.Type categoryType = null;
            if (category instanceof FightingCategory) {
                categoryType = Category.Type.FIGHTING;
                FightingCategory fightingCategory = (FightingCategory)category;
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory(fightingCategory);
                if (ageCategoryOption != null) {
                    matchDuration = ageCategoryOption.getFightTime();
                }
            } else if (category instanceof NewazaCategory) {
                categoryType = Category.Type.NEWAZA;
                NewazaCategory newazaCategory = (NewazaCategory)category;
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory(newazaCategory);
                if (ageCategoryOption != null) {
                    matchDuration = ageCategoryOption.getFightTime();
                }
            } else if (category instanceof DuoCategory) {
                categoryType = Category.Type.DUO;
                DuoCategory duoCategory = (DuoCategory)category;
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory(duoCategory);
                if (ageCategoryOption != null) {
                    if (ageCategoryOption.getAge() > 0 && ageCategoryOption.getAge() <= 10) {
                        matchDuration = 60;
                    } else if (ageCategoryOption.getAge() > 0 && ageCategoryOption.getAge() <= 14) {
                        matchDuration = 90;
                    } else if (ageCategoryOption.getAge() > 0 && ageCategoryOption.getAge() <= 16) {
                        matchDuration = 120;
                    }
                }
            } else if (category instanceof Duo2023Category) {
                categoryType = Category.Type.DUO_2023;
                Duo2023Category duo2023Category = (Duo2023Category)category;
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory(duo2023Category);
                if (ageCategoryOption != null) {
                    if (ageCategoryOption.getAge() > 0 && ageCategoryOption.getAge() <= 12) {
                        presentationDuration = 30;
                        matchDuration = 60;
                    } else if (ageCategoryOption.getAge() > 0 && ageCategoryOption.getAge() <= 14) {
                        presentationDuration = 45;
                        matchDuration = 90;
                    }
                }
            }
            int ageCategoryAverageMatchTime = 0;
            int ageCategoryAveragePresentationTime = 0;
            if (ageCategoryOption != null && categoryType != null) {
                AgeCategoryKey ageCategoryKey = new AgeCategoryKey(ageCategoryOption, categoryType);
                int time = (Integer)ObjectUtil.ifNull(ageCategoryTotalMatchTime.get(ageCategoryKey), (Object)0);
                int num = (Integer)ObjectUtil.ifNull(ageCategoryFinishedMatches.get(ageCategoryKey), (Object)0);
                if (num > 0) {
                    ageCategoryAverageMatchTime = time / num;
                }
                if (num >= 3) {
                    predictedMatchDuration = time / num;
                }
                time = (Integer)ObjectUtil.ifNull(ageCategoryTotalDuoPresentationTime.get(ageCategoryKey), (Object)0);
                num = (Integer)ObjectUtil.ifNull(ageCategoryFinishedDuoPresentations.get(ageCategoryKey), (Object)0);
                if (num > 0) {
                    ageCategoryAveragePresentationTime = time / num;
                }
                if (num >= 3) {
                    predictedPresentationDuration = time / num;
                }
            } else {
                if (categoryMatchCount.getFinishedMatches() >= 3) {
                    predictedMatchDuration = categoryMatchCount.getAverageMatchTime();
                }
                if (categoryMatchCount.getFinishedPresentations() >= 3) {
                    predictedPresentationDuration = categoryMatchCount.getAveragePresentationTime();
                }
            }
            if (predictedMatchDuration <= 0) {
                predictedMatchDuration = Math.round((float)matchDuration * MATCH_DURATION_KOEFICIENT.floatValue() / PREDICTION_MATCH_DURATION_KOEFICIENT.floatValue());
            }
            if (predictedPresentationDuration <= 0) {
                predictedPresentationDuration = Math.round((float)presentationDuration * MATCH_DURATION_KOEFICIENT.floatValue() / PREDICTION_MATCH_DURATION_KOEFICIENT.floatValue());
            }
            int categoryTimeRequired = Math.round((float)categoryMatchCount.getNeededMatches().intValue() * (float)matchDuration * MATCH_DURATION_KOEFICIENT.floatValue()) + Math.round((float)categoryMatchCount.getNeededPresentations().intValue() * (float)presentationDuration * MATCH_DURATION_KOEFICIENT.floatValue());
            int predictedTimeRequired = Math.round((float)categoryMatchCount.getNeededMatches().intValue() * (float)predictedMatchDuration * PREDICTION_MATCH_DURATION_KOEFICIENT.floatValue()) + Math.round((float)categoryMatchCount.getNeededPresentations().intValue() * (float)predictedPresentationDuration * PREDICTION_MATCH_DURATION_KOEFICIENT.floatValue());
            totalTimeRequired += categoryTimeRequired;
            predictedTotalTimeRequired += predictedTimeRequired;
            competitionDuration.getTimeRequiredForCategories().put(category, categoryTimeRequired);
            competitionDuration.getPredictedTimeRequiredForCategories().put(category, predictedTimeRequired);
            if (ageCategoryOption == null || categoryType == null) continue;
            AgeCategoryKey ageCategoryKey = new AgeCategoryKey(ageCategoryOption, categoryType);
            CategoryMatchCount matchCountForAgeCategory = (CategoryMatchCount)competitionDuration.getMatchCountForAgeCategories().get(ageCategoryKey);
            if (matchCountForAgeCategory == null) {
                matchCountForAgeCategory = new CategoryMatchCount();
                matchCountForAgeCategory.setTotalMatches(Integer.valueOf(0));
                matchCountForAgeCategory.setFinishedMatches(Integer.valueOf(0));
                matchCountForAgeCategory.setNeededMatches(Integer.valueOf(0));
                matchCountForAgeCategory.setTotalPresentations(Integer.valueOf(0));
                matchCountForAgeCategory.setFinishedPresentations(Integer.valueOf(0));
                matchCountForAgeCategory.setNeededPresentations(Integer.valueOf(0));
                matchCountForAgeCategory.setAverageMatchTime(Integer.valueOf(ageCategoryAverageMatchTime));
                matchCountForAgeCategory.setAveragePresentationTime(Integer.valueOf(ageCategoryAveragePresentationTime));
                competitionDuration.getMatchCountForAgeCategories().put(ageCategoryKey, matchCountForAgeCategory);
            }
            matchCountForAgeCategory.setTotalMatches(Integer.valueOf(matchCountForAgeCategory.getTotalMatches() + categoryMatchCount.getTotalMatches()));
            matchCountForAgeCategory.setFinishedMatches(Integer.valueOf(matchCountForAgeCategory.getFinishedMatches() + categoryMatchCount.getFinishedMatches()));
            matchCountForAgeCategory.setNeededMatches(Integer.valueOf(matchCountForAgeCategory.getNeededMatches() + categoryMatchCount.getNeededMatches()));
            matchCountForAgeCategory.setTotalPresentations(Integer.valueOf(matchCountForAgeCategory.getTotalPresentations() + categoryMatchCount.getTotalPresentations()));
            matchCountForAgeCategory.setFinishedPresentations(Integer.valueOf(matchCountForAgeCategory.getFinishedPresentations() + categoryMatchCount.getFinishedPresentations()));
            matchCountForAgeCategory.setNeededPresentations(Integer.valueOf(matchCountForAgeCategory.getNeededPresentations() + categoryMatchCount.getNeededPresentations()));
            Integer ageCategoryTimeRequired = (Integer)ObjectUtil.ifNull(competitionDuration.getTimeRequiredForAgeCategories().get(ageCategoryKey), (Object)0) + categoryTimeRequired;
            competitionDuration.getTimeRequiredForAgeCategories().put(ageCategoryKey, ageCategoryTimeRequired);
            Integer ageCategoryPredictedTimeRequired = (Integer)ObjectUtil.ifNull(competitionDuration.getPredictedTimeRequiredForAgeCategories().get(ageCategoryKey), (Object)0) + predictedTimeRequired;
            competitionDuration.getPredictedTimeRequiredForAgeCategories().put(ageCategoryKey, ageCategoryPredictedTimeRequired);
        }
        CategoryMatchCount totalMatchCount = new CategoryMatchCount();
        totalMatchCount.setTotalMatches(Integer.valueOf(totalMatches));
        totalMatchCount.setFinishedMatches(Integer.valueOf(finishedMatches));
        totalMatchCount.setNeededMatches(Integer.valueOf(neededMatches));
        totalMatchCount.setTotalPresentations(Integer.valueOf(totalPresentations));
        totalMatchCount.setFinishedPresentations(Integer.valueOf(finishedPresentations));
        totalMatchCount.setNeededPresentations(Integer.valueOf(neededPresentations));
        competitionDuration.setTotalMatchCount(totalMatchCount);
        competitionDuration.setTotalTimeRequired(Integer.valueOf(totalTimeRequired));
        competitionDuration.setPredictedTotalTimeRequired(Integer.valueOf(predictedTotalTimeRequired));
        return competitionDuration;
    }

    private CategoryMatchCount createCategoryMatchCount(List<Match> matches, List<DuoPresentation> duoPresentations) {
        int duration;
        int totalMatches = 0;
        int finishedMatches = 0;
        int neededMatches = 0;
        int totalMatchTime = 0;
        int finishedMatchesWithTime = 0;
        int totalPresentations = 0;
        int finishedPresentations = 0;
        int neededPresentations = 0;
        int totalPresentationTime = 0;
        int finishedPresentationsWithTime = 0;
        for (Match match : matches) {
            if (match.getNotNeeded().booleanValue() || match.getMatchEmpty().booleanValue()) continue;
            ++totalMatches;
            if (match.getStatus() == Match.Status.FINISHED) {
                ++finishedMatches;
                if (match.getStartedAt() == null || match.getFinishedAt() == null) continue;
                duration = (int)(match.getFinishedAt().getTime() - match.getStartedAt().getTime()) / 1000;
                if (duration < 30) {
                    duration = 30;
                }
                if (duration > 600) {
                    duration = 600;
                }
                totalMatchTime += duration;
                ++finishedMatchesWithTime;
                continue;
            }
            ++neededMatches;
        }
        for (DuoPresentation duoPresentation : duoPresentations) {
            if (duoPresentation.getNotNeeded().booleanValue()) continue;
            ++totalPresentations;
            if (duoPresentation.getStatus() == DuoPresentation.Status.FINISHED) {
                ++finishedPresentations;
                if (duoPresentation.getStartedAt() == null || duoPresentation.getFinishedAt() == null) continue;
                duration = (int)(duoPresentation.getFinishedAt().getTime() - duoPresentation.getStartedAt().getTime()) / 1000;
                if (duration < 30) {
                    duration = 30;
                }
                if (duration > 600) {
                    duration = 600;
                }
                totalPresentationTime += duration;
                ++finishedPresentationsWithTime;
                continue;
            }
            ++neededPresentations;
        }
        int averageMatchTime = 0;
        if (finishedMatchesWithTime > 0) {
            averageMatchTime = totalMatchTime / finishedMatchesWithTime;
        }
        int averagePresentationTime = 0;
        if (finishedPresentationsWithTime > 0) {
            averagePresentationTime = totalPresentationTime / finishedPresentationsWithTime;
        }
        CategoryMatchCount categoryMatchCount = new CategoryMatchCount();
        categoryMatchCount.setTotalMatches(Integer.valueOf(totalMatches));
        categoryMatchCount.setFinishedMatches(Integer.valueOf(finishedMatches));
        categoryMatchCount.setNeededMatches(Integer.valueOf(neededMatches));
        categoryMatchCount.setAverageMatchTime(Integer.valueOf(averageMatchTime));
        categoryMatchCount.setTotalPresentations(Integer.valueOf(totalPresentations));
        categoryMatchCount.setFinishedPresentations(Integer.valueOf(finishedPresentations));
        categoryMatchCount.setNeededPresentations(Integer.valueOf(neededPresentations));
        categoryMatchCount.setAveragePresentationTime(Integer.valueOf(averagePresentationTime));
        return categoryMatchCount;
    }
}

