/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dataimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import si.nevensrok.common.dataexport.FileWriter;
import si.nevensrok.common.dataimport.FileContent;
import si.nevensrok.common.dataimport.FileLine;
import si.nevensrok.common.dataimport.FileReader;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.dataimport.ImportUtil;
import si.nevensrok.jtekma.server.dataimport.ImporterUtil;
import si.nevensrok.jtekma.server.management.TatamiManager;

public class TatamiImporter {
    private static final int BUFFER_SIZE = 65536;
    private TatamiManager tatamiManager;

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public List<Tatami> parseTatamis(FileType fileType, byte[] fileData) throws Exception {
        LinkedList<Tatami> tatamis = new LinkedList<Tatami>();
        FileReader fileReader = ImporterUtil.getFileReader(fileType);
        FileContent fileContent = fileReader.readFile((InputStream)new ByteArrayInputStream(fileData));
        int tatamiNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Ime tatamija", "Ime", "Naziv", "Tatami", "Tatami name", "Name"});
        int tatamiPasswordIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Geslo", "Password", "Tatami password"});
        int tatamiShowAsIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Poka\u017ei kot", "Prikaz", "Show as", "Display as"});
        int tabletRefereesAsIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Sodniki s tablico", "Tablet referees"});
        int videoRefereeAsIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Video sodnik", "Video referee"});
        if (tatamiNameIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoTatamiName);
        }
        if (tatamiPasswordIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoTatamiPassword);
        }
        for (FileLine fileLine : fileContent.getLines()) {
            String name = ImportUtil.formatName(fileLine.getData(tatamiNameIndex));
            String password = fileLine.getData(tatamiPasswordIndex);
            String displayText = ImportUtil.formatName(fileLine.getData(tatamiShowAsIndex));
            Boolean tabletReferees = Boolean.FALSE;
            Boolean videoReferee = Boolean.FALSE;
            if (tabletRefereesAsIndex >= 0) {
                tabletReferees = Boolean.parseBoolean(fileLine.getData(tabletRefereesAsIndex));
            }
            if (videoRefereeAsIndex >= 0) {
                videoReferee = Boolean.parseBoolean(fileLine.getData(videoRefereeAsIndex));
            }
            if (StringUtil.isEmpty((String)name)) continue;
            if (StringUtil.isEmpty((String)displayText)) {
                displayText = name;
            }
            Tatami tatami = new Tatami();
            tatami.setName(name);
            tatami.setPassword(password);
            tatami.setDisplayText(displayText);
            tatami.setTabletReferees(tabletReferees);
            tatami.setVideoReferee(videoReferee);
            tatamis.add(tatami);
        }
        return tatamis;
    }

    public void importTatamis(Competition competition, List<Tatami> tatamis) throws Exception {
        for (Tatami tatami : tatamis) {
            tatami.setCompetition(competition);
            if (this.tatamiManager.getActiveTatamiByName(competition, tatami.getName()) != null) continue;
            this.tatamiManager.createTatami(tatami);
        }
    }

    public byte[] exportTatamis(FileType fileType, List<Tatami> tatamis, String[] header) throws Exception {
        FileWriter fileWriter = ImporterUtil.getFileWriter(fileType);
        String[][] fileContent = new String[tatamis.size() + 1][];
        fileContent[0] = header;
        int i = 1;
        for (Tatami tatami : tatamis) {
            fileContent[i] = new String[]{tatami.getName(), "", tatami.getDisplayText(), ((Boolean)ObjectUtil.ifNull((Object)tatami.getTabletReferees(), (Object)Boolean.FALSE)).toString(), ((Boolean)ObjectUtil.ifNull((Object)tatami.getVideoReferee(), (Object)Boolean.FALSE)).toString()};
            ++i;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        fileWriter.writeFile((OutputStream)buffer, fileContent);
        return buffer.toByteArray();
    }
}

