/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.logging;

import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Date;
import java.util.LinkedList;
import org.bson.Document;
import si.nevensrok.common.logging.AbstractBackgroundAppender;
import si.nevensrok.common.logging.LogItem;

public class MongodbAppender
extends AbstractBackgroundAppender {
    private MongoClient mongoClient = null;
    private String hostname;
    private int port = 27017;
    private String username;
    private String password;
    private String database;
    private String collection;

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
        block3: {
            try {
                if (this.mongoClient != null) {
                    this.mongoClient.close();
                }
            }
            catch (Exception e) {
                if (!this.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        this.mongoClient = null;
    }

    @Override
    public void logItem(LogItem logItem) {
        MongoClient mongoClient = this.getMongoClient();
        try {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(this.database);
            MongoCollection mongoCollection = mongoDatabase.getCollection(this.collection);
            Document mongoDocument = new Document();
            mongoDocument.put("eventDate", (Object)new Date(logItem.getTimeStamp()));
            mongoDocument.put("threadName", (Object)logItem.getThreadName());
            mongoDocument.put("category", (Object)logItem.getCategory());
            mongoDocument.put("logLevel", (Object)logItem.getLevel());
            mongoDocument.put("message", (Object)logItem.getMessage());
            mongoDocument.put("throwable", (Object)logItem.getThrowable());
            mongoDocument.put("locationClassName", (Object)logItem.getLocationClassName());
            mongoDocument.put("locationMethodName", (Object)logItem.getLocationMethodName());
            mongoDocument.put("locationLineNumber", (Object)logItem.getLocationLineNumber());
            mongoDocument.put("machineIp4", (Object)logItem.getMachineIp4());
            mongoDocument.put("machineIp6", (Object)logItem.getMachineIp6());
            mongoDocument.put("machineHostname", (Object)logItem.getMachineHostname());
            mongoDocument.put("machineName", (Object)logItem.getMachineName());
            mongoDocument.put("processName", (Object)logItem.getProcessName());
            mongoCollection.insertOne((Object)mongoDocument);
        }
        catch (Exception e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            this.disconnect();
        }
    }

    private MongoClient getMongoClient() {
        block4: {
            if (this.isClosed()) {
                return null;
            }
            if (this.mongoClient == null) {
                try {
                    ServerAddress serverAddress = new ServerAddress(this.hostname, this.port);
                    LinkedList<MongoCredential> credentialsList = new LinkedList<MongoCredential>();
                    credentialsList.add(MongoCredential.createMongoCRCredential((String)this.username, (String)this.database, (char[])this.password.toCharArray()));
                    this.mongoClient = new MongoClient(serverAddress);
                }
                catch (Exception e) {
                    if (!this.isDebug()) break block4;
                    e.printStackTrace();
                }
            }
        }
        return this.mongoClient;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }
}

