/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.streams;

import java.io.IOException;
import java.io.OutputStream;
import si.nevensrok.common.buffer.DynamicByteBuffer;

public class OutputStreamBuffer
extends OutputStream {
    private DynamicByteBuffer buffer;

    public OutputStreamBuffer() {
        this.buffer = new DynamicByteBuffer();
    }

    public OutputStreamBuffer(int initialSize) {
        this.buffer = new DynamicByteBuffer(initialSize);
    }

    public OutputStreamBuffer(int initialSize, int maxSize) {
        this.buffer = new DynamicByteBuffer(initialSize, maxSize);
    }

    @Override
    public void write(int b) throws IOException {
        try {
            if (this.buffer == null) {
                throw new IOException("Stream is closed");
            }
            this.buffer.addBlocking((byte)b);
        }
        catch (InterruptedException e) {
            throw new IOException("Write was interrupted", e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream is closed");
        }
        try {
            this.buffer.addBlocking(b, off, len);
        }
        catch (InterruptedException e) {
            throw new IOException("Write was interrupted", e);
        }
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
    }

    public int getBufferSize() {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
        return this.buffer.getDataAvailable();
    }

    public byte getFromBuffer() {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
        return this.buffer.get();
    }

    public void getFromBuffer(byte[] data) {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
        this.buffer.get(data);
    }

    public void getFromBuffer(byte[] data, int offset, int length) {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
        this.buffer.get(data, offset, length);
    }

    public byte[] getFromBuffer(int length) {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
        return this.buffer.get(length);
    }

    public byte getFromBufferBlocking() throws InterruptedException {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
        return this.buffer.getBlocking();
    }

    public void getFromBufferBlocking(byte[] data) throws InterruptedException {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
        this.buffer.getBlocking(data);
    }

    public void getFromBufferBlocking(byte[] data, int offset, int length) throws InterruptedException {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
        this.buffer.getBlocking(data, offset, length);
    }

    public byte[] getFromBufferBlocking(int length) throws InterruptedException {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
        return this.buffer.getBlocking(length);
    }
}

