/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.InjuryTimeTracker;
import si.nevensrok.jtekma.tabla.gui.InjuryTimeDialog;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class InjuryTimeCounter
extends JPanel
implements DisposableBean {
    private static final long serialVersionUID = 5730321858472487313L;
    private static final Logger log = LoggerFactory.getLogger(InjuryTimeCounter.class);
    private static final NumberFormat secondsNumberFormat = new DecimalFormat("00");
    private static final Font timeFont = new Font("Serif", 1, 120);
    private MatchData matchData;
    private ApplicationContext applicationContext;
    private JLabel timeLabel = new JLabel();
    private InjuryTimeTracker injuryTimeTracker;

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    public InjuryTimeCounter(final InjuryTimeDialog injuryTimeDialog, MatchData matchData, ApplicationContext applicationContext) {
        this.matchData = matchData;
        this.applicationContext = applicationContext;
        this.injuryTimeTracker = new InjuryTimeTracker(this);
        this.setLayout(new BorderLayout());
        this.timeLabel.setHorizontalAlignment(0);
        this.add(this.timeLabel);
        this.displayTime(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    InjuryTimeCounter.this.injuryTimeTracker.startStopTime();
                } else {
                    InjuryTimeCounter.this.injuryTimeTracker.stopTime();
                    int time = InjuryTimeCounter.this.injuryTimeTracker.getTime() / 1000;
                    int minutes = time / 60;
                    int seconds = time % 60;
                    String timeText = String.valueOf(minutes) + ":" + secondsNumberFormat.format(seconds);
                    timeText = JOptionPane.showInputDialog(injuryTimeDialog, InjuryTimeCounter.this.getLanguageText("text.enterInjuryTime"), timeText);
                    if (timeText != null) {
                        try {
                            String[] parts = timeText.split(":");
                            if (parts.length > 1) {
                                minutes = Integer.parseInt(parts[0].trim());
                                seconds = Integer.parseInt(parts[1].trim());
                            } else {
                                minutes = 0;
                                seconds = Integer.parseInt(parts[0].trim());
                            }
                            time = (minutes * 60 + seconds) * 1000;
                            InjuryTimeCounter.this.setTime(time);
                            InjuryTimeCounter.this.redrawElements();
                        }
                        catch (Exception ex) {
                            log.error("Error while parsing time", (Throwable)ex);
                        }
                    }
                }
            }
        });
    }

    public void destroy() throws Exception {
        this.injuryTimeTracker.destroy();
    }

    @Override
    public void setForeground(Color fg) {
        if (this.timeLabel != null) {
            this.timeLabel.setForeground(fg);
        }
        super.setForeground(fg);
    }

    public Integer getTime() {
        return this.injuryTimeTracker.getTime();
    }

    public void setTime(Integer time) {
        this.injuryTimeTracker.setTime(time);
        this.displayTime(time);
    }

    public void displayTime(int time) {
        int minues = time / 60000;
        int seconds = (time - minues * 60000) / 1000;
        final StringBuilder timeText = new StringBuilder();
        timeText.append(minues);
        timeText.append(":");
        if (seconds < 10) {
            timeText.append("0");
        }
        timeText.append(seconds);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InjuryTimeCounter.this.timeLabel.setText(timeText.toString());
                FontSizeUtil.refitFontSize(timeFont, InjuryTimeCounter.this.timeLabel);
            }
        });
    }

    public void stopTime() {
        this.injuryTimeTracker.stopTime();
    }

    public void redrawElements() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FontSizeUtil.refitFontSize(timeFont, InjuryTimeCounter.this.timeLabel);
            }
        });
    }
}

