(function() {
	let view = definePackage("jtekma.view");
	let restClient = definePackage("restClient");

	view.Search = class Search extends view.main {

		constructor(tatamiId) {
			super("div");
			this.addClass("row");

			let searchInputDiv = new view.div();
			searchInputDiv.addClass("col-md-9");
			this.addContent(searchInputDiv);

			this.searchInput = new view.input("text");
			this.searchInput.addStyle("width", "100%");
			this.searchInput.onChange(() => {
				this.searchData();
			})
			searchInputDiv.addContent(this.searchInput);

			let searchButtonDiv = new view.div();
			searchButtonDiv.addClass("col-md-3");
			this.addContent(searchButtonDiv);

			this.searchButton = new view.button(getSpringMessage("common.search"));
			this.searchButton.addClass("btn btn-primary");
			this.searchButton.addStyle("width", "100%");
			this.searchButton.onClick(() => {
				this.searchData();
			});
			searchButtonDiv.addContent(this.searchButton);

			this.dataDiv = new view.div();
			this.dataDiv.addClass("col-md-12");
			this.addContent(this.dataDiv);
		}

		searchData() {
			let searchString = this.searchInput.getValue();
			if (isTextEmpty(searchString)) {
				this.dataDiv.setContent("");
				this.searching = false;
				this.searchButton.setDisabled(false);
				return;
			}

			if (this.searching) {
				return;
			}
			this.searching = true;
			this.searchButton.setDisabled(true);

			this.dataDiv.setContent(getSpringMessage("common.loading"));

			let parameters = {
				"text": searchString
			};

			restClient.getJson("/search/search", parameters, null, (responseData, response) => {
				if (!this.searching) {
					return;
				}
				this.searching = false;
				this.searchButton.setDisabled(false);
				if (!response.isSuccessful()) {
					this.dataDiv.setContentText(response.errorText);
					return;
				}
				this.dataDiv.setContent(new view.CategoryListDisplay(response.data));
			});
		}

	};

})();

$(document).ready(function() {
	let view = definePackage("jtekma.view");
	let search = new view.Search();
	search.draw($("#search-div")[0]);
});
